/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.PrintStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.ImpersonationConfig;
import org.projectnessie.client.auth.oauth2.OAuth2AuthenticatorConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.Secret;
import org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OAuth2ClientConfig", generator="Immutables")
@Immutable
final class ImmutableOAuth2ClientConfig
extends OAuth2ClientConfig {
    private final URI issuerUrl;
    private final URI tokenEndpoint;
    private final URI authEndpoint;
    private final URI deviceAuthEndpoint;
    private final GrantType grantType;
    private final String clientId;
    private final Secret clientSecret;
    private final Supplier<String> clientSecretSupplier;
    private final String username;
    private final Secret password;
    private final Supplier<String> passwordSupplier;
    private final transient Optional<String> scope;
    private final List<String> scopes;
    private final Map<String, String> extraRequestParameters;
    private final boolean tokenExchangeEnabled;
    private final TokenExchangeConfig tokenExchangeConfig;
    private final ImpersonationConfig impersonationConfig;
    private final Duration defaultAccessTokenLifespan;
    private final Duration defaultRefreshTokenLifespan;
    private final Duration refreshSafetyWindow;
    private final Duration preemptiveTokenRefreshIdleTimeout;
    private final Duration backgroundThreadIdleTimeout;
    private final Duration authorizationCodeFlowTimeout;
    private final Integer authorizationCodeFlowWebServerPort;
    private final Duration deviceCodeFlowTimeout;
    private final Duration deviceCodeFlowPollInterval;
    private final SSLContext sslContext;
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService executor;
    private final transient String clientName;
    private final Duration minDefaultAccessTokenLifespan;
    private final Duration minRefreshSafetyWindow;
    private final Duration minPreemptiveTokenRefreshIdleTimeout;
    private final Duration minAuthorizationCodeFlowTimeout;
    private final Duration minDeviceCodeFlowTimeout;
    private final Duration minDeviceCodeFlowPollInterval;
    private final boolean ignoreDeviceCodeFlowServerPollInterval;
    private final PrintStream console;
    private final Supplier<Instant> clock;
    private final transient boolean publicClient;
    private final transient Optional<Boolean> impersonationPublicClient;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long OPEN_ID_PROVIDER_METADATA_LAZY_INIT_BIT = 1L;
    private transient JsonNode openIdProviderMetadata;
    private static final long IMPERSONATION_OPEN_ID_PROVIDER_METADATA_LAZY_INIT_BIT = 2L;
    private transient Optional<JsonNode> impersonationOpenIdProviderMetadata;
    private static final long RESOLVED_TOKEN_ENDPOINT_LAZY_INIT_BIT = 4L;
    private transient URI resolvedTokenEndpoint;
    private static final long RESOLVED_AUTH_ENDPOINT_LAZY_INIT_BIT = 8L;
    private transient URI resolvedAuthEndpoint;
    private static final long RESOLVED_DEVICE_AUTH_ENDPOINT_LAZY_INIT_BIT = 16L;
    private transient URI resolvedDeviceAuthEndpoint;
    private static final long RESOLVED_IMPERSONATION_TOKEN_ENDPOINT_LAZY_INIT_BIT = 32L;
    private transient Optional<URI> resolvedImpersonationTokenEndpoint;
    private static final long BASIC_AUTHENTICATION_LAZY_INIT_BIT = 64L;
    private transient Optional<HttpAuthentication> basicAuthentication;
    private static final long IMPERSONATION_BASIC_AUTHENTICATION_LAZY_INIT_BIT = 128L;
    private transient Optional<HttpAuthentication> impersonationBasicAuthentication;
    private static final long HTTP_CLIENT_LAZY_INIT_BIT = 256L;
    private transient HttpClient httpClient;

    private ImmutableOAuth2ClientConfig(Builder builder) {
        this.issuerUrl = builder.issuerUrl;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.authEndpoint = builder.authEndpoint;
        this.deviceAuthEndpoint = builder.deviceAuthEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientSecretSupplier = builder.clientSecretSupplier;
        this.username = builder.username;
        this.password = builder.password;
        this.passwordSupplier = builder.passwordSupplier;
        this.scopes = ImmutableOAuth2ClientConfig.createUnmodifiableList(true, builder.scopes);
        this.extraRequestParameters = ImmutableOAuth2ClientConfig.createUnmodifiableMap(false, false, builder.extraRequestParameters);
        this.authorizationCodeFlowWebServerPort = builder.authorizationCodeFlowWebServerPort;
        this.sslContext = builder.sslContext;
        this.executor = builder.executor;
        if (builder.grantType != null) {
            this.initShim.grantType(builder.grantType);
        }
        if (builder.tokenExchangeEnabledIsSet()) {
            this.initShim.tokenExchangeEnabled(builder.tokenExchangeEnabled);
        }
        if (builder.tokenExchangeConfig != null) {
            this.initShim.tokenExchangeConfig(builder.tokenExchangeConfig);
        }
        if (builder.impersonationConfig != null) {
            this.initShim.impersonationConfig(builder.impersonationConfig);
        }
        if (builder.defaultAccessTokenLifespan != null) {
            this.initShim.defaultAccessTokenLifespan(builder.defaultAccessTokenLifespan);
        }
        if (builder.defaultRefreshTokenLifespan != null) {
            this.initShim.defaultRefreshTokenLifespan(builder.defaultRefreshTokenLifespan);
        }
        if (builder.refreshSafetyWindow != null) {
            this.initShim.refreshSafetyWindow(builder.refreshSafetyWindow);
        }
        if (builder.preemptiveTokenRefreshIdleTimeout != null) {
            this.initShim.preemptiveTokenRefreshIdleTimeout(builder.preemptiveTokenRefreshIdleTimeout);
        }
        if (builder.backgroundThreadIdleTimeout != null) {
            this.initShim.backgroundThreadIdleTimeout(builder.backgroundThreadIdleTimeout);
        }
        if (builder.authorizationCodeFlowTimeout != null) {
            this.initShim.authorizationCodeFlowTimeout(builder.authorizationCodeFlowTimeout);
        }
        if (builder.deviceCodeFlowTimeout != null) {
            this.initShim.deviceCodeFlowTimeout(builder.deviceCodeFlowTimeout);
        }
        if (builder.deviceCodeFlowPollInterval != null) {
            this.initShim.deviceCodeFlowPollInterval(builder.deviceCodeFlowPollInterval);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.minDefaultAccessTokenLifespan != null) {
            this.initShim.minDefaultAccessTokenLifespan(builder.minDefaultAccessTokenLifespan);
        }
        if (builder.minRefreshSafetyWindow != null) {
            this.initShim.minRefreshSafetyWindow(builder.minRefreshSafetyWindow);
        }
        if (builder.minPreemptiveTokenRefreshIdleTimeout != null) {
            this.initShim.minPreemptiveTokenRefreshIdleTimeout(builder.minPreemptiveTokenRefreshIdleTimeout);
        }
        if (builder.minAuthorizationCodeFlowTimeout != null) {
            this.initShim.minAuthorizationCodeFlowTimeout(builder.minAuthorizationCodeFlowTimeout);
        }
        if (builder.minDeviceCodeFlowTimeout != null) {
            this.initShim.minDeviceCodeFlowTimeout(builder.minDeviceCodeFlowTimeout);
        }
        if (builder.minDeviceCodeFlowPollInterval != null) {
            this.initShim.minDeviceCodeFlowPollInterval(builder.minDeviceCodeFlowPollInterval);
        }
        if (builder.ignoreDeviceCodeFlowServerPollIntervalIsSet()) {
            this.initShim.ignoreDeviceCodeFlowServerPollInterval(builder.ignoreDeviceCodeFlowServerPollInterval);
        }
        if (builder.console != null) {
            this.initShim.console(builder.console);
        }
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        this.grantType = this.initShim.getGrantType();
        this.scope = this.initShim.getScope();
        this.tokenExchangeEnabled = this.initShim.getTokenExchangeEnabled();
        this.tokenExchangeConfig = this.initShim.getTokenExchangeConfig();
        this.impersonationConfig = this.initShim.getImpersonationConfig();
        this.defaultAccessTokenLifespan = this.initShim.getDefaultAccessTokenLifespan();
        this.defaultRefreshTokenLifespan = this.initShim.getDefaultRefreshTokenLifespan();
        this.refreshSafetyWindow = this.initShim.getRefreshSafetyWindow();
        this.preemptiveTokenRefreshIdleTimeout = this.initShim.getPreemptiveTokenRefreshIdleTimeout();
        this.backgroundThreadIdleTimeout = this.initShim.getBackgroundThreadIdleTimeout();
        this.authorizationCodeFlowTimeout = this.initShim.getAuthorizationCodeFlowTimeout();
        this.deviceCodeFlowTimeout = this.initShim.getDeviceCodeFlowTimeout();
        this.deviceCodeFlowPollInterval = this.initShim.getDeviceCodeFlowPollInterval();
        this.objectMapper = this.initShim.getObjectMapper();
        this.clientName = this.initShim.getClientName();
        this.minDefaultAccessTokenLifespan = this.initShim.getMinDefaultAccessTokenLifespan();
        this.minRefreshSafetyWindow = this.initShim.getMinRefreshSafetyWindow();
        this.minPreemptiveTokenRefreshIdleTimeout = this.initShim.getMinPreemptiveTokenRefreshIdleTimeout();
        this.minAuthorizationCodeFlowTimeout = this.initShim.getMinAuthorizationCodeFlowTimeout();
        this.minDeviceCodeFlowTimeout = this.initShim.getMinDeviceCodeFlowTimeout();
        this.minDeviceCodeFlowPollInterval = this.initShim.getMinDeviceCodeFlowPollInterval();
        this.ignoreDeviceCodeFlowServerPollInterval = this.initShim.ignoreDeviceCodeFlowServerPollInterval();
        this.console = this.initShim.getConsole();
        this.clock = this.initShim.getClock();
        this.publicClient = this.initShim.isPublicClient();
        this.impersonationPublicClient = this.initShim.isImpersonationPublicClient();
        this.initShim = null;
    }

    private ImmutableOAuth2ClientConfig(URI issuerUrl, URI tokenEndpoint, URI authEndpoint, URI deviceAuthEndpoint, GrantType grantType, String clientId, Secret clientSecret, Supplier<String> clientSecretSupplier, String username, Secret password, Supplier<String> passwordSupplier, List<String> scopes, Map<String, String> extraRequestParameters, boolean tokenExchangeEnabled, TokenExchangeConfig tokenExchangeConfig, ImpersonationConfig impersonationConfig, Duration defaultAccessTokenLifespan, Duration defaultRefreshTokenLifespan, Duration refreshSafetyWindow, Duration preemptiveTokenRefreshIdleTimeout, Duration backgroundThreadIdleTimeout, Duration authorizationCodeFlowTimeout, Integer authorizationCodeFlowWebServerPort, Duration deviceCodeFlowTimeout, Duration deviceCodeFlowPollInterval, SSLContext sslContext, ObjectMapper objectMapper, ScheduledExecutorService executor, Duration minDefaultAccessTokenLifespan, Duration minRefreshSafetyWindow, Duration minPreemptiveTokenRefreshIdleTimeout, Duration minAuthorizationCodeFlowTimeout, Duration minDeviceCodeFlowTimeout, Duration minDeviceCodeFlowPollInterval, boolean ignoreDeviceCodeFlowServerPollInterval, PrintStream console, Supplier<Instant> clock) {
        this.issuerUrl = issuerUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.authEndpoint = authEndpoint;
        this.deviceAuthEndpoint = deviceAuthEndpoint;
        this.initShim.grantType(grantType);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientSecretSupplier = clientSecretSupplier;
        this.username = username;
        this.password = password;
        this.passwordSupplier = passwordSupplier;
        this.scopes = scopes;
        this.extraRequestParameters = extraRequestParameters;
        this.initShim.tokenExchangeEnabled(tokenExchangeEnabled);
        this.initShim.tokenExchangeConfig(tokenExchangeConfig);
        this.initShim.impersonationConfig(impersonationConfig);
        this.initShim.defaultAccessTokenLifespan(defaultAccessTokenLifespan);
        this.initShim.defaultRefreshTokenLifespan(defaultRefreshTokenLifespan);
        this.initShim.refreshSafetyWindow(refreshSafetyWindow);
        this.initShim.preemptiveTokenRefreshIdleTimeout(preemptiveTokenRefreshIdleTimeout);
        this.initShim.backgroundThreadIdleTimeout(backgroundThreadIdleTimeout);
        this.initShim.authorizationCodeFlowTimeout(authorizationCodeFlowTimeout);
        this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort;
        this.initShim.deviceCodeFlowTimeout(deviceCodeFlowTimeout);
        this.initShim.deviceCodeFlowPollInterval(deviceCodeFlowPollInterval);
        this.sslContext = sslContext;
        this.initShim.objectMapper(objectMapper);
        this.executor = executor;
        this.initShim.minDefaultAccessTokenLifespan(minDefaultAccessTokenLifespan);
        this.initShim.minRefreshSafetyWindow(minRefreshSafetyWindow);
        this.initShim.minPreemptiveTokenRefreshIdleTimeout(minPreemptiveTokenRefreshIdleTimeout);
        this.initShim.minAuthorizationCodeFlowTimeout(minAuthorizationCodeFlowTimeout);
        this.initShim.minDeviceCodeFlowTimeout(minDeviceCodeFlowTimeout);
        this.initShim.minDeviceCodeFlowPollInterval(minDeviceCodeFlowPollInterval);
        this.initShim.ignoreDeviceCodeFlowServerPollInterval(ignoreDeviceCodeFlowServerPollInterval);
        this.initShim.console(console);
        this.initShim.clock(clock);
        this.grantType = this.initShim.getGrantType();
        this.scope = this.initShim.getScope();
        this.tokenExchangeEnabled = this.initShim.getTokenExchangeEnabled();
        this.tokenExchangeConfig = this.initShim.getTokenExchangeConfig();
        this.impersonationConfig = this.initShim.getImpersonationConfig();
        this.defaultAccessTokenLifespan = this.initShim.getDefaultAccessTokenLifespan();
        this.defaultRefreshTokenLifespan = this.initShim.getDefaultRefreshTokenLifespan();
        this.refreshSafetyWindow = this.initShim.getRefreshSafetyWindow();
        this.preemptiveTokenRefreshIdleTimeout = this.initShim.getPreemptiveTokenRefreshIdleTimeout();
        this.backgroundThreadIdleTimeout = this.initShim.getBackgroundThreadIdleTimeout();
        this.authorizationCodeFlowTimeout = this.initShim.getAuthorizationCodeFlowTimeout();
        this.deviceCodeFlowTimeout = this.initShim.getDeviceCodeFlowTimeout();
        this.deviceCodeFlowPollInterval = this.initShim.getDeviceCodeFlowPollInterval();
        this.objectMapper = this.initShim.getObjectMapper();
        this.clientName = this.initShim.getClientName();
        this.minDefaultAccessTokenLifespan = this.initShim.getMinDefaultAccessTokenLifespan();
        this.minRefreshSafetyWindow = this.initShim.getMinRefreshSafetyWindow();
        this.minPreemptiveTokenRefreshIdleTimeout = this.initShim.getMinPreemptiveTokenRefreshIdleTimeout();
        this.minAuthorizationCodeFlowTimeout = this.initShim.getMinAuthorizationCodeFlowTimeout();
        this.minDeviceCodeFlowTimeout = this.initShim.getMinDeviceCodeFlowTimeout();
        this.minDeviceCodeFlowPollInterval = this.initShim.getMinDeviceCodeFlowPollInterval();
        this.ignoreDeviceCodeFlowServerPollInterval = this.initShim.ignoreDeviceCodeFlowServerPollInterval();
        this.console = this.initShim.getConsole();
        this.clock = this.initShim.getClock();
        this.publicClient = this.initShim.isPublicClient();
        this.impersonationPublicClient = this.initShim.isImpersonationPublicClient();
        this.initShim = null;
    }

    @Override
    public Optional<URI> getIssuerUrl() {
        return Optional.ofNullable(this.issuerUrl);
    }

    @Override
    public Optional<URI> getTokenEndpoint() {
        return Optional.ofNullable(this.tokenEndpoint);
    }

    @Override
    public Optional<URI> getAuthEndpoint() {
        return Optional.ofNullable(this.authEndpoint);
    }

    @Override
    public Optional<URI> getDeviceAuthEndpoint() {
        return Optional.ofNullable(this.deviceAuthEndpoint);
    }

    @Override
    public GrantType getGrantType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGrantType() : this.grantType;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public Optional<Secret> getClientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    @Override
    public Optional<Supplier<String>> getClientSecretSupplier() {
        return Optional.ofNullable(this.clientSecretSupplier);
    }

    @Override
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    public Optional<Secret> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Override
    public Optional<Supplier<String>> getPasswordSupplier() {
        return Optional.ofNullable(this.passwordSupplier);
    }

    @Override
    @Deprecated
    public Optional<String> getScope() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getScope() : this.scope;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public Map<String, String> getExtraRequestParameters() {
        return this.extraRequestParameters;
    }

    @Override
    @Deprecated
    public boolean getTokenExchangeEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTokenExchangeEnabled() : this.tokenExchangeEnabled;
    }

    @Override
    public TokenExchangeConfig getTokenExchangeConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTokenExchangeConfig() : this.tokenExchangeConfig;
    }

    @Override
    public ImpersonationConfig getImpersonationConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getImpersonationConfig() : this.impersonationConfig;
    }

    @Override
    public Duration getDefaultAccessTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultAccessTokenLifespan() : this.defaultAccessTokenLifespan;
    }

    @Override
    public Duration getDefaultRefreshTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultRefreshTokenLifespan() : this.defaultRefreshTokenLifespan;
    }

    @Override
    public Duration getRefreshSafetyWindow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRefreshSafetyWindow() : this.refreshSafetyWindow;
    }

    @Override
    public Duration getPreemptiveTokenRefreshIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPreemptiveTokenRefreshIdleTimeout() : this.preemptiveTokenRefreshIdleTimeout;
    }

    @Override
    public Duration getBackgroundThreadIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBackgroundThreadIdleTimeout() : this.backgroundThreadIdleTimeout;
    }

    @Override
    public Duration getAuthorizationCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAuthorizationCodeFlowTimeout() : this.authorizationCodeFlowTimeout;
    }

    @Override
    public OptionalInt getAuthorizationCodeFlowWebServerPort() {
        return this.authorizationCodeFlowWebServerPort != null ? OptionalInt.of(this.authorizationCodeFlowWebServerPort) : OptionalInt.empty();
    }

    @Override
    public Duration getDeviceCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDeviceCodeFlowTimeout() : this.deviceCodeFlowTimeout;
    }

    @Override
    public Duration getDeviceCodeFlowPollInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDeviceCodeFlowPollInterval() : this.deviceCodeFlowPollInterval;
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public ObjectMapper getObjectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMapper() : this.objectMapper;
    }

    @Override
    public Optional<ScheduledExecutorService> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    @Override
    String getClientName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientName() : this.clientName;
    }

    @Override
    Duration getMinDefaultAccessTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinDefaultAccessTokenLifespan() : this.minDefaultAccessTokenLifespan;
    }

    @Override
    Duration getMinRefreshSafetyWindow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinRefreshSafetyWindow() : this.minRefreshSafetyWindow;
    }

    @Override
    Duration getMinPreemptiveTokenRefreshIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinPreemptiveTokenRefreshIdleTimeout() : this.minPreemptiveTokenRefreshIdleTimeout;
    }

    @Override
    Duration getMinAuthorizationCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinAuthorizationCodeFlowTimeout() : this.minAuthorizationCodeFlowTimeout;
    }

    @Override
    Duration getMinDeviceCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinDeviceCodeFlowTimeout() : this.minDeviceCodeFlowTimeout;
    }

    @Override
    Duration getMinDeviceCodeFlowPollInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinDeviceCodeFlowPollInterval() : this.minDeviceCodeFlowPollInterval;
    }

    @Override
    public boolean ignoreDeviceCodeFlowServerPollInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignoreDeviceCodeFlowServerPollInterval() : this.ignoreDeviceCodeFlowServerPollInterval;
    }

    @Override
    PrintStream getConsole() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConsole() : this.console;
    }

    @Override
    Supplier<Instant> getClock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClock() : this.clock;
    }

    @Override
    boolean isPublicClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublicClient() : this.publicClient;
    }

    @Override
    Optional<Boolean> isImpersonationPublicClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isImpersonationPublicClient() : this.impersonationPublicClient;
    }

    public final ImmutableOAuth2ClientConfig withIssuerUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "issuerUrl");
        if (this.issuerUrl == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(newValue, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withIssuerUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.issuerUrl == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(value, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withTokenEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "tokenEndpoint");
        if (this.tokenEndpoint == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, newValue, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withTokenEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.tokenEndpoint == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, value, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withAuthEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "authEndpoint");
        if (this.authEndpoint == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, newValue, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withAuthEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.authEndpoint == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, value, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDeviceAuthEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "deviceAuthEndpoint");
        if (this.deviceAuthEndpoint == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, newValue, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDeviceAuthEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.deviceAuthEndpoint == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, value, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withGrantType(GrantType value) {
        GrantType newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, newValue, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, newValue, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClientSecret(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, newValue, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClientSecret(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.clientSecret == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, value, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClientSecretSupplier(Supplier<String> value) {
        Supplier<String> newValue = Objects.requireNonNull(value, "clientSecretSupplier");
        if (this.clientSecretSupplier == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, newValue, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClientSecretSupplier(Optional<? extends Supplier<String>> optional) {
        Supplier value = optional.orElse(null);
        if (this.clientSecretSupplier == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, value, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, newValue, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, value, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withPassword(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "password");
        if (this.password == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, newValue, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withPassword(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.password == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, value, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withPasswordSupplier(Supplier<String> value) {
        Supplier<String> newValue = Objects.requireNonNull(value, "passwordSupplier");
        if (this.passwordSupplier == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, newValue, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withPasswordSupplier(Optional<? extends Supplier<String>> optional) {
        Supplier value = optional.orElse(null);
        if (this.passwordSupplier == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, value, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withScopes(String ... elements) {
        List<String> newValue = ImmutableOAuth2ClientConfig.createUnmodifiableList(false, ImmutableOAuth2ClientConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, newValue, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableOAuth2ClientConfig.createUnmodifiableList(false, ImmutableOAuth2ClientConfig.createSafeList(elements, true, false));
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, newValue, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withExtraRequestParameters(Map<String, ? extends String> entries) {
        if (this.extraRequestParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableOAuth2ClientConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, newValue, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    @Deprecated
    public final ImmutableOAuth2ClientConfig withTokenExchangeEnabled(boolean value) {
        if (this.tokenExchangeEnabled == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, value, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withTokenExchangeConfig(TokenExchangeConfig value) {
        if (this.tokenExchangeConfig == value) {
            return this;
        }
        TokenExchangeConfig newValue = Objects.requireNonNull(value, "tokenExchangeConfig");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, newValue, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withImpersonationConfig(ImpersonationConfig value) {
        if (this.impersonationConfig == value) {
            return this;
        }
        ImpersonationConfig newValue = Objects.requireNonNull(value, "impersonationConfig");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, newValue, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDefaultAccessTokenLifespan(Duration value) {
        if (this.defaultAccessTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultAccessTokenLifespan");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, newValue, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDefaultRefreshTokenLifespan(Duration value) {
        if (this.defaultRefreshTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultRefreshTokenLifespan");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, newValue, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withRefreshSafetyWindow(Duration value) {
        if (this.refreshSafetyWindow == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "refreshSafetyWindow");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, newValue, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withPreemptiveTokenRefreshIdleTimeout(Duration value) {
        if (this.preemptiveTokenRefreshIdleTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "preemptiveTokenRefreshIdleTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, newValue, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withBackgroundThreadIdleTimeout(Duration value) {
        if (this.backgroundThreadIdleTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "backgroundThreadIdleTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, newValue, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withAuthorizationCodeFlowTimeout(Duration value) {
        if (this.authorizationCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "authorizationCodeFlowTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, newValue, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withAuthorizationCodeFlowWebServerPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.authorizationCodeFlowWebServerPort, newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, newValue, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withAuthorizationCodeFlowWebServerPort(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.authorizationCodeFlowWebServerPort, value)) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, value, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDeviceCodeFlowTimeout(Duration value) {
        if (this.deviceCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "deviceCodeFlowTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, newValue, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withDeviceCodeFlowPollInterval(Duration value) {
        if (this.deviceCodeFlowPollInterval == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "deviceCodeFlowPollInterval");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, newValue, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withSslContext(SSLContext value) {
        SSLContext newValue = Objects.requireNonNull(value, "sslContext");
        if (this.sslContext == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, newValue, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withSslContext(Optional<? extends SSLContext> optional) {
        SSLContext value = optional.orElse(null);
        if (this.sslContext == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, value, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, newValue, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withExecutor(ScheduledExecutorService value) {
        ScheduledExecutorService newValue = Objects.requireNonNull(value, "executor");
        if (this.executor == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, newValue, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withExecutor(Optional<? extends ScheduledExecutorService> optional) {
        ScheduledExecutorService value = optional.orElse(null);
        if (this.executor == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, value, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinDefaultAccessTokenLifespan(Duration value) {
        if (this.minDefaultAccessTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minDefaultAccessTokenLifespan");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, newValue, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinRefreshSafetyWindow(Duration value) {
        if (this.minRefreshSafetyWindow == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minRefreshSafetyWindow");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, newValue, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinPreemptiveTokenRefreshIdleTimeout(Duration value) {
        if (this.minPreemptiveTokenRefreshIdleTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minPreemptiveTokenRefreshIdleTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, newValue, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinAuthorizationCodeFlowTimeout(Duration value) {
        if (this.minAuthorizationCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minAuthorizationCodeFlowTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, newValue, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinDeviceCodeFlowTimeout(Duration value) {
        if (this.minDeviceCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minDeviceCodeFlowTimeout");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, newValue, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withMinDeviceCodeFlowPollInterval(Duration value) {
        if (this.minDeviceCodeFlowPollInterval == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "minDeviceCodeFlowPollInterval");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, newValue, this.ignoreDeviceCodeFlowServerPollInterval, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withIgnoreDeviceCodeFlowServerPollInterval(boolean value) {
        if (this.ignoreDeviceCodeFlowServerPollInterval == value) {
            return this;
        }
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, value, this.console, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withConsole(PrintStream value) {
        if (this.console == value) {
            return this;
        }
        PrintStream newValue = Objects.requireNonNull(value, "console");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, newValue, this.clock));
    }

    public final ImmutableOAuth2ClientConfig withClock(Supplier<Instant> value) {
        if (this.clock == value) {
            return this;
        }
        Supplier<Instant> newValue = Objects.requireNonNull(value, "clock");
        return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor, this.minDefaultAccessTokenLifespan, this.minRefreshSafetyWindow, this.minPreemptiveTokenRefreshIdleTimeout, this.minAuthorizationCodeFlowTimeout, this.minDeviceCodeFlowTimeout, this.minDeviceCodeFlowPollInterval, this.ignoreDeviceCodeFlowServerPollInterval, this.console, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2ClientConfig && this.equalsByValue((ImmutableOAuth2ClientConfig)another);
    }

    private boolean equalsByValue(ImmutableOAuth2ClientConfig another) {
        return Objects.equals(this.issuerUrl, another.issuerUrl) && Objects.equals(this.tokenEndpoint, another.tokenEndpoint) && Objects.equals(this.authEndpoint, another.authEndpoint) && Objects.equals(this.deviceAuthEndpoint, another.deviceAuthEndpoint) && this.grantType.equals((Object)another.grantType) && this.clientId.equals(another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.clientSecretSupplier, another.clientSecretSupplier) && Objects.equals(this.username, another.username) && Objects.equals(this.password, another.password) && Objects.equals(this.passwordSupplier, another.passwordSupplier) && this.scope.equals(another.scope) && this.scopes.equals(another.scopes) && this.extraRequestParameters.equals(another.extraRequestParameters) && this.tokenExchangeEnabled == another.tokenExchangeEnabled && this.tokenExchangeConfig.equals(another.tokenExchangeConfig) && this.impersonationConfig.equals(another.impersonationConfig) && this.defaultAccessTokenLifespan.equals(another.defaultAccessTokenLifespan) && this.defaultRefreshTokenLifespan.equals(another.defaultRefreshTokenLifespan) && this.refreshSafetyWindow.equals(another.refreshSafetyWindow) && this.preemptiveTokenRefreshIdleTimeout.equals(another.preemptiveTokenRefreshIdleTimeout) && this.backgroundThreadIdleTimeout.equals(another.backgroundThreadIdleTimeout) && this.authorizationCodeFlowTimeout.equals(another.authorizationCodeFlowTimeout) && Objects.equals(this.authorizationCodeFlowWebServerPort, another.authorizationCodeFlowWebServerPort) && this.deviceCodeFlowTimeout.equals(another.deviceCodeFlowTimeout) && this.deviceCodeFlowPollInterval.equals(another.deviceCodeFlowPollInterval) && Objects.equals(this.sslContext, another.sslContext) && this.objectMapper.equals(another.objectMapper) && Objects.equals(this.executor, another.executor) && this.clientName.equals(another.clientName) && this.minDefaultAccessTokenLifespan.equals(another.minDefaultAccessTokenLifespan) && this.minRefreshSafetyWindow.equals(another.minRefreshSafetyWindow) && this.minPreemptiveTokenRefreshIdleTimeout.equals(another.minPreemptiveTokenRefreshIdleTimeout) && this.minAuthorizationCodeFlowTimeout.equals(another.minAuthorizationCodeFlowTimeout) && this.minDeviceCodeFlowTimeout.equals(another.minDeviceCodeFlowTimeout) && this.minDeviceCodeFlowPollInterval.equals(another.minDeviceCodeFlowPollInterval) && this.ignoreDeviceCodeFlowServerPollInterval == another.ignoreDeviceCodeFlowServerPollInterval && this.console.equals(another.console) && this.clock.equals(another.clock) && this.publicClient == another.publicClient && this.impersonationPublicClient.equals(another.impersonationPublicClient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.issuerUrl);
        h += (h << 5) + Objects.hashCode(this.tokenEndpoint);
        h += (h << 5) + Objects.hashCode(this.authEndpoint);
        h += (h << 5) + Objects.hashCode(this.deviceAuthEndpoint);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + Objects.hashCode(this.clientSecretSupplier);
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.passwordSupplier);
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + this.extraRequestParameters.hashCode();
        h += (h << 5) + Boolean.hashCode(this.tokenExchangeEnabled);
        h += (h << 5) + this.tokenExchangeConfig.hashCode();
        h += (h << 5) + this.impersonationConfig.hashCode();
        h += (h << 5) + this.defaultAccessTokenLifespan.hashCode();
        h += (h << 5) + this.defaultRefreshTokenLifespan.hashCode();
        h += (h << 5) + this.refreshSafetyWindow.hashCode();
        h += (h << 5) + this.preemptiveTokenRefreshIdleTimeout.hashCode();
        h += (h << 5) + this.backgroundThreadIdleTimeout.hashCode();
        h += (h << 5) + this.authorizationCodeFlowTimeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.authorizationCodeFlowWebServerPort);
        h += (h << 5) + this.deviceCodeFlowTimeout.hashCode();
        h += (h << 5) + this.deviceCodeFlowPollInterval.hashCode();
        h += (h << 5) + Objects.hashCode(this.sslContext);
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + Objects.hashCode(this.executor);
        h += (h << 5) + this.clientName.hashCode();
        h += (h << 5) + this.minDefaultAccessTokenLifespan.hashCode();
        h += (h << 5) + this.minRefreshSafetyWindow.hashCode();
        h += (h << 5) + this.minPreemptiveTokenRefreshIdleTimeout.hashCode();
        h += (h << 5) + this.minAuthorizationCodeFlowTimeout.hashCode();
        h += (h << 5) + this.minDeviceCodeFlowTimeout.hashCode();
        h += (h << 5) + this.minDeviceCodeFlowPollInterval.hashCode();
        h += (h << 5) + Boolean.hashCode(this.ignoreDeviceCodeFlowServerPollInterval);
        h += (h << 5) + this.console.hashCode();
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + Boolean.hashCode(this.publicClient);
        h += (h << 5) + this.impersonationPublicClient.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OAuth2ClientConfig{");
        if (this.issuerUrl != null) {
            builder.append("issuerUrl=").append(this.issuerUrl);
        }
        if (this.tokenEndpoint != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("tokenEndpoint=").append(this.tokenEndpoint);
        }
        if (this.authEndpoint != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("authEndpoint=").append(this.authEndpoint);
        }
        if (this.deviceAuthEndpoint != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("deviceAuthEndpoint=").append(this.deviceAuthEndpoint);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("grantType=").append((Object)this.grantType);
        builder.append(", ");
        builder.append("clientId=").append(this.clientId);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        builder.append(", ");
        builder.append("scope=").append(this.scope);
        builder.append(", ");
        builder.append("scopes=").append(this.scopes);
        builder.append(", ");
        builder.append("extraRequestParameters=").append(this.extraRequestParameters);
        builder.append(", ");
        builder.append("tokenExchangeEnabled=").append(this.tokenExchangeEnabled);
        builder.append(", ");
        builder.append("tokenExchangeConfig=").append(this.tokenExchangeConfig);
        builder.append(", ");
        builder.append("impersonationConfig=").append(this.impersonationConfig);
        builder.append(", ");
        builder.append("defaultAccessTokenLifespan=").append(this.defaultAccessTokenLifespan);
        builder.append(", ");
        builder.append("defaultRefreshTokenLifespan=").append(this.defaultRefreshTokenLifespan);
        builder.append(", ");
        builder.append("refreshSafetyWindow=").append(this.refreshSafetyWindow);
        builder.append(", ");
        builder.append("preemptiveTokenRefreshIdleTimeout=").append(this.preemptiveTokenRefreshIdleTimeout);
        builder.append(", ");
        builder.append("backgroundThreadIdleTimeout=").append(this.backgroundThreadIdleTimeout);
        builder.append(", ");
        builder.append("authorizationCodeFlowTimeout=").append(this.authorizationCodeFlowTimeout);
        if (this.authorizationCodeFlowWebServerPort != null) {
            builder.append(", ");
            builder.append("authorizationCodeFlowWebServerPort=").append(this.authorizationCodeFlowWebServerPort);
        }
        builder.append(", ");
        builder.append("deviceCodeFlowTimeout=").append(this.deviceCodeFlowTimeout);
        builder.append(", ");
        builder.append("deviceCodeFlowPollInterval=").append(this.deviceCodeFlowPollInterval);
        if (this.sslContext != null) {
            builder.append(", ");
            builder.append("sslContext=").append(this.sslContext);
        }
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        if (this.executor != null) {
            builder.append(", ");
            builder.append("executor=").append(this.executor);
        }
        builder.append(", ");
        builder.append("clientName=").append(this.clientName);
        builder.append(", ");
        builder.append("minDefaultAccessTokenLifespan=").append(this.minDefaultAccessTokenLifespan);
        builder.append(", ");
        builder.append("minRefreshSafetyWindow=").append(this.minRefreshSafetyWindow);
        builder.append(", ");
        builder.append("minPreemptiveTokenRefreshIdleTimeout=").append(this.minPreemptiveTokenRefreshIdleTimeout);
        builder.append(", ");
        builder.append("minAuthorizationCodeFlowTimeout=").append(this.minAuthorizationCodeFlowTimeout);
        builder.append(", ");
        builder.append("minDeviceCodeFlowTimeout=").append(this.minDeviceCodeFlowTimeout);
        builder.append(", ");
        builder.append("minDeviceCodeFlowPollInterval=").append(this.minDeviceCodeFlowPollInterval);
        builder.append(", ");
        builder.append("ignoreDeviceCodeFlowServerPollInterval=").append(this.ignoreDeviceCodeFlowServerPollInterval);
        builder.append(", ");
        builder.append("console=").append(this.console);
        builder.append(", ");
        builder.append("clock=").append(this.clock);
        builder.append(", ");
        builder.append("publicClient=").append(this.publicClient);
        builder.append(", ");
        builder.append("impersonationPublicClient=").append(this.impersonationPublicClient);
        return builder.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JsonNode getOpenIdProviderMetadata() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.openIdProviderMetadata = Objects.requireNonNull(super.getOpenIdProviderMetadata(), "openIdProviderMetadata");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.openIdProviderMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Optional<JsonNode> getImpersonationOpenIdProviderMetadata() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.impersonationOpenIdProviderMetadata = Objects.requireNonNull(super.getImpersonationOpenIdProviderMetadata(), "impersonationOpenIdProviderMetadata");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.impersonationOpenIdProviderMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    URI getResolvedTokenEndpoint() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.resolvedTokenEndpoint = Objects.requireNonNull(super.getResolvedTokenEndpoint(), "resolvedTokenEndpoint");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.resolvedTokenEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    URI getResolvedAuthEndpoint() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.resolvedAuthEndpoint = Objects.requireNonNull(super.getResolvedAuthEndpoint(), "resolvedAuthEndpoint");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.resolvedAuthEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    URI getResolvedDeviceAuthEndpoint() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.resolvedDeviceAuthEndpoint = Objects.requireNonNull(super.getResolvedDeviceAuthEndpoint(), "resolvedDeviceAuthEndpoint");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.resolvedDeviceAuthEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Optional<URI> getResolvedImpersonationTokenEndpoint() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.resolvedImpersonationTokenEndpoint = Objects.requireNonNull(super.getResolvedImpersonationTokenEndpoint(), "resolvedImpersonationTokenEndpoint");
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.resolvedImpersonationTokenEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Optional<HttpAuthentication> getBasicAuthentication() {
        if ((this.lazyInitBitmap & 0x40L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 0x40L) == 0L) {
                    this.basicAuthentication = Objects.requireNonNull(super.getBasicAuthentication(), "basicAuthentication");
                    this.lazyInitBitmap |= 0x40L;
                }
            }
        }
        return this.basicAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Optional<HttpAuthentication> getImpersonationBasicAuthentication() {
        if ((this.lazyInitBitmap & 0x80L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 0x80L) == 0L) {
                    this.impersonationBasicAuthentication = Objects.requireNonNull(super.getImpersonationBasicAuthentication(), "impersonationBasicAuthentication");
                    this.lazyInitBitmap |= 0x80L;
                }
            }
        }
        return this.impersonationBasicAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    HttpClient getHttpClient() {
        if ((this.lazyInitBitmap & 0x100L) == 0L) {
            ImmutableOAuth2ClientConfig immutableOAuth2ClientConfig = this;
            synchronized (immutableOAuth2ClientConfig) {
                if ((this.lazyInitBitmap & 0x100L) == 0L) {
                    this.httpClient = Objects.requireNonNull(super.getHttpClient(), "httpClient");
                    this.lazyInitBitmap |= 0x100L;
                }
            }
        }
        return this.httpClient;
    }

    private static ImmutableOAuth2ClientConfig validate(ImmutableOAuth2ClientConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableOAuth2ClientConfig copyOf(OAuth2ClientConfig instance) {
        if (instance instanceof ImmutableOAuth2ClientConfig) {
            return (ImmutableOAuth2ClientConfig)instance;
        }
        return ImmutableOAuth2ClientConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="OAuth2ClientConfig", generator="Immutables")
    private final class InitShim {
        private byte grantTypeBuildStage = 0;
        private GrantType grantType;
        private byte scopeBuildStage = 0;
        private Optional<String> scope;
        private byte tokenExchangeEnabledBuildStage = 0;
        private boolean tokenExchangeEnabled;
        private byte tokenExchangeConfigBuildStage = 0;
        private TokenExchangeConfig tokenExchangeConfig;
        private byte impersonationConfigBuildStage = 0;
        private ImpersonationConfig impersonationConfig;
        private byte defaultAccessTokenLifespanBuildStage = 0;
        private Duration defaultAccessTokenLifespan;
        private byte defaultRefreshTokenLifespanBuildStage = 0;
        private Duration defaultRefreshTokenLifespan;
        private byte refreshSafetyWindowBuildStage = 0;
        private Duration refreshSafetyWindow;
        private byte preemptiveTokenRefreshIdleTimeoutBuildStage = 0;
        private Duration preemptiveTokenRefreshIdleTimeout;
        private byte backgroundThreadIdleTimeoutBuildStage = 0;
        private Duration backgroundThreadIdleTimeout;
        private byte authorizationCodeFlowTimeoutBuildStage = 0;
        private Duration authorizationCodeFlowTimeout;
        private byte deviceCodeFlowTimeoutBuildStage = 0;
        private Duration deviceCodeFlowTimeout;
        private byte deviceCodeFlowPollIntervalBuildStage = 0;
        private Duration deviceCodeFlowPollInterval;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte clientNameBuildStage = 0;
        private String clientName;
        private byte minDefaultAccessTokenLifespanBuildStage = 0;
        private Duration minDefaultAccessTokenLifespan;
        private byte minRefreshSafetyWindowBuildStage = 0;
        private Duration minRefreshSafetyWindow;
        private byte minPreemptiveTokenRefreshIdleTimeoutBuildStage = 0;
        private Duration minPreemptiveTokenRefreshIdleTimeout;
        private byte minAuthorizationCodeFlowTimeoutBuildStage = 0;
        private Duration minAuthorizationCodeFlowTimeout;
        private byte minDeviceCodeFlowTimeoutBuildStage = 0;
        private Duration minDeviceCodeFlowTimeout;
        private byte minDeviceCodeFlowPollIntervalBuildStage = 0;
        private Duration minDeviceCodeFlowPollInterval;
        private byte ignoreDeviceCodeFlowServerPollIntervalBuildStage = 0;
        private boolean ignoreDeviceCodeFlowServerPollInterval;
        private byte consoleBuildStage = 0;
        private PrintStream console;
        private byte clockBuildStage = 0;
        private Supplier<Instant> clock;
        private byte publicClientBuildStage = 0;
        private boolean publicClient;
        private byte impersonationPublicClientBuildStage = 0;
        private Optional<Boolean> impersonationPublicClient;

        private InitShim() {
        }

        GrantType getGrantType() {
            if (this.grantTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.grantTypeBuildStage == 0) {
                this.grantTypeBuildStage = (byte)-1;
                GrantType computedValue = ImmutableOAuth2ClientConfig.super.getGrantType();
                this.grantType = Objects.requireNonNull(computedValue, "grantType");
                this.grantTypeBuildStage = 1;
            }
            return this.grantType;
        }

        void grantType(GrantType grantType) {
            this.grantType = grantType;
            this.grantTypeBuildStage = 1;
        }

        Optional<String> getScope() {
            if (this.scopeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopeBuildStage == 0) {
                this.scopeBuildStage = (byte)-1;
                Optional computedValue = ImmutableOAuth2ClientConfig.super.getScope();
                this.scope = Objects.requireNonNull(computedValue, "scope");
                this.scopeBuildStage = 1;
            }
            return this.scope;
        }

        boolean getTokenExchangeEnabled() {
            if (this.tokenExchangeEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenExchangeEnabledBuildStage == 0) {
                boolean computedValue;
                this.tokenExchangeEnabledBuildStage = (byte)-1;
                this.tokenExchangeEnabled = computedValue = ImmutableOAuth2ClientConfig.super.getTokenExchangeEnabled();
                this.tokenExchangeEnabledBuildStage = 1;
            }
            return this.tokenExchangeEnabled;
        }

        void tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.tokenExchangeEnabledBuildStage = 1;
        }

        TokenExchangeConfig getTokenExchangeConfig() {
            if (this.tokenExchangeConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenExchangeConfigBuildStage == 0) {
                this.tokenExchangeConfigBuildStage = (byte)-1;
                TokenExchangeConfig computedValue = ImmutableOAuth2ClientConfig.super.getTokenExchangeConfig();
                this.tokenExchangeConfig = Objects.requireNonNull(computedValue, "tokenExchangeConfig");
                this.tokenExchangeConfigBuildStage = 1;
            }
            return this.tokenExchangeConfig;
        }

        void tokenExchangeConfig(TokenExchangeConfig tokenExchangeConfig) {
            this.tokenExchangeConfig = tokenExchangeConfig;
            this.tokenExchangeConfigBuildStage = 1;
        }

        ImpersonationConfig getImpersonationConfig() {
            if (this.impersonationConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.impersonationConfigBuildStage == 0) {
                this.impersonationConfigBuildStage = (byte)-1;
                ImpersonationConfig computedValue = ImmutableOAuth2ClientConfig.super.getImpersonationConfig();
                this.impersonationConfig = Objects.requireNonNull(computedValue, "impersonationConfig");
                this.impersonationConfigBuildStage = 1;
            }
            return this.impersonationConfig;
        }

        void impersonationConfig(ImpersonationConfig impersonationConfig) {
            this.impersonationConfig = impersonationConfig;
            this.impersonationConfigBuildStage = 1;
        }

        Duration getDefaultAccessTokenLifespan() {
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultAccessTokenLifespanBuildStage == 0) {
                this.defaultAccessTokenLifespanBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getDefaultAccessTokenLifespan();
                this.defaultAccessTokenLifespan = Objects.requireNonNull(computedValue, "defaultAccessTokenLifespan");
                this.defaultAccessTokenLifespanBuildStage = 1;
            }
            return this.defaultAccessTokenLifespan;
        }

        void defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = defaultAccessTokenLifespan;
            this.defaultAccessTokenLifespanBuildStage = 1;
        }

        Duration getDefaultRefreshTokenLifespan() {
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultRefreshTokenLifespanBuildStage == 0) {
                this.defaultRefreshTokenLifespanBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getDefaultRefreshTokenLifespan();
                this.defaultRefreshTokenLifespan = Objects.requireNonNull(computedValue, "defaultRefreshTokenLifespan");
                this.defaultRefreshTokenLifespanBuildStage = 1;
            }
            return this.defaultRefreshTokenLifespan;
        }

        void defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = defaultRefreshTokenLifespan;
            this.defaultRefreshTokenLifespanBuildStage = 1;
        }

        Duration getRefreshSafetyWindow() {
            if (this.refreshSafetyWindowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.refreshSafetyWindowBuildStage == 0) {
                this.refreshSafetyWindowBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getRefreshSafetyWindow();
                this.refreshSafetyWindow = Objects.requireNonNull(computedValue, "refreshSafetyWindow");
                this.refreshSafetyWindowBuildStage = 1;
            }
            return this.refreshSafetyWindow;
        }

        void refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = refreshSafetyWindow;
            this.refreshSafetyWindowBuildStage = 1;
        }

        Duration getPreemptiveTokenRefreshIdleTimeout() {
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == 0) {
                this.preemptiveTokenRefreshIdleTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getPreemptiveTokenRefreshIdleTimeout();
                this.preemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(computedValue, "preemptiveTokenRefreshIdleTimeout");
                this.preemptiveTokenRefreshIdleTimeoutBuildStage = 1;
            }
            return this.preemptiveTokenRefreshIdleTimeout;
        }

        void preemptiveTokenRefreshIdleTimeout(Duration preemptiveTokenRefreshIdleTimeout) {
            this.preemptiveTokenRefreshIdleTimeout = preemptiveTokenRefreshIdleTimeout;
            this.preemptiveTokenRefreshIdleTimeoutBuildStage = 1;
        }

        Duration getBackgroundThreadIdleTimeout() {
            if (this.backgroundThreadIdleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundThreadIdleTimeoutBuildStage == 0) {
                this.backgroundThreadIdleTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getBackgroundThreadIdleTimeout();
                this.backgroundThreadIdleTimeout = Objects.requireNonNull(computedValue, "backgroundThreadIdleTimeout");
                this.backgroundThreadIdleTimeoutBuildStage = 1;
            }
            return this.backgroundThreadIdleTimeout;
        }

        void backgroundThreadIdleTimeout(Duration backgroundThreadIdleTimeout) {
            this.backgroundThreadIdleTimeout = backgroundThreadIdleTimeout;
            this.backgroundThreadIdleTimeoutBuildStage = 1;
        }

        Duration getAuthorizationCodeFlowTimeout() {
            if (this.authorizationCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorizationCodeFlowTimeoutBuildStage == 0) {
                this.authorizationCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getAuthorizationCodeFlowTimeout();
                this.authorizationCodeFlowTimeout = Objects.requireNonNull(computedValue, "authorizationCodeFlowTimeout");
                this.authorizationCodeFlowTimeoutBuildStage = 1;
            }
            return this.authorizationCodeFlowTimeout;
        }

        void authorizationCodeFlowTimeout(Duration authorizationCodeFlowTimeout) {
            this.authorizationCodeFlowTimeout = authorizationCodeFlowTimeout;
            this.authorizationCodeFlowTimeoutBuildStage = 1;
        }

        Duration getDeviceCodeFlowTimeout() {
            if (this.deviceCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deviceCodeFlowTimeoutBuildStage == 0) {
                this.deviceCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getDeviceCodeFlowTimeout();
                this.deviceCodeFlowTimeout = Objects.requireNonNull(computedValue, "deviceCodeFlowTimeout");
                this.deviceCodeFlowTimeoutBuildStage = 1;
            }
            return this.deviceCodeFlowTimeout;
        }

        void deviceCodeFlowTimeout(Duration deviceCodeFlowTimeout) {
            this.deviceCodeFlowTimeout = deviceCodeFlowTimeout;
            this.deviceCodeFlowTimeoutBuildStage = 1;
        }

        Duration getDeviceCodeFlowPollInterval() {
            if (this.deviceCodeFlowPollIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deviceCodeFlowPollIntervalBuildStage == 0) {
                this.deviceCodeFlowPollIntervalBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getDeviceCodeFlowPollInterval();
                this.deviceCodeFlowPollInterval = Objects.requireNonNull(computedValue, "deviceCodeFlowPollInterval");
                this.deviceCodeFlowPollIntervalBuildStage = 1;
            }
            return this.deviceCodeFlowPollInterval;
        }

        void deviceCodeFlowPollInterval(Duration deviceCodeFlowPollInterval) {
            this.deviceCodeFlowPollInterval = deviceCodeFlowPollInterval;
            this.deviceCodeFlowPollIntervalBuildStage = 1;
        }

        ObjectMapper getObjectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                ObjectMapper computedValue = ImmutableOAuth2ClientConfig.super.getObjectMapper();
                this.objectMapper = Objects.requireNonNull(computedValue, "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        String getClientName() {
            if (this.clientNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientNameBuildStage == 0) {
                this.clientNameBuildStage = (byte)-1;
                String computedValue = ImmutableOAuth2ClientConfig.super.getClientName();
                this.clientName = Objects.requireNonNull(computedValue, "clientName");
                this.clientNameBuildStage = 1;
            }
            return this.clientName;
        }

        Duration getMinDefaultAccessTokenLifespan() {
            if (this.minDefaultAccessTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minDefaultAccessTokenLifespanBuildStage == 0) {
                this.minDefaultAccessTokenLifespanBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinDefaultAccessTokenLifespan();
                this.minDefaultAccessTokenLifespan = Objects.requireNonNull(computedValue, "minDefaultAccessTokenLifespan");
                this.minDefaultAccessTokenLifespanBuildStage = 1;
            }
            return this.minDefaultAccessTokenLifespan;
        }

        void minDefaultAccessTokenLifespan(Duration minDefaultAccessTokenLifespan) {
            this.minDefaultAccessTokenLifespan = minDefaultAccessTokenLifespan;
            this.minDefaultAccessTokenLifespanBuildStage = 1;
        }

        Duration getMinRefreshSafetyWindow() {
            if (this.minRefreshSafetyWindowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minRefreshSafetyWindowBuildStage == 0) {
                this.minRefreshSafetyWindowBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinRefreshSafetyWindow();
                this.minRefreshSafetyWindow = Objects.requireNonNull(computedValue, "minRefreshSafetyWindow");
                this.minRefreshSafetyWindowBuildStage = 1;
            }
            return this.minRefreshSafetyWindow;
        }

        void minRefreshSafetyWindow(Duration minRefreshSafetyWindow) {
            this.minRefreshSafetyWindow = minRefreshSafetyWindow;
            this.minRefreshSafetyWindowBuildStage = 1;
        }

        Duration getMinPreemptiveTokenRefreshIdleTimeout() {
            if (this.minPreemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minPreemptiveTokenRefreshIdleTimeoutBuildStage == 0) {
                this.minPreemptiveTokenRefreshIdleTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinPreemptiveTokenRefreshIdleTimeout();
                this.minPreemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(computedValue, "minPreemptiveTokenRefreshIdleTimeout");
                this.minPreemptiveTokenRefreshIdleTimeoutBuildStage = 1;
            }
            return this.minPreemptiveTokenRefreshIdleTimeout;
        }

        void minPreemptiveTokenRefreshIdleTimeout(Duration minPreemptiveTokenRefreshIdleTimeout) {
            this.minPreemptiveTokenRefreshIdleTimeout = minPreemptiveTokenRefreshIdleTimeout;
            this.minPreemptiveTokenRefreshIdleTimeoutBuildStage = 1;
        }

        Duration getMinAuthorizationCodeFlowTimeout() {
            if (this.minAuthorizationCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minAuthorizationCodeFlowTimeoutBuildStage == 0) {
                this.minAuthorizationCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinAuthorizationCodeFlowTimeout();
                this.minAuthorizationCodeFlowTimeout = Objects.requireNonNull(computedValue, "minAuthorizationCodeFlowTimeout");
                this.minAuthorizationCodeFlowTimeoutBuildStage = 1;
            }
            return this.minAuthorizationCodeFlowTimeout;
        }

        void minAuthorizationCodeFlowTimeout(Duration minAuthorizationCodeFlowTimeout) {
            this.minAuthorizationCodeFlowTimeout = minAuthorizationCodeFlowTimeout;
            this.minAuthorizationCodeFlowTimeoutBuildStage = 1;
        }

        Duration getMinDeviceCodeFlowTimeout() {
            if (this.minDeviceCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minDeviceCodeFlowTimeoutBuildStage == 0) {
                this.minDeviceCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinDeviceCodeFlowTimeout();
                this.minDeviceCodeFlowTimeout = Objects.requireNonNull(computedValue, "minDeviceCodeFlowTimeout");
                this.minDeviceCodeFlowTimeoutBuildStage = 1;
            }
            return this.minDeviceCodeFlowTimeout;
        }

        void minDeviceCodeFlowTimeout(Duration minDeviceCodeFlowTimeout) {
            this.minDeviceCodeFlowTimeout = minDeviceCodeFlowTimeout;
            this.minDeviceCodeFlowTimeoutBuildStage = 1;
        }

        Duration getMinDeviceCodeFlowPollInterval() {
            if (this.minDeviceCodeFlowPollIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minDeviceCodeFlowPollIntervalBuildStage == 0) {
                this.minDeviceCodeFlowPollIntervalBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2ClientConfig.super.getMinDeviceCodeFlowPollInterval();
                this.minDeviceCodeFlowPollInterval = Objects.requireNonNull(computedValue, "minDeviceCodeFlowPollInterval");
                this.minDeviceCodeFlowPollIntervalBuildStage = 1;
            }
            return this.minDeviceCodeFlowPollInterval;
        }

        void minDeviceCodeFlowPollInterval(Duration minDeviceCodeFlowPollInterval) {
            this.minDeviceCodeFlowPollInterval = minDeviceCodeFlowPollInterval;
            this.minDeviceCodeFlowPollIntervalBuildStage = 1;
        }

        boolean ignoreDeviceCodeFlowServerPollInterval() {
            if (this.ignoreDeviceCodeFlowServerPollIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignoreDeviceCodeFlowServerPollIntervalBuildStage == 0) {
                boolean computedValue;
                this.ignoreDeviceCodeFlowServerPollIntervalBuildStage = (byte)-1;
                this.ignoreDeviceCodeFlowServerPollInterval = computedValue = ImmutableOAuth2ClientConfig.super.ignoreDeviceCodeFlowServerPollInterval();
                this.ignoreDeviceCodeFlowServerPollIntervalBuildStage = 1;
            }
            return this.ignoreDeviceCodeFlowServerPollInterval;
        }

        void ignoreDeviceCodeFlowServerPollInterval(boolean ignoreDeviceCodeFlowServerPollInterval) {
            this.ignoreDeviceCodeFlowServerPollInterval = ignoreDeviceCodeFlowServerPollInterval;
            this.ignoreDeviceCodeFlowServerPollIntervalBuildStage = 1;
        }

        PrintStream getConsole() {
            if (this.consoleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consoleBuildStage == 0) {
                this.consoleBuildStage = (byte)-1;
                PrintStream computedValue = ImmutableOAuth2ClientConfig.super.getConsole();
                this.console = Objects.requireNonNull(computedValue, "console");
                this.consoleBuildStage = 1;
            }
            return this.console;
        }

        void console(PrintStream console) {
            this.console = console;
            this.consoleBuildStage = 1;
        }

        Supplier<Instant> getClock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                Supplier computedValue = ImmutableOAuth2ClientConfig.super.getClock();
                this.clock = Objects.requireNonNull(computedValue, "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Supplier<Instant> clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        boolean isPublicClient() {
            if (this.publicClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.publicClientBuildStage == 0) {
                boolean computedValue;
                this.publicClientBuildStage = (byte)-1;
                this.publicClient = computedValue = ImmutableOAuth2ClientConfig.super.isPublicClient();
                this.publicClientBuildStage = 1;
            }
            return this.publicClient;
        }

        Optional<Boolean> isImpersonationPublicClient() {
            if (this.impersonationPublicClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.impersonationPublicClientBuildStage == 0) {
                this.impersonationPublicClientBuildStage = (byte)-1;
                Optional computedValue = ImmutableOAuth2ClientConfig.super.isImpersonationPublicClient();
                this.impersonationPublicClient = Objects.requireNonNull(computedValue, "impersonationPublicClient");
                this.impersonationPublicClientBuildStage = 1;
            }
            return this.impersonationPublicClient;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.grantTypeBuildStage == -1) {
                attributes.add("grantType");
            }
            if (this.scopeBuildStage == -1) {
                attributes.add("scope");
            }
            if (this.tokenExchangeEnabledBuildStage == -1) {
                attributes.add("tokenExchangeEnabled");
            }
            if (this.tokenExchangeConfigBuildStage == -1) {
                attributes.add("tokenExchangeConfig");
            }
            if (this.impersonationConfigBuildStage == -1) {
                attributes.add("impersonationConfig");
            }
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                attributes.add("defaultAccessTokenLifespan");
            }
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                attributes.add("defaultRefreshTokenLifespan");
            }
            if (this.refreshSafetyWindowBuildStage == -1) {
                attributes.add("refreshSafetyWindow");
            }
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                attributes.add("preemptiveTokenRefreshIdleTimeout");
            }
            if (this.backgroundThreadIdleTimeoutBuildStage == -1) {
                attributes.add("backgroundThreadIdleTimeout");
            }
            if (this.authorizationCodeFlowTimeoutBuildStage == -1) {
                attributes.add("authorizationCodeFlowTimeout");
            }
            if (this.deviceCodeFlowTimeoutBuildStage == -1) {
                attributes.add("deviceCodeFlowTimeout");
            }
            if (this.deviceCodeFlowPollIntervalBuildStage == -1) {
                attributes.add("deviceCodeFlowPollInterval");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.clientNameBuildStage == -1) {
                attributes.add("clientName");
            }
            if (this.minDefaultAccessTokenLifespanBuildStage == -1) {
                attributes.add("minDefaultAccessTokenLifespan");
            }
            if (this.minRefreshSafetyWindowBuildStage == -1) {
                attributes.add("minRefreshSafetyWindow");
            }
            if (this.minPreemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                attributes.add("minPreemptiveTokenRefreshIdleTimeout");
            }
            if (this.minAuthorizationCodeFlowTimeoutBuildStage == -1) {
                attributes.add("minAuthorizationCodeFlowTimeout");
            }
            if (this.minDeviceCodeFlowTimeoutBuildStage == -1) {
                attributes.add("minDeviceCodeFlowTimeout");
            }
            if (this.minDeviceCodeFlowPollIntervalBuildStage == -1) {
                attributes.add("minDeviceCodeFlowPollInterval");
            }
            if (this.ignoreDeviceCodeFlowServerPollIntervalBuildStage == -1) {
                attributes.add("ignoreDeviceCodeFlowServerPollInterval");
            }
            if (this.consoleBuildStage == -1) {
                attributes.add("console");
            }
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.publicClientBuildStage == -1) {
                attributes.add("publicClient");
            }
            if (this.impersonationPublicClientBuildStage == -1) {
                attributes.add("impersonationPublicClient");
            }
            return "Cannot build OAuth2ClientConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="OAuth2ClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements OAuth2ClientConfig.Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long OPT_BIT_TOKEN_EXCHANGE_ENABLED = 1L;
        private static final long OPT_BIT_IGNORE_DEVICE_CODE_FLOW_SERVER_POLL_INTERVAL = 2L;
        private long initBits = 1L;
        private long optBits;
        private URI issuerUrl;
        private URI tokenEndpoint;
        private URI authEndpoint;
        private URI deviceAuthEndpoint;
        private GrantType grantType;
        private String clientId;
        private Secret clientSecret;
        private Supplier<String> clientSecretSupplier;
        private String username;
        private Secret password;
        private Supplier<String> passwordSupplier;
        private List<String> scopes = new ArrayList<String>();
        private Map<String, String> extraRequestParameters = new LinkedHashMap<String, String>();
        private boolean tokenExchangeEnabled;
        private TokenExchangeConfig tokenExchangeConfig;
        private ImpersonationConfig impersonationConfig;
        private Duration defaultAccessTokenLifespan;
        private Duration defaultRefreshTokenLifespan;
        private Duration refreshSafetyWindow;
        private Duration preemptiveTokenRefreshIdleTimeout;
        private Duration backgroundThreadIdleTimeout;
        private Duration authorizationCodeFlowTimeout;
        private Integer authorizationCodeFlowWebServerPort;
        private Duration deviceCodeFlowTimeout;
        private Duration deviceCodeFlowPollInterval;
        private SSLContext sslContext;
        private ObjectMapper objectMapper;
        private ScheduledExecutorService executor;
        private Duration minDefaultAccessTokenLifespan;
        private Duration minRefreshSafetyWindow;
        private Duration minPreemptiveTokenRefreshIdleTimeout;
        private Duration minAuthorizationCodeFlowTimeout;
        private Duration minDeviceCodeFlowTimeout;
        private Duration minDeviceCodeFlowPollInterval;
        private boolean ignoreDeviceCodeFlowServerPollInterval;
        private PrintStream console;
        private Supplier<Instant> clock;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OAuth2ClientConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(OAuth2AuthenticatorConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            OAuth2AuthenticatorConfig instance;
            long bits = 0L;
            if (object instanceof OAuth2ClientConfig) {
                instance = (OAuth2ClientConfig)object;
                this.minAuthorizationCodeFlowTimeout(((OAuth2ClientConfig)instance).getMinAuthorizationCodeFlowTimeout());
                this.minDeviceCodeFlowTimeout(((OAuth2ClientConfig)instance).getMinDeviceCodeFlowTimeout());
                this.console(((OAuth2ClientConfig)instance).getConsole());
                this.minDeviceCodeFlowPollInterval(((OAuth2ClientConfig)instance).getMinDeviceCodeFlowPollInterval());
                this.ignoreDeviceCodeFlowServerPollInterval(((OAuth2ClientConfig)instance).ignoreDeviceCodeFlowServerPollInterval());
                this.clock((Supplier)((OAuth2ClientConfig)instance).getClock());
                this.minDefaultAccessTokenLifespan(((OAuth2ClientConfig)instance).getMinDefaultAccessTokenLifespan());
                this.minRefreshSafetyWindow(((OAuth2ClientConfig)instance).getMinRefreshSafetyWindow());
                this.minPreemptiveTokenRefreshIdleTimeout(((OAuth2ClientConfig)instance).getMinPreemptiveTokenRefreshIdleTimeout());
            }
            if (object instanceof OAuth2AuthenticatorConfig) {
                Optional<URI> deviceAuthEndpointOptional;
                Optional<Secret> clientSecretOptional;
                Optional<URI> authEndpointOptional;
                Optional<Supplier<String>> passwordSupplierOptional;
                instance = (OAuth2AuthenticatorConfig)object;
                OptionalInt authorizationCodeFlowWebServerPortOptional = instance.getAuthorizationCodeFlowWebServerPort();
                if (authorizationCodeFlowWebServerPortOptional.isPresent()) {
                    this.authorizationCodeFlowWebServerPort(authorizationCodeFlowWebServerPortOptional);
                }
                this.authorizationCodeFlowTimeout(instance.getAuthorizationCodeFlowTimeout());
                this.backgroundThreadIdleTimeout(instance.getBackgroundThreadIdleTimeout());
                this.deviceCodeFlowPollInterval(instance.getDeviceCodeFlowPollInterval());
                Optional<Supplier<String>> clientSecretSupplierOptional = instance.getClientSecretSupplier();
                if (clientSecretSupplierOptional.isPresent()) {
                    this.clientSecretSupplier(clientSecretSupplierOptional);
                }
                this.tokenExchangeEnabled(instance.getTokenExchangeEnabled());
                this.putAllExtraRequestParameters(instance.getExtraRequestParameters());
                Optional<URI> tokenEndpointOptional = instance.getTokenEndpoint();
                if (tokenEndpointOptional.isPresent()) {
                    this.tokenEndpoint(tokenEndpointOptional);
                }
                this.refreshSafetyWindow(instance.getRefreshSafetyWindow());
                Optional<Secret> passwordOptional = instance.getPassword();
                if (passwordOptional.isPresent()) {
                    this.password(passwordOptional);
                }
                if ((passwordSupplierOptional = instance.getPasswordSupplier()).isPresent()) {
                    this.passwordSupplier(passwordSupplierOptional);
                }
                if ((authEndpointOptional = instance.getAuthEndpoint()).isPresent()) {
                    this.authEndpoint(authEndpointOptional);
                }
                this.defaultAccessTokenLifespan(instance.getDefaultAccessTokenLifespan());
                Optional<ScheduledExecutorService> executorOptional = instance.getExecutor();
                if (executorOptional.isPresent()) {
                    this.executor(executorOptional);
                }
                if ((clientSecretOptional = instance.getClientSecret()).isPresent()) {
                    this.clientSecret(clientSecretOptional);
                }
                if ((deviceAuthEndpointOptional = instance.getDeviceAuthEndpoint()).isPresent()) {
                    this.deviceAuthEndpoint(deviceAuthEndpointOptional);
                }
                this.clientId(instance.getClientId());
                this.defaultRefreshTokenLifespan(instance.getDefaultRefreshTokenLifespan());
                Optional<URI> issuerUrlOptional = instance.getIssuerUrl();
                if (issuerUrlOptional.isPresent()) {
                    this.issuerUrl(issuerUrlOptional);
                }
                this.deviceCodeFlowTimeout(instance.getDeviceCodeFlowTimeout());
                this.preemptiveTokenRefreshIdleTimeout(instance.getPreemptiveTokenRefreshIdleTimeout());
                Optional<SSLContext> sslContextOptional = instance.getSslContext();
                if (sslContextOptional.isPresent()) {
                    this.sslContext(sslContextOptional);
                }
                this.impersonationConfig(instance.getImpersonationConfig());
                this.objectMapper(instance.getObjectMapper());
                this.addAllScopes(instance.getScopes());
                this.tokenExchangeConfig(instance.getTokenExchangeConfig());
                this.grantType(instance.getGrantType());
                Optional<String> usernameOptional = instance.getUsername();
                if (usernameOptional.isPresent()) {
                    this.username(usernameOptional);
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder issuerUrl(URI issuerUrl) {
            this.issuerUrl = Objects.requireNonNull(issuerUrl, "issuerUrl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuerUrl(Optional<? extends URI> issuerUrl) {
            this.issuerUrl = issuerUrl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(Optional<? extends URI> tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authEndpoint(URI authEndpoint) {
            this.authEndpoint = Objects.requireNonNull(authEndpoint, "authEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authEndpoint(Optional<? extends URI> authEndpoint) {
            this.authEndpoint = authEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceAuthEndpoint(URI deviceAuthEndpoint) {
            this.deviceAuthEndpoint = Objects.requireNonNull(deviceAuthEndpoint, "deviceAuthEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deviceAuthEndpoint(Optional<? extends URI> deviceAuthEndpoint) {
            this.deviceAuthEndpoint = deviceAuthEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder grantType(GrantType grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecret(Secret clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<? extends Secret> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Supplier<String> clientSecretSupplier) {
            this.clientSecretSupplier = Objects.requireNonNull(clientSecretSupplier, "clientSecretSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Optional<? extends Supplier<String>> clientSecretSupplier) {
            this.clientSecretSupplier = clientSecretSupplier.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder password(Secret password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(Optional<? extends Secret> password) {
            this.password = password.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder passwordSupplier(Supplier<String> passwordSupplier) {
            this.passwordSupplier = Objects.requireNonNull(passwordSupplier, "passwordSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordSupplier(Optional<? extends Supplier<String>> passwordSupplier) {
            this.passwordSupplier = passwordSupplier.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraRequestParameter(String key, String value) {
            this.extraRequestParameters.put(Objects.requireNonNull(key, "extraRequestParameters key"), Objects.requireNonNull(value, value == null ? "extraRequestParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraRequestParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraRequestParameters.put(Objects.requireNonNull(k, "extraRequestParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraRequestParameters value for key: " + k : null));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder extraRequestParameters(Map<String, ? extends String> entries) {
            this.extraRequestParameters.clear();
            return this.putAllExtraRequestParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraRequestParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraRequestParameters.put(Objects.requireNonNull(k, "extraRequestParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraRequestParameters value for key: " + k : null));
            }
            return this;
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenExchangeConfig(TokenExchangeConfig tokenExchangeConfig) {
            this.tokenExchangeConfig = Objects.requireNonNull(tokenExchangeConfig, "tokenExchangeConfig");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder impersonationConfig(ImpersonationConfig impersonationConfig) {
            this.impersonationConfig = Objects.requireNonNull(impersonationConfig, "impersonationConfig");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = Objects.requireNonNull(defaultAccessTokenLifespan, "defaultAccessTokenLifespan");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = Objects.requireNonNull(defaultRefreshTokenLifespan, "defaultRefreshTokenLifespan");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = Objects.requireNonNull(refreshSafetyWindow, "refreshSafetyWindow");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder preemptiveTokenRefreshIdleTimeout(Duration preemptiveTokenRefreshIdleTimeout) {
            this.preemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(preemptiveTokenRefreshIdleTimeout, "preemptiveTokenRefreshIdleTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder backgroundThreadIdleTimeout(Duration backgroundThreadIdleTimeout) {
            this.backgroundThreadIdleTimeout = Objects.requireNonNull(backgroundThreadIdleTimeout, "backgroundThreadIdleTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowTimeout(Duration authorizationCodeFlowTimeout) {
            this.authorizationCodeFlowTimeout = Objects.requireNonNull(authorizationCodeFlowTimeout, "authorizationCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowWebServerPort(int authorizationCodeFlowWebServerPort) {
            this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowWebServerPort(OptionalInt authorizationCodeFlowWebServerPort) {
            this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort.isPresent() ? Integer.valueOf(authorizationCodeFlowWebServerPort.getAsInt()) : null;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceCodeFlowTimeout(Duration deviceCodeFlowTimeout) {
            this.deviceCodeFlowTimeout = Objects.requireNonNull(deviceCodeFlowTimeout, "deviceCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceCodeFlowPollInterval(Duration deviceCodeFlowPollInterval) {
            this.deviceCodeFlowPollInterval = Objects.requireNonNull(deviceCodeFlowPollInterval, "deviceCodeFlowPollInterval");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sslContext(SSLContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslContext(Optional<? extends SSLContext> sslContext) {
            this.sslContext = sslContext.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executor(ScheduledExecutorService executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(Optional<? extends ScheduledExecutorService> executor) {
            this.executor = executor.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minDefaultAccessTokenLifespan(Duration minDefaultAccessTokenLifespan) {
            this.minDefaultAccessTokenLifespan = Objects.requireNonNull(minDefaultAccessTokenLifespan, "minDefaultAccessTokenLifespan");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minRefreshSafetyWindow(Duration minRefreshSafetyWindow) {
            this.minRefreshSafetyWindow = Objects.requireNonNull(minRefreshSafetyWindow, "minRefreshSafetyWindow");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minPreemptiveTokenRefreshIdleTimeout(Duration minPreemptiveTokenRefreshIdleTimeout) {
            this.minPreemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(minPreemptiveTokenRefreshIdleTimeout, "minPreemptiveTokenRefreshIdleTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minAuthorizationCodeFlowTimeout(Duration minAuthorizationCodeFlowTimeout) {
            this.minAuthorizationCodeFlowTimeout = Objects.requireNonNull(minAuthorizationCodeFlowTimeout, "minAuthorizationCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minDeviceCodeFlowTimeout(Duration minDeviceCodeFlowTimeout) {
            this.minDeviceCodeFlowTimeout = Objects.requireNonNull(minDeviceCodeFlowTimeout, "minDeviceCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder minDeviceCodeFlowPollInterval(Duration minDeviceCodeFlowPollInterval) {
            this.minDeviceCodeFlowPollInterval = Objects.requireNonNull(minDeviceCodeFlowPollInterval, "minDeviceCodeFlowPollInterval");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder ignoreDeviceCodeFlowServerPollInterval(boolean ignoreDeviceCodeFlowServerPollInterval) {
            this.ignoreDeviceCodeFlowServerPollInterval = ignoreDeviceCodeFlowServerPollInterval;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder console(PrintStream console) {
            this.console = Objects.requireNonNull(console, "console");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clock(Supplier<Instant> clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @Override
        public ImmutableOAuth2ClientConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableOAuth2ClientConfig.validate(new ImmutableOAuth2ClientConfig(this));
        }

        private boolean tokenExchangeEnabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean ignoreDeviceCodeFlowServerPollIntervalIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build OAuth2ClientConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

