/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.CreateReferenceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithTypeCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="CreateReferenceCommandSpec", generator="Immutables")
public final class ImmutableCreateReferenceCommandSpec
implements CreateReferenceCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final String refType;
    private final String ref;
    @Nullable
    private final String fromRef;
    @Nullable
    private final String refTimestampOrHash;
    private final boolean isConditional;

    private ImmutableCreateReferenceCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, String refType, String ref, @Nullable String fromRef, @Nullable String refTimestampOrHash, boolean isConditional) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = Objects.requireNonNull(refType, "refType");
        this.ref = Objects.requireNonNull(ref, "ref");
        this.fromRef = fromRef;
        this.refTimestampOrHash = refTimestampOrHash;
        this.isConditional = isConditional;
    }

    private ImmutableCreateReferenceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.refType = builder.refType;
        this.ref = builder.ref;
        this.fromRef = builder.fromRef;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.isConditional = builder.isConditional;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : CreateReferenceCommandSpec.super.sourceNode();
    }

    private ImmutableCreateReferenceCommandSpec(ImmutableCreateReferenceCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, String refType, String ref, @Nullable String fromRef, @Nullable String refTimestampOrHash, boolean isConditional) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = refType;
        this.ref = ref;
        this.fromRef = fromRef;
        this.refTimestampOrHash = refTimestampOrHash;
        this.isConditional = isConditional;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getRefType() {
        return this.refType;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getFromRef() {
        return this.fromRef;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    public boolean isConditional() {
        return this.isConditional;
    }

    public final ImmutableCreateReferenceCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, value, this.sourceNode, this.refType, this.ref, this.fromRef, this.refTimestampOrHash, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, value, this.refType, this.ref, this.fromRef, this.refTimestampOrHash, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withRefType(String value) {
        String newValue = Objects.requireNonNull(value, "refType");
        if (this.refType.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.fromRef, this.refTimestampOrHash, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withRef(String value) {
        String newValue = Objects.requireNonNull(value, "ref");
        if (this.ref.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, newValue, this.fromRef, this.refTimestampOrHash, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withFromRef(@Nullable String value) {
        if (Objects.equals(this.fromRef, value)) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, value, this.refTimestampOrHash, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, this.fromRef, value, this.isConditional);
    }

    public final ImmutableCreateReferenceCommandSpec withIsConditional(boolean value) {
        if (this.isConditional == value) {
            return this;
        }
        return new ImmutableCreateReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, this.fromRef, this.refTimestampOrHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateReferenceCommandSpec && this.equalsByValue((ImmutableCreateReferenceCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableCreateReferenceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.refType.equals(another.refType) && this.ref.equals(another.ref) && Objects.equals(this.fromRef, another.fromRef) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && this.isConditional == another.isConditional;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.refType.hashCode();
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromRef);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Booleans.hashCode((boolean)this.isConditional);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateReferenceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("refType", (Object)this.refType).add("ref", (Object)this.ref).add("fromRef", (Object)this.fromRef).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("isConditional", this.isConditional).toString();
    }

    public static ImmutableCreateReferenceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, String refType, String ref, @Nullable String fromRef, @Nullable String refTimestampOrHash, boolean isConditional) {
        return new ImmutableCreateReferenceCommandSpec(inCatalog, sourceNode, refType, ref, fromRef, refTimestampOrHash, isConditional);
    }

    public static ImmutableCreateReferenceCommandSpec copyOf(CreateReferenceCommandSpec instance) {
        if (instance instanceof ImmutableCreateReferenceCommandSpec) {
            return (ImmutableCreateReferenceCommandSpec)instance;
        }
        return ImmutableCreateReferenceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateReferenceCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REF_TYPE = 1L;
        private static final long INIT_BIT_REF = 2L;
        private static final long INIT_BIT_IS_CONDITIONAL = 4L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 7L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String refType;
        private String ref;
        private String fromRef;
        private String refTimestampOrHash;
        private boolean isConditional;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateReferenceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithTypeCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String refTimestampOrHashValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CreateReferenceCommandSpec) {
                String fromRefValue;
                instance = (CreateReferenceCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.refType(instance.getRefType());
                    bits |= 8L;
                }
                if ((fromRefValue = instance.getFromRef()) != null) {
                    this.fromRef(fromRefValue);
                }
                this.isConditional(instance.isConditional());
                if ((bits & 0x10L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 0x10L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof RefWithTypeCommandSpec) {
                instance = (RefWithTypeCommandSpec)object;
                if ((bits & 8L) == 0L) {
                    this.refType(instance.getRefType());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(String refType) {
            this.refType = Objects.requireNonNull(refType, "refType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(String ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromRef(@Nullable String fromRef) {
            this.fromRef = fromRef;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isConditional(boolean isConditional) {
            this.isConditional = isConditional;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCreateReferenceCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateReferenceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ref");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isConditional");
            }
            return "Cannot build CreateReferenceCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

