/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Random;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.Status;

class OAuth2Utils {
    private static final Random RANDOM = new SecureRandom();

    OAuth2Utils() {
    }

    static String randomAlphaNumString(int length) {
        return RANDOM.ints(48, 123).filter(i -> i <= 57 || i >= 65 && i <= 90 || i >= 97).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static JsonNode fetchOpenIdProviderMetadata(HttpClient httpClient, URI issuerUrl) {
        HttpResponse response = httpClient.newRequest(issuerUrl).path(".well-known/openid-configuration").get();
        Status status = response.getStatus();
        if (status != Status.OK) {
            throw new HttpClientException("OpenID provider metadata request returned status code " + status.getCode());
        }
        JsonNode data = response.readEntity(JsonNode.class);
        if (!data.has("issuer") || !data.has("authorization_endpoint")) {
            throw new HttpClientException("Invalid OpenID provider metadata");
        }
        return data;
    }
}

