/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v2;

import org.projectnessie.api.v2.params.ImmutableTransplant;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.builder.BaseTransplantCommitsBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Reference;

final class HttpTransplantCommits
extends BaseTransplantCommitsBuilder {
    private final HttpClient client;

    public HttpTransplantCommits(HttpClient client) {
        this.client = client;
    }

    @Override
    public TransplantCommitsBuilder keepIndividualCommits(boolean keepIndividualCommits) {
        if (!keepIndividualCommits) {
            throw new IllegalArgumentException("Individual commits are always kept during transplant operations.");
        }
        return this;
    }

    @Override
    public MergeResponse transplant() throws NessieNotFoundException, NessieConflictException {
        ImmutableTransplant.Builder transplant = ImmutableTransplant.builder().message(this.message).fromRefName(this.fromRefName).hashesToTransplant(this.hashesToTransplant).isDryRun(this.dryRun).isReturnConflictAsResult(this.returnConflictAsResult).isFetchAdditionalInfo(this.fetchAdditionalInfo);
        if (this.defaultMergeMode != null) {
            transplant.defaultKeyMergeMode(this.defaultMergeMode);
        }
        if (this.mergeModes != null) {
            transplant.keyMergeModes(this.mergeModes.values());
        }
        return this.client.newRequest().path("trees/{ref}/history/transplant").resolveTemplate("ref", Reference.toPathString(this.branchName, this.hash)).unwrap(NessieNotFoundException.class, NessieConflictException.class).post(transplant.build()).readEntity(MergeResponse.class);
    }
}

