/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Locale;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk11.JavaRequest;

public final class JavaHttpClient
implements HttpClient {
    final HttpRuntimeConfig config;
    private java.net.http.HttpClient client;

    public JavaHttpClient(HttpRuntimeConfig config) {
        this.config = config;
        HttpClient.Builder clientBuilder = java.net.http.HttpClient.newBuilder().connectTimeout(Duration.ofMillis(config.getConnectionTimeoutMillis()));
        if (config.getSslContext() != null) {
            clientBuilder.sslContext(config.getSslContext());
        }
        if (config.getSslParameters() != null) {
            clientBuilder.sslParameters(config.getSslParameters());
        }
        if (config.getFollowRedirects() != null) {
            clientBuilder.followRedirects(HttpClient.Redirect.valueOf(config.getFollowRedirects().toUpperCase(Locale.ROOT)));
        }
        if (config.isHttp11Only()) {
            clientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        this.client = clientBuilder.build();
    }

    @Override
    public HttpRequest newRequest(URI baseUri) {
        return new JavaRequest(this.config, baseUri, this.client::send);
    }

    @Override
    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    @Override
    public void close() {
        this.client = null;
        this.config.close();
    }
}

