/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.model.Content;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.types.ContentTypes;
import org.projectnessie.model.types.RepositoryConfigTypes;

final class Util {
    public static final int FIRST_ALLOWED_KEY_CHAR = 32;
    public static final char ZERO_BYTE = '\u0000';
    public static final char DOT = '.';
    public static final char GROUP_SEPARATOR = '\u001d';
    public static final char URL_PATH_SEPARATOR = '/';
    public static final String DOT_STRING = ".";
    public static final char REF_HASH_SEPARATOR = '@';

    private Util() {
    }

    public static List<String> fromPathString(String encoded) {
        return Arrays.stream(encoded.split("\\.")).map(x -> x.replace('\u001d', '.').replace('\u0000', '.')).collect(Collectors.toList());
    }

    public static String toPathString(List<String> elements) {
        return elements.stream().map(x -> x.replace('.', '\u001d').replace('\u0000', '\u001d')).collect(Collectors.joining(DOT_STRING));
    }

    public static String toPathStringRef(String name, String hash) {
        boolean separatorRequired;
        StringBuilder builder = new StringBuilder();
        boolean bl = separatorRequired = hash != null && !hash.isEmpty() && Util.isHexChar(hash.charAt(0));
        if (name != null) {
            builder.append(name);
            separatorRequired |= name.indexOf(47) >= 0;
        }
        if (separatorRequired) {
            builder.append('@');
        }
        if (hash != null) {
            builder.append(hash);
        }
        return builder.toString();
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'F' && c <= 'F';
    }

    static class DurationDeserializer
    extends StdDeserializer<Duration> {
        public DurationDeserializer() {
            this(null);
        }

        protected DurationDeserializer(Class<?> vc) {
            super(vc);
        }

        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Duration.parse(p.getText());
        }
    }

    static class DurationSerializer
    extends StdSerializer<Duration> {
        public DurationSerializer() {
            this(Duration.class);
        }

        protected DurationSerializer(Class<Duration> t) {
            super(t);
        }

        public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    static final class RepositoryConfigTypeSerializer
    extends JsonSerializer<RepositoryConfig.Type> {
        RepositoryConfigTypeSerializer() {
        }

        public void serialize(RepositoryConfig.Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.name());
            }
        }
    }

    static final class RepositoryConfigTypeDeserializer
    extends JsonDeserializer<RepositoryConfig.Type> {
        RepositoryConfigTypeDeserializer() {
        }

        public RepositoryConfig.Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? RepositoryConfigTypes.forName(name) : null;
        }
    }

    static final class ContentTypeSerializer
    extends JsonSerializer<Content.Type> {
        ContentTypeSerializer() {
        }

        public void serialize(Content.Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.name());
            }
        }
    }

    static final class ContentTypeDeserializer
    extends JsonDeserializer<Content.Type> {
        ContentTypeDeserializer() {
        }

        public Content.Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? ContentTypes.forName(name) : null;
        }
    }
}

