/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.NessieExec;
import org.apache.spark.sql.execution.datasources.v2.NessieUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieReferenceNotFoundException;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4QAC\u0006\u0002\u0002iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!\u0019\u0005A!A!\u0002\u0013i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bE\u0003A\u0011\u0001*\t\u000bi\u0003A\u0011K.\t\u000b1\u0004A\u0011I7\u0003+\t\u000b7/\u001a#s_B\u0014VMZ3sK:\u001cW-\u0012=fG*\u0011A\"D\u0001\u0003mJR!AD\b\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003!E\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005I\u0019\u0012aA:rY*\u0011A#F\u0001\u0006gB\f'o\u001b\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f\u001e\u001b\u0005Y\u0011B\u0001\u0010\f\u0005)qUm]:jK\u0016CXmY\u0001\u0007_V$\b/\u001e;\u0011\u0007\u0005ZcF\u0004\u0002#Q9\u00111EJ\u0007\u0002I)\u0011Q%G\u0001\u0007yI|w\u000e\u001e \n\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0016\u0002\u000fA\f7m[1hK*\tq%\u0003\u0002-[\t\u00191+Z9\u000b\u0005%R\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005M\n\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0002$!C!uiJL'-\u001e;f\u0003\u0019\u0011'/\u00198dQB\u0011\u0001\b\u0010\b\u0003si\u0002\"a\t\u0016\n\u0005mR\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\u0016\u0002\u001d\r,(O]3oi\u000e\u000bG/\u00197pOB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\bG\u0006$\u0018\r\\8h\u0015\t)\u0015#A\u0005d_:tWm\u0019;pe&\u0011qI\u0011\u0002\u000e\u0007\u0006$\u0018\r\\8h!2,x-\u001b8\u0002\u0011%\u001c(I]1oG\"\u0004\"AS&\u000e\u0003)J!\u0001\u0014\u0016\u0003\u000f\t{w\u000e\\3b]B\u0019!JT\u001c\n\u0005=S#AB(qi&|g.\u0001\u0006gC&dwJ\u001c#s_B\fa\u0001P5oSRtDcB*U+Z;\u0006,\u0017\t\u00039\u0001AQaH\u0004A\u0002\u0001BQAN\u0004A\u0002]BQaP\u0004A\u0002\u0001CQ\u0001S\u0004A\u0002%CQaQ\u0004A\u00025CQ\u0001U\u0004A\u0002%\u000b1B];o\u0013:$XM\u001d8bYR\u0011A,\u0019\t\u0004C-j\u0006C\u00010`\u001b\u0005\u0011\u0014B\u000113\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b\tD\u0001\u0019A2\u0002\u0007\u0005\u0004\u0018\u000e\u0005\u0002eU6\tQM\u0003\u0002cM*\u0011q\r[\u0001\u0007G2LWM\u001c;\u000b\u0005%<\u0012!\u00049s_*,7\r\u001e8fgNLW-\u0003\u0002lK\nYa*Z:tS\u0016\f\u0005/\u001b,2\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h)\t9d\u000eC\u0003p\u0013\u0001\u0007\u0001/A\u0005nCb4\u0015.\u001a7egB\u0011!*]\u0005\u0003e*\u00121!\u00138u\u0001")
public abstract class BaseDropReferenceExec
extends NessieExec {
    private final String branch;
    private final CatalogPlugin currentCatalog;
    private final boolean isBranch;
    private final Option<String> catalog;
    private final boolean failOnDrop;

    @Override
    public Seq<InternalRow> runInternal(NessieApiV1 api) {
        block4: {
            String refName = NessieUtils$.MODULE$.unquoteRefName(this.branch);
            try {
                String hash = api.getReference().refName(refName).get().getHash();
                if (this.isBranch) {
                    ((DeleteBranchBuilder)api.deleteBranch().branchName(refName).hash(hash)).delete();
                } else {
                    ((DeleteTagBuilder)api.deleteTag().tagName(refName).hash(hash)).delete();
                }
            }
            catch (NessieReferenceNotFoundException e) {
                if (!this.failOnDrop) break block4;
                throw e;
            }
        }
        return (Seq)new .colon.colon((Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"OK")})), (List)Nil$.MODULE$);
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(21).append("DropReferenceExec ").append(this.catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.currentCatalog.name())).append(" ").append((Object)(this.isBranch ? "BRANCH" : "TAG")).append(" ").append(NessieUtils$.MODULE$.unquoteRefName(this.branch)).append(" ").toString();
    }

    public BaseDropReferenceExec(Seq<Attribute> output, String branch, CatalogPlugin currentCatalog, boolean isBranch, Option<String> catalog, boolean failOnDrop) {
        this.branch = branch;
        this.currentCatalog = currentCatalog;
        this.isBranch = isBranch;
        this.catalog = catalog;
        this.failOnDrop = failOnDrop;
        Option<String> x$1 = catalog;
        CatalogPlugin x$2 = currentCatalog;
        super(x$2, x$1);
    }
}

