/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.NessieUtils;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.client.api.QueryBuilder;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class NessieUtils$ {
    public static NessieUtils$ MODULE$;
    private final String BRANCH;
    private final String TAG;

    static {
        new NessieUtils$();
    }

    public String BRANCH() {
        return this.BRANCH;
    }

    public String TAG() {
        return this.TAG;
    }

    public String unquoteRefName(String branch) {
        if (branch.startsWith("`") && branch.endsWith("`")) {
            return branch.substring(1, branch.length() - 1);
        }
        return branch;
    }

    public Reference calculateRef(String branch, Option<String> tsOrHash, NessieApiV1 api) {
        String refName = this.unquoteRefName(branch);
        String hash = (String)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$calculateRef$2(x))).orNull(Predef$.MODULE$.$conforms());
        if (hash != null) {
            return this.findReferenceFromHash(refName, hash, api);
        }
        Instant timestamp = (Instant)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).map((Function1 & Serializable & scala.Serializable)x -> {
            Instant instant;
            try {
                instant = ZonedDateTime.parse(x).toInstant();
            }
            catch (DateTimeParseException e) {
                throw new NessieReferenceNotFoundException(String.format("Invalid timestamp provided: %s. You need to provide it with a zone info. For more info, see: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html", e.getMessage()));
            }
            return instant;
        }).orNull(Predef$.MODULE$.$conforms());
        if (timestamp == null) {
            return api.getReference().refName(refName).get();
        }
        return this.findReferenceFromTimestamp(refName, api, timestamp);
    }

    private Reference findReferenceFromHash(String branch, String requestedHash, NessieApiV1 api) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)api.getCommitLog().refName(branch).hashOnRef(Validation.validateHash((String)requestedHash))).stream().findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieReferenceNotFoundException(String.format("Cannot find requested hash %s on reference %s.", requestedHash, branch));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference findReferenceFromTimestamp(String branch, NessieApiV1 api, Instant timestamp) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)((QueryBuilder)api.getCommitLog().refName(branch)).filter(String.format("timestamp(commit.commitTime) <= timestamp('%s')", timestamp))).stream().findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieReferenceNotFoundException(String.format("Cannot find a hash before %s.", timestamp));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference convertToSpecificRef(String hash, Reference reference) {
        Reference reference2 = reference;
        if (reference2 instanceof ImmutableBranch) {
            ImmutableBranch immutableBranch = (ImmutableBranch)reference2;
            return Branch.of((String)immutableBranch.getName(), (String)hash);
        }
        if (reference2 instanceof ImmutableTag) {
            ImmutableTag immutableTag = (ImmutableTag)reference2;
            return Tag.of((String)immutableTag.getName(), (String)hash);
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(reference).toString());
    }

    public NessieApiV1 nessieAPI(CatalogPlugin currentCatalog, Option<String> catalog) {
        NessieClientConfigSource nessieClientConfigSource;
        Option<Object> maybeIcebergCatalog = this.getBaseIcebergCatalog(currentCatalog, catalog);
        String errorPre = "The command works only when the catalog is a NessieCatalog or a RESTCatalog using the Nessie Catalog Server";
        String errorPost = "Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.";
        Predef$.MODULE$.require(maybeIcebergCatalog.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorPre).append(". ").append(errorPost).toString());
        Object icebergCatalog = maybeIcebergCatalog.get();
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        String string = icebergCatalog.getClass().getSimpleName();
        if ("NessieCatalog".equals(string)) {
            SparkConf sparkConf = SparkSession$.MODULE$.active().sparkContext().conf();
            scala.collection.immutable.Map catalogConf = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append(".").toString()))).toMap(Predef$.MODULE$.$conforms());
            nessieClientConfigSource = x -> (String)catalogConf.getOrElse((Object)x.replace("nessie.", ""), (Function0 & Serializable & scala.Serializable)() -> null);
        } else if ("RESTCatalog".equals(string)) {
            java.util.Map<String, String> catalogProperties = this.getCatalogProperties(icebergCatalog);
            Predef$.MODULE$.require(Boolean.parseBoolean(catalogProperties.get("nessie.is-nessie-catalog")), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append(errorPre).append(", but the referenced REST endpoint is not a Nessie Catalog Server. ").append(errorPost).toString());
            NessieUtils.Credential credential = this.resolveCredential(catalogProperties);
            nessieClientConfigSource = x -> {
                String string = x;
                if ("nessie.uri".equals(string)) {
                    return new StringBuilder(2).append((String)catalogProperties.get("nessie.core-base-uri")).append("v2").toString();
                }
                if ("nessie.authentication.oauth2.client-id".equals(string)) {
                    return credential.clientId();
                }
                if ("nessie.authentication.oauth2.client-secret".equals(string)) {
                    return credential.secret();
                }
                if ("nessie.authentication.oauth2.client-scopes".equals(string)) {
                    return MODULE$.resolveOAuthScope(catalogProperties);
                }
                if (catalogProperties.containsKey(x)) {
                    return (String)catalogProperties.get(x);
                }
                return (String)catalogProperties.get(x.replace("nessie.", ""));
            };
        } else {
            throw new IllegalArgumentException(new StringBuilder(14).append(errorPre).append(", ").append("but ").append(catalogName).append(" is a ").append(icebergCatalog.getClass().getName()).append(". ").append(errorPost).toString());
        }
        NessieClientConfigSource nessieClientConfigMapper = nessieClientConfigSource;
        NessieClientBuilder nessieClientBuilder = NessieClientBuilder.createClientBuilderFromSystemSettings((NessieClientConfigSource)nessieClientConfigMapper);
        String string2 = nessieClientConfigMapper.getValue("nessie.client-api-version");
        if (string2 == null ? true : "1".equals(string2)) {
            return (NessieApiV1)nessieClientBuilder.build(NessieApiV1.class);
        }
        if ("2".equals(string2)) {
            return (NessieApiV1)nessieClientBuilder.build(NessieApiV2.class);
        }
        throw new IllegalArgumentException(String.format("Unsupported client-api-version value: %s. Can only be 1 or 2", string2));
    }

    private String resolveViaEnvironment(java.util.Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("env:")) {
            String env = System.getenv(value.substring("env:".length()));
            if (env == null) {
                return defaultValue;
            }
            return env;
        }
        return value;
    }

    private String resolveViaEnvironment$default$3() {
        return null;
    }

    private String resolveOAuthScope(java.util.Map<String, String> catalogProperties) {
        String nessieScope = this.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-scopes", this.resolveViaEnvironment$default$3());
        if (nessieScope != null) {
            return nessieScope;
        }
        return this.resolveViaEnvironment(catalogProperties, "scope", "catalog");
    }

    private NessieUtils.Credential resolveCredential(java.util.Map<String, String> catalogProperties) {
        String nessieClientId = this.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-id", this.resolveViaEnvironment$default$3());
        String nessieClientSecret = this.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-secret", this.resolveViaEnvironment$default$3());
        NessieUtils.Credential credentialFromIceberg = this.parseIcebergCredential(this.resolveViaEnvironment(catalogProperties, "credential", this.resolveViaEnvironment$default$3()));
        return new NessieUtils.Credential(nessieClientId != null ? nessieClientId : credentialFromIceberg.clientId(), nessieClientSecret != null ? nessieClientSecret : credentialFromIceberg.secret());
    }

    private NessieUtils.Credential parseIcebergCredential(String credential) {
        if (credential == null) {
            return new NessieUtils.Credential(null, null);
        }
        int colon2 = credential.indexOf(58);
        if (colon2 == -1) {
            return new NessieUtils.Credential(null, credential);
        }
        return new NessieUtils.Credential(credential.substring(0, colon2), credential.substring(colon2 + 1));
    }

    public void setCurrentRefForSpark(CatalogPlugin currentCatalog, Option<String> catalog, Reference ref, boolean configureRefAtHash) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        CatalogPlugin catalogImpl = SparkSession$.MODULE$.active().sessionState().catalogManager().catalog(catalogName);
        SparkConf activeConf = SparkSession$.MODULE$.active().sparkContext().conf();
        Object icebergCatalog = this.getBaseIcebergCatalog(catalogImpl).get();
        String confPrefix = new StringBuilder(18).append("spark.sql.catalog.").append(catalogName).toString();
        String string = icebergCatalog.getClass().getSimpleName();
        if ("NessieCatalog".equals(string)) {
            activeConf.set(new StringBuilder(4).append(confPrefix).append(".ref").toString(), ref.getName());
            if (configureRefAtHash) {
                activeConf.set(new StringBuilder(9).append(confPrefix).append(".ref.hash").toString(), ref.getHash());
            } else {
                activeConf.remove(new StringBuilder(9).append(confPrefix).append(".ref.hash").toString());
            }
        } else if ("RESTCatalog".equals(string)) {
            java.util.Map<String, String> catalogProperties = this.getCatalogProperties(icebergCatalog);
            if (Boolean.parseBoolean(catalogProperties.get("nessie.is-nessie-catalog"))) {
                String nessiePrefixPattern = catalogProperties.get("nessie.prefix-pattern");
                Tuple2<String, Option<String>> refAndWarehouse = this.refAndWarehouseFromPrefix(catalogProperties.get("prefix"));
                String warehouseSuffix = (String)((Option)refAndWarehouse._2()).map((Function1 & Serializable & scala.Serializable)w -> new StringBuilder(1).append("|").append((String)w).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                if (configureRefAtHash) {
                    activeConf.set(new StringBuilder(7).append(confPrefix).append(".prefix").toString(), new StringBuilder(1).append(ref.getName()).append("@").append(ref.getHash()).append(warehouseSuffix).toString());
                } else {
                    activeConf.set(new StringBuilder(7).append(confPrefix).append(".prefix").toString(), new StringBuilder(0).append(ref.getName()).append(warehouseSuffix).toString());
                }
            }
        } else {
            throw new MatchError((Object)string);
        }
        java.util.Map catalogConf = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeConf.getAllWithPrefix(new StringBuilder(1).append(confPrefix).append(".").toString()))).toMap(Predef$.MODULE$.$conforms())).asJava();
        if (icebergCatalog instanceof AutoCloseable) {
            ((AutoCloseable)icebergCatalog).close();
        }
        catalogImpl.initialize(catalogName, new CaseInsensitiveStringMap(catalogConf));
    }

    public Option<Object> getBaseIcebergCatalog(CatalogPlugin currentCatalog, Option<String> catalog) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        CatalogPlugin catalogImpl = SparkSession$.MODULE$.active().sessionState().catalogManager().catalog(catalogName);
        return this.getBaseIcebergCatalog(catalogImpl);
    }

    private Option<Object> getBaseIcebergCatalog(CatalogPlugin catalogImpl) {
        None$ none$;
        try {
            Object icebergCatalog = this.icebergCatalogFromSparkCatalog(catalogImpl);
            if (icebergCatalog.getClass().getSimpleName().equals("CachingCatalog")) {
                Field cachingCatalogCatalog = icebergCatalog.getClass().getDeclaredField("catalog");
                cachingCatalogCatalog.setAccessible(true);
                icebergCatalog = cachingCatalogCatalog.get(icebergCatalog);
            }
            none$ = new Some(icebergCatalog);
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Object icebergCatalogFromSparkCatalog(CatalogPlugin catalogImpl) {
        Object object;
        try {
            object = catalogImpl.getClass().getDeclaredMethod("icebergCatalog", new Class[0]).invoke((Object)catalogImpl, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Field icebergCatalogField = catalogImpl.getClass().getDeclaredField("icebergCatalog");
            icebergCatalogField.setAccessible(true);
            object = icebergCatalogField.get(catalogImpl);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<String, String> getCatalogProperties(Object icebergCatalog) {
        java.util.Map<String, String> map;
        try {
            void var3_3;
            Method catalogProperties = icebergCatalog.getClass().getDeclaredMethod("properties", new Class[0]);
            catalogProperties.setAccessible(true);
            java.util.Map properties = (java.util.Map)catalogProperties.invoke(icebergCatalog, new Object[0]);
            map = var3_3;
        }
        catch (Exception exception) {
            map = Collections.emptyMap();
        }
        return map;
    }

    public Reference getCurrentRef(NessieApiV1 api, CatalogPlugin currentCatalog, Option<String> catalog) {
        Reference reference;
        Tuple2<String, Option<String>> currentRef = this.getCurrentRef(currentCatalog, catalog);
        String refName = (String)currentRef._1();
        try {
            Object ref = api.getReference().refName(refName).get();
            Option refHash = (Option)currentRef._2();
            if (refHash.nonEmpty()) {
                Reference.ReferenceType referenceType = ref.getType();
                Reference.ReferenceType referenceType2 = Reference.ReferenceType.BRANCH;
                ref = !(referenceType != null ? !referenceType.equals(referenceType2) : referenceType2 != null) ? Branch.of((String)ref.getName(), (String)((String)refHash.get())) : Tag.of((String)ref.getName(), (String)((String)refHash.get()));
            }
            reference = ref;
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(new StringBuilder(83).append("Could not find current reference ").append(refName).append(" configured in spark configuration for catalog '").append(catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name())).append("'.").toString(), (Throwable)e);
        }
        return reference;
    }

    public Tuple2<String, Option<String>> getCurrentRef(CatalogPlugin currentCatalog, Option<String> catalog) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        SparkConf activeConf = SparkSession$.MODULE$.active().sparkContext().conf();
        String confPrefix = new StringBuilder(18).append("spark.sql.catalog.").append(catalogName).toString();
        Object icebergCatalog = this.getBaseIcebergCatalog(currentCatalog, catalog).get();
        String string = icebergCatalog.getClass().getSimpleName();
        if ("NessieCatalog".equals(string)) {
            String refName = activeConf.get(new StringBuilder(4).append(confPrefix).append(".ref").toString());
            None$ refHash = None$.MODULE$;
            try {
                refHash = new Some((Object)activeConf.get(new StringBuilder(9).append(confPrefix).append(".ref.hash").toString()));
            }
            catch (NoSuchElementException noSuchElementException) {}
            return new Tuple2((Object)refName, (Object)refHash);
        }
        if ("RESTCatalog".equals(string)) {
            java.util.Map<String, String> catalogProperties = this.getCatalogProperties(icebergCatalog);
            String prefix = catalogProperties.get("prefix");
            Tuple2<String, Option<String>> refAndWarehouse = this.refAndWarehouseFromPrefix(prefix);
            return this.refNameAndHash((String)refAndWarehouse._1());
        }
        throw new MatchError((Object)string);
    }

    private Tuple2<String, Option<String>> refAndWarehouseFromPrefix(String prefix) {
        int idx;
        int n = idx = prefix.indexOf("|");
        switch (n) {
            case -1: {
                return new Tuple2((Object)prefix, (Object)None$.MODULE$);
            }
        }
        return new Tuple2((Object)prefix.substring(0, idx), (Object)new Some((Object)prefix.substring(idx + 1)));
    }

    private Tuple2<String, Option<String>> refNameAndHash(String prefixRef) {
        int idx;
        int n = idx = prefixRef.indexOf("@");
        switch (n) {
            case -1: {
                return new Tuple2((Object)prefixRef, (Object)None$.MODULE$);
            }
        }
        return new Tuple2((Object)prefixRef.substring(0, idx), (Object)new Some((Object)prefixRef.substring(idx + 1)));
    }

    public String getRefType(Reference ref) {
        Reference reference = ref;
        if (reference instanceof ImmutableBranch) {
            return this.BRANCH();
        }
        if (reference instanceof ImmutableTag) {
            return this.TAG();
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(ref).toString());
    }

    public static final /* synthetic */ boolean $anonfun$calculateRef$2(String x) {
        return Validation.isValidHash((String)x);
    }

    private NessieUtils$() {
        MODULE$ = this;
        this.BRANCH = "Branch";
        this.TAG = "Tag";
    }
}

