/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.client.api.QueryBuilder;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class NessieUtils$ {
    public static NessieUtils$ MODULE$;
    private final String BRANCH;
    private final String TAG;

    static {
        new NessieUtils$();
    }

    public String BRANCH() {
        return this.BRANCH;
    }

    public String TAG() {
        return this.TAG;
    }

    public String unquoteRefName(String branch) {
        if (branch.startsWith("`") && branch.endsWith("`")) {
            return branch.substring(1, branch.length() - 1);
        }
        return branch;
    }

    public Reference calculateRef(String branch, Option<String> tsOrHash, NessieApiV1 api) {
        String refName = this.unquoteRefName(branch);
        String hash = (String)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$calculateRef$2(x))).orNull(Predef$.MODULE$.$conforms());
        if (hash != null) {
            return this.findReferenceFromHash(refName, hash, api);
        }
        Instant timestamp = (Instant)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).map((Function1 & Serializable & scala.Serializable)x -> {
            Instant instant;
            try {
                instant = ZonedDateTime.parse(x).toInstant();
            }
            catch (DateTimeParseException e) {
                throw new NessieReferenceNotFoundException(String.format("Invalid timestamp provided: %s. You need to provide it with a zone info. For more info, see: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html", e.getMessage()));
            }
            return instant;
        }).orNull(Predef$.MODULE$.$conforms());
        if (timestamp == null) {
            return api.getReference().refName(refName).get();
        }
        return this.findReferenceFromTimestamp(refName, api, timestamp);
    }

    private Reference findReferenceFromHash(String branch, String requestedHash, NessieApiV1 api) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)api.getCommitLog().refName(branch).hashOnRef(Validation.validateHash((String)requestedHash))).stream().findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieReferenceNotFoundException(String.format("Cannot find requested hash %s on reference %s.", requestedHash, branch));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference findReferenceFromTimestamp(String branch, NessieApiV1 api, Instant timestamp) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)((QueryBuilder)api.getCommitLog().refName(branch)).filter(String.format("timestamp(commit.commitTime) <= timestamp('%s')", timestamp))).stream().findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieReferenceNotFoundException(String.format("Cannot find a hash before %s.", timestamp));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference convertToSpecificRef(String hash, Reference reference) {
        Reference reference2 = reference;
        if (reference2 instanceof ImmutableBranch) {
            ImmutableBranch immutableBranch = (ImmutableBranch)reference2;
            return Branch.of((String)immutableBranch.getName(), (String)hash);
        }
        if (reference2 instanceof ImmutableTag) {
            ImmutableTag immutableTag = (ImmutableTag)reference2;
            return Tag.of((String)immutableTag.getName(), (String)hash);
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(reference).toString());
    }

    public String getRefType(Reference ref) {
        Reference reference = ref;
        if (reference instanceof ImmutableBranch) {
            return this.BRANCH();
        }
        if (reference instanceof ImmutableTag) {
            return this.TAG();
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(ref).toString());
    }

    public static final /* synthetic */ boolean $anonfun$calculateRef$2(String x) {
        return Validation.isValidHash((String)x);
    }

    private NessieUtils$() {
        MODULE$ = this;
        this.BRANCH = "Branch";
        this.TAG = "Tag";
    }
}

