/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.NessieExec;
import org.apache.spark.sql.execution.datasources.v2.NessieUtils$;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Y4Qa\u0003\u0007\u0002\u0002mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!!\u0005A!A!\u0002\u0013q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!\u0011!Q\u0001\n)CQa\u0015\u0001\u0005\u0002QCQ!\u0018\u0001\u0005RyCQa\u001c\u0001\u0005BA\u0014qCQ1tK\u000e\u0013X-\u0019;f%\u00164WM]3oG\u0016,\u00050Z2\u000b\u00055q\u0011A\u0001<3\u0015\ty\u0001#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\t\u0013\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002\u0019%\u0011q\u0004\u0004\u0002\u000b\u001d\u0016\u001c8/[3Fq\u0016\u001c\u0017AB8viB,H\u000fE\u0002#Y=r!aI\u0015\u000f\u0005\u0011:S\"A\u0013\u000b\u0005\u0019R\u0012A\u0002\u001fs_>$h(C\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQ3&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003!J!!\f\u0018\u0003\u0007M+\u0017O\u0003\u0002+WA\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00025%\u0005A1-\u0019;bYf\u001cH/\u0003\u00027c\tI\u0011\t\u001e;sS\n,H/Z\u0001\u0007EJ\fgn\u00195\u0011\u0005ejdB\u0001\u001e<!\t!3&\u0003\u0002=W\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta4&\u0001\bdkJ\u0014XM\u001c;DCR\fGn\\4\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015aB2bi\u0006dwn\u001a\u0006\u0003\rJ\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005!\u001b%!D\"bi\u0006dwn\u001a)mk\u001eLg.\u0001\u0005jg\n\u0013\u0018M\\2i!\tYE*D\u0001,\u0013\ti5FA\u0004C_>dW-\u00198\u0011\u0007-{\u0005(\u0003\u0002QW\t1q\n\u001d;j_:\f1b\u0019:fCR,GM\u0012:p[\u0006aa-Y5m\u001f:\u001c%/Z1uK\u00061A(\u001b8jiz\"\u0002\"\u0016,X1fS6\f\u0018\t\u0003;\u0001AQ\u0001\t\u0005A\u0002\u0005BQa\u000e\u0005A\u0002aBQ\u0001\u0011\u0005A\u0002\u0005CQ!\u0013\u0005A\u0002)CQ\u0001\u0012\u0005A\u00029CQ!\u0015\u0005A\u00029CQA\u0015\u0005A\u0002)\u000b1B];o\u0013:$XM\u001d8bYR\u0011q\f\u001a\t\u0004E1\u0002\u0007CA1c\u001b\u0005\u0019\u0014BA24\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b\u0015L\u0001\u0019\u00014\u0002\u0007\u0005\u0004\u0018\u000e\u0005\u0002h[6\t\u0001N\u0003\u0002fS*\u0011!n[\u0001\u0007G2LWM\u001c;\u000b\u00051D\u0012!\u00049s_*,7\r\u001e8fgNLW-\u0003\u0002oQ\nYa*Z:tS\u0016\f\u0005/\u001b,2\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h)\tA\u0014\u000fC\u0003s\u0015\u0001\u00071/A\u0005nCb4\u0015.\u001a7egB\u00111\n^\u0005\u0003k.\u00121!\u00138u\u0001")
public abstract class BaseCreateReferenceExec
extends NessieExec {
    private final String branch;
    private final CatalogPlugin currentCatalog;
    private final boolean isBranch;
    private final Option<String> catalog;
    private final Option<String> createdFrom;
    private final boolean failOnCreate;

    @Override
    public Seq<InternalRow> runInternal(NessieApiV1 api) {
        BoxedUnit boxedUnit;
        Reference reference;
        if (this.createdFrom.isDefined()) {
            reference = api.getReference().refName((String)this.createdFrom.map((Function1 & Serializable)branch -> NessieUtils$.MODULE$.unquoteRefName((String)branch)).get()).get();
        } else {
            try {
                reference = NessieUtils$.MODULE$.getCurrentRef(api, this.currentCatalog, this.catalog);
            }
            catch (NessieNotFoundException e) {
                throw new NessieReferenceNotFoundException(new StringBuilder(50).append(e.getMessage()).append(" Use 'CREATE ").append((Object)(this.isBranch ? "BRANCH" : "TAG")).append(" ... FROM <existing-reference-name>'.").toString(), (Throwable)e);
            }
        }
        Reference sourceRef = reference;
        String refName = NessieUtils$.MODULE$.unquoteRefName(this.branch);
        Branch ref = this.isBranch ? Branch.of((String)refName, (String)sourceRef.getHash()) : Tag.of((String)refName, (String)sourceRef.getHash());
        try {
            boxedUnit = api.createReference().reference((Reference)ref).sourceRefName(sourceRef.getName()).create();
        }
        catch (NessieConflictException e) {
            if (this.failOnCreate) {
                throw e;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        Reference result = api.getReference().refName(ref.getName()).get();
        return this.singleRowForRef(result);
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(23).append("CreateReferenceExec ").append(this.catalog.getOrElse((Function0 & Serializable)() -> $this.currentCatalog.name())).append(" ").append((Object)(this.isBranch ? "BRANCH" : "TAG")).append(" ").append(NessieUtils$.MODULE$.unquoteRefName(this.branch)).append(" ").append(this.createdFrom.map((Function1 & Serializable)branch -> NessieUtils$.MODULE$.unquoteRefName((String)branch))).toString();
    }

    public BaseCreateReferenceExec(Seq<Attribute> output, String branch, CatalogPlugin currentCatalog, boolean isBranch, Option<String> catalog, Option<String> createdFrom, boolean failOnCreate) {
        this.branch = branch;
        this.currentCatalog = currentCatalog;
        this.isBranch = isBranch;
        this.catalog = catalog;
        this.createdFrom = createdFrom;
        this.failOnCreate = failOnCreate;
        Option<String> x$1 = catalog;
        CatalogPlugin x$2 = currentCatalog;
        super(x$2, x$1);
    }
}

