/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.ext;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.Extension;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.test.JerseyTest;
import org.jboss.weld.environment.se.Weld;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.projectnessie.jaxrs.ext.NessieAccessChecker;
import org.projectnessie.jaxrs.ext.NessieSecurityContext;
import org.projectnessie.jaxrs.ext.NessieUri;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.AuthorizerExtension;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfigExtension;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.rest.ConstraintViolationExceptionMapper;
import org.projectnessie.services.rest.ContentKeyParamConverterProvider;
import org.projectnessie.services.rest.InstantParamConverterProvider;
import org.projectnessie.services.rest.NessieExceptionMapper;
import org.projectnessie.services.rest.NessieJaxRsJsonMappingExceptionMapper;
import org.projectnessie.services.rest.NessieJaxRsJsonParseExceptionMapper;
import org.projectnessie.services.rest.ReferenceTypeParamConverterProvider;
import org.projectnessie.services.rest.RestConfigResource;
import org.projectnessie.services.rest.RestContentResource;
import org.projectnessie.services.rest.RestDiffResource;
import org.projectnessie.services.rest.RestRefLogResource;
import org.projectnessie.services.rest.RestTreeResource;
import org.projectnessie.services.rest.ValidationExceptionMapper;
import org.projectnessie.versioned.PersistVersionStoreExtension;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;

public class NessieJaxRsExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{NessieJaxRsExtension.class});
    private final Supplier<DatabaseAdapter> databaseAdapterSupplier;

    public NessieJaxRsExtension() {
        throw new UnsupportedOperationException();
    }

    public NessieJaxRsExtension(Supplier<DatabaseAdapter> databaseAdapterSupplier) {
        this.databaseAdapterSupplier = databaseAdapterSupplier;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent(EnvHolder.class, key -> {
            try {
                return new EnvHolder(this.databaseAdapterSupplier);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        EnvHolder env = (EnvHolder)extensionContext.getStore(NAMESPACE).get(EnvHolder.class, EnvHolder.class);
        env.reset();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        EnvHolder env = (EnvHolder)extensionContext.getStore(NAMESPACE).get(EnvHolder.class, EnvHolder.class);
        env.reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(NessieUri.class) || parameterContext.isAnnotated(NessieSecurityContext.class) || parameterContext.isAnnotated(NessieAccessChecker.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        EnvHolder env = (EnvHolder)extensionContext.getStore(NAMESPACE).get(EnvHolder.class, EnvHolder.class);
        if (env == null) {
            throw new ParameterResolutionException("Nessie JaxRs env. is not initialized in " + extensionContext.getUniqueId());
        }
        if (parameterContext.isAnnotated(NessieUri.class)) {
            return env.jerseyTest.target().getUri();
        }
        if (parameterContext.isAnnotated(NessieSecurityContext.class)) {
            return env::setSecurityContext;
        }
        if (parameterContext.isAnnotated(NessieAccessChecker.class)) {
            return env::setAccessChecker;
        }
        throw new ParameterResolutionException("Unsupported annotation on parameter " + parameterContext.getParameter() + " on " + parameterContext.getTarget());
    }

    private static class EnvHolder
    implements ExtensionContext.Store.CloseableResource {
        private final Weld weld = new Weld();
        private final JerseyTest jerseyTest;
        private SecurityContext securityContext;
        private Function<AccessContext, BatchAccessChecker> accessChecker;

        void reset() {
            this.securityContext = null;
            this.accessChecker = null;
        }

        void setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        void setAccessChecker(Function<AccessContext, BatchAccessChecker> accessChecker) {
            this.accessChecker = accessChecker;
        }

        public EnvHolder(Supplier<DatabaseAdapter> databaseAdapterSupplier) throws Exception {
            this.weld.addPackages(true, new Class[]{TreeApiImpl.class});
            this.weld.addExtension((Extension)new ServerConfigExtension());
            this.weld.addExtension((Extension)PersistVersionStoreExtension.forDatabaseAdapter(() -> {
                DatabaseAdapter databaseAdapter = (DatabaseAdapter)databaseAdapterSupplier.get();
                databaseAdapter.eraseRepo();
                databaseAdapter.initializeRepo(ServerConfigExtension.SERVER_CONFIG.getDefaultBranch());
                return databaseAdapter;
            }));
            this.weld.addExtension((Extension)new AuthorizerExtension().setAccessCheckerSupplier(this::createNewChecker));
            this.weld.initialize();
            this.jerseyTest = new JerseyTest(){

                protected Application configure() {
                    ResourceConfig config = new ResourceConfig();
                    config.register(RestConfigResource.class);
                    config.register(RestTreeResource.class);
                    config.register(RestContentResource.class);
                    config.register(RestDiffResource.class);
                    config.register(RestRefLogResource.class);
                    config.register(ConfigApiImpl.class);
                    config.register(ContentKeyParamConverterProvider.class);
                    config.register(ReferenceTypeParamConverterProvider.class);
                    config.register(InstantParamConverterProvider.class);
                    config.register(ValidationExceptionMapper.class, 10);
                    config.register(ConstraintViolationExceptionMapper.class, 10);
                    config.register(NessieExceptionMapper.class);
                    config.register(NessieJaxRsJsonParseExceptionMapper.class, 10);
                    config.register(NessieJaxRsJsonMappingExceptionMapper.class, 10);
                    config.register(EncodingFilter.class);
                    config.register(GZipEncoder.class);
                    config.register(DeflateEncoder.class);
                    config.register(requestContext -> {
                        if (securityContext != null) {
                            requestContext.setSecurityContext(securityContext);
                        }
                    });
                    this.set("jersey.config.test.container.port", "0");
                    return config;
                }
            };
            this.jerseyTest.setUp();
        }

        private BatchAccessChecker createNewChecker(AccessContext context) {
            if (this.accessChecker == null) {
                return AbstractBatchAccessChecker.NOOP_ACCESS_CHECKER;
            }
            return this.accessChecker.apply(context);
        }

        public void close() throws Throwable {
            this.jerseyTest.tearDown();
            this.weld.shutdown();
        }
    }
}

