/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.ext;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.ext.NessieJaxRsExtension;
import org.projectnessie.jaxrs.ext.NessieUri;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.inmem.InmemoryTestConnectionProviderSource;
import org.projectnessie.versioned.persist.tests.extension.DatabaseAdapterExtension;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterName;
import org.projectnessie.versioned.persist.tests.extension.NessieExternalDatabase;

@ExtendWith(value={DatabaseAdapterExtension.class})
@NessieDbAdapterName(value="In-Memory")
@NessieExternalDatabase(value=InmemoryTestConnectionProviderSource.class)
class TestNessieJaxRsExtension {
    @NessieDbAdapter
    static DatabaseAdapter databaseAdapter;
    @RegisterExtension
    static NessieJaxRsExtension server;
    private static NessieApiV1 api;

    TestNessieJaxRsExtension() {
    }

    @BeforeAll
    static void setupClient(@NessieUri URI uri) {
        Assertions.assertThat((Object)databaseAdapter).isNotNull();
        api = (NessieApiV1)HttpClientBuilder.builder().withUri(uri).build(NessieApiV1.class);
    }

    private void checkServer() throws NessieNotFoundException {
        Assertions.assertThat((String)api.getDefaultBranch().getName()).isEqualTo("main");
    }

    @Test
    void topLevel() throws NessieNotFoundException {
        this.checkServer();
    }

    static {
        server = new NessieJaxRsExtension(() -> databaseAdapter);
    }

    @Nested
    class Nested2 {
        Nested2() {
        }

        @Test
        void nestedTest() throws NessieNotFoundException {
            TestNessieJaxRsExtension.this.checkServer();
        }
    }

    @Nested
    class Nested1 {
        Nested1() {
        }

        @Test
        void nestedTest() throws NessieNotFoundException {
            TestNessieJaxRsExtension.this.checkServer();
        }

        @Nested
        class NestedTwice {
            NestedTwice() {
            }

            @Test
            void nestedTest() throws NessieNotFoundException {
                TestNessieJaxRsExtension.this.checkServer();
            }
        }
    }
}

