/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.net.URI;
import javax.enterprise.inject.spi.Extension;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.JerseyTest;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.jaxrs.NessieJaxRsJsonMappingExceptionMapper;
import org.projectnessie.jaxrs.NessieJaxRsJsonParseExceptionMapper;
import org.projectnessie.services.authz.AccessCheckerExtension;
import org.projectnessie.services.config.ServerConfigExtension;
import org.projectnessie.services.rest.ConfigResource;
import org.projectnessie.services.rest.ContentsKeyParamConverterProvider;
import org.projectnessie.services.rest.ContentsResource;
import org.projectnessie.services.rest.InstantParamConverterProvider;
import org.projectnessie.services.rest.NessieExceptionMapper;
import org.projectnessie.services.rest.TreeResource;
import org.projectnessie.services.rest.ValidationExceptionMapper;
import org.projectnessie.versioned.VersionStoreExtension;

public class NessieJaxRsExtension
implements BeforeAllCallback,
AfterAllCallback {
    private Weld weld;
    private JerseyTest jerseyTest;

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.weld = new Weld();
        this.weld.addPackages(true, new Class[]{TreeResource.class});
        this.weld.addExtension((Extension)new ServerConfigExtension());
        this.weld.addExtension((Extension)new VersionStoreExtension());
        this.weld.addExtension((Extension)new AccessCheckerExtension());
        WeldContainer container = this.weld.initialize();
        this.jerseyTest = new JerseyTest(){

            protected Application configure() {
                ResourceConfig config = new ResourceConfig();
                config.register(TreeResource.class);
                config.register(ContentsResource.class);
                config.register(ConfigResource.class);
                config.register(ContentsKeyParamConverterProvider.class);
                config.register(InstantParamConverterProvider.class);
                config.register(ValidationExceptionMapper.class, 10);
                config.register(NessieExceptionMapper.class);
                config.register(NessieJaxRsJsonParseExceptionMapper.class, 10);
                config.register(NessieJaxRsJsonMappingExceptionMapper.class, 10);
                return config;
            }
        };
        this.jerseyTest.setUp();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (null != this.jerseyTest) {
            this.jerseyTest.tearDown();
        }
        if (null != this.weld) {
            this.weld.shutdown();
        }
    }

    public URI getURI() {
        if (null == this.jerseyTest) {
            return null;
        }
        return this.jerseyTest.target().getUri();
    }
}

