/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentsBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;

public abstract class AbstractTestRest {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";
    private NessieApiV1 api;
    private HttpClient httpClient;

    protected void init(URI uri) {
        NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(uri).build(NessieApiV1.class);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        HttpClient httpClient = HttpClient.builder().setBaseUri(uri).setObjectMapper(mapper).build();
        httpClient.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
        this.init(api, httpClient);
    }

    protected void init(NessieApiV1 api, @Nullable HttpClient httpClient) {
        this.api = api;
        this.httpClient = httpClient;
    }

    @BeforeEach
    public void setUp() {
        this.init(URI.create("http://localhost:19121/api/v1"));
    }

    @AfterEach
    public void tearDown() {
        this.api.close();
    }

    @Test
    void createRecreateDefaultBranch() throws NessieConflictException, NessieNotFoundException {
        ((DeleteBranchBuilder)this.api.deleteBranch().branch(this.api.getDefaultBranch())).delete();
        this.api.createReference().reference((Reference)Branch.of((String)"main", null)).create();
        this.api.getReference().refName("main").get();
    }

    @Test
    void createReferences() throws NessieNotFoundException {
        String mainHash = this.api.getReference().refName("main").get().getHash();
        String tagName1 = "createReferences_tag1";
        String tagName2 = "createReferences_tag2";
        String branchName1 = "createReferences_branch1";
        String branchName2 = "createReferences_branch2";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("unknownSource").reference((Reference)Tag.of((String)tagName2, null)).create()).isInstanceOf(NessieNotFoundException.class)).hasMessageContainingAll(new CharSequence[]{"'unknownSource'", "not"}), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> {
            Reference refTag1 = this.api.createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName2, (String)mainHash), (Object)refTag1);
        }, () -> {
            Reference refBranch1 = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName1, null)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName1, (String)mainHash), (Object)refBranch1);
        }, () -> {
            Reference refBranch2 = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)mainHash), (Object)refBranch2);
        }});
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    void referenceNames(String refNamePart) throws NessieNotFoundException, NessieConflictException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        String root = "ref_name_" + refNamePart.replaceAll("[^a-z]", "");
        Reference main = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)root, null)).create();
        IcebergTable meta = IcebergTable.of((String)"meep", (long)-1L);
        main = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("common-merge-ancestor").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"meep"}), (Contents)meta)).commit();
        String someHash = main.getHash();
        Reference createdTag = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)tagName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName, (String)someHash), (Object)createdTag);
        Reference createdBranch1 = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName, (String)someHash), (Object)createdBranch1);
        Reference createdBranch2 = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName2, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)someHash), (Object)createdBranch2);
        Map references = this.api.getAllReferences().get().stream().filter(r -> root.equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        Assertions.assertThat(references).containsAllEntriesOf((Map)ImmutableMap.of((Object)main.getName(), (Object)main, (Object)createdTag.getName(), (Object)createdTag, (Object)createdBranch1.getName(), (Object)createdBranch1, (Object)createdBranch2.getName(), (Object)createdBranch2));
        Assertions.assertThat((Object)((Reference)references.get(main.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdTag.getName()))).isInstanceOf(Tag.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch1.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch2.getName()))).isInstanceOf(Branch.class);
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        Assertions.assertThat((Object)this.api.getReference().refName(tagName).get()).isEqualTo((Object)tagRef);
        Assertions.assertThat((Object)this.api.getReference().refName(branchName).get()).isEqualTo((Object)branchRef);
        EntriesResponse entries = ((GetEntriesBuilder)this.api.getEntries().refName(tagName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        entries = ((GetEntriesBuilder)this.api.getEntries().refName(branchName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(tagName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        meta = IcebergTable.of((String)"foo", (long)-1L);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branchName)).hash(branchHash)).operation((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"some-key"}), (Contents)meta)).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).commit();
        log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).get();
        String newHash = ((CommitMeta)log.getOperations().get(0)).getHash();
        ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(tagName)).hash(tagHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((AssignBranchBuilder)((AssignBranchBuilder)this.api.assignBranch().branchName(branchName)).hash(newHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(branchName2)).hash(branchHash2)).fromRefName(branchName).fromHash(newHash).merge();
        ((DeleteTagBuilder)((DeleteTagBuilder)this.api.deleteTag().tagName(tagName)).hash(newHash)).delete();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(branchName)).hash(newHash)).delete();
    }

    @Test
    public void filterCommitLogByAuthor() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByAuthor", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)filterCommitLogByAuthor).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.author == 'author-3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor);
        log.getOperations().forEach(commit -> Assertions.assertThat((String)commit.getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.author == 'author-3' && commit.committer == 'random-committer'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.author == 'author-3' && commit.committer == ''")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor);
        log.getOperations().forEach(commit -> Assertions.assertThat((String)commit.getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.author in ['author-1', 'author-3', 'author-4']")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 3);
        log.getOperations().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-1", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("!(commit.author in ['author-1', 'author-0'])")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 3);
        log.getOperations().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.author.matches('au.*-(2|4)')")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 2);
        log.getOperations().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()}));
    }

    @Test
    public void filterCommitLogByTimeRange() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByTimeRange", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)filterCommitLogByAuthor).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        int expectedTotalSize = numAuthors * commitsPerAuthor;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        Instant initialCommitTime = ((CommitMeta)log.getOperations().get(log.getOperations().size() - 1)).getCommitTime();
        Assertions.assertThat((Instant)initialCommitTime).isNotNull();
        Instant lastCommitTime = ((CommitMeta)log.getOperations().get(0)).getCommitTime();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        Instant fiveMinLater = initialCommitTime.plus(5L, ChronoUnit.MINUTES);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression(String.format("timestamp(commit.commitTime) > timestamp('%s')", initialCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(initialCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression(String.format("timestamp(commit.commitTime) < timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isBefore(fiveMinLater));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression(String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", initialCommitTime, lastCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize - 2);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(initialCommitTime).isBefore(lastCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression(String.format("timestamp(commit.commitTime) > timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
    }

    @Test
    public void filterCommitLogByProperties() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByProperties", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)filterCommitLogByAuthor).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.properties['prop1'] == 'val1'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log.getOperations().forEach(commit -> Assertions.assertThat((String)((String)commit.getProperties().get("prop1"))).isEqualTo("val1"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).queryExpression("commit.properties['prop1'] == 'val3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
    }

    @Test
    public void filterCommitLogByCommitRange() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch b = Branch.of((String)"filterCommitLogByCommitRange", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)b).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        int numCommits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, numCommits, currentHash);
        LogResponse entireLog = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getOperations()).hasSize(numCommits);
        String startHash = ((CommitMeta)entireLog.getOperations().get(numCommits / 2)).getHash();
        String endHash = ((CommitMeta)entireLog.getOperations().get(0)).getHash();
        LogResponse log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits / 2 + 1);
        int i = 0;
        for (int j = numCommits - 1; i < j; ++i, --j) {
            startHash = ((CommitMeta)entireLog.getOperations().get(j)).getHash();
            endHash = ((CommitMeta)entireLog.getOperations().get(i)).getHash();
            log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - i * 2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getOperations()).subList(i, j + 1)).containsExactlyElementsOf((Iterable)log.getOperations());
        }
    }

    private void createCommits(Reference branch, int numAuthors, int commitsPerAuthor, String currentHash) throws NessieNotFoundException, NessieConflictException {
        for (int j = 0; j < numAuthors; ++j) {
            String author = "author-" + j;
            for (int i = 0; i < commitsPerAuthor; ++i) {
                IcebergTable meta = IcebergTable.of((String)("some-file-" + i), (long)-1L);
                String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("committed-by-" + author).properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"table" + i}), (Contents)meta)).commit().getHash();
                Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
                currentHash = nextHash;
            }
        }
    }

    @Test
    void commitLogPagingAndFilteringByAuthor() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.api.getReference().refName("main").get().getHash();
        String branchName = "commitLogPagingAndFiltering";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.api.createReference().sourceRefName("main").reference((Reference)branch).create();
        int numAuthors = 3;
        int commits = 45;
        int pageSizeHint = 10;
        int expectedTotalSize = numAuthors * commits;
        this.createCommits((Reference)branch, numAuthors, commits, someHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        String author = "author-1";
        List<String> messagesOfAuthorOne = log.getOperations().stream().filter(c -> author.equals(c.getAuthor())).map(CommitMeta::getMessage).collect(Collectors.toList());
        this.verifyPaging(branchName, commits, pageSizeHint, messagesOfAuthorOne, author);
        List allMessages = log.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList());
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.api, (String)branchName, null, null, null, (OptionalInt)OptionalInt.of(pageSizeHint)).collect(Collectors.toList());
        Assertions.assertThat(completeLog.stream().map(CommitMeta::getMessage)).containsExactlyElementsOf(allMessages);
    }

    @Test
    void commitLogPaging() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.api.getReference().refName("main").get().getHash();
        String branchName = "commitLogPaging";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.api.createReference().sourceRefName("main").reference((Reference)branch).create();
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = someHash;
        ArrayList<String> allMessages = new ArrayList<String>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add(msg);
            IcebergTable tableMeta = IcebergTable.of((String)("some-file-" + i), (long)-1L);
            String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branchName)).hash(currentHash)).commitMeta(CommitMeta.fromMessage((String)msg)).operation((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"table"}), (Contents)tableMeta)).commit().getHash();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)currentHash, (Object)nextHash);
            currentHash = nextHash;
        }
        Collections.reverse(allMessages);
        this.verifyPaging(branchName, commits, pageSizeHint, allMessages, null);
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.api, (String)branchName, null, null, null, (OptionalInt)OptionalInt.of(pageSizeHint)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    private void verifyPaging(String branchName, int commits, int pageSizeHint, List<String> commitMessages, String filterByAuthor) throws NessieNotFoundException {
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            String queryExpression = null;
            if (null != filterByAuthor) {
                queryExpression = String.format("commit.author=='%s'", filterByAuthor);
            }
            LogResponse response = ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).maxRecords(pageSizeHint)).pageToken(pageToken)).queryExpression(queryExpression)).get();
            if (pos + pageSizeHint > commits) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMore());
                org.junit.jupiter.api.Assertions.assertNull((Object)response.getToken());
                org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, commitMessages.size()), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMore());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)response.getToken());
            org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, pos + pageSizeHint), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
    }

    @Test
    void multiget() throws NessieNotFoundException, NessieConflictException {
        String branch = "foo";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"foo", null)).create();
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)-1L);
        IcebergTable tb = IcebergTable.of((String)"path2", (long)-1L);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("foo")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)a, (Contents)ta)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("foo")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)b, (Contents)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        Map response = ((GetContentsBuilder)this.api.getContents().key(a).key(b).key(ContentsKey.of((String[])new String[]{"noexist"})).refName("foo")).get();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)response).containsEntry((Object)a, (Object)ta)).containsEntry((Object)b, (Object)tb)).doesNotContainKey((Object)ContentsKey.of((String[])new String[]{"noexist"}));
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName("foo")).hash(this.api.getReference().refName("foo").get().getHash())).delete();
    }

    static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg"}), (Contents)IcebergTable.of((String)"/iceberg/table", (long)-1L))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.DREMIO).sqlText("SELECT foo FROM dremio").build())), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_presto"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.PRESTO).sqlText("SELECT foo FROM presto").build())), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.SPARK).sqlText("SELECT foo FROM spark").build())), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta"}), (Contents)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg_delete"}))), new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg_unchanged"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio_delete"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio_unchanged"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark_delete"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark_unchanged"}))), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta_delete"}))), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta_unchanged"}))));
    }

    @Test
    void verifyAllContentAndOperationTypes() throws NessieNotFoundException, NessieConflictException {
        String branchName = "contentAndOperationAll";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName, null)).create();
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branchName)).hash(r.getHash())).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        AbstractTestRest.contentAndOperationTypes().flatMap(c -> c.globalOperation == null ? Stream.of(c.operation) : Stream.of(c.operation, c.globalOperation)).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)commit).operation(arg_0));
        commit.commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branchName)).get().getEntries();
        List expect = AbstractTestRest.contentAndOperationTypes().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws NessieNotFoundException, NessieConflictException {
        String branchName = "contentAndOperation_" + contentAndOperationType;
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName, null)).create();
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branchName)).hash(r.getHash())).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).operation(contentAndOperationType.operation);
        if (contentAndOperationType.globalOperation != null) {
            commit.operation(contentAndOperationType.globalOperation);
        }
        commit.commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branchName)).get().getEntries();
        ContentsKey fixedContentKey = ContentsKey.of((List)contentAndOperationType.operation.getKey().getElements());
        List expect = contentAndOperationType.operation instanceof Operation.Put ? Collections.singletonList(EntriesResponse.Entry.builder().name(fixedContentKey).type(contentAndOperationType.type).build()) : Collections.emptyList();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @Test
    void filterEntriesByType() throws NessieNotFoundException, NessieConflictException {
        String branch = "filterTypes";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"filterTypes", null)).create();
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable tam = IcebergTable.of((String)"path1", (long)-1L);
        ImmutableSqlView tb = ImmutableSqlView.builder().sqlText("select * from table").dialect(SqlView.Dialect.DREMIO).build();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterTypes")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)a, (Contents)tam)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterTypes")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)b, (Contents)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName("filterTypes")).get().getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Contents.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Contents.Type.VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterTypes")).queryExpression("entry.contentType=='ICEBERG_TABLE'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterTypes")).queryExpression("entry.contentType=='VIEW'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterTypes")).queryExpression("entry.contentType in ['ICEBERG_TABLE', 'VIEW']")).get().getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName("filterTypes")).hash(this.api.getReference().refName("filterTypes").get().getHash())).delete();
    }

    @Test
    public void filterEntriesByNamespace() throws NessieConflictException, NessieNotFoundException {
        String branch = "filterEntriesByNamespace";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"filterEntriesByNamespace", null)).create();
        ContentsKey first = ContentsKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentsKey second = ContentsKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentsKey third = ContentsKey.of((String[])new String[]{"a", "thirdTable"});
        ContentsKey fourth = ContentsKey.of((String[])new String[]{"a", "fourthTable"});
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterEntriesByNamespace")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)first, (Contents)IcebergTable.of((String)"path1", (long)-1L))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterEntriesByNamespace")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)second, (Contents)IcebergTable.of((String)"path2", (long)-1L))).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterEntriesByNamespace")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)third, (Contents)IcebergTable.of((String)"path3", (long)-1L))).commitMeta(CommitMeta.fromMessage((String)"commit 3")).commit();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterEntriesByNamespace")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)fourth, (Contents)IcebergTable.of((String)"path4", (long)-1L))).commitMeta(CommitMeta.fromMessage((String)"commit 4")).commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).queryExpression("entry.namespace.startsWith('a.b')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a.b"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).queryExpression("entry.namespace.startsWith('a')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).queryExpression("entry.namespace.startsWith('a.b.c.firstTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespace")).queryExpression("entry.namespace.startsWith('a.fourthTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName("filterEntriesByNamespace")).hash(this.api.getReference().refName("filterEntriesByNamespace").get().getHash())).delete();
    }

    @Test
    public void filterEntriesByNamespaceAndPrefixDepth() throws NessieConflictException, NessieNotFoundException {
        String branch = "filterEntriesByNamespaceAndPrefixDepth";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"filterEntriesByNamespaceAndPrefixDepth", null)).create();
        ContentsKey first = ContentsKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentsKey second = ContentsKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentsKey third = ContentsKey.of((String[])new String[]{"a", "thirdTable"});
        ContentsKey fourth = ContentsKey.of((String[])new String[]{"a", "b", "fourthTable"});
        ContentsKey fifth = ContentsKey.of((String[])new String[]{"a", "boo", "fifthTable"});
        ImmutableList keys = ImmutableList.of((Object)first, (Object)second, (Object)third, (Object)fourth, (Object)fifth);
        for (int i = 0; i < 5; ++i) {
            ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("filterEntriesByNamespaceAndPrefixDepth")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)((ContentsKey)keys.get(i)), (Contents)IcebergTable.of((String)("path" + i), (long)-1L))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commit();
        }
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(0)).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(0)).queryExpression("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(1)).queryExpression("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(1);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(2)).queryExpression("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.thirdTable", "a.b", "a.boo"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(3)).queryExpression("entry.namespace.matches('a\\\\.b(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c", "a.b.fourthTable"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("filterEntriesByNamespaceAndPrefixDepth")).namespaceDepth(Integer.valueOf(4)).queryExpression("entry.namespace.matches('a\\\\.b\\\\.c(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c.firstTable", "a.b.c.secondTable"});
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName("filterEntriesByNamespaceAndPrefixDepth")).hash(this.api.getReference().refName("filterEntriesByNamespaceAndPrefixDepth").get().getHash())).delete();
    }

    @Test
    public void checkCelScriptFailureReporting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("main")).queryExpression("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName("main")).queryExpression("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
    }

    @Test
    void checkSpecialCharacterRoundTrip() throws NessieNotFoundException, NessieConflictException {
        String branch = "specialchar";
        Reference r = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"specialchar", null)).create();
        ContentsKey k = ContentsKey.of((String[])new String[]{"a.b", "c.txt"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)-1L);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName("specialchar")).hash(r.getHash())).operation((Operation)Operation.Put.of((ContentsKey)k, (Contents)ta)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        Assertions.assertThat((Map)((GetContentsBuilder)this.api.getContents().key(k).refName("specialchar")).get()).containsEntry((Object)k, (Object)ta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ta, ((GetContentsBuilder)this.api.getContents().key(k).refName("specialchar")).get().get(k));
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName("specialchar")).hash(this.api.getReference().refName("specialchar").get().getHash())).delete();
    }

    @Test
    void checkServerErrorPropagation() throws NessieNotFoundException, NessieConflictException {
        String branch = "bar";
        this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"bar", null)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)"bar", null)).create()).isInstanceOf(NessieConflictException.class)).hasMessageContaining("already exists");
    }

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidBranchNames(String invalidBranchName, String validHash) {
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(invalidBranchName)).hash(validHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(invalidBranchName)).untilHash(validHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.getReference().refName(invalidBranchName).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getReferenceByName.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(invalidBranchName)).hash(validHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("assignTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> {
            if (null != this.httpClient) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.httpClient.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", invalidBranchName).queryParam("expectedHash", validHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining("mergeRefIntoBranch.merge: must not be null");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRef((Reference)this.api.getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.api.deleteTag().tagName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api.transplantCommitsIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRefName("main").hashesToTransplant(Collections.singletonList(this.api.getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("transplantCommitsIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")});
    }

    @ParameterizedTest
    @CsvSource(value={"abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(validBranchName)).hash(invalidHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 8-32 bytes").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(validBranchName)).hash(invalidHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("assignTag.oldHash: Hash must consist of the hex representation of 8-32 bytes"), () -> {
            if (null != this.httpClient) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.httpClient.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", validBranchName).queryParam("expectedHash", invalidHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.merge: must not be null").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRef((Reference)this.api.getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.api.deleteTag().tagName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteTag.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api.transplantCommitsIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRefName("main").hashesToTransplant(Collections.singletonList(this.api.getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("transplantCommitsIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)this.api.getContents().refName(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(key).refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(validBranchName)).untilHash(invalidHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.params.startHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.params.endHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.params.hashOnRef: Hash must consist of the hex representation of 8-32 bytes")});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidTags(String invalidTagNameIn, String validHash) {
        Assumptions.assumeThat((Object)this.httpClient).isNotNull();
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null))).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): assignTag.assignTo: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + invalidTagName + "\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of ").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Reference`: known type ids = []\n")});
    }

    @Test
    public void testInvalidNamedRefs() {
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        String invalidRef = "1234567890123456";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.api.getEntries().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)this.api.getContents().key(key).refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)this.api.getContents().refName(invalidRef)).key(key).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
    }

    @Test
    public void testValidHashesOnValidNamedRefs() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch b = Branch.of((String)"testValidHashesOnValidNamedRefs", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)b).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        int commits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, commits, currentHash);
        LogResponse entireLog = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getOperations()).hasSize(commits);
        EntriesResponse allEntries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get();
        Assertions.assertThat((Object)allEntries).isNotNull();
        Assertions.assertThat((List)allEntries.getEntries()).hasSize(commits);
        ArrayList keys = new ArrayList();
        IntStream.range(0, commits).forEach(i -> keys.add(ContentsKey.of((String[])new String[]{"table" + i})));
        Map allContents = ((GetContentsBuilder)this.api.getContents().keys(keys).refName(branch.getName())).get();
        for (int i2 = 0; i2 < commits; ++i2) {
            String hash = ((CommitMeta)entireLog.getOperations().get(i2)).getHash();
            LogResponse log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getOperations()).hasSize(commits - i2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getOperations()).subList(i2, commits)).containsExactlyElementsOf((Iterable)log.getOperations());
            EntriesResponse entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)entries).isNotNull();
            Assertions.assertThat((List)entries.getEntries()).hasSize(commits - i2);
            int idx = commits - 1 - i2;
            ContentsKey key = ContentsKey.of((String[])new String[]{"table" + idx});
            Contents c = (Contents)((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(key).refName(branch.getName())).hashOnRef(hash)).get().get(key);
            ((ObjectAssert)Assertions.assertThat((Object)c).isNotNull()).isEqualTo(allContents.get(key));
        }
    }

    @Test
    public void testUnknownHashesOnValidNamedRefs() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        Branch b = Branch.of((String)"testUnknownHashesOnValidNamedRefs", (String)main.getHash());
        Reference branch = this.api.createReference().sourceRefName(main.getName()).reference((Reference)b).create();
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        String invalidHash = "1234567890123456";
        int commits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, commits, currentHash);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(ContentsKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentsBuilder)((GetContentsBuilder)this.api.getContents().key(ContentsKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, b.getName()));
    }

    @Test
    public void testAssignRefToFreshMain() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.api.getReference().refName("main").get();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(main.getName())).get();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
        String testBranch = "testBranch";
        this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)testBranch, null)).create();
        Reference testBranchRef = this.api.getReference().refName(testBranch).get();
        ((AssignBranchBuilder)((AssignBranchBuilder)this.api.assignBranch().hash(testBranchRef.getHash())).branchName(testBranch)).assignTo(main).assign();
        Assertions.assertThat((String)testBranchRef.getHash()).isEqualTo(main.getHash());
        String testTag = "testTag";
        this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)testTag, null)).create();
        Reference testTagRef = this.api.getReference().refName(testTag).get();
        ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().hash(testTagRef.getHash())).tagName(testTag)).assignTo(main).assign();
        Assertions.assertThat((String)testTagRef.getHash()).isEqualTo(main.getHash());
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }

    private static final class ContentAndOperationType {
        final Contents.Type type;
        final Operation operation;
        final Operation globalOperation;

        ContentAndOperationType(Contents.Type type, Operation operation) {
            this(type, operation, null);
        }

        ContentAndOperationType(Contents.Type type, Operation operation, Operation globalOperation) {
            this.type = type;
            this.operation = operation;
            this.globalOperation = globalOperation;
        }

        public String toString() {
            String s = ContentAndOperationType.opString(this.operation);
            if (this.globalOperation != null) {
                s = "_" + ContentAndOperationType.opString(this.globalOperation);
            }
            return s + "_" + this.operation.getKey().toPathString();
        }

        private static String opString(Operation operation) {
            if (operation instanceof Operation.Put) {
                return "Put_" + ((Operation.Put)operation).getContents().getClass().getSimpleName();
            }
            return operation.getClass().getSimpleName();
        }
    }
}

