/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public class AbstractResteasyTest {
    protected static String basePath = "/api/v1/";

    @BeforeEach
    public void enableLogging() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    public void testBasic() {
        int preSize = ((Reference[])((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(Reference[].class)).length;
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)Branch.of((String)"mainx", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        Reference[] references = (Reference[])((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(Reference[].class);
        org.junit.jupiter.api.Assertions.assertEquals((int)(preSize + 1), (int)references.length);
        Reference reference = (Reference)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(200)).extract().as(Reference.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mainx", (Object)reference.getName());
        ImmutableBranch newReference = ImmutableBranch.builder().hash(reference.getHash()).name("test").build();
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{reference.getHash()}).body((Object)Branch.of((String)"test", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newReference, (Object)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).then()).statusCode(200)).extract().as(Branch.class));
        IcebergTable table = IcebergTable.of((String)"/the/directory/over/there", (String)"x");
        Branch commitResponse = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"xxx", "test"})).contents((Contents)table).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()).queryParam("expectedHash", new Object[]{newReference.getHash()}).post("trees/branch/{branch}/commit", new Object[]{newReference.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)newReference.getHash(), (Object)commitResponse.getHash());
        Operation.Put[] updates = new Operation.Put[11];
        for (int i = 0; i < 10; ++i) {
            updates[i] = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"item", Integer.toString(i)})).contents((Contents)IcebergTable.of((String)("/the/directory/over/there/" + i), (String)"x")).build();
        }
        updates[10] = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"xxx", "test"})).contents((Contents)IcebergTable.of((String)"/the/directory/over/there/has/been/moved", (String)"x")).build();
        Reference branch = (Reference)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Reference.class);
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation[])updates).commitMeta(CommitMeta.fromMessage((String)"")).build();
        commitResponse = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)branch.getHash(), (Object)commitResponse.getHash());
        Response res = (Response)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).extract().response();
        org.junit.jupiter.api.Assertions.assertEquals((Object)updates[10].getContents(), (Object)res.body().as(Contents.class));
        IcebergTable currentTable = table;
        table = IcebergTable.of((String)"/the/directory/over/there/has/been/moved/again", (String)"x", (String)table.getId());
        Branch b2 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"xxx", "test"})).contents((Contents)table).expectedContents((Contents)currentTable).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()).queryParam("expectedHash", new Object[]{b2.getHash()}).post("trees/branch/{branch}/commit", new Object[]{b2.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        Contents returned = (Contents)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).statusCode(200)).extract().as(Contents.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)table, (Object)returned);
        Branch b3 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)Tag.of((String)"tagtest", (String)b3.getHash())).queryParam("sourceRefName", new Object[]{b3.getName()}).post("trees/tree", new Object[0])).then()).statusCode(200);
        Assertions.assertThat((String)((Tag)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/tagtest", new Object[0])).then()).statusCode(200)).extract().body().as(Tag.class)).getHash()).isEqualTo(b3.getHash());
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{"0011223344556677889900112233445566778899001122334455667788990011".substring(0, b2.getHash().length())}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(409);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{b3.getHash()}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(204);
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/test/log", new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)log.getOperations().size());
        Branch b1 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{b1.getHash()}).delete("trees/branch/test", new Object[0])).then()).statusCode(204);
        Branch bx = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{bx.getHash()}).delete("trees/branch/mainx", new Object[0])).then()).statusCode(204);
    }

    private static RequestSpecification rest() {
        return RestAssured.given().when().basePath(basePath).contentType(ContentType.JSON);
    }

    private Branch commit(String contentsId, Branch branch, String contentsKey, String metadataUrl) {
        return this.commit(contentsId, branch, contentsKey, metadataUrl, "nessieAuthor", null);
    }

    private Branch commit(String contentsId, Branch branch, String contentsKey, String metadataUrl, String author, String expectedMetadataUrl) {
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation)(expectedMetadataUrl != null ? Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{contentsKey}), (Contents)IcebergTable.of((String)metadataUrl, (String)"x", (String)contentsId), (Contents)IcebergTable.of((String)expectedMetadataUrl, (String)"x", (String)contentsId)) : Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{contentsKey}), (Contents)IcebergTable.of((String)metadataUrl, (String)"x", (String)contentsId)))).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("").build()).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch getBranch(String name) {
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/{name}", new Object[]{name})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch makeBranch(String name) {
        ImmutableBranch test = ImmutableBranch.builder().name(name).build();
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)test).post("trees/tree", new Object[0])).then()).statusCode(200);
        return test;
    }

    @Test
    public void testOptimisticLocking() {
        this.makeBranch("test3");
        Branch b1 = this.getBranch("test3");
        String contentsId = "cid-test-opt-lock";
        String newHash = this.commit(contentsId, b1, "xxx.test", "/the/directory/over/there").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b1.getHash(), (Object)newHash);
        Branch b2 = this.getBranch("test3");
        newHash = this.commit(contentsId, b2, "xxx.test", "/the/directory/over/there/has/been/moved", "i", "/the/directory/over/there").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b2.getHash(), (Object)newHash);
        Branch b3 = this.getBranch("test3");
        newHash = this.commit(contentsId, b3, "xxx.test", "/the/directory/over/there/has/been/moved/again", "me", "/the/directory/over/there/has/been/moved").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b3.getHash(), (Object)newHash);
    }

    @Test
    public void testLogFiltering() {
        String branchName = "logFiltering";
        this.makeBranch(branchName);
        Branch branch = this.getBranch(branchName);
        int numCommits = 3;
        String contentsId = "cid-test-log-filtering";
        for (int i = 0; i < numCommits; ++i) {
            String newHash = this.commit(contentsId, branch, "xxx.test", "/the/directory/over/there", "author-" + i, i > 0 ? "/the/directory/over/there" : null).getHash();
            Assertions.assertThat((String)newHash).isNotEqualTo((Object)branch.getHash());
            branch = this.getBranch(branchName);
        }
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits);
        Instant firstCommitTime = ((CommitMeta)log.getOperations().get(log.getOperations().size() - 1)).getCommitTime();
        Instant lastCommitTime = ((CommitMeta)log.getOperations().get(0)).getCommitTime();
        Assertions.assertThat((Instant)firstCommitTime).isNotNull();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        String author = "author-1";
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("query_expression", new Object[]{String.format("commit.author=='%s'", author)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(1);
        Assertions.assertThat((String)((CommitMeta)log.getOperations().get(0)).getAuthor()).isEqualTo(author);
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("query_expression", new Object[]{String.format("timestamp(commit.commitTime) > timestamp('%s')", firstCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(firstCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("query_expression", new Object[]{String.format("timestamp(commit.commitTime) < timestamp('%s')", lastCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isBefore(lastCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("query_expression", new Object[]{String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", firstCommitTime, lastCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getOperations()).hasSize(1);
        Assertions.assertThat((Instant)((CommitMeta)log.getOperations().get(0)).getCommitTime()).isBefore(lastCommitTime).isAfter(firstCommitTime);
    }
}

