/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;

public abstract class AbstractTestRest {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";
    private NessieApiV1 api;
    private HttpClient httpClient;

    protected void init(URI uri) {
        NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(uri).build(NessieApiV1.class);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        HttpClient httpClient = HttpClient.builder().setBaseUri(uri).setObjectMapper(mapper).build();
        httpClient.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
        this.init(api, httpClient);
    }

    protected void init(NessieApiV1 api, @Nullable HttpClient httpClient) {
        this.api = api;
        this.httpClient = httpClient;
    }

    @BeforeEach
    public void setUp() {
        this.init(URI.create("http://localhost:19121/api/v1"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        Branch defaultBranch = this.api.getDefaultBranch();
        for (Reference ref : this.api.getAllReferences().get().getReferences()) {
            if (ref.getName().equals(defaultBranch.getName())) continue;
            if (ref instanceof Branch) {
                ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)ref)).delete();
                continue;
            }
            if (!(ref instanceof Tag)) continue;
            ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)ref)).delete();
        }
        this.api.close();
    }

    public NessieApiV1 getApi() {
        return this.api;
    }

    @Test
    public void testSupportedApiVersions() {
        Assertions.assertThat((int)this.api.getConfig().getMaxSupportedApiVersion()).isEqualTo(1);
    }

    @Test
    public void createRecreateDefaultBranch() throws BaseNessieClientServerException {
        ((DeleteBranchBuilder)this.api.deleteBranch().branch(this.api.getDefaultBranch())).delete();
        Reference main = this.api.createReference().reference((Reference)Branch.of((String)"main", null)).create();
        Assertions.assertThat((Object)main).isNotNull();
        Assertions.assertThat((String)main.getName()).isEqualTo("main");
        Assertions.assertThat((String)main.getHash()).isNotNull();
        Assertions.assertThat((Object)this.api.getReference().refName("main").get()).isEqualTo((Object)main);
    }

    @Test
    public void getAllReferences() {
        ReferencesResponse references = this.api.getAllReferences().get();
        Assertions.assertThat((List)references.getReferences()).anySatisfy(r -> Assertions.assertThat((String)r.getName()).isEqualTo("main"));
    }

    @Test
    public void createReferences() throws NessieNotFoundException {
        String mainHash = this.api.getReference().refName("main").get().getHash();
        String tagName1 = "createReferences_tag1";
        String tagName2 = "createReferences_tag2";
        String branchName1 = "createReferences_branch1";
        String branchName2 = "createReferences_branch2";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("unknownSource").reference((Reference)Tag.of((String)tagName2, null)).create()).isInstanceOf(NessieReferenceNotFoundException.class)).hasMessageContainingAll(new CharSequence[]{"'unknownSource'", "not"}), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> {
            Reference refTag1 = this.api.createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName2, (String)mainHash), (Object)refTag1);
        }, () -> {
            Reference refBranch1 = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName1, null)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName1, (String)mainHash), (Object)refBranch1);
        }, () -> {
            Reference refBranch2 = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)mainHash), (Object)refBranch2);
        }});
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    public void referenceNames(String refNamePart) throws BaseNessieClientServerException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        String root = "ref_name_" + refNamePart.replaceAll("[^a-z]", "");
        Branch main = this.createBranch(root);
        IcebergTable meta = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        main = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("common-merge-ancestor").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}), (Content)meta)).commit();
        String someHash = main.getHash();
        Reference createdTag = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)tagName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName, (String)someHash), (Object)createdTag);
        Reference createdBranch1 = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName, (String)someHash), (Object)createdBranch1);
        Reference createdBranch2 = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName2, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)someHash), (Object)createdBranch2);
        Map references = this.api.getAllReferences().get().getReferences().stream().filter(r -> root.equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        Assertions.assertThat(references).containsAllEntriesOf((Map)ImmutableMap.of((Object)main.getName(), (Object)main, (Object)createdTag.getName(), (Object)createdTag, (Object)createdBranch1.getName(), (Object)createdBranch1, (Object)createdBranch2.getName(), (Object)createdBranch2));
        Assertions.assertThat((Object)((Reference)references.get(main.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdTag.getName()))).isInstanceOf(Tag.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch1.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch2.getName()))).isInstanceOf(Branch.class);
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        Assertions.assertThat((Object)this.api.getReference().refName(tagName).get()).isEqualTo((Object)tagRef);
        Assertions.assertThat((Object)this.api.getReference().refName(branchName).get()).isEqualTo((Object)branchRef);
        EntriesResponse entries = ((GetEntriesBuilder)this.api.getEntries().refName(tagName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        entries = ((GetEntriesBuilder)this.api.getEntries().refName(branchName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(tagName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        meta = IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branchName)).hash(branchHash)).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"some-key"}), (Content)meta)).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).commit();
        log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).get();
        String newHash = ((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getHash();
        ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(tagName)).hash(tagHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((AssignBranchBuilder)((AssignBranchBuilder)this.api.assignBranch().branchName(branchName)).hash(newHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(branchName2)).hash(branchHash2)).fromRefName(branchName).fromHash(newHash).merge();
    }

    @Test
    public void filterReferences() throws BaseNessieClientServerException {
        Branch b1 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("refs.branch.1"))).commitMeta(CommitMeta.fromMessage((String)"some awkward message")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"hello.world.BaseTable"}), (Content)SqlView.of((SqlView.Dialect)SqlView.Dialect.SPARK, (String)"SELECT ALL THE THINGS"))).commit();
        Branch b2 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("other-development"))).commitMeta(CommitMeta.fromMessage((String)"invent awesome things")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"cool.stuff.Caresian"}), (Content)SqlView.of((SqlView.Dialect)SqlView.Dialect.SPARK, (String)"CARTESIAN JOINS ARE AWESOME"))).commit();
        Branch b3 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("archive"))).commitMeta(CommitMeta.fromMessage((String)"boring old stuff")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"super.old.Numbers"}), (Content)SqlView.of((SqlView.Dialect)SqlView.Dialect.SPARK, (String)"AGGREGATE EVERYTHING"))).commit();
        Tag t1 = (Tag)this.getApi().createReference().reference((Reference)Tag.of((String)"my-tag", (String)b2.getHash())).sourceRefName(b2.getName()).create();
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("ref.name == 'other-development'")).get().getReferences()).hasSize(1)).allSatisfy(ref -> ((ObjectAssert)Assertions.assertThat((Object)ref).isInstanceOf(Branch.class)).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{b2.getName(), b2.getHash()}));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("refType == 'TAG'")).get().getReferences()).allSatisfy(ref -> Assertions.assertThat((Object)ref).isInstanceOf(Tag.class));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("refType == 'BRANCH'")).get().getReferences()).allSatisfy(ref -> Assertions.assertThat((Object)ref).isInstanceOf(Branch.class));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("has(refMeta.numTotalCommits) && refMeta.numTotalCommits < 0")).get().getReferences()).isEmpty();
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().fetch(FetchOption.ALL).filter("commit.message == 'invent awesome things'")).get().getReferences()).hasSize(2)).allSatisfy(ref -> Assertions.assertThat((String)ref.getName()).isIn(new Object[]{b2.getName(), t1.getName()}));
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().fetch(FetchOption.ALL).filter("refType == 'TAG' && commit.message == 'invent awesome things'")).get().getReferences()).hasSize(1)).allSatisfy(ref -> Assertions.assertThat((String)ref.getName()).isEqualTo(t1.getName()));
    }

    @Test
    public void filterCommitLogOperations() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogOperations");
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"some awkward message")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"hello", "world", "BaseTable"}), (Content)SqlView.of((SqlView.Dialect)SqlView.Dialect.SPARK, (String)"SELECT ALL THE THINGS"))).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"dlrow", "olleh", "BaseTable"}), (Content)SqlView.of((SqlView.Dialect)SqlView.Dialect.SPARK, (String)"SELECT ALL THE THINGS"))).commit();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.type == 'PUT')")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.key.startsWith('hello.world.'))")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.key.startsWith('not.there.'))")).get().getLogEntries()).isEmpty();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.name == 'BaseTable')")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.name == 'ThereIsNoSuchTable')")).get().getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByAuthor() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByAuthor");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)commit.getCommitMeta().getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3' && commit.committer == 'random-committer'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3' && commit.committer == ''")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)commit.getCommitMeta().getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.author in ['author-1', 'author-3', 'author-4']")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 3);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-1", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("!(commit.author in ['author-1', 'author-0'])")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 3);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.author.matches('au.*-(2|4)')")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 2);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
    }

    @Test
    public void filterCommitLogByTimeRange() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByTimeRange");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        int expectedTotalSize = numAuthors * commitsPerAuthor;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        Instant initialCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(log.getLogEntries().size() - 1)).getCommitMeta().getCommitTime();
        Assertions.assertThat((Instant)initialCommitTime).isNotNull();
        Instant lastCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getCommitTime();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        Instant fiveMinLater = initialCommitTime.plus(5L, ChronoUnit.MINUTES);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s')", initialCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize - 1);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isAfter(initialCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) < timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isBefore(fiveMinLater));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", initialCommitTime, lastCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize - 2);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isAfter(initialCommitTime).isBefore(lastCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByProperties() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByProperties");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.properties['prop1'] == 'val1'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)((String)commit.getCommitMeta().getProperties().get("prop1"))).isEqualTo("val1"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).filter("commit.properties['prop1'] == 'val3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByCommitRange() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByCommitRange");
        int numCommits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, numCommits, currentHash);
        LogResponse entireLog = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getLogEntries()).hasSize(numCommits);
        String startHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(numCommits / 2)).getCommitMeta().getHash();
        String endHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(0)).getCommitMeta().getHash();
        LogResponse log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits / 2 + 1);
        int i = 0;
        for (int j = numCommits - 1; i < j; ++i, --j) {
            startHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(j)).getCommitMeta().getHash();
            endHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(i)).getCommitMeta().getHash();
            log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits - i * 2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getLogEntries()).subList(i, j + 1)).containsExactlyElementsOf((Iterable)log.getLogEntries());
        }
    }

    protected String createCommits(Reference branch, int numAuthors, int commitsPerAuthor, String currentHash) throws BaseNessieClientServerException {
        for (int j = 0; j < numAuthors; ++j) {
            String author = "author-" + j;
            for (int i = 0; i < commitsPerAuthor; ++i) {
                IcebergTable meta = IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42);
                String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("committed-by-" + author).properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"table" + i}), (Content)meta)).commit().getHash();
                Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
                currentHash = nextHash;
            }
        }
        return currentHash;
    }

    @Test
    public void commitLogPagingAndFilteringByAuthor() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("commitLogPagingAndFiltering");
        int numAuthors = 3;
        int commits = 45;
        int pageSizeHint = 10;
        int expectedTotalSize = numAuthors * commits;
        this.createCommits((Reference)branch, numAuthors, commits, branch.getHash());
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        String author = "author-1";
        List<String> messagesOfAuthorOne = log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).filter(c -> author.equals(c.getAuthor())).map(CommitMeta::getMessage).collect(Collectors.toList());
        this.verifyPaging(branch.getName(), commits, pageSizeHint, messagesOfAuthorOne, author);
        List allMessages = log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList());
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.api, (String)branch.getName(), null, null, null, (OptionalInt)OptionalInt.of(pageSizeHint)).map(LogResponse.LogEntry::getCommitMeta).collect(Collectors.toList());
        Assertions.assertThat(completeLog.stream().map(CommitMeta::getMessage)).containsExactlyElementsOf(allMessages);
    }

    @Test
    public void commitLogPaging() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("commitLogPaging");
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = branch.getHash();
        ArrayList<String> allMessages = new ArrayList<String>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add(msg);
            IcebergTable tableMeta = IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42);
            String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta(CommitMeta.fromMessage((String)msg)).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"table"}), (Content)tableMeta)).commit().getHash();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)currentHash, (Object)nextHash);
            currentHash = nextHash;
        }
        Collections.reverse(allMessages);
        this.verifyPaging(branch.getName(), commits, pageSizeHint, allMessages, null);
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.api, (String)branch.getName(), null, null, null, (OptionalInt)OptionalInt.of(pageSizeHint)).map(LogResponse.LogEntry::getCommitMeta).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    private Branch createBranch(String name) throws BaseNessieClientServerException {
        Branch main = this.api.getDefaultBranch();
        Branch branch = Branch.of((String)name, (String)main.getHash());
        Reference created = this.api.createReference().sourceRefName("main").reference((Reference)branch).create();
        Assertions.assertThat((Object)created).isEqualTo((Object)branch);
        return branch;
    }

    @Test
    public void transplant() throws BaseNessieClientServerException {
        Branch base = this.createBranch("transplant-base");
        Branch branch = this.createBranch("transplant-branch");
        IcebergTable table1 = IcebergTable.of((String)"transplant-table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"transplant-table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-branch2")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-main")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key2"}), (Content)table2)).commit();
        ((TransplantCommitsBuilder)this.api.transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)committed1.getHash(), (Object)committed2.getHash())).fromRefName(branch.getName()).branch(base)).transplant();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-transplant-branch2", "test-transplant-branch1", "test-transplant-main"});
        Assertions.assertThat(((GetEntriesBuilder)this.api.getEntries().refName(base.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
    }

    @Test
    public void merge() throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        IcebergTable table1 = IcebergTable.of((String)"merge-table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"merge-table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch2")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-main")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key2"}), (Content)table2)).commit();
        ((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branch(base)).fromRef((Reference)committed2).merge();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-merge-branch2", "test-merge-branch1", "test-merge-main"});
        Assertions.assertThat(((GetEntriesBuilder)this.api.getEntries().refName(base.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
    }

    protected void verifyPaging(String branchName, int commits, int pageSizeHint, List<String> commitMessages, String filterByAuthor) throws NessieNotFoundException {
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            String filter = null;
            if (null != filterByAuthor) {
                filter = String.format("commit.author=='%s'", filterByAuthor);
            }
            LogResponse response = ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branchName)).maxRecords(pageSizeHint)).pageToken(pageToken)).filter(filter)).get();
            if (pos + pageSizeHint > commits) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)response.isHasMore());
                org.junit.jupiter.api.Assertions.assertNull((Object)response.getToken());
                org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, commitMessages.size()), response.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)response.isHasMore());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)response.getToken());
            org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, pos + pageSizeHint), response.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
    }

    @Test
    public void multiget() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("foo");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable tb = IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)ta)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        Map response = ((GetContentBuilder)this.api.getContent().key(a).key(b).key(ContentKey.of((String[])new String[]{"noexist"})).refName("foo")).get();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)response).containsEntry((Object)a, (Object)ta)).containsEntry((Object)b, (Object)tb)).doesNotContainKey((Object)ContentKey.of((String[])new String[]{"noexist"}));
    }

    public static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio"}), (Content)ImmutableSqlView.builder().dialect(SqlView.Dialect.DREMIO).sqlText("SELECT foo FROM dremio").build())), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_presto"}), (Content)ImmutableSqlView.builder().dialect(SqlView.Dialect.PRESTO).sqlText("SELECT foo FROM presto").build())), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark"}), (Content)ImmutableSqlView.builder().dialect(SqlView.Dialect.SPARK).sqlText("SELECT foo FROM spark").build())), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"delta"}), (Content)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg_unchanged"}))), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio_delete"}))), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio_unchanged"}))), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark_delete"}))), new ContentAndOperationType(Content.Type.VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark_unchanged"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delta_delete"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"delta_unchanged"}))));
    }

    @Test
    public void verifyAllContentAndOperationTypes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperationAll");
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        AbstractTestRest.contentAndOperationTypes().flatMap(c -> c.globalOperation == null ? Stream.of(c.operation) : Stream.of(c.operation, c.globalOperation)).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)commit).operation(arg_0));
        commit.commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get().getEntries();
        List expect = AbstractTestRest.contentAndOperationTypes().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    public void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperation_" + contentAndOperationType);
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).operation(contentAndOperationType.operation);
        if (contentAndOperationType.globalOperation != null) {
            commit.operation(contentAndOperationType.globalOperation);
        }
        commit.commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get().getEntries();
        ContentKey fixedContentKey = ContentKey.of((List)contentAndOperationType.operation.getKey().getElements());
        List expect = contentAndOperationType.operation instanceof Operation.Put ? Collections.singletonList(EntriesResponse.Entry.builder().name(fixedContentKey).type(contentAndOperationType.type).build()) : Collections.emptyList();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @Test
    public void filterEntriesByType() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterTypes");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tam = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        ImmutableSqlView tb = ImmutableSqlView.builder().sqlText("select * from table").dialect(SqlView.Dialect.DREMIO).build();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)tam)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get().getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Content.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Content.Type.VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.contentType=='ICEBERG_TABLE'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.contentType=='VIEW'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.contentType in ['ICEBERG_TABLE', 'VIEW']")).get().getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void filterEntriesByNamespace() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespace");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "fourthTable"});
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)third, (Content)IcebergTable.of((String)"path3", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 3")).commit();
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)fourth, (Content)IcebergTable.of((String)"path4", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 4")).commit();
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.namespace.startsWith('a.b')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a.b"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.namespace.startsWith('a')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.namespace.startsWith('a.b.c.firstTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).filter("entry.namespace.startsWith('a.fourthTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(branch.getName())).hash(this.api.getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @Test
    public void filterEntriesByNamespaceAndPrefixDepth() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespaceAndPrefixDepth");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "b", "fourthTable"});
        ContentKey fifth = ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"});
        ImmutableList keys = ImmutableList.of((Object)first, (Object)second, (Object)third, (Object)fourth, (Object)fifth);
        for (int i = 0; i < 5; ++i) {
            ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)((ContentKey)keys.get(i)), (Content)IcebergTable.of((String)("path" + i), (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commit();
        }
        List entries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(0)).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(0)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(1)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(1);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(2)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.thirdTable", "a.b", "a.boo"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('a\\\\.b(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c", "a.b.fourthTable"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(4)).filter("entry.namespace.matches('a\\\\.b\\\\.c(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c.firstTable", "a.b.c.secondTable"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(5)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(2))).matches(e -> e.getType().equals((Object)Content.Type.UNKNOWN))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals((Object)Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "fourthTable"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals((Object)Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"})));
    }

    @Test
    public void checkCelScriptFailureReporting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName("main")).filter("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName("main")).filter("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
    }

    @Test
    public void checkSpecialCharacterRoundTrip() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("specialchar");
        ContentKey k = ContentKey.of((String[])new String[]{"a.b", "c.txt"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)k, (Content)ta)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        Assertions.assertThat((Map)((GetContentBuilder)this.api.getContent().key(k).refName(branch.getName())).get()).containsEntry((Object)k, (Object)ta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ta, ((GetContentBuilder)this.api.getContent().key(k).refName(branch.getName())).get().get(k));
    }

    @Test
    public void checkServerErrorPropagation() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("bar");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.createReference().sourceRefName("main").reference((Reference)branch).create()).isInstanceOf(NessieReferenceAlreadyExistsException.class)).hasMessageContaining("already exists");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).commitMeta((CommitMeta)CommitMeta.builder().author("author").message("committed-by-test").committer("disallowed-client-side-committer").build()).operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"table"}))).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Cannot set the committer on the client side.");
    }

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidBranchNames(String invalidBranchName, String validHash) {
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(invalidBranchName)).hash(validHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(invalidBranchName)).untilHash(validHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.getReference().refName(invalidBranchName).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getReferenceByName.params.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(invalidBranchName)).hash(validHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("assignTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> {
            if (null != this.httpClient) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.httpClient.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", invalidBranchName).queryParam("expectedHash", validHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining("mergeRefIntoBranch.merge: must not be null");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRef((Reference)this.api.getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.api.deleteTag().tagName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api.transplantCommitsIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRefName("main").hashesToTransplant(Collections.singletonList(this.api.getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("transplantCommitsIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.api.getDiff().fromRefName(invalidBranchName).toRefName("main").get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".fromRef: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")});
    }

    @ParameterizedTest
    @CsvSource(value={"abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(validBranchName)).hash(invalidHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 8-32 bytes").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.api.deleteBranch().branchName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().tagName(validBranchName)).hash(invalidHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("assignTag.oldHash: Hash must consist of the hex representation of 8-32 bytes"), () -> {
            if (null != this.httpClient) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.httpClient.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", validBranchName).queryParam("expectedHash", invalidHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.merge: must not be null").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api.mergeRefIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRef((Reference)this.api.getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.api.deleteTag().tagName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("deleteTag.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api.transplantCommitsIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRefName("main").hashesToTransplant(Collections.singletonList(this.api.getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("transplantCommitsIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.api.getContent().refName(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(key).refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(validBranchName)).untilHash(invalidHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.params.startHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.params.endHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.params.hashOnRef: Hash must consist of the hex representation of 8-32 bytes")});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidTags(String invalidTagNameIn, String validHash) {
        Assumptions.assumeThat((Object)this.httpClient).isNotNull();
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null))).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): assignTag.assignTo: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + invalidTagName + "\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of ").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Reference`: known type ids = [")});
    }

    @Test
    public void testInvalidNamedRefs() {
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        String invalidRef = "1234567890123456";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.api.getCommitLog().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.api.getEntries().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.api.getContent().key(key).refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.api.getContent().refName(invalidRef)).key(key).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
    }

    @Test
    public void testValidHashesOnValidNamedRefs() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testValidHashesOnValidNamedRefs");
        int commits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, commits, currentHash);
        LogResponse entireLog = ((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getLogEntries()).hasSize(commits);
        EntriesResponse allEntries = ((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).get();
        Assertions.assertThat((Object)allEntries).isNotNull();
        Assertions.assertThat((List)allEntries.getEntries()).hasSize(commits);
        ArrayList keys = new ArrayList();
        IntStream.range(0, commits).forEach(i -> keys.add(ContentKey.of((String[])new String[]{"table" + i})));
        Map allContent = ((GetContentBuilder)this.api.getContent().keys(keys).refName(branch.getName())).get();
        for (int i2 = 0; i2 < commits; ++i2) {
            String hash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(i2)).getCommitMeta().getHash();
            LogResponse log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getLogEntries()).hasSize(commits - i2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getLogEntries()).subList(i2, commits)).containsExactlyElementsOf((Iterable)log.getLogEntries());
            EntriesResponse entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)entries).isNotNull();
            Assertions.assertThat((List)entries.getEntries()).hasSize(commits - i2);
            int idx = commits - 1 - i2;
            ContentKey key = ContentKey.of((String[])new String[]{"table" + idx});
            Content c = (Content)((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(key).refName(branch.getName())).hashOnRef(hash)).get().get(key);
            ((ObjectAssert)Assertions.assertThat((Object)c).isNotNull()).isEqualTo(allContent.get(key));
        }
    }

    @Test
    public void testUnknownHashesOnValidNamedRefs() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testUnknownHashesOnValidNamedRefs");
        String invalidHash = "1234567890123456";
        int commits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, commits, currentHash);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(ContentKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.api.getContent().key(ContentKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
    }

    @Test
    public void testAssignRefToFreshMain() throws BaseNessieClientServerException {
        Reference main = this.api.getReference().refName("main").get();
        LogResponse log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(main.getName())).get();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
        Branch testBranch = this.createBranch("testBranch");
        ((AssignBranchBuilder)this.api.assignBranch().branch(testBranch)).assignTo(main).assign();
        Reference testBranchRef = this.api.getReference().refName(testBranch.getName()).get();
        Assertions.assertThat((String)testBranchRef.getHash()).isEqualTo(main.getHash());
        String testTag = "testTag";
        Reference testTagRef = this.api.createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)testTag, (String)main.getHash())).create();
        Assertions.assertThat((String)testTagRef.getHash()).isNotNull();
        ((AssignTagBuilder)((AssignTagBuilder)this.api.assignTag().hash(testTagRef.getHash())).tagName(testTag)).assignTo(main).assign();
        testTagRef = this.api.getReference().refName(testTag).get();
        Assertions.assertThat((String)testTagRef.getHash()).isEqualTo(main.getHash());
    }

    @Test
    public void testReferencesHaveMetadataProperties() throws BaseNessieClientServerException {
        String branchPrefix = "branchesHaveMetadataProperties";
        String tagPrefix = "tagsHaveMetadataProperties";
        int numBranches = 5;
        int commitsPerBranch = 10;
        for (int i = 0; i < numBranches; ++i) {
            Reference r2 = this.api.createReference().reference((Reference)Branch.of((String)(branchPrefix + i), null)).create();
            String currentHash = r2.getHash();
            currentHash = this.createCommits(r2, 1, commitsPerBranch, currentHash);
            this.api.createReference().reference((Reference)Tag.of((String)(tagPrefix + i), (String)currentHash)).sourceRefName(r2.getName()).create();
        }
        List references = this.api.getAllReferences().get().getReferences();
        Optional<Reference> main = references.stream().filter(r -> r.getName().equals("main")).findFirst();
        Assertions.assertThat(main).isPresent();
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(branchPrefix)).map(r -> (Branch)r)).hasSize(numBranches)).allSatisfy(branch -> Assertions.assertThat((Object)branch.getMetadata()).isNull());
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(tagPrefix)).map(r -> (Tag)r)).hasSize(numBranches)).allSatisfy(tag -> Assertions.assertThat((Object)tag.getMetadata()).isNull());
        references = this.api.getAllReferences().fetch(FetchOption.ALL).get().getReferences();
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(branchPrefix)).map(r -> (Branch)r)).hasSize(numBranches)).allSatisfy(branch -> this.verifyMetadataProperties(commitsPerBranch, 0, (Branch)branch, (Reference)main.get(), commitsPerBranch));
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(tagPrefix)).map(r -> (Tag)r)).hasSize(numBranches)).allSatisfy(this::verifyMetadataProperties);
    }

    @Test
    public void testSingleReferenceHasMetadataProperties() throws BaseNessieClientServerException {
        String branchName = "singleBranchHasMetadataProperties";
        String tagName = "singleTagHasMetadataProperties";
        int numCommits = 10;
        Reference r = this.api.createReference().reference((Reference)Branch.of((String)branchName, null)).create();
        String currentHash = r.getHash();
        currentHash = this.createCommits(r, 1, numCommits, currentHash);
        this.api.createReference().reference((Reference)Tag.of((String)tagName, (String)currentHash)).sourceRefName(r.getName()).create();
        Reference ref = this.api.getReference().refName(branchName).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class)).extracting("metadata").isNull();
        ref = this.api.getReference().refName(tagName).get();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Tag.class)).extracting("metadata").isNull();
        ref = this.api.getReference().refName(branchName).fetch(FetchOption.ALL).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class);
        this.verifyMetadataProperties(numCommits, 0, (Branch)ref, this.api.getReference().refName("main").get(), numCommits);
        ref = this.api.getReference().refName(tagName).fetch(FetchOption.ALL).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Tag.class);
        this.verifyMetadataProperties((Tag)ref);
    }

    private void verifyMetadataProperties(int expectedCommitsAhead, int expectedCommitsBehind, Branch branch, Reference reference, long expectedCommits) throws NessieNotFoundException {
        List commits = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(branch.getName())).maxRecords(1)).get().getLogEntries();
        Assertions.assertThat((List)commits).hasSize(1);
        CommitMeta commitMeta = ((LogResponse.LogEntry)commits.get(0)).getCommitMeta();
        ReferenceMetadata referenceMetadata = branch.getMetadata();
        Assertions.assertThat((Object)referenceMetadata).isNotNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsAhead()).isEqualTo(expectedCommitsAhead);
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsBehind()).isEqualTo(expectedCommitsBehind);
        Assertions.assertThat((Object)referenceMetadata.getCommitMetaOfHEAD()).isEqualTo((Object)commitMeta);
        Assertions.assertThat((String)referenceMetadata.getCommonAncestorHash()).isEqualTo(reference.getHash());
        Assertions.assertThat((Long)referenceMetadata.getNumTotalCommits()).isEqualTo(expectedCommits);
    }

    private void verifyMetadataProperties(Tag tag) throws NessieNotFoundException {
        List commits = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api.getCommitLog().refName(tag.getName())).maxRecords(1)).get().getLogEntries();
        Assertions.assertThat((List)commits).hasSize(1);
        CommitMeta commitMeta = ((LogResponse.LogEntry)commits.get(0)).getCommitMeta();
        ReferenceMetadata referenceMetadata = tag.getMetadata();
        Assertions.assertThat((Object)referenceMetadata).isNotNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsAhead()).isNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsBehind()).isNull();
        Assertions.assertThat((Object)referenceMetadata.getCommitMetaOfHEAD()).isEqualTo((Object)commitMeta);
        Assertions.assertThat((String)referenceMetadata.getCommonAncestorHash()).isNull();
        Assertions.assertThat((Long)referenceMetadata.getNumTotalCommits()).isEqualTo(10L);
    }

    @Test
    public void commitLogExtended() throws Exception {
        String branch = "commitLogExtended";
        String firstParent = this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branch, null)).create().getHash();
        int numCommits = 10;
        List hashes = IntStream.rangeClosed(1, numCommits).mapToObj(i -> {
            try {
                String head = this.api.getReference().refName(branch).get().getHash();
                return ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"k" + i}), (Content)IcebergTable.of((String)("m" + i), (long)i, (int)i, (int)i, (int)i, (String)("c" + i)))).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}), (Content)IcebergTable.of((String)("meta" + i), (long)i, (int)i, (int)i, (int)i, (String)("cid" + i)))).operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delete" + i}))).operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}))).commitMeta(CommitMeta.fromMessage((String)("Commit #" + i))).branchName(branch)).hash(head)).commit().getHash();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List parentHashes = Stream.concat(Stream.of(firstParent), hashes.subList(0, 9).stream()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)Lists.reverse((List)((GetCommitLogBuilder)this.api.getCommitLog().untilHash(firstParent).refName(branch)).get().getLogEntries())).allSatisfy(c -> {
            Assertions.assertThat((List)c.getOperations()).isNull();
            Assertions.assertThat((String)c.getParentCommitHash()).isNull();
        })).extracting(e -> e.getCommitMeta().getHash()).containsExactlyElementsOf(hashes);
        List commits = Lists.reverse((List)((GetCommitLogBuilder)this.api.getCommitLog().fetch(FetchOption.ALL).untilHash(firstParent).refName(branch)).get().getLogEntries());
        Assertions.assertThat((IntStream)IntStream.rangeClosed(1, numCommits)).allSatisfy(i -> {
            LogResponse.LogEntry c = (LogResponse.LogEntry)commits.get(i - 1);
            Assertions.assertThat((Object)c).extracting(new Function[]{e -> e.getCommitMeta().getMessage(), e -> e.getCommitMeta().getHash(), LogResponse.LogEntry::getParentCommitHash, LogResponse.LogEntry::getOperations}).containsExactly(new Object[]{"Commit #" + i, hashes.get(i - 1), parentHashes.get(i - 1), Arrays.asList(Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delete" + i})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"k" + i}), (Content)IcebergTable.of((String)("m" + i), (long)i.intValue(), (int)i, (int)i, (int)i, (String)("c" + i))), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}), (Content)IcebergTable.of((String)("meta" + i), (long)i.intValue(), (int)i, (int)i, (int)i, (String)("cid" + i))))});
        });
    }

    @Test
    public void testDiff() throws BaseNessieClientServerException {
        int commitsPerBranch = 10;
        Reference fromRef = this.api.createReference().reference((Reference)Branch.of((String)"testDiffFromRef", null)).create();
        Reference toRef = this.api.createReference().reference((Reference)Branch.of((String)"testDiffToRef", null)).create();
        String toRefHash = this.createCommits(toRef, 1, commitsPerBranch, toRef.getHash());
        ((ListAssert)Assertions.assertThat((List)this.api.getDiff().fromRefName(fromRef.getName()).toRefName(toRef.getName()).get().getDiffs()).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        this.createCommits(fromRef, 1, commitsPerBranch, fromRef.getHash());
        ((ListAssert)Assertions.assertThat((List)this.api.getDiff().fromRefName(fromRef.getName()).toRefName(toRef.getName()).get().getDiffs()).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
            Assertions.assertThat((String)diff.getFrom().getId()).isNotEqualTo((Object)diff.getTo().getId());
            Optional fromTable = diff.getFrom().unwrap(IcebergTable.class);
            Assertions.assertThat((Optional)fromTable).isPresent();
            Optional toTable = diff.getTo().unwrap(IcebergTable.class);
            Assertions.assertThat((Optional)toTable).isPresent();
            Assertions.assertThat((String)((IcebergTable)fromTable.get()).getMetadataLocation()).isEqualTo(((IcebergTable)toTable.get()).getMetadataLocation());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSchemaId()).isEqualTo(((IcebergTable)toTable.get()).getSchemaId());
            Assertions.assertThat((long)((IcebergTable)fromTable.get()).getSnapshotId()).isEqualTo(((IcebergTable)toTable.get()).getSnapshotId());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSortOrderId()).isEqualTo(((IcebergTable)toTable.get()).getSortOrderId());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSpecId()).isEqualTo(((IcebergTable)toTable.get()).getSpecId());
        });
        List keys = IntStream.rangeClosed(0, commitsPerBranch).mapToObj(i -> ContentKey.of((String[])new String[]{"table" + i})).collect(Collectors.toList());
        Map map = ((GetContentBuilder)this.api.getContent().refName(toRef.getName())).keys(keys).get();
        for (Map.Entry entry : map.entrySet()) {
            toRef = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(toRef.getName())).hash(toRefHash)).commitMeta(CommitMeta.fromMessage((String)"delete")).operation((Operation)Operation.Delete.of((ContentKey)((ContentKey)entry.getKey()))).commit();
        }
        ((ListAssert)Assertions.assertThat((List)this.api.getDiff().fromRefName(fromRef.getName()).toRefName(toRef.getName()).get().getDiffs()).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNull();
        });
    }

    @Test
    public void commitLogExtendedForUnchangedOperation() throws Exception {
        String branch = "commitLogExtendedUnchanged";
        this.api.createReference().sourceRefName("main").reference((Reference)Branch.of((String)branch, null)).create().getHash();
        String head = this.api.getReference().refName(branch).get().getHash();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}))).commitMeta(CommitMeta.fromMessage((String)"Commit #1")).branchName(branch)).hash(head)).commit();
        List logEntries = ((GetCommitLogBuilder)this.api.getCommitLog().fetch(FetchOption.ALL).refName(branch)).get().getLogEntries();
        Assertions.assertThat((int)logEntries.size()).isEqualTo(1);
        Assertions.assertThat((String)((LogResponse.LogEntry)logEntries.get(0)).getCommitMeta().getMessage()).contains(new CharSequence[]{"Commit #1"});
        Assertions.assertThat((List)((LogResponse.LogEntry)logEntries.get(0)).getOperations()).isNull();
    }

    protected void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }

    public static final class ContentAndOperationType {
        final Content.Type type;
        final Operation operation;
        final Operation globalOperation;

        public ContentAndOperationType(Content.Type type, Operation operation) {
            this(type, operation, null);
        }

        public ContentAndOperationType(Content.Type type, Operation operation, Operation globalOperation) {
            this.type = type;
            this.operation = operation;
            this.globalOperation = globalOperation;
        }

        public String toString() {
            String s = ContentAndOperationType.opString(this.operation);
            if (this.globalOperation != null) {
                s = "_" + ContentAndOperationType.opString(this.globalOperation);
            }
            return s + "_" + this.operation.getKey().toPathString();
        }

        private static String opString(Operation operation) {
            if (operation instanceof Operation.Put) {
                return "Put_" + ((Operation.Put)operation).getContent().getClass().getSimpleName();
            }
            return operation.getClass().getSimpleName();
        }
    }
}

