/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.jaxrs.AbstractTestRest;
import org.projectnessie.jaxrs.ext.NessieAccessChecker;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Detached;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.DetachedRef;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public abstract class AbstractRestAccessCheckDetached
extends AbstractTestRest {
    private static final String VIEW_MSG = "Must not view detached references";
    private static final String COMMITS_MSG = "Must not list from detached references";
    private static final String READ_MSG = "Must not read from detached references";
    private static final String ENTITIES_MSG = "Must not get entities from detached references";
    private static final Map<Check.CheckType, String> CHECK_TYPE_MSG = ImmutableMap.of((Object)Check.CheckType.VIEW_REFERENCE, (Object)"Must not view detached references", (Object)Check.CheckType.LIST_COMMIT_LOG, (Object)"Must not list from detached references", (Object)Check.CheckType.READ_ENTITY_VALUE, (Object)"Must not get entities from detached references", (Object)Check.CheckType.READ_ENTRIES, (Object)"Must not read from detached references");

    private BatchAccessChecker newAccessChecker() {
        return new AbstractBatchAccessChecker(){

            public Map<Check, String> check() {
                LinkedHashMap<Check, String> failed = new LinkedHashMap<Check, String>();
                this.getChecks().forEach(check -> {
                    String msg = (String)CHECK_TYPE_MSG.get(check.type());
                    if (msg != null) {
                        if (check.ref() instanceof DetachedRef) {
                            failed.put((Check)check, msg);
                        } else {
                            Assertions.assertThat((String)check.ref().getName()).isNotEqualTo((Object)"DETACHED");
                        }
                    }
                });
                return failed;
            }
        };
    }

    @Test
    public void detachedRefAccessChecks(@NessieAccessChecker Consumer<Function<AccessContext, BatchAccessChecker>> accessCheckerConsumer) throws Exception {
        accessCheckerConsumer.accept(x -> this.newAccessChecker());
        Branch main = this.createBranch("committerAndAuthor");
        Branch merge = this.createBranch("committerAndAuthorMerge");
        Branch transplant = this.createBranch("committerAndAuthorTransplant");
        IcebergTable meta1 = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key = ContentKey.of((String[])new String[]{"meep"});
        Branch mainCommit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("no security context").build()).operation((Operation)Operation.Put.of((ContentKey)key, (Content)meta1)).commit();
        Branch detachedAsBranch = Branch.of((String)"DETACHED", (String)mainCommit.getHash());
        Tag detachedAsTag = Tag.of((String)"DETACHED", (String)mainCommit.getHash());
        Detached detached = Detached.of((String)mainCommit.getHash());
        Assertions.assertThat(Stream.of(detached, detachedAsBranch, detachedAsTag)).allSatisfy(ref -> org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().reference(ref)).get()).describedAs("ref='%s', getCommitLog", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(COMMITS_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().fromRef(ref).branch(merge)).merge()).describedAs("ref='%s', mergeRefIntoBranch", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().fromRefName(ref.getName()).hashesToTransplant(Collections.singletonList(ref.getHash())).branch(transplant)).transplant()).describedAs("ref='%s', transplantCommitsIntoBranch", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.getApi().getEntries().reference(ref)).get()).describedAs("ref='%s', getEntries", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(READ_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().reference(ref)).key(key).get()).describedAs("ref='%s', getContent", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(ENTITIES_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getDiff().fromRef(ref).toRef((Reference)main).get()).describedAs("ref='%s', getDiff1", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getDiff().fromRef((Reference)main).toRef(ref).get()).describedAs("ref='%s', getDiff2", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG)}));
    }
}

