/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieRefLogNotFoundException;
import org.projectnessie.jaxrs.AbstractRestReferences;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestRefLog
extends AbstractRestReferences {
    @Test
    public void testReflog() throws BaseNessieClientServerException {
        String tagName = "tag1_test_reflog";
        String branch1 = "branch1_test_reflog";
        String branch2 = "branch2_test_reflog";
        String branch3 = "branch3_test_reflog";
        String root = "ref_name_test_reflog";
        ArrayList<Tuple> expectedEntries = new ArrayList<Tuple>(12);
        Branch branch0 = this.createBranch(root);
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{root, "CREATE_REFERENCE"}));
        Reference createdTag = this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Tag.of((String)tagName, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{tagName, "CREATE_REFERENCE"}));
        Reference createdBranch1 = this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch1, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch1, "CREATE_REFERENCE"}));
        Reference createdBranch2 = this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch2, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch2, "CREATE_REFERENCE"}));
        Branch createdBranch3 = (Branch)this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch3, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch3, "CREATE_REFERENCE"}));
        IcebergTable meta = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        branch0 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch0.getName())).hash(branch0.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("dummy commit log").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}), (Content)meta)).commit();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{root, "COMMIT"}));
        ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(tagName)).hash(createdTag.getHash())).assignTo((Reference)branch0).assign();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{tagName, "ASSIGN_REFERENCE"}));
        ((AssignBranchBuilder)((AssignBranchBuilder)this.getApi().assignBranch().branchName(branch1)).hash(createdBranch1.getHash())).assignTo((Reference)branch0).assign();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch1, "ASSIGN_REFERENCE"}));
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(branch2)).hash(createdBranch2.getHash())).fromRefName(branch1).fromHash(branch0.getHash()).merge();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch2, "MERGE"}));
        ((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)Objects.requireNonNull(branch0.getHash()))).fromRefName(branch1).branch(createdBranch3)).transplant();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch3, "TRANSPLANT"}));
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch1)).hash(branch0.getHash())).delete();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch1, "DELETE_REFERENCE"}));
        ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(tagName)).hash(branch0.getHash())).delete();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{tagName, "DELETE_REFERENCE"}));
        Collections.reverse(expectedEntries);
        RefLogResponse refLogResponse = this.getApi().getRefLog().get();
        Assertions.assertThat(refLogResponse.getLogEntries().subList(0, 12)).extracting(new Function[]{RefLogResponse.RefLogResponseEntry::getRefName, RefLogResponse.RefLogResponseEntry::getOperation}).isEqualTo(expectedEntries);
        RefLogResponse refLogResponse1 = ((GetRefLogBuilder)this.getApi().getRefLog().maxRecords(2)).get();
        Assertions.assertThat((List)refLogResponse1.getLogEntries()).isEqualTo(refLogResponse.getLogEntries().subList(0, 2));
        Assertions.assertThat((boolean)refLogResponse1.isHasMore()).isTrue();
        RefLogResponse refLogResponse2 = ((GetRefLogBuilder)this.getApi().getRefLog().pageToken(refLogResponse1.getToken())).get();
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse2.getLogEntries().get(0)).getRefLogId()).isEqualTo(refLogResponse1.getToken());
        Assertions.assertThat(refLogResponse2.getLogEntries().subList(0, 10)).isEqualTo(refLogResponse.getLogEntries().subList(2, 12));
        RefLogResponse refLogResponse3 = this.getApi().getRefLog().fromHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(10)).getRefLogId()).get();
        Assertions.assertThat(refLogResponse3.getLogEntries().subList(0, 2)).isEqualTo(refLogResponse.getLogEntries().subList(10, 12));
        RefLogResponse refLogResponse4 = this.getApi().getRefLog().fromHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(3)).getRefLogId()).untilHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(5)).getRefLogId()).get();
        Assertions.assertThat((List)refLogResponse4.getLogEntries()).isEqualTo(refLogResponse.getLogEntries().subList(3, 6));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getRefLog().fromHash("f1234d75178d892a133a410355a5a990cf75d2f33eba25d575943d4df632f3a4").get()).isInstanceOf(NessieRefLogNotFoundException.class)).hasMessageContaining("RefLog entry for 'f1234d75178d892a133a410355a5a990cf75d2f33eba25d575943d4df632f3a4' does not exist");
        Assertions.assertThat((List)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(4)).getSourceHashes()).isEqualTo(Collections.singletonList(createdBranch1.getHash()));
        Assertions.assertThat((List)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(3)).getSourceHashes()).isEqualTo(Collections.singletonList(branch0.getHash()));
        Assertions.assertThat((List)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(2)).getSourceHashes()).isEqualTo(Collections.singletonList(branch0.getHash()));
        List filteredResult = StreamingUtil.getReflogStream((NessieApiV1)this.getApi(), null, null, (String)"reflog.operation == 'ASSIGN_REFERENCE' && reflog.refName == 'tag1_test_reflog'", (OptionalInt)OptionalInt.empty()).collect(Collectors.toList());
        Assertions.assertThat((int)filteredResult.size()).isEqualTo(1);
        Assertions.assertThat((Object)((RefLogResponse.RefLogResponseEntry)filteredResult.get(0))).extracting(new Function[]{RefLogResponse.RefLogResponseEntry::getRefName, RefLogResponse.RefLogResponseEntry::getOperation}).isEqualTo((Object)((Tuple)expectedEntries.get(5)).toList());
    }
}

