/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestInvalidWithHttp;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestMergeTransplant
extends AbstractRestInvalidWithHttp {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void transplant(boolean withDetachedCommit) throws BaseNessieClientServerException {
        Branch base = this.createBranch("transplant-base");
        Branch branch = this.createBranch("transplant-branch");
        IcebergTable table1 = IcebergTable.of((String)"transplant-table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"transplant-table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-branch2")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        int commitsToTransplant = 2;
        LogResponse logBranch = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).untilHash(branch.getHash()).maxRecords(commitsToTransplant)).get();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-transplant-main")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key2"}), (Content)table2)).commit();
        ((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)committed1.getHash(), (Object)committed2.getHash())).fromRefName(AbstractRestMergeTransplant.maybeAsDetachedName(withDetachedCommit, (Reference)branch)).branch(base)).transplant();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-transplant-branch2", "test-transplant-branch1", "test-transplant-main"});
        LogResponse logOfTransplanted = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).maxRecords(commitsToTransplant)).get();
        Assertions.assertThat(logOfTransplanted.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime)).isNotEqualTo(logBranch.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime));
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class, mode=EnumSource.Mode.EXCLUDE, names={"NAME_ONLY"})
    public void merge(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        IcebergTable table1 = IcebergTable.of((String)"merge-table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"merge-table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch2")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}), (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        int commitsToMerge = 2;
        LogResponse logBranch = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).untilHash(branch.getHash()).maxRecords(commitsToMerge)).get();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-main")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key2"}), (Content)table2)).commit();
        ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef(refMode.transform((Reference)committed2)).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-merge-branch2", "test-merge-branch1", "test-merge-main"});
        LogResponse logOfMerged = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).maxRecords(commitsToMerge)).get();
        Assertions.assertThat(logOfMerged.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime)).isNotEqualTo(logBranch.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime));
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
    }
}

