/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestDiff;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestEntries
extends AbstractRestDiff {
    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByType(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterTypes");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tam = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (int)1, (int)1, (String)"select * from table", (String)"Dremio");
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)tam)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Content.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Content.Type.ICEBERG_VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_TABLE'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_VIEW'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType in ['ICEBERG_TABLE', 'ICEBERG_VIEW']")).get().getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByNamespace(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespace");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "fourthTable"});
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)third, (Content)IcebergTable.of((String)"path3", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 3")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)fourth, (Content)IcebergTable.of((String)"path4", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 4")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a.b"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b.c.firstTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.fourthTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByNamespaceAndPrefixDepth(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespaceAndPrefixDepth");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "b", "fourthTable"});
        ContentKey fifth = ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"});
        ImmutableList keys = ImmutableList.of((Object)first, (Object)second, (Object)third, (Object)fourth, (Object)fifth);
        for (int i = 0; i < 5; ++i) {
            ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)((ContentKey)keys.get(i)), (Content)IcebergTable.of((String)("path" + i), (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commit();
        }
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(0)).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(0)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(1)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(1);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(2)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.thirdTable", "a.b", "a.boo"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('a\\\\.b(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c", "a.b.fourthTable"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(4)).filter("entry.namespace.matches('a\\\\.b\\\\.c(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat(entries.stream().map(e -> e.getName().toPathString())).containsExactlyInAnyOrder((Object[])new String[]{"a.b.c.firstTable", "a.b.c.secondTable"});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(5)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(2))).matches(e -> e.getType().equals((Object)Content.Type.UNKNOWN))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals((Object)Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "fourthTable"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals((Object)Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"})));
    }
}

