/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestAssign;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestCommitLog
extends AbstractRestAssign {
    @Test
    public void filterCommitLogOperations() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogOperations");
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"some awkward message")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"hello", "world", "BaseTable"}), (Content)IcebergView.of((String)"path1", (int)1, (int)1, (String)"Spark", (String)"SELECT ALL THE THINGS"))).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"dlrow", "olleh", "BaseTable"}), (Content)IcebergView.of((String)"path2", (int)1, (int)1, (String)"Spark", (String)"SELECT ALL THE THINGS"))).commit();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.type == 'PUT')")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.key.startsWith('hello.world.'))")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.key.startsWith('not.there.'))")).get().getLogEntries()).isEmpty();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.name == 'BaseTable')")).get().getLogEntries()).hasSize(1);
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).fetch(FetchOption.ALL).filter("operations.exists(op, op.name == 'ThereIsNoSuchTable')")).get().getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByAuthor() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByAuthor");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)commit.getCommitMeta().getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3' && commit.committer == 'random-committer'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.author == 'author-3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)commit.getCommitMeta().getAuthor()).isEqualTo("author-3"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.author in ['author-1', 'author-3', 'author-4']")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 3);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-1", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("!(commit.author in ['author-1', 'author-0'])")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 3);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.author.matches('au.*-(2|4)')")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(commitsPerAuthor * 2);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-4")).contains((Object[])new String[]{commit.getCommitMeta().getAuthor()}));
    }

    @Test
    public void filterCommitLogByTimeRange() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByTimeRange");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        int expectedTotalSize = numAuthors * commitsPerAuthor;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        Instant initialCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(log.getLogEntries().size() - 1)).getCommitMeta().getCommitTime();
        Assertions.assertThat((Instant)initialCommitTime).isNotNull();
        Instant lastCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getCommitTime();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        Instant fiveMinLater = initialCommitTime.plus(5L, ChronoUnit.MINUTES);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s')", initialCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize - 1);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isAfter(initialCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) < timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isBefore(fiveMinLater));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", initialCommitTime, lastCommitTime))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize - 2);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isAfter(initialCommitTime).isBefore(lastCommitTime));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter(String.format("timestamp(commit.commitTime) > timestamp('%s')", fiveMinLater))).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByProperties() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByProperties");
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.properties['prop1'] == 'val1'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numAuthors * commitsPerAuthor);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((String)((String)commit.getCommitMeta().getProperties().get("prop1"))).isEqualTo("val1"));
        log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).filter("commit.properties['prop1'] == 'val3'")).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).isEmpty();
    }

    @Test
    public void filterCommitLogByCommitRange() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterCommitLogByCommitRange");
        int numCommits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, numCommits, currentHash);
        LogResponse entireLog = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getLogEntries()).hasSize(numCommits);
        String startHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(numCommits / 2)).getCommitMeta().getHash();
        String endHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(0)).getCommitMeta().getHash();
        LogResponse log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits / 2 + 1);
        int i = 0;
        for (int j = numCommits - 1; i < j; ++i, --j) {
            startHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(j)).getCommitMeta().getHash();
            endHash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(i)).getCommitMeta().getHash();
            log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(endHash)).untilHash(startHash).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits - i * 2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getLogEntries()).subList(i, j + 1)).containsExactlyElementsOf((Iterable)log.getLogEntries());
        }
    }

    @Test
    public void commitLogPagingAndFilteringByAuthor() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("commitLogPagingAndFiltering");
        int numAuthors = 3;
        int commits = 45;
        int pageSizeHint = 10;
        int expectedTotalSize = numAuthors * commits;
        this.createCommits((Reference)branch, numAuthors, commits, branch.getHash());
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getLogEntries()).hasSize(expectedTotalSize);
        String author = "author-1";
        List<String> messagesOfAuthorOne = log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).filter(c -> author.equals(c.getAuthor())).map(CommitMeta::getMessage).collect(Collectors.toList());
        this.verifyPaging(branch.getName(), commits, pageSizeHint, messagesOfAuthorOne, author);
        List allMessages = log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList());
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.getApi(), c -> ((GetCommitLogBuilder)c.refName(branch.getName())).fetch(FetchOption.MINIMAL), (OptionalInt)OptionalInt.of(pageSizeHint)).map(LogResponse.LogEntry::getCommitMeta).collect(Collectors.toList());
        Assertions.assertThat(completeLog.stream().map(CommitMeta::getMessage)).containsExactlyElementsOf(allMessages);
    }

    @Test
    public void commitLogPaging() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("commitLogPaging");
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = branch.getHash();
        ArrayList<String> allMessages = new ArrayList<String>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add(msg);
            IcebergTable tableMeta = IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42);
            String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta(CommitMeta.fromMessage((String)msg)).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"table"}), (Content)tableMeta)).commit().getHash();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)currentHash, (Object)nextHash);
            currentHash = nextHash;
        }
        Collections.reverse(allMessages);
        this.verifyPaging(branch.getName(), commits, pageSizeHint, allMessages, null);
        List completeLog = StreamingUtil.getCommitLogStream((NessieApiV1)this.getApi(), c -> ((GetCommitLogBuilder)c.refName(branch.getName())).fetch(FetchOption.MINIMAL), (OptionalInt)OptionalInt.of(pageSizeHint)).map(LogResponse.LogEntry::getCommitMeta).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void commitLogExtended(AbstractRest.ReferenceMode refMode) throws Exception {
        String branch = "commitLogExtended";
        String firstParent = this.getApi().createReference().sourceRefName("main").reference((Reference)Branch.of((String)branch, null)).create().getHash();
        int numCommits = 10;
        IntFunction<String> c1 = i -> refMode.name() + "-c1-" + i;
        IntFunction<String> c2 = i -> refMode.name() + "-c2-" + i;
        List hashes = IntStream.rangeClosed(1, numCommits).mapToObj(i -> {
            try {
                String head = this.getApi().getReference().refName(branch).get().getHash();
                return ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"k" + i}), (Content)IcebergTable.of((String)("m" + i), (long)i, (int)i, (int)i, (int)i, (String)((String)c1.apply(i))))).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}), (Content)IcebergTable.of((String)("meta" + i), (long)i, (int)i, (int)i, (int)i, (String)((String)c2.apply(i))))).operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delete" + i}))).operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}))).commitMeta(CommitMeta.fromMessage((String)("Commit #" + i))).branchName(branch)).hash(head)).commit().getHash();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List parentHashes = Stream.concat(Stream.of(firstParent), hashes.subList(0, 9).stream()).collect(Collectors.toList());
        Reference branchRef = this.getApi().getReference().refName(branch).get();
        ((ListAssert)Assertions.assertThat((List)Lists.reverse((List)((GetCommitLogBuilder)this.getApi().getCommitLog().untilHash(firstParent).reference(refMode.transform(branchRef))).get().getLogEntries())).allSatisfy(c -> {
            Assertions.assertThat((List)c.getOperations()).isNull();
            Assertions.assertThat((String)c.getParentCommitHash()).isNull();
        })).extracting(e -> e.getCommitMeta().getHash()).containsExactlyElementsOf(hashes);
        List commits = Lists.reverse((List)((GetCommitLogBuilder)this.getApi().getCommitLog().fetch(FetchOption.ALL).reference(refMode.transform(branchRef))).untilHash(firstParent).get().getLogEntries());
        Assertions.assertThat((IntStream)IntStream.rangeClosed(1, numCommits)).allSatisfy(i -> {
            LogResponse.LogEntry c = (LogResponse.LogEntry)commits.get(i - 1);
            Assertions.assertThat((Object)c).extracting(new Function[]{e -> e.getCommitMeta().getMessage(), e -> e.getCommitMeta().getHash(), LogResponse.LogEntry::getParentCommitHash, LogResponse.LogEntry::getOperations}).containsExactly(new Object[]{"Commit #" + i, hashes.get(i - 1), parentHashes.get(i - 1), Arrays.asList(Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delete" + i})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"k" + i}), (Content)IcebergTable.of((String)("m" + i), (long)i.intValue(), (int)i, (int)i, (int)i, (String)((String)c1.apply((int)i)))), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i}), (Content)IcebergTable.of((String)("meta" + i), (long)i.intValue(), (int)i, (int)i, (int)i, (String)((String)c2.apply((int)i)))))});
        });
    }

    @Test
    public void commitLogExtendedForUnchangedOperation() throws Exception {
        String branch = "commitLogExtendedUnchanged";
        this.getApi().createReference().sourceRefName("main").reference((Reference)Branch.of((String)branch, null)).create().getHash();
        String head = this.getApi().getReference().refName(branch).get().getHash();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"key1"}))).commitMeta(CommitMeta.fromMessage((String)"Commit #1")).branchName(branch)).hash(head)).commit();
        List logEntries = ((GetCommitLogBuilder)this.getApi().getCommitLog().fetch(FetchOption.ALL).refName(branch)).get().getLogEntries();
        Assertions.assertThat((int)logEntries.size()).isEqualTo(1);
        Assertions.assertThat((String)((LogResponse.LogEntry)logEntries.get(0)).getCommitMeta().getMessage()).contains(new CharSequence[]{"Commit #1"});
        Assertions.assertThat((List)((LogResponse.LogEntry)logEntries.get(0)).getOperations()).isNull();
    }

    void verifyPaging(String branchName, int commits, int pageSizeHint, List<String> commitMessages, String filterByAuthor) throws NessieNotFoundException {
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            String filter = null;
            if (null != filterByAuthor) {
                filter = String.format("commit.author=='%s'", filterByAuthor);
            }
            LogResponse response = ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branchName)).maxRecords(pageSizeHint)).pageToken(pageToken)).filter(filter)).get();
            if (pos + pageSizeHint > commits) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)response.isHasMore());
                org.junit.jupiter.api.Assertions.assertNull((Object)response.getToken());
                org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, commitMessages.size()), response.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)response.isHasMore());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)response.getToken());
            org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, pos + pageSizeHint), response.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
    }
}

