/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRestCommitLog;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.Operation;

public abstract class AbstractRestContents
extends AbstractRestCommitLog {
    public static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio"}), (Content)IcebergView.of((String)"/iceberg/view", (int)1, (int)1, (String)"Dremio", (String)"SELECT foo FROM dremio"))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_presto"}), (Content)IcebergView.of((String)"/iceberg/view", (int)1, (int)1, (String)"Presto", (String)"SELECT foo FROM presto"))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark"}), (Content)IcebergView.of((String)"/iceberg/view2", (int)1, (int)1, (String)"Spark", (String)"SELECT foo FROM spark"))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"delta"}), (Content)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"iceberg_unchanged"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"view_dremio_unchanged"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"view_spark_unchanged"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delta_delete"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"delta_unchanged"}))));
    }

    @Test
    public void verifyAllContentAndOperationTypes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperationAll");
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        AbstractRestContents.contentAndOperationTypes().flatMap(c -> c.globalOperation == null ? Stream.of(c.operation) : Stream.of(c.operation, c.globalOperation)).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)commit).operation(arg_0));
        commit.commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).get().getEntries();
        List expect = AbstractRestContents.contentAndOperationTypes().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    public void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperation_" + contentAndOperationType);
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).operation(contentAndOperationType.operation);
        if (contentAndOperationType.globalOperation != null) {
            commit.operation(contentAndOperationType.globalOperation);
        }
        commit.commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).get().getEntries();
        ContentKey fixedContentKey = ContentKey.of((List)contentAndOperationType.operation.getKey().getElements());
        List expect = contentAndOperationType.operation instanceof Operation.Put ? Collections.singletonList(EntriesResponse.Entry.builder().name(fixedContentKey).type(contentAndOperationType.type).build()) : Collections.emptyList();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @Test
    public void multiget() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("foo");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable tb = IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)ta)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        Map response = ((GetContentBuilder)this.getApi().getContent().key(a).key(b).key(ContentKey.of((String[])new String[]{"noexist"})).refName("foo")).get();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)response).containsEntry((Object)a, (Object)ta)).containsEntry((Object)b, (Object)tb)).doesNotContainKey((Object)ContentKey.of((String[])new String[]{"noexist"}));
    }

    public static final class ContentAndOperationType {
        final Content.Type type;
        final Operation operation;
        final Operation globalOperation;

        public ContentAndOperationType(Content.Type type, Operation operation) {
            this(type, operation, null);
        }

        public ContentAndOperationType(Content.Type type, Operation operation, Operation globalOperation) {
            this.type = type;
            this.operation = operation;
            this.globalOperation = globalOperation;
        }

        public String toString() {
            String s = ContentAndOperationType.opString(this.operation);
            if (this.globalOperation != null) {
                s = "_" + ContentAndOperationType.opString(this.globalOperation);
            }
            return s + "_" + this.operation.getKey().toPathString();
        }

        private static String opString(Operation operation) {
            if (operation instanceof Operation.Put) {
                return "Put_" + ((Operation.Put)operation).getContent().getClass().getSimpleName();
            }
            return operation.getClass().getSimpleName();
        }
    }
}

