/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.NessieForbiddenException;
import org.projectnessie.jaxrs.AbstractTestRest;
import org.projectnessie.jaxrs.ext.NessieAccessChecker;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Detached;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.DetachedRef;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public abstract class AbstractRestAccessChecks
extends AbstractTestRest {
    private static final String VIEW_MSG = "Must not view detached references";
    private static final String COMMITS_MSG = "Must not list from detached references";
    private static final String READ_MSG = "Must not read from detached references";
    private static final String ENTITIES_MSG = "Must not get entities from detached references";
    private static final Map<Check.CheckType, String> CHECK_TYPE_MSG = ImmutableMap.of((Object)Check.CheckType.VIEW_REFERENCE, (Object)"Must not view detached references", (Object)Check.CheckType.LIST_COMMIT_LOG, (Object)"Must not list from detached references", (Object)Check.CheckType.READ_ENTITY_VALUE, (Object)"Must not get entities from detached references", (Object)Check.CheckType.READ_ENTRIES, (Object)"Must not read from detached references");

    @Test
    public void forbiddenContentKeys(@NessieAccessChecker Consumer<Function<AccessContext, BatchAccessChecker>> accessCheckerConsumer) throws Exception {
        Branch main = this.createBranch("forbiddenContentKeys");
        ContentKey keyForbidden1 = ContentKey.of((String[])new String[]{"forbidden_1"});
        ContentKey keyForbidden2 = ContentKey.of((String[])new String[]{"forbidden_2"});
        ContentKey idForbidden1 = ContentKey.of((String[])new String[]{"id_forbidden_1"});
        ContentKey idForbidden2 = ContentKey.of((String[])new String[]{"id_forbidden_2"});
        ContentKey keyAllowed1 = ContentKey.of((String[])new String[]{"allowed_1"});
        ContentKey keyAllowed2 = ContentKey.of((String[])new String[]{"allowed_2"});
        final String contentIdForbidden1 = UUID.randomUUID().toString();
        final String contentIdForbidden2 = UUID.randomUUID().toString();
        Branch commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("no security context").build()).operation((Operation)Operation.Put.of((ContentKey)keyForbidden1, (Content)IcebergTable.of((String)keyForbidden1.getName(), (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)idForbidden1, (Content)IcebergTable.of((String)idForbidden1.getName(), (long)42L, (int)42, (int)42, (int)42, (String)contentIdForbidden1))).operation((Operation)Operation.Put.of((ContentKey)keyAllowed1, (Content)IcebergTable.of((String)keyAllowed1.getName(), (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)keyForbidden2, (Content)IcebergTable.of((String)keyForbidden2.getName(), (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)idForbidden2, (Content)IcebergTable.of((String)idForbidden2.getName(), (long)42L, (int)42, (int)42, (int)42, (String)contentIdForbidden2))).operation((Operation)Operation.Put.of((ContentKey)keyAllowed2, (Content)IcebergTable.of((String)keyAllowed2.getName(), (long)42L, (int)42, (int)42, (int)42))).commit();
        ThrowingConsumer assertKeys = expectedKeys -> {
            Assertions.assertThat((List)((GetEntriesBuilder)this.getApi().getEntries().reference((Reference)commit)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrderElementsOf((Iterable)expectedKeys);
            ((ListAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)commit)).fetch(FetchOption.ALL).get().getLogEntries()).hasSize(1)).element(0)).extracting(LogResponse.LogEntry::getOperations).asInstanceOf(InstanceOfAssertFactories.list(Operation.class))).map(Operation::getKey).containsExactlyInAnyOrderElementsOf((Iterable)expectedKeys);
        };
        assertKeys.accept(Arrays.asList(keyAllowed1, keyAllowed2, keyForbidden1, keyForbidden2, idForbidden1, idForbidden2));
        accessCheckerConsumer.accept(x -> new AbstractBatchAccessChecker(){

            public Map<Check, String> check() {
                return this.getChecks().stream().filter(c -> c.type() == Check.CheckType.READ_CONTENT_KEY).filter(c -> c.key().getName().startsWith("forbidden") || c.contentId().equals(contentIdForbidden1) || c.contentId().equals(contentIdForbidden2)).collect(Collectors.toMap(Function.identity(), c -> "Forbidden key " + c.key().getName()));
            }
        });
        assertKeys.accept(Arrays.asList(keyAllowed1, keyAllowed2));
    }

    @Test
    public void detachedRefAccessChecks(@NessieAccessChecker Consumer<Function<AccessContext, BatchAccessChecker>> accessCheckerConsumer) throws Exception {
        AbstractBatchAccessChecker accessChecker = new AbstractBatchAccessChecker(){

            public Map<Check, String> check() {
                LinkedHashMap<Check, String> failed = new LinkedHashMap<Check, String>();
                this.getChecks().forEach(check -> {
                    String msg = (String)CHECK_TYPE_MSG.get(check.type());
                    if (msg != null) {
                        if (check.ref() instanceof DetachedRef) {
                            failed.put((Check)check, msg);
                        } else {
                            Assertions.assertThat((String)check.ref().getName()).isNotEqualTo((Object)"DETACHED");
                        }
                    }
                });
                return failed;
            }
        };
        accessCheckerConsumer.accept(arg_0 -> AbstractRestAccessChecks.lambda$detachedRefAccessChecks$2((BatchAccessChecker)accessChecker, arg_0));
        Branch main = this.createBranch("committerAndAuthor");
        Branch merge = this.createBranch("committerAndAuthorMerge");
        Branch transplant = this.createBranch("committerAndAuthorTransplant");
        IcebergTable meta1 = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key = ContentKey.of((String[])new String[]{"meep"});
        Branch mainCommit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("no security context").build()).operation((Operation)Operation.Put.of((ContentKey)key, (Content)meta1)).commit();
        Branch detachedAsBranch = Branch.of((String)"DETACHED", (String)mainCommit.getHash());
        Tag detachedAsTag = Tag.of((String)"DETACHED", (String)mainCommit.getHash());
        Detached detached = Detached.of((String)mainCommit.getHash());
        Assertions.assertThat(Stream.of(detached, detachedAsBranch, detachedAsTag)).allSatisfy(ref -> org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().reference(ref)).get()).describedAs("ref='%s', getCommitLog", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(COMMITS_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().fromRef(ref).branch(merge)).merge()).describedAs("ref='%s', mergeRefIntoBranch", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().fromRefName(ref.getName()).hashesToTransplant(Collections.singletonList(ref.getHash())).branch(transplant)).transplant()).describedAs("ref='%s', transplantCommitsIntoBranch", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.getApi().getEntries().reference(ref)).get()).describedAs("ref='%s', getEntries", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(READ_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().reference(ref)).key(key).get()).describedAs("ref='%s', getContent", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(ENTITIES_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getDiff().fromRef(ref).toRef((Reference)main).get()).describedAs("ref='%s', getDiff1", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG), () -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getDiff().fromRef((Reference)main).toRef(ref).get()).describedAs("ref='%s', getDiff2", new Object[]{ref})).isInstanceOf(NessieForbiddenException.class)).hasMessageContaining(VIEW_MSG)}));
    }

    private static /* synthetic */ BatchAccessChecker lambda$detachedRefAccessChecks$2(BatchAccessChecker accessChecker, AccessContext x) {
        return accessChecker;
    }
}

