/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.core.SecurityContext;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.jaxrs.AbstractRestAccessChecks;
import org.projectnessie.jaxrs.ext.NessieSecurityContext;
import org.projectnessie.jaxrs.ext.PrincipalSecurityContext;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestSecurityContext
extends AbstractRestAccessChecks {
    @Test
    public void committerAndAuthor(@NessieSecurityContext Consumer<SecurityContext> securityContextConsumer) throws Exception {
        Branch main = this.createBranch("committerAndAuthor");
        Branch merge2 = this.createBranch("committerAndAuthorMergeTarget2");
        Branch merge = this.createBranch("committerAndAuthorMerge");
        Branch transplant = this.createBranch("committerAndAuthorTransplant");
        IcebergTable meta1 = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable meta2 = IcebergTable.of((String)"meep_meep", (long)42L, (int)42, (int)42, (int)42);
        Branch noSecurityContext = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("no security context").build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}), (Content)meta1)).commit();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)noSecurityContext)).maxRecords(1)).get().getLogEntries()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getCommitter, CommitMeta::getAuthor, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"", "", "no security context"})});
        securityContextConsumer.accept(PrincipalSecurityContext.forName((String)"ThatNessieGuy"));
        Branch withSecurityContext = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(noSecurityContext.getName())).hash(noSecurityContext.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("with security").build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"meep_meep"}), (Content)meta2)).commit();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)withSecurityContext)).maxRecords(2)).get().getLogEntries()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getCommitter, CommitMeta::getAuthor, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"ThatNessieGuy", "ThatNessieGuy", "with security"}), Tuple.tuple((Object[])new Object[]{"", "", "no security context"})});
        securityContextConsumer.accept(PrincipalSecurityContext.forName((String)"NessieHerself"));
        ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().fromRef((Reference)withSecurityContext).branch(merge)).merge();
        merge = (Branch)this.getApi().getReference().refName(merge.getName()).get();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)merge)).maxRecords(1)).get().getLogEntries()).extracting(LogResponse.LogEntry::getCommitMeta).allSatisfy(commitMeta -> {
            Assertions.assertThat((String)commitMeta.getCommitter()).isEqualTo("NessieHerself");
            Assertions.assertThat((String)commitMeta.getAuthor()).isEqualTo("NessieHerself");
            ((AbstractStringAssert)Assertions.assertThat((String)commitMeta.getMessage()).contains(new CharSequence[]{"with security"})).contains(new CharSequence[]{"no security context"});
        });
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().fromRef((Reference)withSecurityContext).branch(merge2)).keepIndividualCommits(true)).merge();
        merge2 = (Branch)this.getApi().getReference().refName(merge2.getName()).get();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)merge2)).maxRecords(2)).get().getLogEntries()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getCommitter, CommitMeta::getAuthor, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"NessieHerself", "ThatNessieGuy", "with security"}), Tuple.tuple((Object[])new Object[]{"NessieHerself", "", "no security context"})});
        ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().fromRefName(withSecurityContext.getName())).hashesToTransplant(Arrays.asList(noSecurityContext.getHash(), withSecurityContext.getHash())).branch(transplant)).keepIndividualCommits(true)).transplant();
        transplant = (Branch)this.getApi().getReference().refName(transplant.getName()).get();
        Assertions.assertThat((List)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)transplant)).maxRecords(2)).get().getLogEntries()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getCommitter, CommitMeta::getAuthor, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"NessieHerself", "ThatNessieGuy", "with security"}), Tuple.tuple((Object[])new Object[]{"NessieHerself", "", "no security context"})});
    }
}

