/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.jaxrs.AbstractRestMisc;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Tag;

public abstract class AbstractRestReferences
extends AbstractRestMisc {
    @Test
    public void createRecreateDefaultBranch() throws BaseNessieClientServerException {
        ((DeleteBranchBuilder)this.getApi().deleteBranch().branch(this.getApi().getDefaultBranch())).delete();
        Reference main = this.getApi().createReference().reference((Reference)Branch.of((String)"main", null)).create();
        Assertions.assertThat((Object)main).isNotNull();
        Assertions.assertThat((String)main.getName()).isEqualTo("main");
        Assertions.assertThat((String)main.getHash()).isNotNull();
        Assertions.assertThat((Object)this.getApi().getReference().refName("main").get()).isEqualTo((Object)main);
    }

    @Test
    public void getAllReferences() {
        ReferencesResponse references = this.getApi().getAllReferences().get();
        Assertions.assertThat((List)references.getReferences()).anySatisfy(r -> Assertions.assertThat((String)r.getName()).isEqualTo("main"));
    }

    @Test
    public void getUnknownReference() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getReference().refName("unknown123").get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining("unknown123");
    }

    @ParameterizedTest
    @ValueSource(strings={"HEAD", "DETACHED", "cafebabedeadbeef", "a234567890123456", "CAFEBABEDEADBEEF", "A234567890123456", "caffee20", "caffee2022"})
    public void forbiddenReferenceNames(String refName) throws NessieNotFoundException {
        String mainHash = this.getApi().getReference().refName("main").get().getHash();
        Assertions.assertThat(Stream.of(Branch.of((String)refName, null), Tag.of((String)refName, null), Branch.of((String)refName, (String)mainHash), Tag.of((String)refName, (String)mainHash))).allSatisfy(ref -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().createReference().sourceRefName("main").reference(ref).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Reference name mut not be HEAD, DETACHED or a potential commit ID representation."));
    }

    @Test
    public void createReferences() throws NessieNotFoundException {
        String mainHash = this.getApi().getReference().refName("main").get().getHash();
        String tagName1 = "createReferences_tag1";
        String tagName2 = "createReferences_tag2";
        String branchName1 = "createReferences_branch1";
        String branchName2 = "createReferences_branch2";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().createReference().sourceRefName("unknownSource").reference((Reference)Tag.of((String)tagName2, null)).create()).isInstanceOf(NessieReferenceNotFoundException.class)).hasMessageContainingAll(new CharSequence[]{"'unknownSource'", "not"}), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().createReference().reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName1, null)).create()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Tag-creation requires a target named-reference and hash."), () -> {
            Reference refTag1 = this.getApi().createReference().sourceRefName("main").reference((Reference)Tag.of((String)tagName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName2, (String)mainHash), (Object)refTag1);
        }, () -> {
            Reference refBranch1 = this.getApi().createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName1, null)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName1, (String)mainHash), (Object)refBranch1);
        }, () -> {
            Reference refBranch2 = this.getApi().createReference().sourceRefName("main").reference((Reference)Branch.of((String)branchName2, (String)mainHash)).create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)mainHash), (Object)refBranch2);
        }});
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    public void referenceNames(String refNamePart) throws BaseNessieClientServerException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        String root = "ref_name_" + refNamePart.replaceAll("[^a-z]", "");
        Branch main = this.createBranch(root);
        IcebergTable meta = IcebergTable.of((String)"meep", (long)42L, (int)42, (int)42, (int)42);
        main = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(main.getName())).hash(main.getHash())).commitMeta((CommitMeta)CommitMeta.builder().message("common-merge-ancestor").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}), (Content)meta)).commit();
        String someHash = main.getHash();
        Reference createdTag = this.getApi().createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)tagName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName, (String)someHash), (Object)createdTag);
        Reference createdBranch1 = this.getApi().createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName, (String)someHash), (Object)createdBranch1);
        Reference createdBranch2 = this.getApi().createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName2, (String)someHash)).create();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)someHash), (Object)createdBranch2);
        Map references = this.getApi().getAllReferences().get().getReferences().stream().filter(r -> root.equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        Assertions.assertThat(references).containsAllEntriesOf((Map)ImmutableMap.of((Object)main.getName(), (Object)main, (Object)createdTag.getName(), (Object)createdTag, (Object)createdBranch1.getName(), (Object)createdBranch1, (Object)createdBranch2.getName(), (Object)createdBranch2));
        Assertions.assertThat((Object)((Reference)references.get(main.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdTag.getName()))).isInstanceOf(Tag.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch1.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch2.getName()))).isInstanceOf(Branch.class);
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        Assertions.assertThat((Object)this.getApi().getReference().refName(tagName).get()).isEqualTo((Object)tagRef);
        Assertions.assertThat((Object)this.getApi().getReference().refName(branchName).get()).isEqualTo((Object)branchRef);
        EntriesResponse entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(tagName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branchName)).get();
        Assertions.assertThat((Object)entries).isNotNull();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(tagName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branchName)).get();
        Assertions.assertThat((Object)log).isNotNull();
        meta = IcebergTable.of((String)"foo", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branchName)).hash(branchHash)).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"some-key"}), (Content)meta)).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).commit();
        log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branchName)).get();
        String newHash = ((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getHash();
        ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(tagName)).hash(tagHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((AssignBranchBuilder)((AssignBranchBuilder)this.getApi().assignBranch().branchName(branchName)).hash(newHash)).assignTo((Reference)Branch.of((String)branchName, (String)newHash)).assign();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(branchName2)).hash(branchHash2)).fromRefName(branchName)).fromHash(newHash).merge();
    }

    @Test
    public void filterReferences() throws BaseNessieClientServerException {
        Branch b1 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("refs.branch.1"))).commitMeta(CommitMeta.fromMessage((String)"some awkward message")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"hello.world.BaseTable"}), (Content)IcebergView.of((String)"path1", (int)1, (int)1, (String)"Spark", (String)"SELECT ALL THE THINGS"))).commit();
        Branch b2 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("other-development"))).commitMeta(CommitMeta.fromMessage((String)"invent awesome things")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"cool.stuff.Caresian"}), (Content)IcebergView.of((String)"path2", (int)1, (int)1, (String)"Spark", (String)"CARTESIAN JOINS ARE AWESOME"))).commit();
        Branch b3 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(this.createBranch("archive"))).commitMeta(CommitMeta.fromMessage((String)"boring old stuff")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"super.old.Numbers"}), (Content)IcebergView.of((String)"path3", (int)1, (int)1, (String)"Spark", (String)"AGGREGATE EVERYTHING"))).commit();
        Tag t1 = (Tag)this.getApi().createReference().reference((Reference)Tag.of((String)"my-tag", (String)b2.getHash())).sourceRefName(b2.getName()).create();
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("ref.name == 'other-development'")).get().getReferences()).hasSize(1)).allSatisfy(ref -> ((ObjectAssert)Assertions.assertThat((Object)ref).isInstanceOf(Branch.class)).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{b2.getName(), b2.getHash()}));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("refType == 'TAG'")).get().getReferences()).allSatisfy(ref -> Assertions.assertThat((Object)ref).isInstanceOf(Tag.class));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("refType == 'BRANCH'")).get().getReferences()).allSatisfy(ref -> Assertions.assertThat((Object)ref).isInstanceOf(Branch.class));
        Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().filter("has(refMeta.numTotalCommits) && refMeta.numTotalCommits < 0")).get().getReferences()).isEmpty();
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().fetch(FetchOption.ALL).filter("commit.message == 'invent awesome things'")).get().getReferences()).hasSize(2)).allSatisfy(ref -> Assertions.assertThat((String)ref.getName()).isIn(new Object[]{b2.getName(), t1.getName()}));
        ((ListAssert)Assertions.assertThat((List)((GetAllReferencesBuilder)this.getApi().getAllReferences().fetch(FetchOption.ALL).filter("refType == 'TAG' && commit.message == 'invent awesome things'")).get().getReferences()).hasSize(1)).allSatisfy(ref -> Assertions.assertThat((String)ref.getName()).isEqualTo(t1.getName()));
    }

    @Test
    public void testReferencesHaveMetadataProperties() throws BaseNessieClientServerException {
        String branchPrefix = "branchesHaveMetadataProperties";
        String tagPrefix = "tagsHaveMetadataProperties";
        int numBranches = 3;
        int commitsPerBranch = 3;
        for (int i = 0; i < numBranches; ++i) {
            Reference r2 = this.getApi().createReference().reference((Reference)Branch.of((String)(branchPrefix + i), null)).create();
            String currentHash = r2.getHash();
            currentHash = this.createCommits(r2, 1, commitsPerBranch, currentHash);
            this.getApi().createReference().reference((Reference)Tag.of((String)(tagPrefix + i), (String)currentHash)).sourceRefName(r2.getName()).create();
        }
        List references = this.getApi().getAllReferences().get().getReferences();
        Optional<Reference> main = references.stream().filter(r -> r.getName().equals("main")).findFirst();
        Assertions.assertThat(main).isPresent();
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(branchPrefix)).map(r -> (Branch)r)).hasSize(numBranches)).allSatisfy(branch -> Assertions.assertThat((Object)branch.getMetadata()).isNull());
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(tagPrefix)).map(r -> (Tag)r)).hasSize(numBranches)).allSatisfy(tag -> Assertions.assertThat((Object)tag.getMetadata()).isNull());
        references = this.getApi().getAllReferences().fetch(FetchOption.ALL).get().getReferences();
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(branchPrefix)).map(r -> (Branch)r)).hasSize(numBranches)).allSatisfy(branch -> this.verifyMetadataProperties(commitsPerBranch, 0, (Branch)branch, (Reference)main.get(), commitsPerBranch));
        ((ListAssert)Assertions.assertThat(references.stream().filter(r -> r.getName().startsWith(tagPrefix)).map(r -> (Tag)r)).hasSize(numBranches)).allSatisfy(this::verifyMetadataProperties);
    }

    @Test
    public void testSingleReferenceHasMetadataProperties() throws BaseNessieClientServerException {
        String branchName = "singleBranchHasMetadataProperties";
        String tagName = "singleTagHasMetadataProperties";
        int numCommits = 3;
        Reference r = this.getApi().createReference().reference((Reference)Branch.of((String)branchName, null)).create();
        String currentHash = r.getHash();
        currentHash = this.createCommits(r, 1, numCommits, currentHash);
        this.getApi().createReference().reference((Reference)Tag.of((String)tagName, (String)currentHash)).sourceRefName(r.getName()).create();
        Reference ref = this.getApi().getReference().refName(branchName).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class)).extracting("metadata").isNull();
        ref = this.getApi().getReference().refName(tagName).get();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Tag.class)).extracting("metadata").isNull();
        ref = this.getApi().getReference().refName(branchName).fetch(FetchOption.ALL).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Branch.class);
        this.verifyMetadataProperties(numCommits, 0, (Branch)ref, this.getApi().getReference().refName("main").get(), numCommits);
        ref = this.getApi().getReference().refName(tagName).fetch(FetchOption.ALL).get();
        ((ObjectAssert)Assertions.assertThat((Object)ref).isNotNull()).isInstanceOf(Tag.class);
        this.verifyMetadataProperties((Tag)ref);
    }

    void verifyMetadataProperties(int expectedCommitsAhead, int expectedCommitsBehind, Branch branch, Reference reference, long expectedCommits) throws NessieNotFoundException {
        List commits = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).maxRecords(1)).get().getLogEntries();
        Assertions.assertThat((List)commits).hasSize(1);
        CommitMeta commitMeta = ((LogResponse.LogEntry)commits.get(0)).getCommitMeta();
        ReferenceMetadata referenceMetadata = branch.getMetadata();
        Assertions.assertThat((Object)referenceMetadata).isNotNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsAhead()).isEqualTo(expectedCommitsAhead);
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsBehind()).isEqualTo(expectedCommitsBehind);
        Assertions.assertThat((Object)referenceMetadata.getCommitMetaOfHEAD()).isEqualTo((Object)commitMeta);
        Assertions.assertThat((String)referenceMetadata.getCommonAncestorHash()).isEqualTo(reference.getHash());
        Assertions.assertThat((Long)referenceMetadata.getNumTotalCommits()).isEqualTo(expectedCommits);
    }

    void verifyMetadataProperties(Tag tag) throws NessieNotFoundException {
        List commits = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(tag.getName())).maxRecords(1)).get().getLogEntries();
        Assertions.assertThat((List)commits).hasSize(1);
        CommitMeta commitMeta = ((LogResponse.LogEntry)commits.get(0)).getCommitMeta();
        ReferenceMetadata referenceMetadata = tag.getMetadata();
        Assertions.assertThat((Object)referenceMetadata).isNotNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsAhead()).isNull();
        Assertions.assertThat((Integer)referenceMetadata.getNumCommitsBehind()).isNull();
        Assertions.assertThat((Object)referenceMetadata.getCommitMetaOfHEAD()).isEqualTo((Object)commitMeta);
        Assertions.assertThat((String)referenceMetadata.getCommonAncestorHash()).isNull();
        Assertions.assertThat((Long)referenceMetadata.getNumTotalCommits()).isEqualTo(3L);
    }
}

