/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.AbstractRestInvalidRefs;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestInvalidWithHttp
extends AbstractRestInvalidRefs {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidBranchNames(String invalidBranchName, String validHash) {
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(invalidBranchName)).hash(validHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(invalidBranchName)).untilHash(validHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getReference().refName(invalidBranchName).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(invalidBranchName)).hash(validHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> {
            if (null != this.getHttpClient()) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getHttpClient().newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", invalidBranchName).queryParam("expectedHash", validHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'").hasMessageContaining(".merge: must not be null");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRef((Reference)this.getApi().getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRefName("main")).hashesToTransplant(Collections.singletonList(this.getApi().getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().getDiff().fromRefName(invalidBranchName).toRefName("main").get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")});
    }

    @ParameterizedTest
    @CsvSource(value={"abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(validBranchName)).hash(invalidHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes").hasMessageContaining(opsCountMsg), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(validBranchName)).hash(invalidHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".oldHash: Hash must consist of the hex representation of 4-32 bytes"), () -> {
            if (null != this.getHttpClient()) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getHttpClient().newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", validBranchName).queryParam("expectedHash", invalidHash).post(null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("mergeRefIntoBranch.merge: must not be null").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes");
            }
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRef((Reference)this.getApi().getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRefName("main")).hashesToTransplant(Collections.singletonList(this.getApi().getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().refName(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".request.requestedKeys: size must be between 1 and 2147483647").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".hashOnRef: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(validBranchName)).untilHash(invalidHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".params.startHash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".params.endHash: Hash must consist of the hex representation of 4-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining(".params.hashOnRef: Hash must consist of the hex representation of 4-32 bytes")});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidTags(String invalidTagNameIn, String validHash) {
        Assumptions.assumeThat((Object)this.getHttpClient()).isNotNull();
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.getHttpClient().newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400):").hasMessageContaining(".assignTo: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.getHttpClient().newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + invalidTagName + "\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.getHttpClient().newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of ").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.getHttpClient().newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Reference`: known type ids = [")});
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }
}

