/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.jaxrs.AbstractRestRefLog;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestNamespace
extends AbstractRestRefLog {
    @ParameterizedTest
    @ValueSource(strings={"a.b.c", "a.b\u001dc.d", "a.b.c.d", "a.b\u0000c.d"})
    public void testNamespaces(String namespaceName) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespaces");
        Namespace ns = Namespace.parse((String)namespaceName);
        Namespace namespace = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(ns)).create();
        ((ObjectAssert)Assertions.assertThat((Object)namespace).isNotNull()).isEqualTo((Object)ns);
        Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get()).isEqualTo((Object)namespace);
        String namespaceInErrorMsg = namespaceName.replace("\u0000", "\u001d");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespaceInErrorMsg));
        ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(ns)).delete();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespaceInErrorMsg));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespaceInErrorMsg));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(Namespace.parse((String)"nonexisting"))).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'nonexisting' does not exist");
    }

    @Test
    public void testNamespacesRetrieval() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("namespace");
        Namespace one = Namespace.parse((String)"a.b.c");
        Namespace two = Namespace.parse((String)"a.b.d");
        Namespace three = Namespace.parse((String)"x.y.z");
        Namespace four = Namespace.parse((String)"one.two");
        for (Namespace namespace : Arrays.asList(one, two, three, four)) {
            Assertions.assertThat((Object)((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(namespace)).create()).isNotNull();
        }
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two, three, four});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two, three, four});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b.c")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b.d")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{two});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("x")).get().getNamespaces()).containsExactly((Object[])new Namespace[]{three});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("z")).get().getNamespaces()).isEmpty();
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("one")).get().getNamespaces()).containsExactly((Object[])new Namespace[]{four});
    }

    @Test
    public void testNamespaceDeletion() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespaceDeletion");
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        AbstractRestNamespace.contentAndOperationTypes().flatMap(c -> c.globalOperation == null ? Stream.of(c.operation) : Stream.of(c.operation, c.globalOperation)).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)commit).operation(arg_0));
        commit.commit();
        List entries = AbstractRestNamespace.contentAndOperationTypes().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
        for (EntriesResponse.Entry e : entries) {
            Namespace namespace = e.getName().getNamespace();
            Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(namespace)).get()).isEqualTo((Object)namespace);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(namespace)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).hasMessage(String.format("Namespace '%s' is not empty", namespace));
        }
    }

    @Test
    public void testNamespaceMerge() throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(branch.getName())).create();
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(base.getName())).create();
        base = (Branch)this.getApi().getReference().refName(base.getName()).get();
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef((Reference)branch).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        String expectedCommitMsg = "create namespace a.b.c";
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{expectedCommitMsg, expectedCommitMsg});
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{ContentKey.of((List)ns.getElements())});
        Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @Test
    public void testNamespaceMergeWithConflict() throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(base.getName())).create();
        base = (Branch)this.getApi().getReference().refName(base.getName()).get();
        IcebergTable table = IcebergTable.of((String)"merge-table1", (long)42L, (int)42, (int)42, (int)42);
        branch = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "b", "c"}), (Content)table)).commit();
        Branch finalBase = base;
        Branch finalBranch = branch;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(finalBase)).fromRef((Reference)finalBranch).merge()).isInstanceOf(NessieReferenceConflictException.class)).hasMessage("The following keys have been changed in conflict: 'a.b.c'");
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"create namespace a.b.c"});
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries();
        Assertions.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{ContentKey.of((List)ns.getElements())});
        Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @Test
    public void testNamespaceConflictWithOtherContent() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespaceConflictWithOtherContent");
        IcebergTable icebergTable = IcebergTable.of((String)"icebergTable", (long)42L, (int)42, (int)42, (int)42);
        List<String> elements = Arrays.asList("a", "b", "c");
        ContentKey key = ContentKey.of(elements);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"add table")).operation((Operation)Operation.Put.of((ContentKey)key, (Content)icebergTable)).commit();
        Namespace ns = Namespace.of(elements);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage("Another content object with name 'a.b.c' already exists");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'a.b.c' does not exist");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'a.b.c' does not exist");
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{Namespace.parse((String)"a.b")});
    }

    @Test
    public void testNamespacesWithAndWithoutZeroBytes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespacesWithAndWithoutZeroBytes");
        String firstName = "a.b\u0000c.d";
        String secondName = "a.b.c.d";
        Namespace first = Namespace.parse((String)firstName);
        Namespace second = Namespace.parse((String)secondName);
        List<Namespace> namespaces = Arrays.asList(first, second);
        for (Namespace namespace : namespaces) {
            Namespace created = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(namespace)).create();
            ((ObjectAssert)Assertions.assertThat((Object)created).isNotNull()).isEqualTo((Object)namespace);
            Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(namespace)).get()).isEqualTo((Object)created);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(namespace)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespace.name()));
        }
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrderElementsOf(namespaces);
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a")).refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrderElementsOf(namespaces);
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{second});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b\u001dc")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{first});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b\u0000c")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{first});
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b.c")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{second});
        for (Namespace namespace : namespaces) {
            ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(namespace)).delete();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(namespace)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespace.name()));
        }
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
    }

    @Test
    public void testEmptyNamespace() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("emptyNamespace");
        Assertions.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).create()).isInstanceOf(Exception.class);
        Assertions.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).get()).isInstanceOf(Exception.class);
        Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).delete()).isInstanceOf(Exception.class);
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
        ContentKey keyWithoutNamespace = ContentKey.of((String[])new String[]{"icebergTable"});
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"add table")).operation((Operation)Operation.Put.of((ContentKey)keyWithoutNamespace, (Content)IcebergTable.of((String)"icebergTable", (long)42L, (int)42, (int)42, (int)42))).commit();
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace(Namespace.EMPTY)).get().getNamespaces()).isEmpty();
    }

    @Test
    public void testNamespaceWithProperties() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("namespaceWithProperties");
        ImmutableMap properties = ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2");
        Namespace namespace = Namespace.of((Map)properties, (String[])new String[]{"a", "b", "c"});
        Namespace ns = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(namespace)).properties((Map)properties).reference((Reference)branch)).create();
        Assertions.assertThat((Map)ns.getProperties()).isEqualTo((Object)properties);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testNamespaceWithProperties$17(branch, (Map)properties)).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'non-existing' does not exist");
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference((Reference)branch)).namespace(namespace)).updateProperties((Map)properties).update();
        ns = ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference((Reference)branch)).namespace(namespace)).get();
        Assertions.assertThat((Map)ns.getProperties()).isEqualTo((Object)properties);
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference((Reference)branch)).namespace(namespace)).updateProperties((Map)ImmutableMap.of((Object)"key3", (Object)"val3", (Object)"key1", (Object)"xyz")).removeProperties((Set)ImmutableSet.of((Object)"key2", (Object)"key5")).update();
        ns = ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference((Reference)branch)).namespace(namespace)).get();
        Assertions.assertThat((Map)ns.getProperties()).isEqualTo((Object)ImmutableMap.of((Object)"key1", (Object)"xyz", (Object)"key3", (Object)"val3"));
    }

    private /* synthetic */ void lambda$testNamespaceWithProperties$17(Branch branch, Map properties) throws Throwable {
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference((Reference)branch)).namespace("non-existing")).updateProperties(properties).update();
    }
}

