/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestContents;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestDiff
extends AbstractRestContents {
    public static Stream<Object[]> diffRefModes() {
        return Arrays.stream(AbstractRest.ReferenceMode.values()).flatMap(refModeFrom -> Arrays.stream(AbstractRest.ReferenceMode.values()).map(refModeTo -> new Object[]{refModeFrom, refModeTo}));
    }

    @ParameterizedTest
    @MethodSource(value={"diffRefModes"})
    public void testDiff(AbstractRest.ReferenceMode refModeFrom, AbstractRest.ReferenceMode refModeTo) throws BaseNessieClientServerException {
        int commitsPerBranch = 3;
        Reference fromRef = this.getApi().createReference().reference((Reference)Branch.of((String)"testDiffFromRef", null)).create();
        Reference toRef = this.getApi().createReference().reference((Reference)Branch.of((String)"testDiffToRef", null)).create();
        String toRefHash = this.createCommits(toRef, 1, commitsPerBranch, toRef.getHash());
        toRef = Branch.of((String)toRef.getName(), (String)toRefHash);
        List diffOnRefHeadResponse = this.getApi().getDiff().fromRef(refModeFrom.transform(fromRef)).toRef(refModeTo.transform(toRef)).get().getDiffs();
        ((ListAssert)Assertions.assertThat((List)diffOnRefHeadResponse).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        Assertions.assertThat((List)this.getApi().getDiff().fromRefName(fromRef.getName()).fromHashOnRef(fromRef.getHash()).toRefName(toRef.getName()).toHashOnRef(toRef.getHash()).get().getDiffs()).isEqualTo((Object)diffOnRefHeadResponse);
        if (refModeTo != AbstractRest.ReferenceMode.NAME_ONLY) {
            Branch toRefAtFrom = Branch.of((String)toRef.getName(), (String)fromRef.getHash());
            Assertions.assertThat((List)this.getApi().getDiff().fromRef(refModeFrom.transform(fromRef)).toRef(refModeTo.transform((Reference)toRefAtFrom)).get().getDiffs()).isEmpty();
        }
        fromRef = Branch.of((String)fromRef.getName(), (String)this.createCommits(fromRef, 1, commitsPerBranch, fromRef.getHash()));
        ((ListAssert)Assertions.assertThat((List)this.getApi().getDiff().fromRef(refModeFrom.transform(fromRef)).toRef(refModeTo.transform(toRef)).get().getDiffs()).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
            Assertions.assertThat((String)diff.getFrom().getId()).isNotEqualTo((Object)diff.getTo().getId());
            Optional fromTable = diff.getFrom().unwrap(IcebergTable.class);
            Assertions.assertThat((Optional)fromTable).isPresent();
            Optional toTable = diff.getTo().unwrap(IcebergTable.class);
            Assertions.assertThat((Optional)toTable).isPresent();
            Assertions.assertThat((String)((IcebergTable)fromTable.get()).getMetadataLocation()).isEqualTo(((IcebergTable)toTable.get()).getMetadataLocation());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSchemaId()).isEqualTo(((IcebergTable)toTable.get()).getSchemaId());
            Assertions.assertThat((long)((IcebergTable)fromTable.get()).getSnapshotId()).isEqualTo(((IcebergTable)toTable.get()).getSnapshotId());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSortOrderId()).isEqualTo(((IcebergTable)toTable.get()).getSortOrderId());
            Assertions.assertThat((int)((IcebergTable)fromTable.get()).getSpecId()).isEqualTo(((IcebergTable)toTable.get()).getSpecId());
        });
        List keys = IntStream.rangeClosed(0, commitsPerBranch).mapToObj(i -> ContentKey.of((String[])new String[]{"table" + i})).collect(Collectors.toList());
        Map map = ((GetContentBuilder)this.getApi().getContent().refName(toRef.getName())).keys(keys).get();
        for (Map.Entry entry : map.entrySet()) {
            toRef = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(toRef.getName())).hash(toRefHash)).commitMeta(CommitMeta.fromMessage((String)"delete")).operation((Operation)Operation.Delete.of((ContentKey)((ContentKey)entry.getKey()))).commit();
        }
        ((ListAssert)Assertions.assertThat((List)this.getApi().getDiff().fromRef(refModeFrom.transform(fromRef)).toRef(refModeTo.transform(toRef)).get().getDiffs()).hasSize(commitsPerBranch)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNull();
        });
    }
}

