/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestInvalidWithHttp;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestMergeTransplant
extends AbstractRestInvalidWithHttp {
    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void transplant(boolean withDetachedCommit, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        this.mergeTransplant(keepIndividualCommits, (ThrowingConsumer<Tuple>)((ThrowingConsumer)t -> {
            List objects = t.toList();
            Branch base = (Branch)objects.get(0);
            Branch branch = (Branch)objects.get(1);
            Reference committed1 = (Reference)objects.get(2);
            Reference committed2 = (Reference)objects.get(3);
            ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)committed1.getHash(), (Object)committed2.getHash())).fromRefName(AbstractRestMergeTransplant.maybeAsDetachedName(withDetachedCommit, (Reference)branch))).branch(base)).keepIndividualCommits(keepIndividualCommits)).transplant();
        }));
    }

    @ParameterizedTest
    @CsvSource(value={"UNCHANGED,true", "UNCHANGED,false", "DETACHED,true", "DETACHED,false"})
    public void merge(AbstractRest.ReferenceMode refMode, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        this.mergeTransplant(keepIndividualCommits, (ThrowingConsumer<Tuple>)((ThrowingConsumer)t -> {
            List objects = t.toList();
            Branch base = (Branch)objects.get(0);
            Reference committed2 = (Reference)objects.get(3);
            ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef(refMode.transform(committed2)).keepIndividualCommits(keepIndividualCommits)).merge();
        }));
    }

    private void mergeTransplant(boolean keepIndividualCommits, ThrowingConsumer<Tuple> actor) throws BaseNessieClientServerException {
        Branch base = this.createBranch("base");
        Branch branch = this.createBranch("branch");
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        int commitCount = 2;
        LogResponse logBranch = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).untilHash(branch.getHash()).maxRecords(commitCount)).get();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        actor.accept((Object)Tuple.tuple((Object[])new Object[]{base, branch, committed1, committed2}));
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        if (keepIndividualCommits) {
            ((ListAssert)Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).hasSize(3)).containsExactly((Object[])new String[]{"test-branch2", "test-branch1", "test-main"});
        } else {
            ((AbstractStringAssert)((AbstractStringAssert)((ListAssert)Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).hasSize(2)).first(InstanceOfAssertFactories.STRING)).contains(new CharSequence[]{"test-branch2"})).contains(new CharSequence[]{"test-branch1"});
        }
        LogResponse logOfMerged = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).maxRecords(commitCount)).get();
        Assertions.assertThat(logOfMerged.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime)).isNotEqualTo(logBranch.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime));
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class, mode=EnumSource.Mode.EXCLUDE, names={"NAME_ONLY"})
    public void mergeWithNamespaces(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(branch.getName())).create();
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(base.getName())).create();
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        ContentKey key1 = ContentKey.of((Namespace)ns, (String)"key1");
        ContentKey key2 = ContentKey.of((Namespace)ns, (String)"key2");
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef(refMode.transform((Reference)committed2)).keepIndividualCommits(true)).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-branch2", "test-branch1", "create namespace a.b.c", "test-main", "create namespace a.b.c"});
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, ContentKey.of((List)ns.getElements())});
        Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }
}

