/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.jaxrs.AbstractRestMergeTransplant;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestMisc
extends AbstractRestMergeTransplant {
    @Test
    public void testSupportedApiVersions() {
        Assertions.assertThat((int)this.getApi().getConfig().getMaxSupportedApiVersion()).isEqualTo(1);
    }

    @Test
    public void checkSpecialCharacterRoundTrip() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("specialchar");
        ContentKey key = ContentKey.of((String[])new String[]{"a.b", "c.txt"});
        IcebergTable table = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)key, (Content)table)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((MapAssert)Assertions.assertThat((Map)((GetContentBuilder)this.getApi().getContent().key(key).refName(branch.getName())).get()).containsKey((Object)key)).hasEntrySatisfying((Object)key, content -> Assertions.assertThat((Object)content).isEqualTo((Object)IcebergTable.builder().from(table).id(content.getId()).build()));
    }

    @Test
    public void checkServerErrorPropagation() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("bar");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getApi().createReference().sourceRefName("main").reference((Reference)branch).create()).isInstanceOf(NessieReferenceAlreadyExistsException.class)).hasMessageContaining("already exists");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta((CommitMeta)CommitMeta.builder().author("author").message("committed-by-test").committer("disallowed-client-side-committer").build()).operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"table"}))).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Cannot set the committer on the client side.");
    }

    @Test
    public void checkCelScriptFailureReporting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName("main")).filter("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName("main")).filter("invalid_script")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
    }
}

