/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Tag;

public abstract class AbstractResteasyTest {
    protected static String basePath = "/api/v1/";

    @BeforeEach
    public void enableLogging() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    public void testBasic() {
        int preSize = ((ReferencesResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(ReferencesResponse.class)).getReferences().size();
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)Branch.of((String)"mainx", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        ReferencesResponse references = (ReferencesResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees", new Object[0])).then()).statusCode(200)).extract().as(ReferencesResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)(preSize + 1), (int)references.getReferences().size());
        Reference reference = (Reference)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).then()).statusCode(200)).extract().as(Reference.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mainx", (Object)reference.getName());
        ImmutableBranch newReference = ImmutableBranch.builder().hash(reference.getHash()).name("test").build();
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{reference.getHash()}).body((Object)Branch.of((String)"test", null)).post("trees/tree", new Object[0])).then()).statusCode(200);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newReference, (Object)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).then()).statusCode(200)).extract().as(Branch.class));
        IcebergTable initialTable = IcebergTable.of((String)"/the/directory/over/there", (long)42L, (int)43, (int)44, (int)45);
        Branch commitResponse = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(ContentKey.of((String[])new String[]{"xxx", "test"})).content((Content)initialTable).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()).queryParam("expectedHash", new Object[]{newReference.getHash()}).post("trees/branch/{branch}/commit", new Object[]{newReference.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)newReference.getHash(), (Object)commitResponse.getHash());
        IcebergTable table = (IcebergTable)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).statusCode(200)).extract().as(IcebergTable.class);
        Assertions.assertThat((Object)table).extracting(new Function[]{IcebergTable::getMetadataLocation, IcebergTable::getSnapshotId, IcebergTable::getSchemaId, IcebergTable::getSpecId, IcebergTable::getSortOrderId}).containsExactly(new Object[]{initialTable.getMetadataLocation(), initialTable.getSnapshotId(), initialTable.getSchemaId(), initialTable.getSpecId(), initialTable.getSortOrderId()});
        Operation.Put[] updates = new Operation.Put[11];
        for (int i = 0; i < 10; ++i) {
            updates[i] = ImmutablePut.builder().key(ContentKey.of((String[])new String[]{"item", Integer.toString(i)})).content((Content)IcebergTable.of((String)("/the/directory/over/there/" + i), (long)42L, (int)42, (int)42, (int)42)).build();
        }
        updates[10] = ImmutablePut.builder().key(ContentKey.of((String[])new String[]{"xxx", "test"})).content((Content)IcebergTable.of((String)"/the/directory/over/there/has/been/moved", (long)42L, (int)42, (int)42, (int)42)).build();
        Reference branch = (Reference)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Reference.class);
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation[])updates).commitMeta(CommitMeta.fromMessage((String)"")).build();
        commitResponse = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)branch.getHash(), (Object)commitResponse.getHash());
        Response res = (Response)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).extract().response();
        org.junit.jupiter.api.Assertions.assertEquals((Object)updates[10].getContent(), (Object)AbstractResteasyTest.withoutId((Content)res.body().as(Content.class)));
        IcebergTable currentTable = table;
        table = IcebergTable.of((String)"/the/directory/over/there/has/been/moved/again", (long)42L, (int)42, (int)42, (int)42, (String)table.getId());
        Branch b2 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(ContentKey.of((String[])new String[]{"xxx", "test"})).content((Content)table).expectedContent((Content)currentTable).build()).commitMeta(CommitMeta.fromMessage((String)"")).build()).queryParam("expectedHash", new Object[]{b2.getHash()}).post("trees/branch/{branch}/commit", new Object[]{b2.getName()})).then()).statusCode(200)).extract().as(Branch.class);
        Content returned = (Content)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{"test"}).get("contents/xxx.test", new Object[0])).then()).statusCode(200)).extract().as(Content.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)table, (Object)returned);
        Branch b3 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)Tag.of((String)"tagtest", (String)b3.getHash())).queryParam("sourceRefName", new Object[]{b3.getName()}).post("trees/tree", new Object[0])).then()).statusCode(200);
        Assertions.assertThat((String)((Tag)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/tagtest", new Object[0])).then()).statusCode(200)).extract().body().as(Tag.class)).getHash()).isEqualTo(b3.getHash());
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{"0011223344556677889900112233445566778899001122334455667788990011".substring(0, b2.getHash().length())}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(409);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{b3.getHash()}).delete("trees/tag/tagtest", new Object[0])).then()).statusCode(204);
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/test/log", new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)log.getLogEntries().size());
        Branch b1 = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/test", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{b1.getHash()}).delete("trees/branch/test", new Object[0])).then()).statusCode(204);
        Branch bx = (Branch)((Response)AbstractResteasyTest.rest().get("trees/tree/mainx", new Object[0])).as(Branch.class);
        ((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("expectedHash", new Object[]{bx.getHash()}).delete("trees/branch/mainx", new Object[0])).then()).statusCode(204);
    }

    private static Content withoutId(Content content) {
        if (content instanceof IcebergTable) {
            return IcebergTable.builder().from(content).id(null).build();
        }
        throw new IllegalArgumentException("Expected IcebergTable, got " + content);
    }

    private static RequestSpecification rest() {
        return RestAssured.given().when().baseUri(RestAssured.baseURI).basePath(basePath).contentType(ContentType.JSON);
    }

    private Branch commit(String contentId, Branch branch, String contentKey, String metadataUrl) {
        return this.commit(contentId, branch, contentKey, metadataUrl, "nessieAuthor", null);
    }

    private Branch commit(String contentId, Branch branch, String contentKey, String metadataUrl, String author, String expectedMetadataUrl) {
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation)(expectedMetadataUrl != null ? Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{contentKey}), (Content)IcebergTable.of((String)metadataUrl, (long)42L, (int)42, (int)42, (int)42, (String)contentId), (Content)IcebergTable.of((String)expectedMetadataUrl, (long)42L, (int)42, (int)42, (int)42, (String)contentId)) : Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{contentKey}), (Content)IcebergTable.of((String)metadataUrl, (long)42L, (int)42, (int)42, (int)42, (String)contentId)))).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("").build()).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch commit(ContentKey contentKey, Content content, Branch branch, String author) {
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation)Operation.Put.of((ContentKey)contentKey, (Content)content)).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("").build()).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)contents).queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch getBranch(String name) {
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("trees/tree/{name}", new Object[]{name})).then()).statusCode(200)).extract().as(Branch.class);
    }

    private Branch makeBranch(String name) {
        ImmutableBranch test = ImmutableBranch.builder().name(name).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().body((Object)test).post("trees/tree", new Object[0])).then()).statusCode(200)).extract().as(Branch.class);
    }

    @Test
    public void testOptimisticLocking() {
        this.makeBranch("test3");
        Branch b1 = this.getBranch("test3");
        String contentId = "cid-test-opt-lock";
        String newHash = this.commit(contentId, b1, "xxx.test", "/the/directory/over/there").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b1.getHash(), (Object)newHash);
        Branch b2 = this.getBranch("test3");
        newHash = this.commit(contentId, b2, "xxx.test", "/the/directory/over/there/has/been/moved", "i", "/the/directory/over/there").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b2.getHash(), (Object)newHash);
        Branch b3 = this.getBranch("test3");
        newHash = this.commit(contentId, b3, "xxx.test", "/the/directory/over/there/has/been/moved/again", "me", "/the/directory/over/there/has/been/moved").getHash();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)b3.getHash(), (Object)newHash);
    }

    @Test
    public void testLogFiltering() {
        String branchName = "logFiltering";
        this.makeBranch(branchName);
        Branch branch = this.getBranch(branchName);
        int numCommits = 3;
        String contentId = "cid-test-log-filtering";
        for (int i = 0; i < numCommits; ++i) {
            String newHash = this.commit(contentId, branch, "xxx.test", "/the/directory/over/there", "author-" + i, i > 0 ? "/the/directory/over/there" : null).getHash();
            Assertions.assertThat((String)newHash).isNotEqualTo((Object)branch.getHash());
            branch = this.getBranch(branchName);
        }
        LogResponse log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits);
        Instant firstCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(log.getLogEntries().size() - 1)).getCommitMeta().getCommitTime();
        Instant lastCommitTime = ((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getCommitTime();
        Assertions.assertThat((Instant)firstCommitTime).isNotNull();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        String author = "author-1";
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("filter", new Object[]{String.format("commit.author=='%s'", author)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getLogEntries()).hasSize(1);
        Assertions.assertThat((String)((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getAuthor()).isEqualTo(author);
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("filter", new Object[]{String.format("timestamp(commit.commitTime) > timestamp('%s')", firstCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits - 1);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isAfter(firstCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("filter", new Object[]{String.format("timestamp(commit.commitTime) < timestamp('%s')", lastCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getLogEntries()).hasSize(numCommits - 1);
        log.getLogEntries().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitMeta().getCommitTime()).isBefore(lastCommitTime));
        log = (LogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("filter", new Object[]{String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", firstCommitTime, lastCommitTime)}).get(String.format("trees/tree/%s/log", branchName), new Object[0])).then()).statusCode(200)).extract().as(LogResponse.class);
        Assertions.assertThat((List)log.getLogEntries()).hasSize(1);
        Assertions.assertThat((Instant)((LogResponse.LogEntry)log.getLogEntries().get(0)).getCommitMeta().getCommitTime()).isBefore(lastCommitTime).isAfter(firstCommitTime);
    }

    @ParameterizedTest
    @CsvSource(value={"simple,name", "simple,dotted.txt", "dotted.prefix,name", "dotted.prefix,dotted.txt"})
    public void testGetContent(String ns, String name) {
        Branch branch = this.makeBranch("content-test-" + UUID.randomUUID());
        IcebergTable table = IcebergTable.of((String)"content-table1", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key = ContentKey.of((String[])new String[]{ns, name});
        branch = this.commit(key, (Content)table, branch, "test author");
        Content content = (Content)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("ref", new Object[]{branch.getName()}).queryParam("hashOnRef", new Object[]{branch.getHash()}).get(String.format("contents/%s", key.toPathString()), new Object[0])).then()).statusCode(200)).extract().as(Content.class);
        Assertions.assertThat((Object)AbstractResteasyTest.withoutId(content)).isEqualTo((Object)table);
    }

    @Test
    public void testGetDiff() {
        Branch fromBranch = this.makeBranch("getdiff-test-from");
        Branch toBranch = this.makeBranch("getdiff-test-to");
        IcebergTable fromTable = IcebergTable.of((String)"content-table", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable toTable = IcebergTable.of((String)"content-table", (long)43L, (int)43, (int)43, (int)43);
        ContentKey contentKey = ContentKey.of((String[])new String[]{"key1"});
        this.commit(contentKey, (Content)fromTable, fromBranch, "diffAuthor");
        this.commit(contentKey, (Content)toTable, toBranch, "diffAuthor2");
        DiffResponse diffResponse = (DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get(String.format("diffs/%s...%s", fromBranch.getName(), toBranch.getName()), new Object[0])).then()).statusCode(200)).extract().as(DiffResponse.class);
        Assertions.assertThat((Object)diffResponse).isNotNull();
        Assertions.assertThat((List)diffResponse.getDiffs()).hasSize(1);
        DiffResponse.DiffEntry diff = (DiffResponse.DiffEntry)diffResponse.getDiffs().get(0);
        Assertions.assertThat((Object)diff.getKey()).isEqualTo((Object)contentKey);
        Assertions.assertThat((Object)AbstractResteasyTest.withoutId(diff.getFrom())).isEqualTo((Object)fromTable);
        Assertions.assertThat((Object)AbstractResteasyTest.withoutId(diff.getTo())).isEqualTo((Object)toTable);
    }

    @Test
    public void testGetRefLog() {
        Branch branch = this.makeBranch("branch-temp");
        IcebergTable table = IcebergTable.of((String)"content-table", (long)42L, (int)42, (int)42, (int)42);
        ContentKey contentKey = ContentKey.of((String[])new String[]{"key1"});
        this.commit(contentKey, (Content)table, branch, "code");
        RefLogResponse refLogResponse = (RefLogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().get("reflogs", new Object[0])).then()).statusCode(200)).extract().as(RefLogResponse.class);
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(0)).getOperation()).isEqualTo("COMMIT");
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(0)).getRefName()).isEqualTo("branch-temp");
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(1)).getOperation()).isEqualTo("CREATE_REFERENCE");
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(1)).getRefName()).isEqualTo("branch-temp");
        RefLogResponse refLogResponse1 = (RefLogResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyTest.rest().queryParam("endHash", new Object[]{((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(1)).getRefLogId()}).get("reflogs", new Object[0])).then()).statusCode(200)).extract().as(RefLogResponse.class);
        Assertions.assertThat((String)((RefLogResponse.RefLogResponseEntry)refLogResponse1.getLogEntries().get(0)).getRefLogId()).isEqualTo(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(1)).getRefLogId());
    }
}

