/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestAssign
extends AbstractRest {
    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void testAssignRefToFreshMain(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Reference main = this.getApi().getReference().refName("main").get();
        Assertions.assertThat((Stream)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(main.getName())).stream()).isEmpty();
        Branch testBranch = this.createBranch("testBranch");
        ((AssignBranchBuilder)this.getApi().assignBranch().branch(testBranch)).assignTo(main).assign();
        Reference testBranchRef = this.getApi().getReference().refName(testBranch.getName()).get();
        Assertions.assertThat((String)testBranchRef.getHash()).isEqualTo(main.getHash());
        String testTag = "testTag";
        Reference testTagRef = this.getApi().createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)testTag, (String)main.getHash())).create();
        Assertions.assertThat((String)testTagRef.getHash()).isNotNull();
        ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().hash(testTagRef.getHash())).tagName(testTag)).assignTo(refMode.transform(main)).assign();
        testTagRef = this.getApi().getReference().refName(testTag).get();
        Assertions.assertThat((String)testTagRef.getHash()).isEqualTo(main.getHash());
    }
}

