/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.AbstractRestEntries;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Reference;

public abstract class AbstractRestInvalidRefs
extends AbstractRestEntries {
    @Test
    public void testInvalidNamedRefs() {
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        String invalidRef = "1234567890123456";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)this.getApi().getEntries().refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().key(key).refName(invalidRef)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().refName(invalidRef)).key(key).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
    }

    @Test
    public void testValidHashesOnValidNamedRefs() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testValidHashesOnValidNamedRefs");
        int commits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, commits, currentHash);
        LogResponse entireLog = (LogResponse)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).get();
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getLogEntries()).hasSize(commits);
        EntriesResponse allEntries = (EntriesResponse)((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).get();
        Assertions.assertThat((Object)allEntries).isNotNull();
        Assertions.assertThat((List)allEntries.getEntries()).hasSize(commits);
        ArrayList keys = new ArrayList();
        IntStream.range(0, commits).forEach(i -> keys.add(ContentKey.of((String[])new String[]{"table" + i})));
        Map allContent = ((GetContentBuilder)this.getApi().getContent().keys(keys).refName(branch.getName())).get();
        for (int i2 = 0; i2 < commits; ++i2) {
            String hash = ((LogResponse.LogEntry)entireLog.getLogEntries().get(i2)).getCommitMeta().getHash();
            LogResponse log = (LogResponse)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getLogEntries()).hasSize(commits - i2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getLogEntries()).subList(i2, commits)).containsExactlyElementsOf((Iterable)log.getLogEntries());
            EntriesResponse entries = (EntriesResponse)((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).hashOnRef(hash)).get();
            Assertions.assertThat((Object)entries).isNotNull();
            Assertions.assertThat((List)entries.getEntries()).hasSize(commits - i2);
            int idx = commits - 1 - i2;
            ContentKey key = ContentKey.of((String[])new String[]{"table" + idx});
            Content c = (Content)((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(branch.getName())).hashOnRef(hash)).get().get(key);
            ((ObjectAssert)Assertions.assertThat((Object)c).isNotNull()).isEqualTo(allContent.get(key));
        }
    }

    @Test
    public void testUnknownHashesOnValidNamedRefs() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testUnknownHashesOnValidNamedRefs");
        String invalidHash = "1234567890123456";
        int commits = 10;
        String currentHash = branch.getHash();
        this.createCommits((Reference)branch, 1, commits, currentHash);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(ContentKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(ContentKey.of((String[])new String[]{"table0"})).refName(branch.getName())).hashOnRef(invalidHash)).get()).isInstanceOf(NessieNotFoundException.class)).hasMessageContaining(String.format("Could not find commit '%s' in reference '%s'.", invalidHash, branch.getName()));
    }
}

