/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.AbstractRestCommitLog;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestContents
extends AbstractRestCommitLog {
    private static JsonNode loadJson(String scenario, String name) {
        JsonNode jsonNode;
        block8: {
            String resource = String.format("org/projectnessie/test-data/iceberg-metadata/%s/%s-%s.json", scenario, scenario, name);
            URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
            JsonParser parser = new ObjectMapper().createParser(Objects.requireNonNull(url, () -> String.format("Resource %s not found", resource)));
            try {
                jsonNode = (JsonNode)parser.readValueAs(JsonNode.class);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg-metadata"}), (Content)IcebergTable.of((JsonNode)AbstractRestContents.loadJson("table-three-snapshots", "3"), (String)"/iceberg/table/metadata", null))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view-metadata"}), (Content)IcebergView.of((JsonNode)AbstractRestContents.loadJson("view-simple", "1"), (String)"/iceberg/view/metadata", null))), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_dremio"}), (Content)IcebergView.of((String)"/iceberg/view", (int)1, (int)1, (String)"Dremio", (String)"SELECT foo FROM dremio"))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_presto"}), (Content)IcebergView.of((String)"/iceberg/view", (int)1, (int)1, (String)"Presto", (String)"SELECT foo FROM presto"))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"b", "view_spark"}), (Content)IcebergView.of((String)"/iceberg/view2", (int)1, (int)1, (String)"Spark", (String)"SELECT foo FROM spark"))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"c", "delta"}), (Content)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_unchanged"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_dremio_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_dremio_unchanged"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_spark_delete"}))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_spark_unchanged"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_delete"}))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_unchanged"}))));
    }

    @Test
    public void verifyAllContentAndOperationTypes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperationAll");
        List<ContentAndOperationType> contentAndOps = AbstractRestContents.contentAndOperationTypes().collect(Collectors.toList());
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        contentAndOps.forEach(contentAndOp -> commit.operation(contentAndOp.operation));
        Branch committed = commit.commit();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
            List expect = contentAndOps.stream().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
            Assertions.assertThat(entries).containsExactlyInAnyOrderElementsOf(expect);
        }, () -> ((ListAssert)Assertions.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).extracting(new Function[]{DiffResponse.DiffEntry::getKey, e -> this.clearIdOnContent(e.getFrom()), DiffResponse.DiffEntry::getTo}).containsExactlyInAnyOrderElementsOf((Iterable)contentAndOps.stream().map(c -> c.operation).filter(op -> op instanceof Operation.Put).map(Operation.Put.class::cast).map(put -> Tuple.tuple((Object[])new Object[]{put.getKey(), put.getContent(), null})).collect(Collectors.toList())), () -> {
            List allKeys = contentAndOps.stream().map(contentAndOperationType -> contentAndOperationType.operation.getKey()).collect(Collectors.toList());
            Map<ContentKey, Content> expected = contentAndOps.stream().filter(c -> c.operation instanceof Operation.Put).collect(Collectors.toMap(e -> e.operation.getKey(), e -> ((Operation.Put)e.operation).getContent()));
            ((MapAssert)Assertions.assertThat((Map)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed)).keys(allKeys).get()).containsOnlyKeys(expected.keySet())).allSatisfy((key, content) -> Assertions.assertThat((Object)this.clearIdOnContent((Content)content)).isEqualTo(expected.get(key)));
        }, () -> ((ListAssert)((ObjectAssert)Assertions.assertThat((Stream)((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream()).element(0)).extracting(LogResponse.LogEntry::getOperations).extracting(this::clearIdOnOperations, InstanceOfAssertFactories.list(Operation.class))).containsExactlyInAnyOrderElementsOf((Iterable)contentAndOps.stream().map(c -> c.operation).filter(op -> !(op instanceof Operation.Unchanged)).collect(Collectors.toList()))});
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    public void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperation_" + contentAndOperationType);
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).operation(contentAndOperationType.operation);
        Branch committed = commit.commit();
        ContentKey fixedContentKey = ContentKey.of((List)contentAndOperationType.operation.getKey().getElements());
        if (contentAndOperationType.operation instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)contentAndOperationType.operation;
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
                List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
                Assertions.assertThat(entries).containsExactly((Object[])new EntriesResponse.Entry[]{EntriesResponse.Entry.builder().name(fixedContentKey).type(contentAndOperationType.type).build()});
            }, () -> ((ListAssert)Assertions.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).extracting(new Function[]{DiffResponse.DiffEntry::getKey, e -> this.clearIdOnContent(e.getFrom()), DiffResponse.DiffEntry::getTo}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{fixedContentKey, put.getContent(), null})}), () -> {
                Map content = ((GetContentBuilder)this.getApi().getContent().key(fixedContentKey).reference((Reference)committed)).get();
                Assertions.assertThat((Map)content).extractingByKey((Object)fixedContentKey).extracting(this::clearIdOnContent).isEqualTo((Object)put.getContent());
            }, () -> {
                List log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream().collect(Collectors.toList());
                ((ObjectAssert)((ListAssert)((ObjectAssert)Assertions.assertThat(log).element(0)).extracting(LogResponse.LogEntry::getOperations, InstanceOfAssertFactories.list(Operation.class))).element(0)).extracting(this::clearIdOnOperation).isEqualTo((Object)put);
            }});
        } else {
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
                List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
                Assertions.assertThat(entries).isEmpty();
            }, () -> ((ListAssert)Assertions.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).isEmpty(), () -> {
                Map content = ((GetContentBuilder)this.getApi().getContent().key(fixedContentKey).reference((Reference)committed)).get();
                Assertions.assertThat((Map)content).isEmpty();
            }, () -> {
                List log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream().collect(Collectors.toList());
                ((ObjectAssert)Assertions.assertThat(log).element(0)).extracting(LogResponse.LogEntry::getOperations).satisfies(new ThrowingConsumer[]{ops -> {
                    if (contentAndOperationType.operation instanceof Operation.Delete) {
                        Assertions.assertThat((List)ops).containsExactly((Object[])new Operation[]{contentAndOperationType.operation});
                    } else if (contentAndOperationType.operation instanceof Operation.Unchanged) {
                        Assertions.assertThat((List)ops).isNullOrEmpty();
                    } else {
                        org.junit.jupiter.api.Assertions.fail((String)("Unexpected operation " + contentAndOperationType.operation));
                    }
                }});
            }});
        }
    }

    private List<Operation> clearIdOnOperations(List<Operation> o) {
        return o.stream().map(this::clearIdOnOperation).collect(Collectors.toList());
    }

    private Operation clearIdOnOperation(Operation o) {
        try {
            if (!(o instanceof Operation.Put)) {
                return o;
            }
            Operation.Put put = (Operation.Put)o;
            Content contentWithoutId = this.clearIdOnContent(put.getContent());
            return ImmutablePut.builder().from(put).content(contentWithoutId).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Content clearIdOnContent(Content content) {
        return this.setIdOnContent(content, null);
    }

    private Content setIdOnContent(Content content, String contentId) {
        try {
            return (Content)content.getClass().getDeclaredMethod("withId", String.class).invoke((Object)content, contentId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void multiget() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("foo");
        ContentKey keyA = ContentKey.of((String[])new String[]{"a"});
        ContentKey keyB = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tableA = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable tableB = IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)keyA, (Content)tableA)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)keyB, (Content)tableB)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        Map response = ((GetContentBuilder)this.getApi().getContent().key(keyA).key(keyB).key(ContentKey.of((String[])new String[]{"noexist"})).refName("foo")).get();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)response).containsKeys((Object[])new ContentKey[]{keyA, keyB})).hasEntrySatisfying((Object)keyA, content -> Assertions.assertThat((Object)content).isEqualTo((Object)IcebergTable.builder().from(tableA).id(content.getId()).build()))).hasEntrySatisfying((Object)keyB, content -> Assertions.assertThat((Object)content).isEqualTo((Object)IcebergTable.builder().from(tableB).id(content.getId()).build()))).doesNotContainKey((Object)ContentKey.of((String[])new String[]{"noexist"}));
    }

    static Stream<Arguments> icebergMetadataScenarios() {
        return Stream.of(AbstractRestContents.loadIcebergMetadataScenario("table-three-snapshots", 3));
    }

    private static Arguments loadIcebergMetadataScenario(String name, int count) {
        ArrayList<IcebergTable> contents = new ArrayList<IcebergTable>();
        for (int i = 1; i <= count; ++i) {
            IcebergTable content = IcebergTable.of((JsonNode)AbstractRestContents.loadJson(name, Integer.toString(i)), (String)String.format("/iceberg/%s", name), null);
            contents.add(content);
        }
        return Arguments.arguments((Object[])new Object[]{name, contents});
    }

    @ParameterizedTest
    @MethodSource(value={"icebergMetadataScenarios"})
    public void icebergMetadataScenario(String name, List<Content> contents) throws Exception {
        ContentKey key = ContentKey.of((String[])new String[]{"iceberg", "metadata-scenario", name});
        Branch head = this.createBranch("icebergMetadataScenario_" + name);
        Content previousContent = null;
        String contentId = null;
        for (Content content : contents) {
            content = this.setIdOnContent(content, contentId);
            Operation.Put op = previousContent == null ? Operation.Put.of((ContentKey)key, (Content)content) : Operation.Put.of((ContentKey)key, (Content)content, previousContent);
            Branch committed = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(head)).commitMeta(CommitMeta.fromMessage((String)"commit")).operation((Operation)op).commit();
            Map contentMap = ((GetContentBuilder)this.getApi().getContent().key(key).reference((Reference)committed)).get();
            if (contentId == null) {
                Assertions.assertThat((Map)contentMap).extractingByKey((Object)key).extracting(this::clearIdOnContent).isEqualTo((Object)content);
                contentId = ((Content)contentMap.get(key)).getId();
                content = this.setIdOnContent(content, contentId);
            } else {
                Assertions.assertThat((Map)contentMap).extractingByKey((Object)key).isEqualTo((Object)content);
            }
            List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(head.getName())).get().getEntries();
            Assertions.assertThat((List)entries).containsExactly((Object[])new EntriesResponse.Entry[]{EntriesResponse.Entry.builder().name(key).type(content.getType()).build()});
            ((ListAssert)Assertions.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)head).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).extracting(new Function[]{DiffResponse.DiffEntry::getKey, DiffResponse.DiffEntry::getFrom, DiffResponse.DiffEntry::getTo}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{key, content, previousContent})});
            LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).get();
            ((ObjectAssert)((ListAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((Object)log).extracting(LogResponse::getLogEntries, InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).element(0)).extracting(LogResponse.LogEntry::getOperations, InstanceOfAssertFactories.list(Operation.class))).element(0)).isEqualTo((Object)Operation.Put.of((ContentKey)key, (Content)content));
            head = committed;
            previousContent = content;
        }
    }

    public static final class ContentAndOperationType {
        final Content.Type type;
        final Operation operation;

        public ContentAndOperationType(Content.Type type, Operation operation) {
            this.type = type;
            this.operation = operation;
        }

        public String toString() {
            String s = ContentAndOperationType.opString(this.operation);
            return s + "_" + this.operation.getKey().toPathString();
        }

        private static String opString(Operation operation) {
            if (operation instanceof Operation.Put) {
                return "Put_" + ((Operation.Put)operation).getContent().getClass().getSimpleName();
            }
            return operation.getClass().getSimpleName();
        }
    }
}

