/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestDiff;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestEntries
extends AbstractRestDiff {
    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByType(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterTypes");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tam = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (int)1, (int)1, (String)"select * from table", (String)"Dremio");
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)tam)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Content.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Content.Type.ICEBERG_VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_TABLE'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_VIEW'")).get().getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType in ['ICEBERG_TABLE', 'ICEBERG_VIEW']")).get().getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByName(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByName");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.name.startsWith('first')")).get().getEntries();
        Assertions.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{first});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.name.endsWith('Table')")).get().getEntries();
        Assertions.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{first, second});
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByFullKeyName(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByFullKeyName");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "table"});
        ContentKey second = ContentKey.of((String[])new String[]{"d", "b", "c", "table"});
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.key == 'a.b.c.table'")).get().getEntries();
        Assertions.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{first});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.key.endsWith('.b.c.table')")).get().getEntries();
        Assertions.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{first, second});
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByNamespace(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespace");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "fourthTable"});
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)third, (Content)IcebergTable.of((String)"path3", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 3")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)fourth, (Content)IcebergTable.of((String)"path4", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 4")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a.b"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b.c.firstTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.fourthTable')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByNamespaceAndPrefixDepth(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespaceAndPrefixDepth");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "b", "fourthTable"});
        ContentKey fifth = ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"});
        ContentKey withoutNamespace = ContentKey.of((String[])new String[]{"withoutNamespace"});
        ImmutableList keys = ImmutableList.of((Object)first, (Object)second, (Object)third, (Object)fourth, (Object)fifth, (Object)withoutNamespace);
        for (int i = 0; i < keys.size(); ++i) {
            ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)((ContentKey)keys.get(i)), (Content)IcebergTable.of((String)("path" + i), (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commit();
        }
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        Reference reference = refMode.transform((Reference)branch);
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(0)).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(6);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(0)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(1)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals(Content.Type.NAMESPACE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a"})));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(2)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(2))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "thirdTable"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals(Content.Type.NAMESPACE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals(Content.Type.NAMESPACE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "boo"})));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('a\\\\.b(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals(Content.Type.NAMESPACE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "fourthTable"})));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(4)).filter("entry.namespace.matches('a\\\\.b\\\\.c(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"})));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(5)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(2))).matches(e -> e.getType().equals(Content.Type.NAMESPACE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "c"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(1))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "b", "fourthTable"})));
        ((ObjectAssert)Assertions.assertThat((Object)((EntriesResponse.Entry)entries.get(0))).matches(e -> e.getType().equals(Content.Type.ICEBERG_TABLE))).matches(e -> e.getName().equals(ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"})));
        if (AbstractRest.ReferenceMode.DETACHED != refMode) {
            this.checkNamespaces(reference, Arrays.asList("a", "a.b", "a.boo", "a.b.c"), Arrays.asList(first, second, third, fourth, fifth));
        }
    }

    private void checkNamespaces(Reference reference, List<String> knownNamespaces, List<ContentKey> knownContentKeys) throws NessieReferenceNotFoundException, NessieNamespaceNotFoundException {
        Assertions.assertThat((List)((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().reference(reference)).namespace("a")).get().getNamespaces()).hasSize(4);
        for (String namespace : knownNamespaces) {
            Namespace ns = Namespace.parse((String)namespace);
            Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(reference)).namespace(ns)).get()).isNotNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference(reference)).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespace));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(reference)).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).hasMessage(String.format("Namespace '%s' is not empty", namespace));
        }
        List unknownNamespaces = knownContentKeys.stream().map(ContentKey::toString).collect(Collectors.toList());
        for (String namespace : unknownNamespaces) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(reference)).namespace(Namespace.parse((String)namespace))).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespace));
        }
    }
}

