/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.jaxrs.AbstractRestInvalidWithHttp;
import org.projectnessie.model.BaseMergeTransplant;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestMergeTransplant
extends AbstractRestInvalidWithHttp {
    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void transplant(boolean withDetachedCommit, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        this.mergeTransplant(false, keepIndividualCommits, (target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)committed1.getHash(), (Object)committed2.getHash())).fromRefName(AbstractRestMergeTransplant.maybeAsDetachedName(withDetachedCommit, (Reference)source))).branch(target)).keepIndividualCommits(keepIndividualCommits)).returnConflictAsResult(returnConflictAsResult)).transplant());
    }

    @ParameterizedTest
    @CsvSource(value={"UNCHANGED,true", "UNCHANGED,false", "DETACHED,true", "DETACHED,false"})
    public void merge(AbstractRest.ReferenceMode refMode, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        this.mergeTransplant(!keepIndividualCommits, keepIndividualCommits, (target, source, committed1, committed2, returnConflictAsResult) -> ((MergeReferenceBuilder)((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(target)).fromRef(refMode.transform((Reference)committed2)).keepIndividualCommits(keepIndividualCommits)).returnConflictAsResult(returnConflictAsResult)).merge());
    }

    private void mergeTransplant(boolean verifyAdditionalParents, boolean keepIndividualCommits, MergeTransplantActor actor) throws BaseNessieClientServerException {
        Branch target = this.createBranch("base");
        Branch source = this.createBranch("branch");
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(source.getName())).hash(source.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(source.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        int commitCount = 2;
        LogResponse logBranch = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(source.getName())).untilHash(source.getHash()).maxRecords(commitCount)).get();
        Branch baseHead = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(target.getName())).hash(target.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        MergeResponse response = actor.act(target, source, committed1, committed2, false);
        Reference newHead = this.mergeWentFine(target, source, key1, key2, committed1, committed2, baseHead, response);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actor.act(target, source, committed1, committed2, false)).isInstanceOf(NessieReferenceConflictException.class)).hasMessageContaining("keys have been changed in conflict");
        AbstractRestMergeTransplant.conflictExceptionReturnedAsMergeResult(actor, target, source, key1, key2, committed1, committed2, newHead);
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(target.getName())).untilHash(target.getHash()).get();
        if (keepIndividualCommits) {
            ((ListAssert)Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).hasSize(3)).containsExactly((Object[])new String[]{"test-branch2", "test-branch1", "test-main"});
        } else {
            ((AbstractStringAssert)((AbstractStringAssert)((ListAssert)Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).hasSize(2)).first(InstanceOfAssertFactories.STRING)).contains(new CharSequence[]{"test-branch2"})).contains(new CharSequence[]{"test-branch1"});
        }
        LogResponse logOfMerged = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(target.getName())).maxRecords(commitCount)).get();
        Assertions.assertThat(logOfMerged.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime)).isNotEqualTo(logBranch.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime));
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(target.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"key1", "key2"});
        if (verifyAdditionalParents) {
            ((ObjectAssert)Assertions.assertThat((List)logOfMerged.getLogEntries()).first()).satisfies(new ThrowingConsumer[]{logEntry -> ((ListAssert)Assertions.assertThat((Object)logEntry).extracting(LogResponse.LogEntry::getAdditionalParents).asInstanceOf(InstanceOfAssertFactories.list(String.class))).isEmpty(), logEntry -> ((MapAssert)Assertions.assertThat((Object)logEntry).extracting(LogResponse.LogEntry::getCommitMeta).extracting(CommitMeta::getProperties).asInstanceOf(InstanceOfAssertFactories.map(String.class, String.class))).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"_merge_parent", (Object)committed2.getHash())})});
        }
    }

    private Reference mergeWentFine(Branch target, Branch source, ContentKey key1, ContentKey key2, Branch committed1, Branch committed2, Branch baseHead, MergeResponse response) throws NessieNotFoundException {
        Reference newHead = this.getApi().getReference().refName(target.getName()).get();
        Assertions.assertThat((Object)response).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((Object)r).extracting(new Function[]{MergeResponse::wasApplied, MergeResponse::wasSuccessful, MergeResponse::getExpectedHash, MergeResponse::getTargetBranch, MergeResponse::getEffectiveTargetHash, MergeResponse::getResultantTargetHash}).containsExactly(new Object[]{true, true, source.getHash(), target.getName(), baseHead.getHash(), newHead.getHash()}), r -> Assertions.assertThat((Object)r).extracting(new Function[]{MergeResponse::getCommonAncestor, MergeResponse::getDetails, MergeResponse::getSourceCommits, MergeResponse::getTargetCommits}).satisfiesExactly(new ThrowingConsumer[]{commonAncestor -> Assertions.assertThat((Object)commonAncestor).satisfiesAnyOf(new ThrowingConsumer[]{a -> Assertions.assertThat((Object)a).isNull(), b -> Assertions.assertThat((Object)b).isEqualTo((Object)target.getHash())}), details -> ((ListAssert)Assertions.assertThat((Object)details).asInstanceOf(InstanceOfAssertFactories.list(MergeResponse.ContentKeyDetails.class))).extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType, MergeResponse.ContentKeyDetails::getMergeBehavior}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, MergeResponse.ContentKeyConflict.NONE, BaseMergeTransplant.MergeBehavior.NORMAL}), Assertions.tuple((Object[])new Object[]{key2, MergeResponse.ContentKeyConflict.NONE, BaseMergeTransplant.MergeBehavior.NORMAL})}), sourceCommits -> ((ListAssert)Assertions.assertThat((Object)sourceCommits).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{committed2.getHash(), "test-branch2"}), Assertions.tuple((Object[])new Object[]{committed1.getHash(), "test-branch1"})}), targetCommits -> ((ListAssert)Assertions.assertThat((Object)targetCommits).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{baseHead.getHash(), "test-main"})})})});
        return newHead;
    }

    private static void conflictExceptionReturnedAsMergeResult(MergeTransplantActor actor, Branch target, Branch source, ContentKey key1, ContentKey key2, Branch committed1, Branch committed2, Reference newHead) throws NessieNotFoundException, NessieConflictException {
        MergeResponse conflictResult = actor.act(target, source, committed1, committed2, true);
        Assertions.assertThat((Object)conflictResult).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((Object)r).extracting(new Function[]{MergeResponse::wasApplied, MergeResponse::wasSuccessful, MergeResponse::getExpectedHash, MergeResponse::getTargetBranch, MergeResponse::getEffectiveTargetHash, MergeResponse::getResultantTargetHash}).containsExactly(new Object[]{false, false, source.getHash(), target.getName(), newHead.getHash(), newHead.getHash()}), r -> Assertions.assertThat((Object)r).extracting(new Function[]{MergeResponse::getCommonAncestor, MergeResponse::getDetails, MergeResponse::getSourceCommits, MergeResponse::getTargetCommits}).satisfiesExactly(new ThrowingConsumer[]{commonAncestor -> Assertions.assertThat((Object)commonAncestor).satisfiesAnyOf(new ThrowingConsumer[]{a -> Assertions.assertThat((Object)a).isNull(), b -> Assertions.assertThat((Object)b).isEqualTo((Object)target.getHash())}), details -> ((ListAssert)Assertions.assertThat((Object)details).asInstanceOf(InstanceOfAssertFactories.list(MergeResponse.ContentKeyDetails.class))).extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType, MergeResponse.ContentKeyDetails::getMergeBehavior}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, MergeResponse.ContentKeyConflict.UNRESOLVABLE, BaseMergeTransplant.MergeBehavior.NORMAL}), Assertions.tuple((Object[])new Object[]{key2, MergeResponse.ContentKeyConflict.NONE, BaseMergeTransplant.MergeBehavior.NORMAL})}), sourceCommits -> ((ListAssert)Assertions.assertThat((Object)sourceCommits).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{committed2.getHash(), "test-branch2"}), Assertions.tuple((Object[])new Object[]{committed1.getHash(), "test-branch1"})}), targetCommits -> ((ListAssert)Assertions.assertThat((Object)targetCommits).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(CommitMeta::getMessage).containsAnyOf((Object[])new String[]{"test-branch2", "test-branch1", "test-main"})})});
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class, mode=EnumSource.Mode.EXCLUDE, names={"NAME_ONLY"})
    public void mergeWithNamespaces(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        Branch branch = this.createBranch("merge-branch");
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(branch.getName())).create();
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(base.getName())).create();
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        ContentKey key1 = ContentKey.of((Namespace)ns, (String)"key1");
        ContentKey key2 = ContentKey.of((Namespace)ns, (String)"key2");
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        Assertions.assertThat((String)committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        Assertions.assertThat((String)committed2.getHash()).isNotNull();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef(refMode.transform((Reference)committed2)).keepIndividualCommits(true)).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        Assertions.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-branch2", "test-branch1", "create namespace a.b.c", "test-main", "create namespace a.b.c"});
        Assertions.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, ContentKey.of((List)ns.getElements())});
        Assertions.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @FunctionalInterface
    static interface MergeTransplantActor {
        public MergeResponse act(Branch var1, Branch var2, Branch var3, Branch var4, boolean var5) throws NessieNotFoundException, NessieConflictException;
    }
}

