/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Detached;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRest {
    private NessieApiV1 api;

    protected void initApi(URI nessieApiUri) {
        NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(nessieApiUri).build(NessieApiV1.class);
        this.initApi(api);
    }

    protected void initApi(NessieApiV1 api) {
        this.api = api;
    }

    public NessieApiV1 getApi() {
        return Objects.requireNonNull(this.api, "Tests need to call initApi in @BeforeEach");
    }

    @AfterEach
    public void tearDown() throws Exception {
        Branch defaultBranch = this.api.getDefaultBranch();
        this.api.getAllReferences().stream().forEach(ref -> {
            try {
                if (ref instanceof Branch && !ref.getName().equals(defaultBranch.getName())) {
                    ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)ref)).delete();
                } else if (ref instanceof Tag) {
                    ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)ref)).delete();
                }
            }
            catch (NessieConflictException | NessieNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        this.api.close();
    }

    protected String createCommits(Reference branch, int numAuthors, int commitsPerAuthor, String currentHash) throws BaseNessieClientServerException {
        for (int j = 0; j < numAuthors; ++j) {
            String author = "author-" + j;
            for (int i = 0; i < commitsPerAuthor; ++i) {
                IcebergTable meta = IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42);
                String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("committed-by-" + author).properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"table" + i}), (Content)meta)).commit().getHash();
                Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
                currentHash = nextHash;
            }
        }
        return currentHash;
    }

    protected Branch createBranch(String name, Branch from) throws BaseNessieClientServerException {
        String srcBranchName;
        Branch expectedBranch;
        if (from == null) {
            Branch main = this.getApi().getDefaultBranch();
            expectedBranch = Branch.of((String)name, (String)main.getHash());
            srcBranchName = "main";
        } else {
            expectedBranch = Branch.of((String)name, (String)from.getHash());
            srcBranchName = from.getName();
        }
        Reference created = this.getApi().createReference().sourceRefName(srcBranchName).reference((Reference)Branch.of((String)name, (String)expectedBranch.getHash())).create();
        Assertions.assertThat((Object)created).isEqualTo((Object)expectedBranch);
        return expectedBranch;
    }

    protected Branch createBranch(String name) throws BaseNessieClientServerException {
        return this.createBranch(name, null);
    }

    protected static void getOrCreateEmptyBranch(NessieApiV1 api, String gcBranchName) {
        try {
            api.getReference().refName(gcBranchName).get();
        }
        catch (NessieNotFoundException e) {
            try {
                api.createReference().reference((Reference)Branch.of((String)gcBranchName, null)).create();
            }
            catch (NessieConflictException | NessieNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void deleteBranch(String name, String hash) throws BaseNessieClientServerException {
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(name)).hash(hash)).delete();
    }

    protected static String maybeAsDetachedName(boolean withDetachedCommit, Reference ref) {
        return withDetachedCommit ? "DETACHED" : ref.getName();
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }

    static enum ReferenceMode {
        NAME_ONLY{

            @Override
            Reference transform(Reference ref) {
                switch (ref.getType()) {
                    case TAG: {
                        return Tag.of((String)ref.getName(), null);
                    }
                    case BRANCH: {
                        return Branch.of((String)ref.getName(), null);
                    }
                }
                throw new IllegalArgumentException(ref.toString());
            }
        }
        ,
        UNCHANGED{

            @Override
            Reference transform(Reference ref) {
                return ref;
            }
        }
        ,
        DETACHED{

            @Override
            Reference transform(Reference ref) {
                return Detached.of((String)ref.getHash());
            }
        };


        abstract Reference transform(Reference var1);
    }
}

