/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.tests.AbstractRest;
import org.projectnessie.jaxrs.tests.AbstractRestCommitLog;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestContents
extends AbstractRestCommitLog {
    public static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view"}), (Content)IcebergView.of((String)"/iceberg/view", (int)1, (int)1, (String)"dial", (String)"SELECT foo FROM table"))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"c", "delta"}), (Content)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_delete"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_delete"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_unchanged"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "iceberg_unchanged"}), (Content)IcebergTable.of((String)"/iceberg/table", (long)42L, (int)42, (int)42, (int)42))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_delete"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_delete"}), (Content)IcebergView.of((String)"/iceberg/view", (int)42, (int)42, (String)"dial", (String)"sql"))), new ContentAndOperationType(Content.Type.ICEBERG_VIEW, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_unchanged"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "view_unchanged"}), (Content)IcebergView.of((String)"/iceberg/view", (int)42, (int)42, (String)"dial", (String)"sql"))), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_delete"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_delete"}), (Content)ImmutableDeltaLakeTable.builder().addMetadataLocationHistory("/delta/table").addCheckpointLocationHistory("/delta/history").lastCheckpoint("/delta/check").build())), new ContentAndOperationType(Content.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_unchanged"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "delta_unchanged"}), (Content)ImmutableDeltaLakeTable.builder().addMetadataLocationHistory("/delta/table").addCheckpointLocationHistory("/delta/history").lastCheckpoint("/delta/check").build())));
    }

    @Test
    public void verifyAllContentAndOperationTypes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperationAll");
        List<ContentAndOperationType> contentAndOps = AbstractRestContents.contentAndOperationTypes().collect(Collectors.toList());
        CommitMultipleOperationsBuilder prepare = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes prepare"));
        contentAndOps.stream().filter(co -> co.prepare != null).map(co -> co.prepare).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)prepare).operation(arg_0));
        branch = prepare.commit();
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        contentAndOps.forEach(contentAndOp -> commit.operation(contentAndOp.operation));
        Branch committed = commit.commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
        List expect = contentAndOps.stream().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.entry((ContentKey)c.operation.getKey(), (Content.Type)c.type)).collect(Collectors.toList());
        List notExpect = contentAndOps.stream().filter(c -> c.operation instanceof Operation.Delete).map(c -> EntriesResponse.Entry.entry((ContentKey)c.operation.getKey(), (Content.Type)c.type)).collect(Collectors.toList());
        ((ListAssert)this.soft.assertThat(entries).containsAll(expect)).doesNotContainAnyElementsOf(notExpect);
        ((ListAssert)((ListAssert)this.soft.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).filteredOn(e -> e.getFrom() != null)).extracting(AbstractRest::diffEntryWithoutContentId).containsExactlyInAnyOrderElementsOf((Iterable)contentAndOps.stream().map(c -> c.operation).filter(op -> op instanceof Operation.Put).map(Operation.Put.class::cast).map(put -> DiffResponse.DiffEntry.diffEntry((ContentKey)put.getKey(), (Content)put.getContent())).collect(Collectors.toList()));
        List allKeys = contentAndOps.stream().map(contentAndOperationType -> contentAndOperationType.operation.getKey()).collect(Collectors.toList());
        Map<ContentKey, Content> expected = contentAndOps.stream().map(c -> {
            if (c.operation instanceof Operation.Put) {
                return Maps.immutableEntry((Object)c.operation.getKey(), (Object)((Operation.Put)c.operation).getContent());
            }
            if (c.operation instanceof Operation.Unchanged) {
                return Maps.immutableEntry((Object)c.operation.getKey(), (Object)c.prepare.getContent());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ((MapAssert)this.soft.assertThat(((GetContentBuilder)this.getApi().getContent().reference((Reference)committed)).keys(allKeys).get()).containsOnlyKeys(expected.keySet())).allSatisfy((key, content) -> Assertions.assertThat((Object)this.clearIdOnContent((Content)content)).isEqualTo(expected.get(key)));
        ((ListAssert)((ObjectAssert)this.soft.assertThat(((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream()).element(0)).extracting(LogResponse.LogEntry::getOperations).extracting(this::clearIdOnOperations, InstanceOfAssertFactories.list(Operation.class))).containsExactlyInAnyOrderElementsOf((Iterable)contentAndOps.stream().map(c -> c.operation).filter(op -> !(op instanceof Operation.Unchanged)).collect(Collectors.toList()));
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    public void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("contentAndOperation_" + contentAndOperationType);
        if (contentAndOperationType.prepare != null) {
            branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes prepare")).operation((Operation)contentAndOperationType.prepare).commit();
        }
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).operation(contentAndOperationType.operation);
        Branch committed = commit.commit();
        ContentKey fixedContentKey = ContentKey.of((List)contentAndOperationType.operation.getKey().getElements());
        if (contentAndOperationType.operation instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)contentAndOperationType.operation;
            List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
            this.soft.assertThat(entries).containsExactly((Object[])new EntriesResponse.Entry[]{EntriesResponse.Entry.entry((ContentKey)fixedContentKey, (Content.Type)contentAndOperationType.type)});
            ((ListAssert)this.soft.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).extracting(new Function[]{DiffResponse.DiffEntry::getKey, e -> this.clearIdOnContent(e.getFrom()), DiffResponse.DiffEntry::getTo}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{fixedContentKey, put.getContent(), null})});
            Map content = ((GetContentBuilder)this.getApi().getContent().key(fixedContentKey).reference((Reference)committed)).get();
            this.soft.assertThat(content).extractingByKey((Object)fixedContentKey).extracting(this::clearIdOnContent).isEqualTo((Object)put.getContent());
            List log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream().collect(Collectors.toList());
            ((ObjectAssert)((ListAssert)((ObjectAssert)this.soft.assertThat(log).element(0)).extracting(LogResponse.LogEntry::getOperations, InstanceOfAssertFactories.list(Operation.class))).element(0)).extracting(this::clearIdOnOperation).isEqualTo((Object)put);
        } else if (contentAndOperationType.operation instanceof Operation.Delete) {
            List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
            this.soft.assertThat(entries).isEmpty();
            ((ListAssert)((ListAssert)this.soft.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).filteredOn(e -> e.getFrom() != null)).isEmpty();
            Map content = ((GetContentBuilder)this.getApi().getContent().key(fixedContentKey).reference((Reference)committed)).get();
            this.soft.assertThat(content).isEmpty();
            List log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream().collect(Collectors.toList());
            ((ListAssert)((ObjectAssert)this.soft.assertThat(log).element(0)).extracting(LogResponse.LogEntry::getOperations, InstanceOfAssertFactories.list(Operation.class))).containsExactly((Object[])new Operation[]{contentAndOperationType.operation});
        } else if (contentAndOperationType.operation instanceof Operation.Unchanged) {
            List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(branch.getName())).stream().collect(Collectors.toList());
            this.soft.assertThat(entries).containsExactly((Object[])new EntriesResponse.Entry[]{EntriesResponse.Entry.entry((ContentKey)fixedContentKey, (Content.Type)contentAndOperationType.type)});
            ((ListAssert)((ListAssert)this.soft.assertThat((Object)this.getApi().getDiff().fromRef((Reference)committed).toRef((Reference)branch).get()).extracting(DiffResponse::getDiffs, InstanceOfAssertFactories.list(DiffResponse.DiffEntry.class))).filteredOn(e -> e.getFrom() != null)).isEmpty();
            Map content = ((GetContentBuilder)this.getApi().getContent().key(fixedContentKey).reference((Reference)committed)).get();
            this.soft.assertThat(content).extractingByKey((Object)fixedContentKey).extracting(this::clearIdOnContent).isEqualTo((Object)contentAndOperationType.prepare.getContent());
            List log = ((GetCommitLogBuilder)this.getApi().getCommitLog().reference((Reference)committed)).fetch(FetchOption.ALL).stream().collect(Collectors.toList());
            ((ObjectAssert)this.soft.assertThat(log).element(0)).extracting(LogResponse.LogEntry::getOperations).isNull();
        }
    }

    private List<Operation> clearIdOnOperations(List<Operation> o) {
        return o.stream().map(this::clearIdOnOperation).collect(Collectors.toList());
    }

    private Operation clearIdOnOperation(Operation o) {
        try {
            if (!(o instanceof Operation.Put)) {
                return o;
            }
            Operation.Put put = (Operation.Put)o;
            Content contentWithoutId = this.clearIdOnContent(put.getContent());
            return ImmutablePut.builder().from(put).content(contentWithoutId).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Content clearIdOnContent(Content content) {
        return this.setIdOnContent(content, null);
    }

    private Content setIdOnContent(Content content, String contentId) {
        try {
            return (Content)content.getClass().getDeclaredMethod("withId", String.class).invoke((Object)content, contentId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void multiget() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("foo");
        ContentKey keyA = ContentKey.of((String[])new String[]{"a"});
        ContentKey keyB = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tableA = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable tableB = IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42);
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)keyA, (Content)tableA)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)keyB, (Content)tableB)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        Map response = ((GetContentBuilder)this.getApi().getContent().key(keyA).key(keyB).key(ContentKey.of((String[])new String[]{"noexist"})).refName("foo")).get();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)response).containsKeys((Object[])new ContentKey[]{keyA, keyB})).hasEntrySatisfying((Object)keyA, content -> Assertions.assertThat((Object)content).isEqualTo((Object)IcebergTable.builder().from(tableA).id(content.getId()).build()))).hasEntrySatisfying((Object)keyB, content -> Assertions.assertThat((Object)content).isEqualTo((Object)IcebergTable.builder().from(tableB).id(content.getId()).build()))).doesNotContainKey((Object)ContentKey.of((String[])new String[]{"noexist"}));
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void fetchContentByNamelessReference() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("fetchContentByNamelessReference");
        IcebergTable t = IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4);
        ContentKey key = ContentKey.of((String[])new String[]{"key1"});
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"test commit")).operation((Operation)Operation.Put.of((ContentKey)key, (Content)t));
        Branch committed = commit.commit();
        Assertions.assertThat((Object)((Content)((GetContentBuilder)this.getApi().getContent().hashOnRef(committed.getHash())).key(key).get().get(key))).isInstanceOf(IcebergTable.class);
    }

    public static final class ContentAndOperationType {
        final Content.Type type;
        final Operation operation;
        final Operation.Put prepare;

        public ContentAndOperationType(Content.Type type, Operation operation) {
            this(type, operation, null);
        }

        public ContentAndOperationType(Content.Type type, Operation operation, Operation.Put prepare) {
            this.type = type;
            this.operation = operation;
            this.prepare = prepare;
        }

        public String toString() {
            String s = ContentAndOperationType.opString(this.operation);
            return s + "_" + this.operation.getKey().toPathString();
        }

        private static String opString(Operation operation) {
            if (operation instanceof Operation.Put) {
                return "Put_" + ((Operation.Put)operation).getContent().getClass().getSimpleName();
            }
            return operation.getClass().getSimpleName();
        }
    }
}

