/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.MergeTransplantBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.jaxrs.tests.AbstractRest;
import org.projectnessie.jaxrs.tests.AbstractRestInvalid;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestMergeTransplant
extends AbstractRestInvalid {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void transplantKeepCommits(boolean withDetachedCommit) throws BaseNessieClientServerException {
        this.testTransplant(withDetachedCommit, true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void transplantSquashed(boolean withDetachedCommit) throws BaseNessieClientServerException {
        this.testTransplant(withDetachedCommit, false);
    }

    private void testTransplant(boolean withDetachedCommit, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        this.mergeTransplant(false, keepIndividualCommits, (target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().hashesToTransplant((List)ImmutableList.of((Object)committed1.getHash(), (Object)committed2.getHash())).fromRefName(AbstractRestMergeTransplant.maybeAsDetachedName(withDetachedCommit, (Reference)source))).branch(target)).keepIndividualCommits(keepIndividualCommits)).returnConflictAsResult(returnConflictAsResult)).transplant());
    }

    @ParameterizedTest
    @EnumSource(names={"UNCHANGED", "DETACHED"})
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void mergeKeepCommits(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        this.testMerge(refMode, true);
    }

    @ParameterizedTest
    @EnumSource(names={"UNCHANGED", "DETACHED"})
    public void mergeSquashed(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        this.testMerge(refMode, false);
    }

    private void testMerge(AbstractRest.ReferenceMode refMode, boolean keepIndividualCommits) throws BaseNessieClientServerException {
        if (this.getApi() instanceof NessieApiV2) {
            Assumptions.assumeFalse((boolean)keepIndividualCommits);
        }
        this.mergeTransplant(!keepIndividualCommits, keepIndividualCommits, (target, source, committed1, committed2, returnConflictAsResult) -> ((MergeReferenceBuilder)((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(target)).fromRef(refMode.transform((Reference)committed2)).keepIndividualCommits(keepIndividualCommits)).returnConflictAsResult(returnConflictAsResult)).merge());
    }

    private void mergeTransplant(boolean verifyAdditionalParents, boolean keepIndividualCommits, MergeTransplantActor actor) throws BaseNessieClientServerException {
        Branch root = this.createBranch("root");
        root = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(root)).commitMeta(CommitMeta.fromMessage((String)"root")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"other"}), (Content)IcebergTable.of((String)"/dev/null", (long)42L, (int)42, (int)42, (int)42))).commit();
        Branch target = this.createBranch("base", root);
        Branch source = this.createBranch("branch", root);
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(source.getName())).hash(source.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        this.soft.assertThat(committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(source.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        this.soft.assertThat(committed2.getHash()).isNotNull();
        int commitCount = 2;
        LogResponse logBranch = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(source.getName())).untilHash(source.getHash()).maxRecords(commitCount)).get();
        Branch baseHead = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(target.getName())).hash(target.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        MergeResponse response = actor.act(target, source, committed1, committed2, false);
        Reference newHead = this.mergeWentFine(target, source, key1, committed1, committed2, baseHead, response);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> actor.act(target, source, committed1, committed2, false)).isInstanceOf(NessieReferenceConflictException.class)).hasMessageContaining("keys have been changed in conflict");
        this.conflictExceptionReturnedAsMergeResult(actor, target, source, key1, committed1, committed2, newHead);
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(target.getName())).untilHash(target.getHash()).get();
        if (keepIndividualCommits) {
            this.soft.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"test-branch2", "test-branch1", "test-main", "root"});
        } else {
            ((AbstractStringAssert)((AbstractStringAssert)((AbstractListAssert)this.soft.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).hasSize(3)).first(InstanceOfAssertFactories.STRING)).contains(new CharSequence[]{"test-branch2"})).contains(new CharSequence[]{"test-branch1"});
        }
        LogResponse logOfMerged = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(target.getName())).maxRecords(commitCount)).get();
        this.soft.assertThat(logOfMerged.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime)).isNotEqualTo(logBranch.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getCommitTime));
        this.soft.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(target.getName())).get().getEntries().stream().map(e -> e.getName().getName())).containsExactlyInAnyOrder((Object[])new String[]{"other", "key1", "key2"});
        if (verifyAdditionalParents) {
            ((ListAssert)((ObjectAssert)this.soft.assertThat(logOfMerged.getLogEntries()).first()).extracting(LogResponse.LogEntry::getAdditionalParents).asInstanceOf(InstanceOfAssertFactories.list(String.class))).isEmpty();
            ((MapAssert)((ObjectAssert)this.soft.assertThat(logOfMerged.getLogEntries()).first()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(CommitMeta::getProperties).asInstanceOf(InstanceOfAssertFactories.map(String.class, String.class))).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"_merge_parent", (Object)committed2.getHash())});
        }
    }

    private Reference mergeWentFine(Branch target, Branch source, ContentKey key1, Branch committed1, Branch committed2, Branch baseHead, MergeResponse response) throws NessieNotFoundException {
        Reference newHead = this.getApi().getReference().refName(target.getName()).get();
        this.soft.assertThat((Object)response).extracting(new Function[]{MergeResponse::wasApplied, MergeResponse::wasSuccessful, MergeResponse::getExpectedHash, MergeResponse::getTargetBranch, MergeResponse::getEffectiveTargetHash, MergeResponse::getResultantTargetHash}).containsExactly(new Object[]{true, true, source.getHash(), target.getName(), baseHead.getHash(), newHead.getHash()});
        this.soft.assertThat(response.getCommonAncestor()).satisfiesAnyOf(new ThrowingConsumer[]{a -> Assertions.assertThat((String)a).isNull(), b -> Assertions.assertThat((String)b).isEqualTo(target.getHash())});
        ((ListAssert)this.soft.assertThat(response.getDetails()).asInstanceOf(InstanceOfAssertFactories.list(MergeResponse.ContentKeyDetails.class))).extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType, MergeResponse.ContentKeyDetails::getMergeBehavior}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, MergeResponse.ContentKeyConflict.NONE, MergeBehavior.NORMAL})});
        ((ListAssert)this.soft.assertThat(response.getSourceCommits()).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{committed2.getHash(), "test-branch2"}), Assertions.tuple((Object[])new Object[]{committed1.getHash(), "test-branch1"})});
        ((ListAssert)this.soft.assertThat(response.getTargetCommits()).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{baseHead.getHash(), "test-main"})});
        return newHead;
    }

    private void conflictExceptionReturnedAsMergeResult(MergeTransplantActor actor, Branch target, Branch source, ContentKey key1, Branch committed1, Branch committed2, Reference newHead) throws NessieNotFoundException, NessieConflictException {
        MergeResponse conflictResult = actor.act(target, source, committed1, committed2, true);
        this.soft.assertThat((Object)conflictResult).extracting(new Function[]{MergeResponse::wasApplied, MergeResponse::wasSuccessful, MergeResponse::getExpectedHash, MergeResponse::getTargetBranch, MergeResponse::getEffectiveTargetHash}).containsExactly(new Object[]{false, false, source.getHash(), target.getName(), newHead.getHash()});
        this.soft.assertThat(conflictResult.getCommonAncestor()).satisfiesAnyOf(new ThrowingConsumer[]{a -> Assertions.assertThat((String)a).isNull(), b -> Assertions.assertThat((String)b).isEqualTo(target.getHash())});
        ((ListAssert)this.soft.assertThat(conflictResult.getDetails()).asInstanceOf(InstanceOfAssertFactories.list(MergeResponse.ContentKeyDetails.class))).extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType, MergeResponse.ContentKeyDetails::getMergeBehavior}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, MergeResponse.ContentKeyConflict.UNRESOLVABLE, MergeBehavior.NORMAL})});
        ((ListAssert)this.soft.assertThat(conflictResult.getSourceCommits()).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getHash, CommitMeta::getMessage}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{committed2.getHash(), "test-branch2"}), Assertions.tuple((Object[])new Object[]{committed1.getHash(), "test-branch1"})});
        ((ListAssert)this.soft.assertThat(conflictResult.getTargetCommits()).asInstanceOf(InstanceOfAssertFactories.list(LogResponse.LogEntry.class))).extracting(LogResponse.LogEntry::getCommitMeta).extracting(CommitMeta::getMessage).containsAnyOf((Object[])new String[]{"test-branch2", "test-branch1", "test-main"});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeMessage() throws BaseNessieClientServerException {
        this.testMergeTransplantMessage((target, source, committed1, committed2, returnConflictAsResult) -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().message("test-message-override-123").branch(target)).fromRef((Reference)source).returnConflictAsResult(returnConflictAsResult)).merge(), (Collection<String>)ImmutableList.of((Object)"test-message-override-123"));
    }

    @Test
    public void mergeMessageDefault() throws BaseNessieClientServerException {
        this.testMergeTransplantMessage((target, source, committed1, committed2, returnConflictAsResult) -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(target)).fromRef((Reference)source).returnConflictAsResult(returnConflictAsResult)).merge(), (Collection<String>)ImmutableList.of((Object)"test-commit-1\n---------------------------------------------\ntest-commit-2"));
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void transplantMessageSquashed() throws BaseNessieClientServerException {
        this.testMergeTransplantMessage((target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().message("test-message-override-123").branch(target)).fromRefName(source.getName())).keepIndividualCommits(false)).hashesToTransplant((List)ImmutableList.of((Object)Objects.requireNonNull(committed1.getHash()), (Object)Objects.requireNonNull(committed2.getHash()))).returnConflictAsResult(returnConflictAsResult)).transplant(), (Collection<String>)ImmutableList.of((Object)"test-message-override-123"));
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void transplantMessageSingle() throws BaseNessieClientServerException {
        this.testMergeTransplantMessage((target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().message("test-message-override-123").branch(target)).fromRefName(source.getName())).hashesToTransplant((List)ImmutableList.of((Object)Objects.requireNonNull(committed1.getHash()))).returnConflictAsResult(returnConflictAsResult)).transplant(), (Collection<String>)ImmutableList.of((Object)"test-message-override-123"));
    }

    @Test
    public void transplantMessageOverrideMultiple() throws BaseNessieClientServerException {
        this.testMergeTransplantMessage((target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().message("ignored-message-override").keepIndividualCommits(true)).branch(target)).fromRefName(source.getName())).hashesToTransplant((List)ImmutableList.of((Object)Objects.requireNonNull(committed1.getHash()), (Object)Objects.requireNonNull(committed2.getHash()))).returnConflictAsResult(returnConflictAsResult)).transplant(), (Collection<String>)ImmutableList.of((Object)"test-commit-2", (Object)"test-commit-1"));
    }

    private void testMergeTransplantMessage(MergeTransplantActor actor, Collection<String> expectedMessages) throws BaseNessieClientServerException {
        Branch target = this.createBranch("merge-transplant-msg-target");
        target = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(target)).commitMeta(CommitMeta.fromMessage((String)"test-root")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"irrelevant-to-this-test"}), (Content)IcebergTable.of((String)"something", (long)42L, (int)43, (int)44, (int)45))).commit();
        Branch source = this.createBranch("merge-transplant-msg-source");
        ContentKey key1 = ContentKey.of((String[])new String[]{"test-key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"test-key2"});
        Branch firstCommitOnSource = source = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(source)).commitMeta(CommitMeta.fromMessage((String)"test-commit-1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)IcebergTable.of((String)"table1", (long)42L, (int)43, (int)44, (int)45))).commit();
        source = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(source)).commitMeta(CommitMeta.fromMessage((String)"test-commit-2")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)IcebergTable.of((String)"table2", (long)42L, (int)43, (int)44, (int)45))).commit();
        actor.act(target, source, firstCommitOnSource, source, false);
        Stream logStream = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(target.getName())).stream();
        ((AbstractListAssert)this.soft.assertThat(logStream.limit(expectedMessages.size())).isNotEmpty()).extracting(e -> e.getCommitMeta().getMessage()).containsExactlyElementsOf(expectedMessages);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class, mode=EnumSource.Mode.EXCLUDE, names={"NAME_ONLY"})
    public void mergeWithNamespaces(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch root = this.createBranch("root");
        ContentKey something = ContentKey.of((String[])new String[]{"something"});
        root = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(root.getName())).hash(root.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)something, (Content)IcebergTable.of((String)"something", (long)42L, (int)43, (int)44, (int)45))).commit();
        Branch base = this.createBranch("merge-base", root);
        Branch branch = this.createBranch("merge-branch", root);
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(base.getName())).create();
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).refName(branch.getName())).create();
        base = (Branch)this.getApi().getReference().refName(base.getName()).get();
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        IcebergTable table1 = IcebergTable.of((String)"table1", (long)42L, (int)42, (int)42, (int)42);
        IcebergTable table2 = IcebergTable.of((String)"table2", (long)43L, (int)43, (int)43, (int)43);
        ContentKey key1 = ContentKey.of((Namespace)ns, (String)"key1");
        ContentKey key2 = ContentKey.of((Namespace)ns, (String)"key2");
        Branch committed1 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch1")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1)).commit();
        this.soft.assertThat(committed1.getHash()).isNotNull();
        table1 = (IcebergTable)((Content)((GetContentBuilder)this.getApi().getContent().reference((Reference)committed1)).key(key1).get().get(key1)).unwrap(IcebergTable.class).get();
        Branch committed2 = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(committed1.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-branch2")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)table1, (Content)table1)).commit();
        this.soft.assertThat(committed2.getHash()).isNotNull();
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(base.getName())).hash(base.getHash())).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)table2)).commit();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef(refMode.transform((Reference)committed2)).keepIndividualCommits(false)).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        ((OptionalAssert)((OptionalAssert)this.soft.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage).findFirst()).isPresent()).hasValueSatisfying(v -> Assertions.assertThat((String)v).contains(new CharSequence[]{"test-branch1"}))).hasValueSatisfying(v -> Assertions.assertThat((String)v).contains(new CharSequence[]{"test-branch2"}));
        this.soft.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{something, key1, key2, ContentKey.of((List)ns.getElements())});
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @Test
    public void mergeWithCustomModes() throws BaseNessieClientServerException {
        MergeReferenceBuilder merge = this.getApi().mergeRefIntoBranch();
        this.testMergeTransplantWithCustomModes(merge, (target, source, committed1, committed2, returnConflictAsResult) -> ((MergeReferenceBuilder)((MergeReferenceBuilder)merge.branch(target)).fromRef((Reference)source).returnConflictAsResult(returnConflictAsResult)).merge());
    }

    @Test
    public void transplantWithCustomModes() throws BaseNessieClientServerException {
        TransplantCommitsBuilder transplant = this.getApi().transplantCommitsIntoBranch();
        this.testMergeTransplantWithCustomModes(transplant, (target, source, committed1, committed2, returnConflictAsResult) -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)transplant.branch(target)).fromRefName(source.getName())).hashesToTransplant((List)ImmutableList.of((Object)Objects.requireNonNull(committed1.getHash()), (Object)Objects.requireNonNull(committed2.getHash()))).returnConflictAsResult(returnConflictAsResult)).transplant());
    }

    private <B extends MergeTransplantBuilder<B>> void testMergeTransplantWithCustomModes(B opBuilder, MergeTransplantActor actor) throws BaseNessieClientServerException {
        Branch target = this.createBranch("target");
        target = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(target)).commitMeta(CommitMeta.fromMessage((String)"test-root")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"irrelevant-to-this-test"}), (Content)IcebergTable.of((String)"something", (long)42L, (int)43, (int)44, (int)45))).commit();
        Branch branch = this.createBranch("test-branch", target);
        ContentKey key1 = ContentKey.of((String[])new String[]{"both-added1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"both-added2"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"branch-added"});
        target = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(target)).commitMeta(CommitMeta.fromMessage((String)"test-main")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)IcebergTable.of((String)"main-table1", (long)42L, (int)43, (int)44, (int)45))).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)IcebergTable.of((String)"main-table1", (long)42L, (int)43, (int)44, (int)45))).commit();
        Branch firstCommitOnBranch = branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"test-fork")).operation((Operation)Operation.Put.of((ContentKey)key1, (Content)IcebergTable.of((String)"branch-table1", (long)42L, (int)43, (int)44, (int)45))).operation((Operation)Operation.Put.of((ContentKey)key2, (Content)IcebergTable.of((String)"branch-table2", (long)42L, (int)43, (int)44, (int)45))).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"test-fork")).operation((Operation)Operation.Put.of((ContentKey)key3, (Content)IcebergTable.of((String)"branch-no-conflict", (long)42L, (int)43, (int)44, (int)45))).commit();
        opBuilder.defaultMergeMode(MergeBehavior.FORCE).mergeMode(key1, MergeBehavior.DROP).mergeMode(key3, MergeBehavior.NORMAL);
        MergeResponse response = actor.act(target, branch, firstCommitOnBranch, branch, false);
        ((ListAssert)this.soft.assertThat(response.getDetails()).asInstanceOf(InstanceOfAssertFactories.list(MergeResponse.ContentKeyDetails.class))).extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType, MergeResponse.ContentKeyDetails::getMergeBehavior}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, MergeResponse.ContentKeyConflict.NONE, MergeBehavior.DROP}), Assertions.tuple((Object[])new Object[]{key2, MergeResponse.ContentKeyConflict.NONE, MergeBehavior.FORCE}), Assertions.tuple((Object[])new Object[]{key3, MergeResponse.ContentKeyConflict.NONE, MergeBehavior.NORMAL})});
        this.soft.assertThat(((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().refName(target.getName())).hashOnRef(response.getResultantTargetHash())).key(key1).key(key2).key(key3).get().entrySet()).extracting(new Function[]{Map.Entry::getKey, e -> ((IcebergTable)e.getValue()).getMetadataLocation()}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{key1, "main-table1"}), Assertions.tuple((Object[])new Object[]{key2, "branch-table2"}), Assertions.tuple((Object[])new Object[]{key3, "branch-no-conflict"})});
    }

    @FunctionalInterface
    static interface MergeTransplantActor {
        public MergeResponse act(Branch var1, Branch var2, Branch var3, Branch var4, boolean var5) throws NessieNotFoundException, NessieConflictException;
    }
}

