/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.Detached;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRest {
    private NessieApiV1 api;
    protected final SoftAssertions soft = new SoftAssertions();

    @BeforeEach
    void initApi(NessieClientFactory clientFactory) {
        this.api = clientFactory.make();
    }

    public NessieApiV1 getApi() {
        return this.api;
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.soft.assertAll();
        }
        finally {
            Branch defaultBranch = this.api.getDefaultBranch();
            this.api.getAllReferences().stream().forEach(ref -> {
                try {
                    if (ref instanceof Branch && !ref.getName().equals(defaultBranch.getName())) {
                        ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)ref)).delete();
                    } else if (ref instanceof Tag) {
                        ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)ref)).delete();
                    }
                }
                catch (NessieConflictException | NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            this.api.close();
        }
    }

    protected String createCommits(Reference branch, int numAuthors, int commitsPerAuthor, String currentHash) throws BaseNessieClientServerException {
        for (int j = 0; j < numAuthors; ++j) {
            String author = "author-" + j;
            for (int i = 0; i < commitsPerAuthor; ++i) {
                ContentKey key = ContentKey.of((String[])new String[]{"table" + i});
                Content existing = (Content)((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().refName(branch.getName())).hashOnRef(currentHash)).key(key).get().get(key);
                Operation.Put op = existing != null ? Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42, (String)existing.getId()), (Content)existing) : Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)("some-file-" + i), (long)42L, (int)42, (int)42, (int)42));
                String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author(author).message("committed-by-" + author).properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)op).commit().getHash();
                Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
                currentHash = nextHash;
            }
        }
        return currentHash;
    }

    protected Branch createBranch(String name, Branch from) throws BaseNessieClientServerException {
        String srcBranchName;
        Branch expectedBranch;
        if (from == null) {
            Branch main = this.getApi().getDefaultBranch();
            expectedBranch = Branch.of((String)name, (String)main.getHash());
            srcBranchName = "main";
        } else {
            expectedBranch = Branch.of((String)name, (String)from.getHash());
            srcBranchName = from.getName();
        }
        Reference created = this.getApi().createReference().sourceRefName(srcBranchName).reference((Reference)Branch.of((String)name, (String)expectedBranch.getHash())).create();
        Assertions.assertThat((Object)created).isEqualTo((Object)expectedBranch);
        return expectedBranch;
    }

    protected Tag createTag(String name, Reference from) throws BaseNessieClientServerException {
        Reference created = this.getApi().createReference().sourceRefName(from.getName()).reference((Reference)Tag.of((String)name, (String)from.getHash())).create();
        Assertions.assertThat((Object)created).isInstanceOf(Tag.class);
        return (Tag)created;
    }

    protected Branch createBranch(String name) throws BaseNessieClientServerException {
        return this.createBranch(name, null);
    }

    protected static String maybeAsDetachedName(boolean withDetachedCommit, Reference ref) {
        return withDetachedCommit ? "DETACHED" : ref.getName();
    }

    protected static Content contentWithoutId(Content content) {
        if (content == null) {
            return null;
        }
        if (content instanceof IcebergTable) {
            IcebergTable t = (IcebergTable)content;
            return IcebergTable.of((String)t.getMetadataLocation(), (long)t.getSnapshotId(), (int)t.getSchemaId(), (int)t.getSpecId(), (int)t.getSortOrderId());
        }
        if (content instanceof IcebergView) {
            IcebergView t = (IcebergView)content;
            return IcebergView.of((String)t.getMetadataLocation(), (int)t.getVersionId(), (int)t.getSchemaId(), (String)t.getDialect(), (String)t.getSqlText());
        }
        if (content instanceof DeltaLakeTable) {
            DeltaLakeTable t = (DeltaLakeTable)content;
            return ImmutableDeltaLakeTable.builder().from(t).id(null).build();
        }
        if (content instanceof Namespace) {
            Namespace t = (Namespace)content;
            return Namespace.of((List)t.getElements());
        }
        throw new IllegalArgumentException(content.toString());
    }

    protected static Operation operationWithoutContentId(Operation op) {
        if (op instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)op;
            return put.getExpectedContent() != null ? Operation.Put.of((ContentKey)put.getKey(), (Content)AbstractRest.contentWithoutId(put.getContent()), (Content)AbstractRest.contentWithoutId(put.getExpectedContent())) : Operation.Put.of((ContentKey)put.getKey(), (Content)AbstractRest.contentWithoutId(put.getContent()));
        }
        return op;
    }

    protected static DiffResponse.DiffEntry diffEntryWithoutContentId(DiffResponse.DiffEntry diff) {
        if (diff == null) {
            return null;
        }
        return DiffResponse.DiffEntry.diffEntry((ContentKey)diff.getKey(), (Content)AbstractRest.contentWithoutId(diff.getFrom()), (Content)AbstractRest.contentWithoutId(diff.getTo()));
    }

    protected static List<DiffResponse.DiffEntry> diffEntriesWithoutContentId(List<DiffResponse.DiffEntry> diff) {
        if (diff == null) {
            return null;
        }
        return diff.stream().map(AbstractRest::diffEntryWithoutContentId).collect(Collectors.toList());
    }

    protected static List<Operation> operationsWithoutContentId(List<Operation> operations) {
        if (operations == null) {
            return null;
        }
        return operations.stream().map(AbstractRest::operationWithoutContentId).collect(Collectors.toList());
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }

    static enum ReferenceMode {
        NAME_ONLY{

            @Override
            Reference transform(Reference ref) {
                switch (ref.getType()) {
                    case TAG: {
                        return Tag.of((String)ref.getName(), null);
                    }
                    case BRANCH: {
                        return Branch.of((String)ref.getName(), null);
                    }
                }
                throw new IllegalArgumentException(ref.toString());
            }
        }
        ,
        UNCHANGED{

            @Override
            Reference transform(Reference ref) {
                return ref;
            }
        }
        ,
        DETACHED{

            @Override
            Reference transform(Reference ref) {
                return Detached.of((String)ref.getHash());
            }
        };


        abstract Reference transform(Reference var1);
    }
}

