/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.jaxrs.tests.AbstractRest;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestAssign
extends AbstractRest {
    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void testAssignRefToFreshMain(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Reference main = this.getApi().getReference().refName("main").get();
        this.soft.assertThat(((GetCommitLogBuilder)this.getApi().getCommitLog().refName(main.getName())).stream()).isEmpty();
        Branch testBranch = this.createBranch("testBranch");
        ((AssignBranchBuilder)this.getApi().assignBranch().branch(testBranch)).assignTo(main).assign();
        Reference testBranchRef = this.getApi().getReference().refName(testBranch.getName()).get();
        this.soft.assertThat(testBranchRef.getHash()).isEqualTo(main.getHash());
        String testTag = "testTag";
        Reference testTagRef = this.getApi().createReference().sourceRefName(main.getName()).reference((Reference)Tag.of((String)testTag, (String)main.getHash())).create();
        this.soft.assertThat(testTagRef.getHash()).isNotNull();
        ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().hash(testTagRef.getHash())).tagName(testTag)).assignTo(refMode.transform(main)).assign();
        testTagRef = this.getApi().getReference().refName(testTag).get();
        this.soft.assertThat(testTagRef.getHash()).isEqualTo(main.getHash());
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void testAssignBranch(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch main = this.createBranch("test-main");
        Branch branch = this.createBranch("test-branch");
        this.createCommits((Reference)main, 1, 1, main.getHash());
        main = this.getApi().getReference().refName(main.getName()).get();
        this.soft.assertThat(branch.getHash()).isNotEqualTo((Object)main.getHash());
        ((AssignBranchBuilder)this.getApi().assignBranch().branch(branch)).assignTo(refMode.transform((Reference)main)).assign();
        Reference assignedBranch = this.getApi().getReference().refName(branch.getName()).get();
        this.soft.assertThat(assignedBranch.getHash()).isEqualTo(main.getHash());
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testAssignAndGetBranch(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch main = this.createBranch("test-main2");
        Branch branch = this.createBranch("test-branch2");
        this.createCommits((Reference)main, 1, 1, main.getHash());
        main = this.getApi().getReference().refName(main.getName()).get();
        this.soft.assertThat(branch.getHash()).isNotEqualTo((Object)main.getHash());
        Branch assignedBranch = ((AssignBranchBuilder)this.getApi().assignBranch().branch(branch)).assignTo(refMode.transform((Reference)main)).assignAndGet();
        this.soft.assertThat(assignedBranch.getHash()).isEqualTo(main.getHash());
        Reference currentBranch = this.getApi().getReference().refName(branch.getName()).get();
        this.soft.assertThat((Object)assignedBranch).isEqualTo((Object)currentBranch);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void testAssignTag(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch main = this.createBranch("test-main");
        Tag tag = this.createTag("testTag", (Reference)main);
        this.createCommits((Reference)main, 1, 1, main.getHash());
        main = this.getApi().getReference().refName(main.getName()).get();
        this.soft.assertThat(tag.getHash()).isNotEqualTo((Object)main.getHash());
        ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(tag.getName())).hash(tag.getHash())).assignTo(refMode.transform((Reference)main)).assign();
        Reference assignedTag = this.getApi().getReference().refName(tag.getName()).get();
        this.soft.assertThat(assignedTag.getHash()).isEqualTo(main.getHash());
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testAssignAndGetTag(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch main = this.createBranch("test-main2");
        Tag tag = this.createTag("testTag2", (Reference)main);
        this.createCommits((Reference)main, 1, 1, main.getHash());
        main = this.getApi().getReference().refName(main.getName()).get();
        this.soft.assertThat(tag.getHash()).isNotEqualTo((Object)main.getHash());
        Tag assignedTag = ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(tag.getName())).hash(tag.getHash())).assignTo(refMode.transform((Reference)main)).assignAndGet();
        this.soft.assertThat(assignedTag.getHash()).isEqualTo(main.getHash());
        Reference currentTag = this.getApi().getReference().refName(tag.getName()).get();
        this.soft.assertThat((Object)assignedTag).isEqualTo((Object)currentTag);
    }
}

