/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.jaxrs.tests.AbstractRestInvalidRefs;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestInvalid
extends AbstractRestInvalidRefs {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidBranchNames(String invalidBranchName, String validHash) {
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(invalidBranchName)).hash(validHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'").hasMessageContaining(opsCountMsg);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(invalidBranchName)).untilHash(validHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.getApi().getReference().refName(invalidBranchName).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRef((Reference)this.getApi().getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(invalidBranchName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().branchName(invalidBranchName)).hash(validHash)).fromRefName("main")).hashesToTransplant(Collections.singletonList(this.getApi().getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(invalidBranchName)).hashOnRef(validHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.getApi().getDiff().fromRefName(invalidBranchName).toRefName("main").get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
    }

    @ParameterizedTest
    @CsvSource(value={"abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ContentKey key = ContentKey.of((String[])new String[]{"x"});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = ".operations.operations: size must be between 1 and 2147483647";
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(validBranchName)).hash(invalidHash)).commitMeta(CommitMeta.fromMessage((String)"")).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes").hasMessageContaining(opsCountMsg);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(validBranchName)).hash(invalidHash)).assignTo((Reference)tag).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((MergeReferenceBuilder)((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRef((Reference)this.getApi().getDefaultBranch()).merge()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(validBranchName)).hash(invalidHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.getApi().transplantCommitsIntoBranch().branchName(validBranchName)).hash(invalidHash)).fromRefName("main")).hashesToTransplant(Collections.singletonList(this.getApi().getReference().refName("main").get().getHash())).transplant()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)this.getApi().getContent().refName(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("size must be between 1 and 2147483647").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("size must be between 1 and 2147483647").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)((GetContentBuilder)this.getApi().getContent().key(key).refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(validBranchName)).untilHash(invalidHash).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().refName(validBranchName)).hashOnRef(invalidHash)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("consist of the hex representation of 4-32 bytes");
    }

    @Test
    public void missingExpectedHash() {
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName("test")).commitMeta(CommitMeta.fromMessage((String)"")).operation((Operation)Operation.Unchanged.of((ContentKey)ContentKey.of((String[])new String[]{"test1"}))).commit()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("expectedHash: must not be null");
    }

    @ParameterizedTest
    @CsvSource(value={"abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    public void invalidTags(String invalidTagName, String validHash) {
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)((AssignTagBuilder)this.getApi().assignTag().tagName(invalidTagName)).hash(validHash)).assignTo((Reference)Tag.of((String)"validTag", (String)validHash)).assign()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(invalidTagName)).hash(validHash)).delete()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400):").hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
    }
}

