/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.jaxrs.tests.AbstractRest;
import org.projectnessie.jaxrs.tests.AbstractRestDiff;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestEntries
extends AbstractRestDiff {
    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByType(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterTypes");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable tam = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (int)1, (int)1, (String)"select * from table", (String)"Dremio");
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)tam)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ImmutableMap expect = ImmutableMap.of((Object)a, (Object)Content.Type.ICEBERG_TABLE, (Object)b, (Object)Content.Type.ICEBERG_VIEW);
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrderElementsOf(expect.entrySet());
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_TABLE'")).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactly((Object[])new Map.Entry[]{Maps.immutableEntry((Object)a, (Object)Content.Type.ICEBERG_TABLE)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType=='ICEBERG_VIEW'")).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactly((Object[])new Map.Entry[]{Maps.immutableEntry((Object)b, (Object)Content.Type.ICEBERG_VIEW)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.contentType in ['ICEBERG_TABLE', 'ICEBERG_VIEW']")).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrderElementsOf(expect.entrySet());
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByName(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByName");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.name.startsWith('first')")).get().getEntries();
        this.soft.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{first});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.name.endsWith('Table')")).get().getEntries();
        this.soft.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{first, second});
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByFullKeyName(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByFullKeyName");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "table"});
        ContentKey second = ContentKey.of((String[])new String[]{"d", "b", "c", "table"});
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.key == 'a.b.c.table'")).get().getEntries();
        this.soft.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactly((Object[])new ContentKey[]{first});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.key.endsWith('.b.c.table')")).get().getEntries();
        this.soft.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).containsExactlyInAnyOrder((Object[])new ContentKey[]{first, second});
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    public void filterEntriesByNamespace(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespace");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "fourthTable"});
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)first, (Content)IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)second, (Content)IcebergTable.of((String)"path2", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 2")).commit();
        ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)third, (Content)IcebergTable.of((String)"path3", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 3")).commit();
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)fourth, (Content)IcebergTable.of((String)"path4", (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)"commit 4")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).isNotNull()).hasSize(4);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(2)).map(e -> e.getName().getNamespace().name()).allMatch(n -> n.startsWith("a.b"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(4)).map(e -> e.getName().getNamespace().name()).allMatch(n -> n.startsWith("a"));
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.b.c.firstTable')")).get().getEntries();
        this.soft.assertThat(entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(refMode.transform((Reference)branch))).filter("entry.namespace.startsWith('a.fourthTable')")).get().getEntries();
        this.soft.assertThat(entries).isEmpty();
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch.getName())).hash(this.getApi().getReference().refName(branch.getName()).get().getHash())).delete();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractRest.ReferenceMode.class)
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void filterEntriesByNamespaceAndPrefixDepth(AbstractRest.ReferenceMode refMode) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("filterEntriesByNamespaceAndPrefixDepth");
        ContentKey first = ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentKey second = ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentKey third = ContentKey.of((String[])new String[]{"a", "thirdTable"});
        ContentKey fourth = ContentKey.of((String[])new String[]{"a", "b", "fourthTable"});
        ContentKey fifth = ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"});
        ContentKey withoutNamespace = ContentKey.of((String[])new String[]{"withoutNamespace"});
        ImmutableList keys = ImmutableList.of((Object)first, (Object)second, (Object)third, (Object)fourth, (Object)fifth, (Object)withoutNamespace);
        for (int i = 0; i < keys.size(); ++i) {
            ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)((ContentKey)keys.get(i)), (Content)IcebergTable.of((String)("path" + i), (long)42L, (int)42, (int)42, (int)42))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commit();
        }
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        Reference reference = refMode.transform((Reference)branch);
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(0)).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).isNotNull()).hasSize(6);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(0)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).isNotNull()).hasSize(5);
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(1)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(1)).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactly((Object[])new Map.Entry[]{Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a"}), (Object)Content.Type.NAMESPACE)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(2)).filter("entry.namespace.matches('a(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(3)).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "boo"}), (Object)Content.Type.NAMESPACE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b"}), (Object)Content.Type.NAMESPACE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "thirdTable"}), (Object)Content.Type.ICEBERG_TABLE)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('a\\\\.b(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(2)).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "fourthTable"}), (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "c"}), (Object)Content.Type.NAMESPACE)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(4)).filter("entry.namespace.matches('a\\\\.b\\\\.c(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(2)).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "c", "secondTable"}), (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "c", "firstTable"}), (Object)Content.Type.ICEBERG_TABLE)});
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(5)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        this.soft.assertThat(entries).isEmpty();
        entries = ((GetEntriesBuilder)((GetEntriesBuilder)this.getApi().getEntries().reference(reference)).namespaceDepth(Integer.valueOf(3)).filter("entry.namespace.matches('(\\\\.|$)')")).get().getEntries();
        ((ListAssert)this.soft.assertThat(entries).hasSize(3)).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "boo", "fifthTable"}), (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "fourthTable"}), (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)ContentKey.of((String[])new String[]{"a", "b", "c"}), (Object)Content.Type.NAMESPACE)});
        if (AbstractRest.ReferenceMode.DETACHED != refMode) {
            this.checkNamespaces(reference, Arrays.asList("a", "a.b", "a.boo", "a.b.c"), Arrays.asList(first, second, third, fourth, fifth));
        }
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void fetchEntriesByNamelessReference() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("fetchEntriesByNamelessReference");
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (int)1, (int)1, (String)"select * from table", (String)"Dremio");
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)ta)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().hashOnRef(branch.getHash())).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)a, (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)b, (Object)Content.Type.ICEBERG_VIEW)});
    }

    private void checkNamespaces(Reference reference, List<String> knownNamespaces, List<ContentKey> knownContentKeys) throws NessieReferenceNotFoundException, NessieNamespaceNotFoundException {
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().reference(reference)).namespace("a")).get().getNamespaces()).hasSize(4);
        for (String namespace : knownNamespaces) {
            Namespace ns = Namespace.parse((String)namespace);
            this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(reference)).namespace(ns)).get()).isNotNull();
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference(reference)).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespace));
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(reference)).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).hasMessage(String.format("Namespace '%s' is not empty", namespace));
        }
        List unknownNamespaces = knownContentKeys.stream().map(ContentKey::toString).collect(Collectors.toList());
        for (String namespace : unknownNamespaces) {
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(reference)).namespace(Namespace.parse((String)namespace))).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespace));
        }
    }
}

