/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.jaxrs.tests.AbstractRestRefLog;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestNamespace
extends AbstractRestRefLog {
    private Reference current(Reference ref) throws NessieNotFoundException {
        return this.getApi().getReference().refName(ref.getName()).get();
    }

    @ParameterizedTest
    @ValueSource(strings={"a.b.c", "a.b\u001dc.d", "a.b.c.d", "a.b\u0000c.d"})
    public void testNamespaces(String namespaceName) throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespaces");
        Namespace ns = Namespace.parse((String)namespaceName);
        Namespace namespace = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference((Reference)branch)).namespace(ns)).create();
        ((ObjectAssert)this.soft.assertThat((Object)namespace).isNotNull()).extracting(new Function[]{Namespace::getElements, Namespace::toPathString}).containsExactly(new Object[]{ns.getElements(), ns.toPathString()});
        Namespace got = ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get();
        this.soft.assertThat((Object)got).isEqualTo((Object)namespace);
        String namespaceInErrorMsg = namespaceName.replace("\u0000", "\u001d");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference(this.current((Reference)branch))).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespaceInErrorMsg));
        ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(this.current((Reference)branch))).namespace(ns)).delete();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(this.current((Reference)branch))).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespaceInErrorMsg));
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespaceInErrorMsg));
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference((Reference)branch)).namespace(Namespace.parse((String)"nonexisting"))).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'nonexisting' does not exist");
    }

    @Test
    public void testNamespacesRetrieval() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("namespace");
        ThrowingExtractor createNamespace = identifier -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference((Reference)branch)).namespace(Namespace.parse((String)identifier))).create();
        Namespace one = (Namespace)createNamespace.apply((Object)"a.b.c");
        Namespace two = (Namespace)createNamespace.apply((Object)"a.b.d");
        Namespace three = (Namespace)createNamespace.apply((Object)"x.y.z");
        Namespace four = (Namespace)createNamespace.apply((Object)"one.two");
        for (Namespace namespace : Arrays.asList(one, two, three, four)) {
            this.soft.assertThat((Object)namespace).isNotNull();
            this.soft.assertThat(namespace.getId()).isNotNull();
        }
        this.soft.assertThat(((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two, three, four});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two, three, four});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one, two});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b.c")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{one});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("a.b.d")).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{two});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("x")).get().getNamespaces()).containsExactly((Object[])new Namespace[]{three});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("z")).get().getNamespaces()).isEmpty();
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace("one")).get().getNamespaces()).containsExactly((Object[])new Namespace[]{four});
    }

    @Test
    public void testNamespaceDeletion() throws BaseNessieClientServerException {
        Branch init = this.createBranch("testNamespaceDeletion");
        List contentAndOps = AbstractRestNamespace.contentAndOperationTypes().collect(Collectors.toList());
        CommitMultipleOperationsBuilder prepare = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(init)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes prepare"));
        contentAndOps.stream().filter(co -> co.prepare != null).map(co -> co.prepare).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)prepare).operation(arg_0));
        Branch branch = prepare.commit();
        CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes"));
        contentAndOps.stream().map(c -> c.operation).forEach(arg_0 -> ((CommitMultipleOperationsBuilder)commit).operation(arg_0));
        commit.commit();
        List entries = contentAndOps.stream().filter(c -> c.operation instanceof Operation.Put).map(c -> c.operation.getKey()).collect(Collectors.toList());
        CommitMultipleOperationsBuilder commit2 = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"create namespaces"));
        entries.stream().map(ContentKey::getNamespace).distinct().forEach(ns -> commit2.operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((List)ns.getElements()), (Content)ns)));
        commit2.commit();
        for (ContentKey contentKey : entries) {
            Namespace namespace = contentKey.getNamespace();
            this.soft.assertThat(((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(namespace)).get().getElements()).isEqualTo((Object)namespace.getElements());
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(namespace)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).hasMessage(String.format("Namespace '%s' is not empty", namespace));
        }
    }

    @Test
    public void testNamespaceMerge() throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        base = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(base)).commitMeta(CommitMeta.fromMessage((String)"root")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"root"}), (Content)IcebergTable.of((String)"/dev/null", (long)42L, (int)42, (int)42, (int)42))).commit();
        Branch branch = this.createBranch("merge-branch", base);
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).reference((Reference)branch)).create();
        base = (Branch)this.getApi().getReference().refName(base.getName()).get();
        branch = (Branch)this.getApi().getReference().refName(branch.getName()).get();
        ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(base)).fromRef((Reference)branch).merge();
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        String expectedCommitMsg = "create namespace a.b.c";
        this.soft.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{expectedCommitMsg, "root"});
        this.soft.assertThat(((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries().stream().map(EntriesResponse.Entry::getName)).contains((Object[])new ContentKey[]{ContentKey.of((List)ns.getElements())});
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @Test
    public void testNamespaceMergeWithConflict() throws BaseNessieClientServerException {
        Branch base = this.createBranch("merge-base");
        base = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(base)).commitMeta(CommitMeta.fromMessage((String)"root")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"root"}), (Content)IcebergTable.of((String)"/dev/null", (long)42L, (int)42, (int)42, (int)42))).commit();
        Branch branch = this.createBranch("merge-branch", base);
        Namespace ns = Namespace.parse((String)"a.b.c");
        ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(ns)).reference((Reference)base)).create();
        base = (Branch)this.getApi().getReference().refName(base.getName()).get();
        IcebergTable table = IcebergTable.of((String)"merge-table1", (long)42L, (int)42, (int)42, (int)42);
        branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)"test-merge-branch1")).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a", "b", "c"}), (Content)table)).commit();
        Branch finalBase = base;
        Branch finalBranch = branch;
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((MergeReferenceBuilder)this.getApi().mergeRefIntoBranch().branch(finalBase)).fromRef((Reference)finalBranch).merge()).isInstanceOf(NessieReferenceConflictException.class)).hasMessage("The following keys have been changed in conflict: 'a.b.c'");
        LogResponse log = ((GetCommitLogBuilder)this.getApi().getCommitLog().refName(base.getName())).untilHash(base.getHash()).get();
        this.soft.assertThat(log.getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getMessage)).containsExactly((Object[])new String[]{"create namespace a.b.c"});
        List entries = ((GetEntriesBuilder)this.getApi().getEntries().refName(base.getName())).get().getEntries();
        this.soft.assertThat(entries.stream().map(EntriesResponse.Entry::getName)).contains((Object[])new ContentKey[]{ContentKey.of((List)ns.getElements())});
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(base.getName())).namespace(ns)).get()).isNotNull();
    }

    @Test
    public void testNamespaceConflictWithOtherContent() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespaceConflictWithOtherContent");
        IcebergTable icebergTable = IcebergTable.of((String)"icebergTable", (long)42L, (int)42, (int)42, (int)42);
        List<String> elements = Arrays.asList("a", "b", "c");
        ContentKey key = ContentKey.of(elements);
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"add table")).operation((Operation)Operation.Put.of((ContentKey)key, (Content)icebergTable)).commit();
        Namespace ns = Namespace.of(elements);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(ns)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage("Another content object with name 'a.b.c' already exists");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(ns)).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'a.b.c' does not exist");
        this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(ns)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class);
    }

    @Test
    public void testNamespacesWithAndWithoutZeroBytes() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("testNamespacesWithAndWithoutZeroBytes");
        String firstName = "a.b\u0000c.d";
        String secondName = "a.b.c.d";
        ThrowingExtractor creator = identifier -> {
            Namespace namespace = Namespace.parse((String)identifier);
            Namespace created = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().reference((Reference)branch)).namespace(namespace)).create();
            ((ObjectAssert)this.soft.assertThat((Object)created).isNotNull()).extracting(new Function[]{Namespace::getElements, Namespace::toPathString}).containsExactly(new Object[]{namespace.getElements(), namespace.toPathString()});
            this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(namespace)).get()).isEqualTo((Object)created);
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(namespace)).create()).isInstanceOf(NessieNamespaceAlreadyExistsException.class)).hasMessage(String.format("Namespace '%s' already exists", namespace.name()));
            this.soft.assertAll();
            return created;
        };
        Namespace first = (Namespace)creator.apply((Object)firstName);
        Namespace second = (Namespace)creator.apply((Object)secondName);
        List<Namespace> namespaces = Arrays.asList(first, second);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrderElementsOf(namespaces);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a")).refName(branch.getName())).get().getNamespaces()).containsExactlyInAnyOrderElementsOf(namespaces);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{second});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b\u001dc")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{first});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b\u0000c")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{first});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().namespace("a.b.c")).refName(branch.getName())).get().getNamespaces()).containsExactly((Object[])new Namespace[]{second});
        for (Namespace namespace : namespaces) {
            ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(this.current((Reference)branch))).namespace(namespace)).delete();
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().reference(this.current((Reference)branch))).namespace(namespace)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage(String.format("Namespace '%s' does not exist", namespace.name()));
        }
        this.soft.assertThat(((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
    }

    @Test
    public void testEmptyNamespace() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("emptyNamespace");
        this.soft.assertThatThrownBy(() -> ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).create()).isInstanceOf(Exception.class);
        this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).get()).isInstanceOf(Exception.class);
        this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.getApi().deleteNamespace().refName(branch.getName())).namespace(Namespace.EMPTY)).delete()).isInstanceOf(Exception.class);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
        ContentKey keyWithoutNamespace = ContentKey.of((String[])new String[]{"icebergTable"});
        ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)"add table")).operation((Operation)Operation.Put.of((ContentKey)keyWithoutNamespace, (Content)IcebergTable.of((String)"icebergTable", (long)42L, (int)42, (int)42, (int)42))).commit();
        this.soft.assertThat(((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).get().getNamespaces()).isEmpty();
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.getApi().getMultipleNamespaces().refName(branch.getName())).namespace(Namespace.EMPTY)).get().getNamespaces()).isEmpty();
    }

    @Test
    public void testNamespaceWithProperties() throws BaseNessieClientServerException {
        Branch branch = this.createBranch("namespaceWithProperties");
        ImmutableMap properties = ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2");
        Namespace namespace = Namespace.of((Map)properties, (String[])new String[]{"a", "b", "c"});
        Namespace ns = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.getApi().createNamespace().namespace(namespace)).properties((Map)properties).reference((Reference)branch)).create();
        this.soft.assertThat(ns.getProperties()).isEqualTo((Object)properties);
        this.soft.assertThat(ns.getId()).isNotNull();
        String nsId = ns.getId();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$testNamespaceWithProperties$22(branch, (Map)properties)).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'non-existing' does not exist");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$testNamespaceWithProperties$23(branch, (Map)properties)).isInstanceOf(NessieNamespaceNotFoundException.class)).hasMessage("Namespace 'non-existing' does not exist");
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference(this.current((Reference)branch))).namespace(namespace)).updateProperties((Map)properties).update();
        this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference((Reference)branch)).namespace(namespace)).get()).isInstanceOf(NessieNamespaceNotFoundException.class);
        Reference updated = this.current((Reference)branch);
        ns = ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(updated)).namespace(namespace)).get();
        this.soft.assertThat(ns.getProperties()).isEqualTo((Object)properties);
        this.soft.assertThat(ns.getId()).isEqualTo(nsId);
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference(updated)).namespace(namespace)).updateProperties((Map)ImmutableMap.of((Object)"key3", (Object)"val3", (Object)"key1", (Object)"xyz")).removeProperties((Set)ImmutableSet.of((Object)"key2", (Object)"key5")).update();
        this.soft.assertThat(((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(updated)).namespace(namespace)).get().getProperties()).isEqualTo((Object)properties);
        updated = this.current((Reference)branch);
        ns = ((GetNamespaceBuilder)((GetNamespaceBuilder)this.getApi().getNamespace().reference(updated)).namespace(namespace)).get();
        this.soft.assertThat(ns.getProperties()).isEqualTo((Object)ImmutableMap.of((Object)"key1", (Object)"xyz", (Object)"key3", (Object)"val3"));
        this.soft.assertThat(ns.getId()).isEqualTo(nsId);
    }

    private /* synthetic */ void lambda$testNamespaceWithProperties$23(Branch branch, Map properties) throws Throwable {
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference((Reference)branch)).namespace("non-existing")).removeProperties(properties.keySet()).update();
    }

    private /* synthetic */ void lambda$testNamespaceWithProperties$22(Branch branch, Map properties) throws Throwable {
        ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.getApi().updateProperties().reference((Reference)branch)).namespace("non-existing")).updateProperties(properties).update();
    }
}

