/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieRefLogNotFoundException;
import org.projectnessie.jaxrs.tests.AbstractRestReferences;
import org.projectnessie.model.Branch;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

public abstract class AbstractRestRefLog
extends AbstractRestReferences {
    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    @DisabledOnOs(value={OS.WINDOWS})
    public void testReflog() throws BaseNessieClientServerException {
        String tagName = "tag1_test_reflog_" + ThreadLocalRandom.current().nextInt();
        String branch1 = "branch1_test_reflog";
        String branch2 = "branch2_test_reflog";
        String branch3 = "branch3_test_reflog";
        String root = "ref_name_test_reflog";
        ArrayList<Tuple> expectedEntries = new ArrayList<Tuple>();
        Branch branch0 = this.createBranch(root);
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{root, "CREATE_REFERENCE"}));
        this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Tag.of((String)tagName, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{tagName, "CREATE_REFERENCE"}));
        this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch1, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch1, "CREATE_REFERENCE"}));
        this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch2, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch2, "CREATE_REFERENCE"}));
        this.getApi().createReference().sourceRefName(branch0.getName()).reference((Reference)Branch.of((String)branch3, (String)branch0.getHash())).create();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch3, "CREATE_REFERENCE"}));
        ((DeleteBranchBuilder)((DeleteBranchBuilder)this.getApi().deleteBranch().branchName(branch1)).hash(branch0.getHash())).delete();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{branch1, "DELETE_REFERENCE"}));
        ((DeleteTagBuilder)((DeleteTagBuilder)this.getApi().deleteTag().tagName(tagName)).hash(branch0.getHash())).delete();
        expectedEntries.add(Tuple.tuple((Object[])new Object[]{tagName, "DELETE_REFERENCE"}));
        Collections.reverse(expectedEntries);
        RefLogResponse refLogResponse = this.getApi().getRefLog().get();
        this.soft.assertThat(refLogResponse.getLogEntries().subList(0, 7)).extracting(new Function[]{RefLogResponse.RefLogResponseEntry::getRefName, RefLogResponse.RefLogResponseEntry::getOperation}).isEqualTo(expectedEntries);
        RefLogResponse refLogResponse1 = ((GetRefLogBuilder)this.getApi().getRefLog().maxRecords(2)).get();
        this.soft.assertThat(refLogResponse1.getLogEntries()).isEqualTo(refLogResponse.getLogEntries().subList(0, 2));
        this.soft.assertThat(refLogResponse1.isHasMore()).isTrue();
        RefLogResponse refLogResponse2 = ((GetRefLogBuilder)this.getApi().getRefLog().pageToken(refLogResponse1.getToken())).get();
        this.soft.assertThat(((RefLogResponse.RefLogResponseEntry)refLogResponse2.getLogEntries().get(0)).getRefLogId()).isEqualTo(refLogResponse1.getToken());
        this.soft.assertThat(refLogResponse2.getLogEntries().subList(0, 5)).isEqualTo(refLogResponse.getLogEntries().subList(2, 7));
        RefLogResponse refLogResponse3 = this.getApi().getRefLog().fromHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(4)).getRefLogId()).get();
        this.soft.assertThat(refLogResponse3.getLogEntries().subList(0, 2)).isEqualTo(refLogResponse.getLogEntries().subList(4, 6));
        RefLogResponse refLogResponse4 = this.getApi().getRefLog().fromHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(3)).getRefLogId()).untilHash(((RefLogResponse.RefLogResponseEntry)refLogResponse.getLogEntries().get(5)).getRefLogId()).get();
        this.soft.assertThat(refLogResponse4.getLogEntries()).isEqualTo(refLogResponse.getLogEntries().subList(3, 6));
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.getApi().getRefLog().fromHash("f1234d75178d892a133a410355a5a990cf75d2f33eba25d575943d4df632f3a4").get()).isInstanceOf(NessieRefLogNotFoundException.class)).hasMessageContaining("RefLog entry for 'f1234d75178d892a133a410355a5a990cf75d2f33eba25d575943d4df632f3a4' does not exist");
        List filteredResult = StreamingUtil.getReflogStream((NessieApiV1)this.getApi(), builder -> (GetRefLogBuilder)builder.filter("reflog.operation == 'CREATE_REFERENCE' && reflog.refName == '" + tagName + "'"), (OptionalInt)OptionalInt.empty()).collect(Collectors.toList());
        this.soft.assertThat(filteredResult.size()).isEqualTo(1);
        this.soft.assertThat((Object)((RefLogResponse.RefLogResponseEntry)filteredResult.get(0))).extracting(new Function[]{RefLogResponse.RefLogResponseEntry::getRefName, RefLogResponse.RefLogResponseEntry::getOperation}).isEqualTo((Object)((Tuple)expectedEntries.get(5)).toList());
    }
}

