/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.client.ext.NessieClientUri;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SingleReferenceResponse;

@NessieApiVersions(versions={NessieApiVersion.V2})
public abstract class AbstractResteasyV2Test {
    protected static String basePath = "/api/v2/";

    @BeforeEach
    public void enableLogging() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    private static RequestSpecification rest() {
        return RestAssured.given().when().baseUri(RestAssured.baseURI).basePath(basePath).contentType(ContentType.JSON);
    }

    private Branch createBranch(String branchName) {
        return (Branch)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().queryParam("name", new Object[]{branchName}).queryParam("type", new Object[]{Reference.ReferenceType.BRANCH.name()}).post("trees", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
    }

    private Branch commit(Branch branch, ContentKey key, IcebergTable table) {
        return ((CommitResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().body((Object)ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"test commit")).addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)table)).build()).post("trees/{ref}/history/commit", new Object[]{branch.toPathString()})).then()).statusCode(200)).extract().as(CommitResponse.class)).getTargetBranch();
    }

    private Content getContent(Reference reference, ContentKey key) {
        return ((ContentResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/{ref}/contents/{key}", new Object[]{reference.toPathString(), key.toPathString()})).then()).statusCode(200)).extract().as(ContentResponse.class)).getContent();
    }

    @ParameterizedTest
    @CsvSource(value={"simple1,testKey", "simple2,test.Key", "simple3,test\u001dKey", "simple4,test\u001dnested.Key", "with/slash1,testKey", "with/slash2,test.Key", "with/slash3,test\u001dKey", "with/slash4,test\u001d.nested.Key"})
    void testGetSingleContent(String branchName, String encodedKey) {
        Branch branch = this.createBranch(branchName);
        ContentKey key = ContentKey.fromPathString((String)encodedKey);
        IcebergTable table = IcebergTable.of((String)"test-location", (long)1L, (int)2, (int)3, (int)4);
        branch = this.commit(branch, key, table);
        ((ObjectAssert)Assertions.assertThat((Object)this.getContent((Reference)branch, key)).asInstanceOf(InstanceOfAssertFactories.type(IcebergTable.class))).extracting(IcebergTable::getMetadataLocation).isEqualTo((Object)"test-location");
    }

    @ParameterizedTest
    @ValueSource(strings={"simple", "with/slash"})
    void testGetSeveralContents(String branchName) {
        Branch branch = this.createBranch(branchName);
        ContentKey key1 = ContentKey.of((String[])new String[]{"test", "Key"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"test.with.dot", "Key"});
        IcebergTable table1 = IcebergTable.of((String)"loc1", (long)1L, (int)2, (int)3, (int)4);
        IcebergTable table2 = IcebergTable.of((String)"loc2", (long)1L, (int)2, (int)3, (int)4);
        branch = this.commit(branch, key1, table1);
        branch = this.commit(branch, key2, table2);
        EntriesResponse entries = (EntriesResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/{ref}/entries", new Object[]{branch.toPathString()})).then()).statusCode(200)).extract().as(EntriesResponse.class);
        ((ListAssert)Assertions.assertThat((List)entries.getEntries()).hasSize(2)).allSatisfy(e -> Assertions.assertThat((String)e.getContentId()).isNotNull());
        Stream<MapEntry> contents = ((GetMultipleContentsResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().queryParam("key", new Object[]{key1.toPathString(), key2.toPathString()}).get("trees/{ref}/contents", new Object[]{branch.toPathString()})).then()).statusCode(200)).extract().as(GetMultipleContentsResponse.class)).getContents().stream().map(content -> Assertions.entry((Object)content.getKey(), (Object)((IcebergTable)content.getContent()).getMetadataLocation()));
        Assertions.assertThat(contents).containsExactlyInAnyOrder((Object[])new MapEntry[]{Assertions.entry((Object)key1, (Object)"loc1"), Assertions.entry((Object)key2, (Object)"loc2")});
    }

    @Test
    void testBranchWithSlashInUrlPath(@NessieClientUri URI clientUri) throws IOException {
        Branch branch = this.createBranch("test/branch/name1");
        Assertions.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/test/branch/name1@", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference()).isEqualTo((Object)branch);
        URL url = new URL(clientUri + "/trees/test/branch/name1@");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assertions.assertThat((int)conn.getResponseCode()).isEqualTo(200);
        conn.disconnect();
    }

    @Test
    void testDefaultBranchSpecInUrlPath() {
        Reference main = ((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/-", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
        Assertions.assertThat((String)main.getName()).isEqualTo("main");
        Branch branch = this.createBranch("testDefaultBranchSpecInUrlPath");
        ContentKey key = ContentKey.of((String[])new String[]{"test1"});
        this.commit(branch, key, IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4));
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/-/diff/{name}", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).satisfiesExactly(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getKey()).isEqualTo((Object)key)});
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/{name}/diff/-", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).satisfiesExactly(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getKey()).isEqualTo((Object)key)});
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/-/diff/-", new Object[0])).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).isEmpty();
    }

    @Test
    public void testCommitMetaAttributes() {
        Branch branch = this.createBranch("testCommitMetaAttributes");
        this.commit(branch, ContentKey.of((String[])new String[]{"test-key"}), IcebergTable.of((String)"meta", (long)1L, (int)2, (int)3, (int)4));
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)AbstractResteasyV2Test.rest().get("trees/{ref}/history", new Object[]{branch.getName()})).then()).statusCode(200)).extract().asString();
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)response).doesNotContain(new CharSequence[]{"\"author\""})).contains(new CharSequence[]{"\"authors\""})).doesNotContain(new CharSequence[]{"\"signedOffBy\""})).contains(new CharSequence[]{"allSignedOffBy"});
    }
}

