/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.validation.constraints.NotNull;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.CreateNamespaceResult;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.DeleteNamespaceResult;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.client.api.UpdateNamespaceResult;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Tag;

@NessieApiVersions
public abstract class BaseTestNessieApi {
    public static final String EMPTY = Hashing.sha256().hashString((CharSequence)"empty", StandardCharsets.UTF_8).toString();
    private NessieApiV1 api;
    private NessieApiVersion apiVersion;
    protected final SoftAssertions soft = new SoftAssertions();

    @BeforeEach
    void initApi(NessieClientFactory clientFactory) {
        this.api = clientFactory.make();
        this.apiVersion = clientFactory.apiVersion();
    }

    @NotNull
    @jakarta.validation.constraints.NotNull
    public NessieApiV1 api() {
        return this.api;
    }

    public boolean isV2() {
        return NessieApiVersion.V2 == this.apiVersion;
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.soft.assertAll();
        }
        finally {
            Branch defaultBranch = this.api.getDefaultBranch();
            ((AssignBranchBuilder)this.api().assignBranch().branch(defaultBranch)).assignTo((Reference)Branch.of((String)defaultBranch.getName(), (String)EMPTY)).assign();
            this.api.getAllReferences().stream().forEach(ref -> {
                try {
                    if (ref instanceof Branch && !ref.getName().equals(defaultBranch.getName())) {
                        ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)ref)).delete();
                    } else if (ref instanceof Tag) {
                        ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)ref)).delete();
                    }
                }
                catch (NessieConflictException | NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            this.api.close();
        }
    }

    protected <R extends Reference> R createReference(R reference, String sourceRefName) throws NessieConflictException, NessieNotFoundException {
        return (R)this.api().createReference().sourceRefName(sourceRefName).reference(reference).create();
    }

    protected CommitMultipleOperationsBuilder prepCommit(Branch branch, String msg, Operation ... operations) {
        return ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)msg)).operations(Arrays.asList(operations));
    }

    protected Operation.Put dummyPut(String ... elements) {
        return Operation.Put.of((ContentKey)ContentKey.of((String[])elements), (Content)IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4));
    }

    protected static boolean pagingSupported(PagingBuilder<?, ?, ?> apiRequestBuilder) {
        return !(apiRequestBuilder instanceof GetDiffBuilder) && !(apiRequestBuilder instanceof GetAllReferencesBuilder) && !(apiRequestBuilder instanceof GetEntriesBuilder);
    }

    @Test
    public void config() throws NessieNotFoundException {
        NessieConfiguration config = this.api().getConfig();
        this.soft.assertThat((Object)config).extracting(new Function[]{NessieConfiguration::getDefaultBranch, NessieConfiguration::getMaxSupportedApiVersion}).containsExactly(new Object[]{"main", 2});
        this.soft.assertThat((Object)this.api().getDefaultBranch()).extracting(new Function[]{Branch::getName, Branch::getHash}).containsExactly(new Object[]{config.getDefaultBranch(), EMPTY});
    }

    @Test
    public void references() throws Exception {
        Tag deleted;
        Branch branchAssigned;
        Branch main = this.api().getDefaultBranch();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactly((Object[])new Reference[]{main});
        Branch main1 = this.prepCommit(main, "commit", new Operation[]{this.dummyPut("key", "foo")}).commit();
        CommitMeta commitMetaMain = ((LogResponse.LogEntry)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main1)).get().getLogEntries().get(0)).getCommitMeta();
        Tag tag = this.createReference(Tag.of((String)"tag1", (String)main1.getHash()), main.getName());
        Branch branch = this.createReference(Branch.of((String)"branch1", (String)main1.getHash()), main.getName());
        Branch branch1 = this.prepCommit(branch, "branch", new Operation[]{this.dummyPut("key", "bar")}).commit();
        CommitMeta commitMetaBranch = ((LogResponse.LogEntry)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)branch1)).get().getLogEntries().get(0)).getCommitMeta();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1, tag, branch1});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).get()).isEqualTo((Object)tag);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).get()).isEqualTo((Object)branch1);
        Branch mainFull = Branch.of((String)main.getName(), (String)main1.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(1L)).commitMetaOfHEAD(commitMetaMain).build());
        Branch branchFull = Branch.of((String)branch.getName(), (String)branch1.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(2L)).numCommitsAhead(Integer.valueOf(1)).numCommitsBehind(Integer.valueOf(0)).commonAncestorHash(main1.getHash()).commitMetaOfHEAD(commitMetaBranch).build());
        Tag tagFull = Tag.of((String)tag.getName(), (String)tag.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(1L)).commitMetaOfHEAD(commitMetaMain).build());
        this.soft.assertThat(this.api().getAllReferences().fetch(FetchOption.ALL).get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{mainFull, branchFull, tagFull});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)mainFull);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)tagFull);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)branchFull);
        if (this.isV2()) {
            tag = ((AssignTagBuilder)this.api.assignTag().tag(tag)).assignTo((Reference)main).assignAndGet();
            this.soft.assertThat((Object)tag).isEqualTo((Object)Tag.of((String)tag.getName(), (String)main.getHash()));
        } else {
            ((AssignTagBuilder)this.api.assignTag().tag(tag)).assignTo((Reference)main).assign();
            tag = Tag.of((String)tag.getName(), (String)main.getHash());
        }
        if (this.isV2()) {
            this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api.assignBranch().branch(branch)).assignTo((Reference)main).assignAndGet()).isInstanceOf(NessieReferenceConflictException.class);
        } else {
            this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api.assignBranch().branch(branch)).assignTo((Reference)main).assign()).isInstanceOf(NessieReferenceConflictException.class);
        }
        if (this.isV2()) {
            branchAssigned = ((AssignBranchBuilder)this.api.assignBranch().branch(branch1)).assignTo((Reference)main).assignAndGet();
            this.soft.assertThat((Object)branchAssigned).isEqualTo((Object)Branch.of((String)branch.getName(), (String)main.getHash()));
        } else {
            ((AssignBranchBuilder)this.api.assignBranch().branch(branch1)).assignTo((Reference)main).assign();
            branchAssigned = Branch.of((String)branch.getName(), (String)main.getHash());
        }
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1, tag, branchAssigned});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).get()).isEqualTo((Object)tag);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).get()).isEqualTo((Object)branchAssigned);
        if (this.isV2()) {
            deleted = ((DeleteTagBuilder)this.api().deleteTag().tag(tag)).getAndDelete();
            this.soft.assertThat((Object)deleted).isEqualTo((Object)tag);
        } else {
            ((DeleteTagBuilder)this.api().deleteTag().tag(tag)).delete();
        }
        if (this.isV2()) {
            this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).getAndDelete()).isInstanceOf(NessieReferenceConflictException.class);
        } else {
            this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete()).isInstanceOf(NessieReferenceConflictException.class);
        }
        if (this.isV2()) {
            deleted = ((DeleteBranchBuilder)this.api().deleteBranch().branch(branchAssigned)).getAndDelete();
            this.soft.assertThat((Object)deleted).isEqualTo((Object)branchAssigned);
        } else {
            ((DeleteBranchBuilder)this.api().deleteBranch().branch(branchAssigned)).delete();
        }
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThatThrownBy(() -> this.createReference(Tag.of((String)"tag2", null), main.getName())).isInstanceOf(NessieBadRequestException.class);
        Branch branch2 = this.createReference(Branch.of((String)"branch2", null), main.getName());
        this.soft.assertThat((Object)branch2).isEqualTo((Object)Branch.of((String)"branch2", (String)EMPTY));
        String refName = "does-not-exist";
        this.soft.assertThatThrownBy(() -> this.api().getReference().refName(refName).get()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api().assignBranch().branch(Branch.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assign()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)this.api().assignTag().tag(Tag.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assign()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(Branch.of((String)refName, (String)main.getHash()))).delete()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)this.api().deleteTag().tag(Tag.of((String)refName, (String)main.getHash()))).delete()).isInstanceOf(NessieNotFoundException.class);
        if (this.isV2()) {
            this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api().assignBranch().branch(Branch.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assignAndGet()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)this.api().assignTag().tag(Tag.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assignAndGet()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(Branch.of((String)refName, (String)main.getHash()))).getAndDelete()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)this.api().deleteTag().tag(Tag.of((String)refName, (String)main.getHash()))).getAndDelete()).isInstanceOf(NessieNotFoundException.class);
        }
    }

    @Test
    public void referencesWithLimitInFirstPage() throws Exception {
        Assumptions.assumeThat((boolean)BaseTestNessieApi.pagingSupported(this.api().getAllReferences())).isFalse();
        this.api().createReference().reference((Reference)Branch.of((String)"branch", null)).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetAllReferencesBuilder)this.api().getAllReferences().maxRecords(1)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Paging not supported");
    }

    @Test
    public void commitMergeTransplant() throws Exception {
        Branch main = this.api().getDefaultBranch();
        main = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("unrelated")}).commit();
        main = this.prepCommit(main, "common ancestor", new Operation[]{Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"unrelated"}))}).commit();
        Branch branch = this.createReference(Branch.of((String)"branch", (String)main.getHash()), main.getName());
        Branch otherBranch = this.createReference(Branch.of((String)"other", (String)main.getHash()), main.getName());
        if (this.isV2()) {
            CommitResponse resp = this.prepCommit(branch, "one", new Operation[]{this.dummyPut("a", "a")}).commitWithResponse();
            branch = resp.getTargetBranch();
            this.soft.assertThat(resp.getAddedContents()).hasSize(1);
            resp = this.prepCommit(branch, "two", new Operation[]{this.dummyPut("b", "a"), this.dummyPut("b", "b")}).commitWithResponse();
            branch = resp.getTargetBranch();
            ((ListAssert)this.soft.assertThat(resp.getAddedContents()).hasSize(2)).extracting(CommitResponse.AddedContent::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        } else {
            branch = this.prepCommit(branch, "one", new Operation[]{this.dummyPut("a", "a")}).commit();
            branch = this.prepCommit(branch, "two", new Operation[]{this.dummyPut("b", "a"), this.dummyPut("b", "b")}).commit();
        }
        this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(branch.getName())).get().getLogEntries()).hasSize(4);
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)branch)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).get().getLogEntries()).hasSize(2);
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).get().getEntries()).extracting(EntriesResponse.Entry::getName).isEmpty();
        ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).keepIndividualCommits(false)).merge();
        Reference main2 = this.api().getReference().refName(main.getName()).get();
        this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).get().getLogEntries()).hasSize(3);
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference(main2)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)otherBranch)).get().getEntries()).isEmpty();
        ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api().transplantCommitsIntoBranch().fromRefName(main.getName())).hashesToTransplant(Collections.singletonList(main2.getHash())).branch(otherBranch)).transplant();
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().refName(otherBranch.getName())).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetContentBuilder)this.api().getContent().key(ContentKey.of((String[])new String[]{"a", "a"})).key(ContentKey.of((String[])new String[]{"b", "a"})).key(ContentKey.of((String[])new String[]{"b", "b"})).refName(main.getName())).get()).containsKeys((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitParents() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Branch initialCommit = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("initial")}).commit();
        main = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("test1")}).commit();
        ((ListAssert)((ObjectAssert)this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).maxRecords(1)).get().getLogEntries()).map(logEntry -> logEntry.getCommitMeta().getParentCommitHashes()).first()).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{initialCommit.getHash()});
        Branch branch = this.createReference(Branch.of((String)"branch", (String)main.getHash()), main.getName());
        branch = this.prepCommit(branch, "one", new Operation[]{this.dummyPut("a", "a")}).commit();
        Reference mainParent = this.api().getReference().refName(main.getName()).get();
        ((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).merge();
        ((ListAssert)((ObjectAssert)this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).maxRecords(1)).get().getLogEntries()).map(logEntry -> logEntry.getCommitMeta().getParentCommitHashes()).first()).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{mainParent.getHash(), branch.getHash()});
    }

    @Test
    public void diff() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Branch branch1 = this.createReference(Branch.of((String)"b1", (String)main.getHash()), main.getName());
        Branch branch2 = this.createReference(Branch.of((String)"b2", (String)main.getHash()), main.getName());
        branch1 = this.prepCommit(branch1, "c1", new Operation[]{this.dummyPut("1", "1"), this.dummyPut("1", "2"), this.dummyPut("1", "3")}).commit();
        branch2 = this.prepCommit(branch2, "c2", new Operation[]{this.dummyPut("1", "1"), this.dummyPut("3", "1"), this.dummyPut("4", "1")}).commit();
        ContentKey key11 = ContentKey.of((String[])new String[]{"1", "1"});
        ContentKey key12 = ContentKey.of((String[])new String[]{"1", "2"});
        ContentKey key13 = ContentKey.of((String[])new String[]{"1", "3"});
        ContentKey key31 = ContentKey.of((String[])new String[]{"3", "1"});
        ContentKey key41 = ContentKey.of((String[])new String[]{"4", "1"});
        Map contents1 = ((GetContentBuilder)this.api().getContent().reference((Reference)branch1)).key(key11).key(key12).key(key13).get();
        Map contents2 = ((GetContentBuilder)this.api().getContent().reference((Reference)branch2)).key(key11).key(key31).key(key41).get();
        DiffResponse diff1response = this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).get();
        List diff1 = diff1response.getDiffs();
        if (this.isV2()) {
            this.soft.assertThat((Object)diff1response.getEffectiveFromReference()).isEqualTo((Object)branch1);
            this.soft.assertThat((Object)diff1response.getEffectiveToReference()).isEqualTo((Object)branch2);
        }
        this.soft.assertThat(diff1).containsExactlyInAnyOrder((Object[])new DiffResponse.DiffEntry[]{DiffResponse.DiffEntry.diffEntry((ContentKey)key11, (Content)((Content)contents1.get(key11)), (Content)((Content)contents2.get(key11))), DiffResponse.DiffEntry.diffEntry((ContentKey)key12, (Content)((Content)contents1.get(key12)), null), DiffResponse.DiffEntry.diffEntry((ContentKey)key13, (Content)((Content)contents1.get(key13)), null), DiffResponse.DiffEntry.diffEntry((ContentKey)key31, null, (Content)((Content)contents2.get(key31))), DiffResponse.DiffEntry.diffEntry((ContentKey)key41, null, (Content)((Content)contents2.get(key41)))});
        List diff2 = this.api().getDiff().fromRefName(branch1.getName()).toRef((Reference)branch2).get().getDiffs();
        List diff3 = this.api().getDiff().fromRef((Reference)branch1).toRefName(branch2.getName()).get().getDiffs();
        this.soft.assertThat(diff1).isEqualTo((Object)diff2).isEqualTo((Object)diff3);
        if (BaseTestNessieApi.pagingSupported(this.api().getDiff())) {
            ArrayList all = new ArrayList();
            String token = null;
            for (int i = 0; i < 5; ++i) {
                DiffResponse resp = ((GetDiffBuilder)((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).maxRecords(1)).pageToken(token)).get();
                all.addAll(resp.getDiffs());
                token = resp.getToken();
                if (i == 4) {
                    this.soft.assertThat(token).isNull();
                    continue;
                }
                this.soft.assertThat(token).isNotNull();
            }
            this.soft.assertThat(all).containsExactlyInAnyOrderElementsOf((Iterable)diff1);
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf((Iterable)diff1);
        }
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void diffWithLimitInFirstPage() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Assumptions.assumeThat((boolean)BaseTestNessieApi.pagingSupported(this.api().getDiff())).isFalse();
        Branch branch1 = this.createReference(Branch.of((String)"b1", (String)main.getHash()), main.getName());
        Branch branch2 = this.createReference(Branch.of((String)"b2", (String)main.getHash()), main.getName());
        Branch from = this.prepCommit(branch1, "c1", new Operation[]{this.dummyPut("1", "1")}).commit();
        Branch to = this.prepCommit(branch2, "c2", new Operation[]{this.dummyPut("2", "2")}).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetDiffBuilder)this.api().getDiff().maxRecords(1)).fromRef((Reference)from).toRef((Reference)to).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Paging not supported");
    }

    @Test
    public void commitLog() throws Exception {
        Branch main = this.api().getDefaultBranch();
        for (int i = 0; i < 10; ++i) {
            main = this.prepCommit(main, "c-" + i, new Operation[]{this.dummyPut("c", Integer.toString(i))}).commit();
        }
        List notPaged = ((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).get().getLogEntries();
        this.soft.assertThat(notPaged).hasSize(10);
        ArrayList all = new ArrayList();
        String token = null;
        for (int i = 0; i < 10; ++i) {
            LogResponse resp = ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).maxRecords(1)).pageToken(token)).get();
            all.addAll(resp.getLogEntries());
            token = resp.getToken();
            if (i == 9) {
                this.soft.assertThat(token).isNull();
                continue;
            }
            this.soft.assertThat(token).isNotNull();
        }
        this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
        this.soft.assertAll();
        this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
    }

    @Test
    public void allReferences() throws Exception {
        Branch main = this.api().getDefaultBranch();
        ArrayList<Object> expect = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            expect.add(this.createReference(Branch.of((String)("b-" + i), (String)main.getHash()), main.getName()));
            expect.add(this.createReference(Tag.of((String)("t-" + i), (String)main.getHash()), main.getName()));
        }
        expect.add(main);
        List notPaged = this.api().getAllReferences().get().getReferences();
        this.soft.assertThat(notPaged).containsExactlyInAnyOrderElementsOf(expect);
        if (BaseTestNessieApi.pagingSupported(this.api().getAllReferences())) {
            ArrayList all = new ArrayList();
            String token = null;
            for (int i = 0; i < 11; ++i) {
                ReferencesResponse resp = ((GetAllReferencesBuilder)((GetAllReferencesBuilder)this.api().getAllReferences().maxRecords(1)).pageToken(token)).get();
                all.addAll(resp.getReferences());
                token = resp.getToken();
                if (i == 10) {
                    this.soft.assertThat(token).isNull();
                    continue;
                }
                this.soft.assertThat(token).isNotNull();
            }
            this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
            this.soft.assertAll();
            this.soft.assertThat(((GetAllReferencesBuilder)this.api().getAllReferences().maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
        }
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void contents() throws Exception {
        Branch main = this.api().getDefaultBranch();
        CommitResponse committed = this.prepCommit(main, "commit", (Operation[])IntStream.range(0, 10).mapToObj(i -> this.dummyPut("b.b", "c", Integer.toString(i))).toArray(Operation[]::new)).commitWithResponse();
        main = committed.getTargetBranch();
        List allKeys = IntStream.range(0, 10).mapToObj(i -> ContentKey.of((String[])new String[]{"b.b", "c", Integer.toString(i)})).collect(Collectors.toList());
        GetMultipleContentsResponse resp = ((GetContentBuilder)this.api().getContent().refName(main.getName())).keys(allKeys).getWithResponse();
        ContentKey singleKey = ContentKey.of((String[])new String[]{"b.b", "c", "3"});
        this.soft.assertThat((Object)((GetContentBuilder)this.api().getContent().refName(main.getName())).getSingle(singleKey)).extracting(new Function[]{ContentResponse::getEffectiveReference, ContentResponse::getContent}).containsExactly(new Object[]{main, IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4, (String)((String)committed.toAddedContentsMap().get(singleKey)))});
        this.soft.assertThat((Object)resp.getEffectiveReference()).isEqualTo((Object)main);
        ((MapAssert)this.soft.assertThat(resp.toContentsMap()).containsOnlyKeys(allKeys)).hasSize(allKeys.size());
        ContentKey key = ContentKey.of((String[])new String[]{"b.b", "c", "1"});
        this.soft.assertThat((Object)((GetContentBuilder)this.api().getContent().refName(main.getName())).getSingle(key)).isEqualTo((Object)ContentResponse.of((Content)IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4, (String)((String)committed.toAddedContentsMap().get(key))), (Reference)main));
    }

    @Test
    public void entries() throws Exception {
        Branch main0 = this.api().getDefaultBranch();
        Branch main = this.prepCommit(main0, "commit", (Operation[])IntStream.range(0, 10).mapToObj(i -> this.dummyPut("c", Integer.toString(i))).toArray(Operation[]::new)).commit();
        EntriesResponse response = ((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).withContent(this.isV2()).get();
        if (this.isV2()) {
            this.soft.assertThat((Object)response.getEffectiveReference()).isEqualTo((Object)main);
            ((AbstractListAssert)this.soft.assertThat(response.getEntries()).extracting(EntriesResponse.Entry::getContent).doesNotContainNull()).isNotEmpty();
        }
        List notPaged = response.getEntries();
        this.soft.assertThat(notPaged).hasSize(10);
        if (BaseTestNessieApi.pagingSupported(this.api().getEntries())) {
            ArrayList all = new ArrayList();
            String token = null;
            for (int i2 = 0; i2 < 10; ++i2) {
                EntriesResponse resp = ((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().withContent(this.isV2()).reference((Reference)main)).maxRecords(1)).pageToken(token)).get();
                all.addAll(resp.getEntries());
                token = resp.getToken();
                if (i2 == 9) {
                    this.soft.assertThat(token).isNull();
                    continue;
                }
                this.soft.assertThat(token).isNotNull();
            }
            this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
            this.soft.assertAll();
            this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().withContent(this.isV2()).reference((Reference)main)).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
        }
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    public void entryContentId() throws Exception {
        Branch main = this.prepCommit(this.api().getDefaultBranch(), "commit", new Operation[]{this.dummyPut("test-table")}).commit();
        ((AbstractListAssert)this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).stream()).isNotEmpty()).allSatisfy(e -> Assertions.assertThat((String)e.getContentId()).isNotNull());
    }

    @Test
    public void entriesWithLimitInFirstPage() throws Exception {
        Assumptions.assumeThat((boolean)BaseTestNessieApi.pagingSupported(this.api().getEntries())).isFalse();
        Branch main = this.prepCommit(this.api().getDefaultBranch(), "commit", new Operation[]{this.dummyPut("t1"), this.dummyPut("t2")}).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().maxRecords(1)).reference((Reference)main)).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Paging not supported");
    }

    @Test
    public void namespaces() throws Exception {
        Namespace namespace4WithId;
        Namespace namespace3WithId;
        Namespace namespace2WithId;
        Namespace namespace1WithId;
        Branch main = this.api().getDefaultBranch();
        String mainName = main.getName();
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().reference((Reference)main)).namespace(Namespace.EMPTY)).get().getNamespaces()).isEmpty();
        Namespace namespace1 = Namespace.of((String[])new String[]{"a"});
        Namespace namespace2 = Namespace.of((String[])new String[]{"a", "b.b"});
        Namespace namespace3 = Namespace.of((String[])new String[]{"a", "b.bbbb"});
        Namespace namespace4 = Namespace.of((String[])new String[]{"a", "b.b", "c"});
        if (this.isV2()) {
            CreateNamespaceResult resp1 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace1)).createWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)resp1.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
            CreateNamespaceResult resp2 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace2)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp2.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main)).isNotEqualTo((Object)resp1.getEffectiveBranch());
            CreateNamespaceResult resp3 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace3)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp3.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)resp1.getEffectiveBranch())).isNotEqualTo((Object)resp2.getEffectiveBranch());
            CreateNamespaceResult resp4 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace4)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp4.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)resp2.getEffectiveBranch())).isNotEqualTo((Object)resp3.getEffectiveBranch());
            namespace1WithId = resp1.getNamespace();
            namespace2WithId = resp2.getNamespace();
            namespace3WithId = resp3.getNamespace();
            namespace4WithId = resp4.getNamespace();
            for (Map.Entry c : ImmutableMap.of((Object)Namespace.EMPTY, Collections.singletonList(namespace1WithId), (Object)namespace1, Arrays.asList(namespace2WithId, namespace3WithId), (Object)namespace2, Collections.singletonList(namespace4WithId), (Object)namespace3, Collections.emptyList(), (Object)namespace4, Collections.emptyList()).entrySet()) {
                ((ListAssert)this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace((Namespace)c.getKey())).onlyDirectChildren(true).get().getNamespaces()).describedAs("for namespace %s", new Object[]{c.getKey()})).containsExactlyInAnyOrderElementsOf((Iterable)c.getValue());
            }
        } else {
            namespace1WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace1)).create();
            namespace2WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace2)).create();
            namespace3WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace3)).create();
            namespace4WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace4)).create();
        }
        for (Map.Entry c : ImmutableMap.of((Object)Namespace.EMPTY, Arrays.asList(namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId), (Object)namespace1, Arrays.asList(namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId), (Object)namespace2, Arrays.asList(namespace2WithId, namespace4WithId), (Object)namespace3, Collections.singletonList(namespace3WithId), (Object)namespace4, Collections.singletonList(namespace4WithId)).entrySet()) {
            ((ListAssert)this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace((Namespace)c.getKey())).get().getNamespaces()).describedAs("for namespace %s", new Object[]{c.getKey()})).containsExactlyInAnyOrderElementsOf((Iterable)c.getValue());
        }
        GetNamespacesResponse getMultiple = ((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get();
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            this.soft.assertThat((Object)getMultiple.getEffectiveReference()).isEqualTo((Object)main);
        }
        this.soft.assertThat(getMultiple.getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(namespace1)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(namespace2)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace2WithId, namespace4WithId});
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((List)namespace1.getElements())).key(ContentKey.of((List)namespace2.getElements())).key(ContentKey.of((List)namespace3.getElements())).key(ContentKey.of((List)namespace4.getElements())).get()).containsEntry((Object)ContentKey.of((List)namespace1.getElements()), (Object)namespace1WithId)).containsEntry((Object)ContentKey.of((List)namespace2.getElements()), (Object)namespace2WithId)).containsEntry((Object)ContentKey.of((List)namespace3.getElements()), (Object)namespace3WithId)).containsEntry((Object)ContentKey.of((List)namespace4.getElements()), (Object)namespace4WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace1)).get()).isEqualTo((Object)namespace1WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace3)).get()).isEqualTo((Object)namespace3WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace4)).get()).isEqualTo((Object)namespace4WithId);
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            UpdateNamespaceResult update = ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).updateProperty("foo", "bar").updateProperty("bar", "baz").updateWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)update.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
        } else {
            ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).updateProperty("foo", "bar").updateProperty("bar", "baz").update();
        }
        Namespace namespace2update = (Namespace)((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b"})).get().get(ContentKey.of((String[])new String[]{"a", "b.b"}));
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2update);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update, namespace3WithId, namespace4WithId});
        if (this.isV2()) {
            UpdateNamespaceResult updateResponse = ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).removeProperty("foo").updateWithResponse();
            this.soft.assertThat((Object)updateResponse.getEffectiveBranch()).isNotEqualTo((Object)main);
            main = updateResponse.getEffectiveBranch();
        } else {
            ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).removeProperty("foo").update();
        }
        Namespace namespace2update2 = (Namespace)((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b"})).get().get(ContentKey.of((String[])new String[]{"a", "b.b"}));
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2update2);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update2, namespace3WithId, namespace4WithId});
        if (this.isV2()) {
            this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace2)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class);
        }
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            DeleteNamespaceResult response = ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).deleteWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)response.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
        } else {
            ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete();
        }
        this.soft.assertThat(((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b", "c"})).get()).isEmpty();
        this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace4)).get()).isInstanceOf(NessieNamespaceNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update2, namespace3WithId});
        this.soft.assertThatCode(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace2)).delete()).doesNotThrowAnyException();
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitLogForNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch branch = this.createReference(Branch.of((String)"commitLogForNamelessReference", (String)main.getHash()), main.getName());
        for (int i = 0; i < 5; ++i) {
            branch = this.prepCommit(branch, "c-" + i, new Operation[]{this.dummyPut("c", Integer.toString(i))}).commit();
        }
        List log = ((GetCommitLogBuilder)this.api().getCommitLog().hashOnRef(branch.getHash())).stream().collect(Collectors.toList());
        Assertions.assertThat(log).hasSize(5);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testDiffByNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch fromRef = this.createReference(Branch.of((String)"testFrom", (String)main.getHash()), main.getName());
        Branch toRef = this.createReference(Branch.of((String)"testTo", (String)main.getHash()), main.getName());
        toRef = this.prepCommit(toRef, "commit", new Operation[]{this.dummyPut("c")}).commit();
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromRef((Reference)fromRef).toHashOnRef(toRef.getHash()).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromHashOnRef(fromRef.getHash()).toHashOnRef(toRef.getHash()).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromHashOnRef(toRef.getHash()).toRef((Reference)fromRef).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Object)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNull();
        });
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void fetchEntriesByNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch branch = this.createReference(Branch.of((String)"fetchEntriesByNamelessReference", (String)main.getHash()), main.getName());
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (int)1, (int)1, (String)"select * from table", (String)"Dremio");
        branch = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)ta)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)this.api().getEntries().hashOnRef(branch.getHash())).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)a, (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)b, (Object)Content.Type.ICEBERG_VIEW)});
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }
}

