/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.Hash;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableHiveDatabase;
import org.projectnessie.model.ImmutableHiveTable;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;

public abstract class AbstractTestRest {
    public static final String COMMA_VALID_HASH_1 = ",1234567890123456789012345678901234567890123456789012345678901234";
    public static final String COMMA_VALID_HASH_2 = ",1234567890123456789012345678901234567890";
    public static final String COMMA_VALID_HASH_3 = ",1234567890123456";
    private NessieClient client;
    private TreeApi tree;
    private ContentsApi contents;
    private HttpClient httpClient;

    protected void init(URI uri) {
        this.client = NessieClient.builder().withUri(uri).build();
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.httpClient = HttpClient.builder().setBaseUri(uri).setObjectMapper(mapper).build();
        this.httpClient.register((ResponseFilter)new NessieHttpResponseFilter(mapper));
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    void createReferences() throws NessieNotFoundException {
        String mainHash = this.tree.getReferenceByName("main").getHash();
        String tagName1 = "createReferences_tag1";
        String tagName2 = "createReferences_tag2";
        String branchName1 = "createReferences_branch1";
        String branchName2 = "createReferences_branch2";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Tag.of((String)tagName1, null))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot create an unassigned tag reference"), () -> {
            Reference refTag1 = this.tree.createReference((Reference)Tag.of((String)tagName2, (String)mainHash));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName2, (String)mainHash), (Object)refTag1);
        }, () -> {
            Reference refBranch1 = this.tree.createReference((Reference)Branch.of((String)branchName1, null));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName1, (String)mainHash), (Object)refBranch1);
        }, () -> {
            Reference refBranch2 = this.tree.createReference((Reference)Branch.of((String)branchName2, (String)mainHash));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)mainHash), (Object)refBranch2);
        }, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Hash.of((String)"cafebabedeafbeef"))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Only tag and branch references can be created")});
    }

    @ParameterizedTest
    @ValueSource(strings={"normal", "with-no_space", "slash/thing"})
    void referenceNames(String refNamePart) throws NessieNotFoundException, NessieConflictException {
        String tagName = "tag" + refNamePart;
        String branchName = "branch" + refNamePart;
        String branchName2 = "branch2" + refNamePart;
        Reference main = this.tree.getReferenceByName("main");
        String someHash = main.getHash();
        Reference createdTag = this.tree.createReference((Reference)Tag.of((String)tagName, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Tag.of((String)tagName, (String)someHash), (Object)createdTag);
        Reference createdBranch1 = this.tree.createReference((Reference)Branch.of((String)branchName, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName, (String)someHash), (Object)createdBranch1);
        Reference createdBranch2 = this.tree.createReference((Reference)Branch.of((String)branchName2, (String)someHash));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Branch.of((String)branchName2, (String)someHash), (Object)createdBranch2);
        Map references = this.tree.getAllReferences().stream().filter(r -> "main".equals(r.getName()) || r.getName().endsWith(refNamePart)).collect(Collectors.toMap(Reference::getName, Function.identity()));
        Assertions.assertThat(references).containsAllEntriesOf((Map)ImmutableMap.of((Object)main.getName(), (Object)main, (Object)createdTag.getName(), (Object)createdTag, (Object)createdBranch1.getName(), (Object)createdBranch1, (Object)createdBranch2.getName(), (Object)createdBranch2));
        Assertions.assertThat((Object)((Reference)references.get(main.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdTag.getName()))).isInstanceOf(Tag.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch1.getName()))).isInstanceOf(Branch.class);
        Assertions.assertThat((Object)((Reference)references.get(createdBranch2.getName()))).isInstanceOf(Branch.class);
        Reference tagRef = (Reference)references.get(tagName);
        Reference branchRef = (Reference)references.get(branchName);
        Reference branchRef2 = (Reference)references.get(branchName2);
        String tagHash = tagRef.getHash();
        String branchHash = branchRef.getHash();
        String branchHash2 = branchRef2.getHash();
        Assertions.assertThat((Object)this.tree.getReferenceByName(tagName)).isEqualTo((Object)tagRef);
        Assertions.assertThat((Object)this.tree.getReferenceByName(branchName)).isEqualTo((Object)branchRef);
        EntriesResponse entries = this.tree.getEntries(tagName, EntriesParams.empty());
        Assertions.assertThat((Object)entries).isNotNull();
        entries = this.tree.getEntries(branchName, EntriesParams.empty());
        Assertions.assertThat((Object)entries).isNotNull();
        LogResponse log = this.tree.getCommitLog(tagName, CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        log = this.tree.getCommitLog(branchName, CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        ImmutablePut op = ImmutablePut.builder().key(ContentsKey.of((String[])new String[]{"some-key"})).contents((Contents)IcebergTable.of((String)"foo")).build();
        ImmutableOperations ops = ImmutableOperations.builder().addOperations((Operation)op).commitMeta(CommitMeta.fromMessage((String)"One dummy op")).build();
        this.tree.commitMultipleOperations(branchName, branchHash, (Operations)ops);
        log = this.tree.getCommitLog(branchName, CommitLogParams.empty());
        String newHash = ((CommitMeta)log.getOperations().get(0)).getHash();
        this.tree.assignTag(tagName, tagHash, Tag.of((String)tagName, (String)newHash));
        this.tree.assignBranch(branchName, newHash, Branch.of((String)branchName, (String)newHash));
        this.tree.mergeRefIntoBranch(branchName2, branchHash2, (Merge)ImmutableMerge.builder().fromHash(newHash).build());
        this.tree.deleteTag(tagName, newHash);
        this.tree.deleteBranch(branchName, newHash);
    }

    @Test
    public void filterCommitLogByAuthor() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByAuthor", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)filterCommitLogByAuthor);
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.author == 'author-3'").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor);
        log.getOperations().forEach(commit -> Assertions.assertThat((String)commit.getAuthor()).isEqualTo("author-3"));
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.author == 'author-3' && commit.committer == 'random-committer'").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.author == 'author-3' && commit.committer == ''").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor);
        log.getOperations().forEach(commit -> {
            Assertions.assertThat((String)commit.getAuthor()).isEqualTo("author-3");
            Assertions.assertThat((String)commit.getCommitter()).isEmpty();
        });
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.author in ['author-1', 'author-3', 'author-4']").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 3);
        log.getOperations().forEach(commit -> {
            Assertions.assertThat((List)ImmutableList.of((Object)"author-1", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()});
            Assertions.assertThat((String)commit.getCommitter()).isEmpty();
        });
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("!(commit.author in ['author-1', 'author-0'])").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 3);
        log.getOperations().forEach(commit -> {
            Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-3", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()});
            Assertions.assertThat((String)commit.getCommitter()).isEmpty();
        });
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.author.matches('au.*-(2|4)')").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(commitsPerAuthor * 2);
        log.getOperations().forEach(commit -> {
            Assertions.assertThat((List)ImmutableList.of((Object)"author-2", (Object)"author-4")).contains((Object[])new String[]{commit.getAuthor()});
            Assertions.assertThat((String)commit.getCommitter()).isEmpty();
        });
    }

    @Test
    public void filterCommitLogByTimeRange() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByTimeRange", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)filterCommitLogByAuthor);
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        int expectedTotalSize = numAuthors * commitsPerAuthor;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        Instant initialCommitTime = ((CommitMeta)log.getOperations().get(log.getOperations().size() - 1)).getCommitTime();
        Assertions.assertThat((Instant)initialCommitTime).isNotNull();
        Instant lastCommitTime = ((CommitMeta)log.getOperations().get(0)).getCommitTime();
        Assertions.assertThat((Instant)lastCommitTime).isNotNull();
        Instant fiveMinLater = initialCommitTime.plus(5L, ChronoUnit.MINUTES);
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression(String.format("timestamp(commit.commitTime) > timestamp('%s')", initialCommitTime)).build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize - 1);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(initialCommitTime));
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression(String.format("timestamp(commit.commitTime) < timestamp('%s')", fiveMinLater)).build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isBefore(fiveMinLater));
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression(String.format("timestamp(commit.commitTime) > timestamp('%s') && timestamp(commit.commitTime) < timestamp('%s')", initialCommitTime, lastCommitTime)).build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize - 2);
        log.getOperations().forEach(commit -> Assertions.assertThat((Instant)commit.getCommitTime()).isAfter(initialCommitTime).isBefore(lastCommitTime));
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression(String.format("timestamp(commit.commitTime) > timestamp('%s')", fiveMinLater)).build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
    }

    @Test
    public void filterCommitLogByProperties() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch filterCommitLogByAuthor = Branch.of((String)"filterCommitLogByProperties", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)filterCommitLogByAuthor);
        Assertions.assertThat((Object)branch).isEqualTo((Object)filterCommitLogByAuthor);
        int numAuthors = 5;
        int commitsPerAuthor = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, numAuthors, commitsPerAuthor, currentHash);
        LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.properties['prop1'] == 'val1'").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numAuthors * commitsPerAuthor);
        log.getOperations().forEach(commit -> Assertions.assertThat((String)((String)commit.getProperties().get("prop1"))).isEqualTo("val1"));
        log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().expression("commit.properties['prop1'] == 'val3'").build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).isEmpty();
    }

    @Test
    public void filterCommitLogByCommitRange() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch b = Branch.of((String)"filterCommitLogByCommitRange", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)b);
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        int numCommits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, numCommits, currentHash);
        LogResponse entireLog = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getOperations()).hasSize(numCommits);
        String startHash = ((CommitMeta)entireLog.getOperations().get(numCommits / 2)).getHash();
        String endHash = ((CommitMeta)entireLog.getOperations().get(0)).getHash();
        LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().startHash(startHash).endHash(endHash).build());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(numCommits / 2 + 1);
        int i = 0;
        for (int j = numCommits - 1; i < j; ++i, --j) {
            startHash = ((CommitMeta)entireLog.getOperations().get(j)).getHash();
            endHash = ((CommitMeta)entireLog.getOperations().get(i)).getHash();
            log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().startHash(startHash).endHash(endHash).build());
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getOperations()).hasSize(numCommits - i * 2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getOperations()).subList(i, j + 1)).containsExactlyElementsOf((Iterable)log.getOperations());
        }
    }

    private void createCommits(Reference branch, int numAuthors, int commitsPerAuthor, String currentHash) throws NessieNotFoundException, NessieConflictException {
        for (int j = 0; j < numAuthors; ++j) {
            String author = "author-" + j;
            for (int i = 0; i < commitsPerAuthor; ++i) {
                String nextHash = this.tree.commitMultipleOperations(branch.getName(), currentHash, (Operations)ImmutableOperations.builder().commitMeta((CommitMeta)CommitMeta.builder().author(author).message("committed-by-" + author).properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).addOperations((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"table" + i}), (Contents)IcebergTable.of((String)("some-file-" + i)))).build()).getHash();
                Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
                currentHash = nextHash;
            }
        }
    }

    @Test
    void commitLogPagingAndFilteringByAuthor() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.tree.getReferenceByName("main").getHash();
        String branchName = "commitLogPagingAndFiltering";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.tree.createReference((Reference)branch);
        int numAuthors = 3;
        int commits = 45;
        int pageSizeHint = 10;
        int expectedTotalSize = numAuthors * commits;
        this.createCommits((Reference)branch, numAuthors, commits, someHash);
        LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)log).isNotNull();
        Assertions.assertThat((List)log.getOperations()).hasSize(expectedTotalSize);
        String author = "author-1";
        List<String> messagesOfAuthorOne = log.getOperations().stream().filter(c -> author.equals(c.getAuthor())).map(CommitMeta::getMessage).collect(Collectors.toList());
        this.verifyPaging(branchName, commits, pageSizeHint, messagesOfAuthorOne, author);
        List allMessages = log.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList());
        List completeLog = StreamingUtil.getCommitLogStream((TreeApi)this.tree, (String)branchName, (CommitLogParams)CommitLogParams.builder().maxRecords(Integer.valueOf(pageSizeHint)).build()).collect(Collectors.toList());
        Assertions.assertThat(completeLog.stream().map(CommitMeta::getMessage)).containsExactlyElementsOf(allMessages);
    }

    @Test
    void commitLogPaging() throws NessieNotFoundException, NessieConflictException {
        String someHash = this.tree.getReferenceByName("main").getHash();
        String branchName = "commitLogPaging";
        Branch branch = Branch.of((String)branchName, (String)someHash);
        this.tree.createReference((Reference)branch);
        int commits = 95;
        int pageSizeHint = 10;
        String currentHash = someHash;
        ArrayList<String> allMessages = new ArrayList<String>();
        for (int i = 0; i < commits; ++i) {
            String msg = "message-for-" + i;
            allMessages.add(msg);
            String nextHash = this.tree.commitMultipleOperations(branchName, currentHash, (Operations)ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)msg)).addOperations((Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"table"}), (Contents)IcebergTable.of((String)("some-file-" + i)))).build()).getHash();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)currentHash, (Object)nextHash);
            currentHash = nextHash;
        }
        Collections.reverse(allMessages);
        this.verifyPaging(branchName, commits, pageSizeHint, allMessages, null);
        List completeLog = StreamingUtil.getCommitLogStream((TreeApi)this.tree, (String)branchName, (CommitLogParams)CommitLogParams.builder().maxRecords(Integer.valueOf(pageSizeHint)).build()).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(completeLog.stream().map(CommitMeta::getMessage).collect(Collectors.toList()), allMessages);
    }

    private void verifyPaging(String branchName, int commits, int pageSizeHint, List<String> commitMessages, String filterByAuthor) throws NessieNotFoundException {
        String pageToken = null;
        for (int pos = 0; pos < commits; pos += pageSizeHint) {
            String queryExpression = null;
            if (null != filterByAuthor) {
                queryExpression = String.format("commit.author=='%s'", filterByAuthor);
            }
            LogResponse response = this.tree.getCommitLog(branchName, CommitLogParams.builder().maxRecords(Integer.valueOf(pageSizeHint)).pageToken(pageToken).expression(queryExpression).build());
            if (pos + pageSizeHint > commits) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMore());
                org.junit.jupiter.api.Assertions.assertNull((Object)response.getToken());
                org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, commitMessages.size()), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
                break;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMore());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)response.getToken());
            org.junit.jupiter.api.Assertions.assertEquals(commitMessages.subList(pos, pos + pageSizeHint), response.getOperations().stream().map(CommitMeta::getMessage).collect(Collectors.toList()));
            pageToken = response.getToken();
        }
    }

    @Test
    void multiget() throws NessieNotFoundException, NessieConflictException {
        String branch = "foo";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"foo", null));
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        IcebergTable tb = IcebergTable.of((String)"path2");
        this.tree.commitMultipleOperations("foo", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(a).contents((Contents)ta).build()).commitMeta(CommitMeta.fromMessage((String)"commit 1")).build());
        this.tree.commitMultipleOperations("foo", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(b).contents((Contents)tb).build()).commitMeta(CommitMeta.fromMessage((String)"commit 2")).build());
        List keys = this.contents.getMultipleContents("foo", null, MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{a, b, ContentsKey.of((String[])new String[]{"noexist"})})).getContents();
        List<MultiGetContentsResponse.ContentsWithKey> expected = Arrays.asList(MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)a, (Contents)ta), MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)b, (Contents)tb));
        Assertions.assertThat((List)keys).containsExactlyInAnyOrderElementsOf(expected);
        this.tree.deleteBranch("foo", this.tree.getReferenceByName("foo").getHash());
    }

    static Stream<ContentAndOperationType> contentAndOperationTypes() {
        return Stream.of(new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg"}), (Contents)IcebergTable.of((String)"/iceberg/table"))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.DREMIO).sqlText("SELECT foo FROM dremio").build())), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_hive"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.HIVE).sqlText("SELECT foo FROM hive").build())), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_presto"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.PRESTO).sqlText("SELECT foo FROM presto").build())), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark"}), (Contents)ImmutableSqlView.builder().dialect(SqlView.Dialect.SPARK).sqlText("SELECT foo FROM spark").build())), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta"}), (Contents)ImmutableDeltaLakeTable.builder().addCheckpointLocationHistory("checkpoint").addMetadataLocationHistory("metadata").build())), new ContentAndOperationType(Contents.Type.HIVE_DATABASE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivedb"}), (Contents)ImmutableHiveDatabase.builder().databaseDefinition(new byte[]{1, 2, 3}).build())), new ContentAndOperationType(Contents.Type.HIVE_TABLE, (Operation)Operation.Put.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivetable"}), (Contents)ImmutableHiveTable.builder().tableDefinition(new byte[]{1, 2, 3}).build())), new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg_delete"}))), new ContentAndOperationType(Contents.Type.ICEBERG_TABLE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"iceberg_unchanged"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio_delete"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_dremio_unchanged"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark_delete"}))), new ContentAndOperationType(Contents.Type.VIEW, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"view_spark_unchanged"}))), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta_delete"}))), new ContentAndOperationType(Contents.Type.DELTA_LAKE_TABLE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"delta_unchanged"}))), new ContentAndOperationType(Contents.Type.HIVE_DATABASE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivedb_delete"}))), new ContentAndOperationType(Contents.Type.HIVE_DATABASE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivedb_unchanged"}))), new ContentAndOperationType(Contents.Type.HIVE_TABLE, (Operation)Operation.Delete.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivetable_delete"}))), new ContentAndOperationType(Contents.Type.HIVE_TABLE, (Operation)Operation.Unchanged.of((ContentsKey)ContentsKey.of((String[])new String[]{"hivetable_unchanged"}))));
    }

    @Test
    void veriryAllContentAndOperationTypes() throws NessieNotFoundException, NessieConflictException {
        String branchName = "contentAndOperationAll";
        Reference r = this.tree.createReference((Reference)Branch.of((String)branchName, null));
        this.tree.commitMultipleOperations(branchName, r.getHash(), (Operations)ImmutableOperations.builder().addAllOperations((Iterable)AbstractTestRest.contentAndOperationTypes().map(c -> c.operation).collect(Collectors.toList())).commitMeta(CommitMeta.fromMessage((String)"verifyAllContentAndOperationTypes")).build());
        List entries = this.tree.getEntries(branchName, EntriesParams.empty()).getEntries();
        List expect = AbstractTestRest.contentAndOperationTypes().filter(c -> c.operation instanceof Operation.Put).map(c -> EntriesResponse.Entry.builder().type(c.type).name(c.operation.getKey()).build()).collect(Collectors.toList());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @ParameterizedTest
    @MethodSource(value={"contentAndOperationTypes"})
    void verifyContentAndOperationTypesIndividually(ContentAndOperationType contentAndOperationType) throws NessieNotFoundException, NessieConflictException {
        String branchName = "contentAndOperation_" + contentAndOperationType;
        Reference r = this.tree.createReference((Reference)Branch.of((String)branchName, null));
        this.tree.commitMultipleOperations(branchName, r.getHash(), (Operations)ImmutableOperations.builder().addOperations(contentAndOperationType.operation).commitMeta(CommitMeta.fromMessage((String)("commit " + contentAndOperationType))).build());
        List entries = this.tree.getEntries(branchName, EntriesParams.empty()).getEntries();
        ContentsKey fixedContentKey = ContentsKey.of((List)contentAndOperationType.operation.getKey().getElements());
        List expect = contentAndOperationType.operation instanceof Operation.Put ? Collections.singletonList(EntriesResponse.Entry.builder().name(fixedContentKey).type(contentAndOperationType.type).build()) : Collections.emptyList();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expect);
    }

    @Test
    void filterEntriesByType() throws NessieNotFoundException, NessieConflictException {
        String branch = "filterTypes";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"filterTypes", null));
        ContentsKey a = ContentsKey.of((String[])new String[]{"a"});
        ContentsKey b = ContentsKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        ImmutableSqlView tb = ImmutableSqlView.builder().sqlText("select * from table").dialect(SqlView.Dialect.DREMIO).build();
        this.tree.commitMultipleOperations("filterTypes", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(a).contents((Contents)ta).build()).commitMeta(CommitMeta.fromMessage((String)"commit 1")).build());
        this.tree.commitMultipleOperations("filterTypes", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(b).contents((Contents)tb).build()).commitMeta(CommitMeta.fromMessage((String)"commit 2")).build());
        List entries = this.tree.getEntries("filterTypes", EntriesParams.empty()).getEntries();
        List<EntriesResponse.Entry> expected = Arrays.asList(EntriesResponse.Entry.builder().name(a).type(Contents.Type.ICEBERG_TABLE).build(), EntriesResponse.Entry.builder().name(b).type(Contents.Type.VIEW).build());
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        entries = this.tree.getEntries("filterTypes", EntriesParams.builder().expression("entry.contentType=='ICEBERG_TABLE'").build()).getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(0)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", EntriesParams.builder().expression("entry.contentType=='VIEW'").build()).getEntries();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(expected.get(1)), (Object)entries);
        entries = this.tree.getEntries("filterTypes", EntriesParams.builder().expression("entry.contentType in ['ICEBERG_TABLE', 'VIEW']").build()).getEntries();
        Assertions.assertThat((List)entries).containsExactlyInAnyOrderElementsOf(expected);
        this.tree.deleteBranch("filterTypes", this.tree.getReferenceByName("filterTypes").getHash());
    }

    @Test
    public void filterEntriesByNamespace() throws NessieConflictException, NessieNotFoundException {
        String branch = "filterEntriesByNamespace";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"filterEntriesByNamespace", null));
        ContentsKey first = ContentsKey.of((String[])new String[]{"a", "b", "c", "firstTable"});
        ContentsKey second = ContentsKey.of((String[])new String[]{"a", "b", "c", "secondTable"});
        ContentsKey third = ContentsKey.of((String[])new String[]{"a", "thirdTable"});
        ContentsKey fourth = ContentsKey.of((String[])new String[]{"a", "fourthTable"});
        this.tree.commitMultipleOperations("filterEntriesByNamespace", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(first).contents((Contents)IcebergTable.of((String)"path1")).build()).commitMeta(CommitMeta.fromMessage((String)"commit 1")).build());
        this.tree.commitMultipleOperations("filterEntriesByNamespace", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(second).contents((Contents)IcebergTable.of((String)"path2")).build()).commitMeta(CommitMeta.fromMessage((String)"commit 2")).build());
        this.tree.commitMultipleOperations("filterEntriesByNamespace", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(third).contents((Contents)IcebergTable.of((String)"path3")).build()).commitMeta(CommitMeta.fromMessage((String)"commit 3")).build());
        this.tree.commitMultipleOperations("filterEntriesByNamespace", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(fourth).contents((Contents)IcebergTable.of((String)"path4")).build()).commitMeta(CommitMeta.fromMessage((String)"commit 4")).build());
        List entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.empty()).getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.empty()).getEntries();
        ((ListAssert)Assertions.assertThat((List)entries).isNotNull()).hasSize(4);
        entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.builder().expression("entry.namespace.startsWith('a.b')").build()).getEntries();
        Assertions.assertThat((List)entries).hasSize(2);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a.b"));
        entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.builder().expression("entry.namespace.startsWith('a')").build()).getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        entries.forEach(e -> Assertions.assertThat((String)e.getName().getNamespace().name()).startsWith((CharSequence)"a"));
        entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.builder().expression("entry.namespace.startsWith('a.b.c.firstTable')").build()).getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        entries = this.tree.getEntries("filterEntriesByNamespace", EntriesParams.builder().expression("entry.namespace.startsWith('a.fourthTable')").build()).getEntries();
        Assertions.assertThat((List)entries).isEmpty();
        this.tree.deleteBranch("filterEntriesByNamespace", this.tree.getReferenceByName("filterEntriesByNamespace").getHash());
    }

    @Test
    public void checkCelScriptFailureReporting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getEntries("main", EntriesParams.builder().expression("invalid_script").build())).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog("main", CommitLogParams.builder().expression("invalid_script").build())).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("undeclared reference to 'invalid_script'");
    }

    @Test
    void checkSpecialCharacterRoundTrip() throws NessieNotFoundException, NessieConflictException {
        String branch = "specialchar";
        Reference r = this.tree.createReference((Reference)Branch.of((String)"specialchar", null));
        ContentsKey k = ContentsKey.of((String[])new String[]{"a.b", "c.d"});
        IcebergTable ta = IcebergTable.of((String)"path1");
        this.tree.commitMultipleOperations("specialchar", r.getHash(), (Operations)ImmutableOperations.builder().addOperations((Operation)ImmutablePut.builder().key(k).contents((Contents)ta).build()).commitMeta(CommitMeta.fromMessage((String)"commit 1")).build());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MultiGetContentsResponse.ContentsWithKey.of((ContentsKey)k, (Contents)ta), this.contents.getMultipleContents("specialchar", null, MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{k})).getContents().get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ta, (Object)this.contents.getContents(k, "specialchar", null));
        this.tree.deleteBranch("specialchar", this.tree.getReferenceByName("specialchar").getHash());
    }

    @Test
    void checkServerErrorPropagation() throws NessieNotFoundException, NessieConflictException {
        String branch = "bar";
        this.tree.createReference((Reference)Branch.of((String)"bar", null));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.createReference((Reference)Branch.of((String)"bar", null))).isInstanceOf(NessieConflictException.class)).hasMessageContaining("already exists");
    }

    @ParameterizedTest
    @CsvSource(value={"x/,1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidBranchNames(String invalidBranchName, String validHash) {
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = "commitMultipleOperations.operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidBranchNames$27(invalidBranchName, validHash, (Operations)ops, opsCountMsg), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(invalidBranchName, validHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getCommitLog(invalidBranchName, CommitLogParams.builder().startHash(validHash).build()))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getEntries(invalidBranchName, EntriesParams.builder().hashOnRef(validHash).build()))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getReferenceByName.refName: Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.getReferenceByName(invalidBranchName))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(invalidBranchName, validHash, tag))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.mergeRefIntoBranch(invalidBranchName, validHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("mergeRefIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..").hasMessageContaining("mergeRefIntoBranch.merge: must not be null"), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.tagName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(invalidBranchName, validHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(invalidBranchName, validHash, null, null))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getContents.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getContents(key, invalidBranchName, validHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): getMultipleContents.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.contents.getMultipleContents(invalidBranchName, validHash, mgReq))).getMessage())});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidHashes(String invalidHashIn, String validHash) {
        String invalidHash = invalidHashIn != null ? invalidHashIn : "";
        String validBranchName = "hello";
        ImmutableOperations ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"")).build();
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        IcebergTable cts = IcebergTable.of((String)"moo");
        Tag tag = Tag.of((String)"valid", (String)validHash);
        String opsCountMsg = "commitMultipleOperations.operations.operations: size must be between 1 and 2147483647";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> this.lambda$invalidHashes$49(validBranchName, invalidHash, (Operations)ops, opsCountMsg), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteBranch(validBranchName, invalidHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): assignTag.oldHash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.assignTag(validBranchName, invalidHash, tag))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.mergeRefIntoBranch(validBranchName, invalidHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("mergeRefIntoBranch.merge: must not be null").hasMessageContaining("mergeRefIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes"), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): deleteTag.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.deleteTag(validBranchName, invalidHash))).getMessage()), () -> org.junit.jupiter.api.Assertions.assertEquals((Object)"Bad Request (HTTP/400): transplantCommitsIntoBranch.hash: Hash must consist of the hex representation of 8-32 bytes", (Object)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.transplantCommitsIntoBranch(validBranchName, invalidHash, null, null))).getMessage()), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getMultipleContents(invalidHash, null, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getMultipleContents.request: must not be null").hasMessageContaining("getMultipleContents.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getMultipleContents(validBranchName, invalidHash, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getMultipleContents.hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getContents(key, validBranchName, invalidHash)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getContents.hashOnRef: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog(validBranchName, CommitLogParams.builder().startHash(invalidHash).build())).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getCommitLog.params.startHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog(validBranchName, CommitLogParams.builder().endHash(invalidHash).build())).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getCommitLog.params.endHash: Hash must consist of the hex representation of 8-32 bytes"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getEntries(validBranchName, EntriesParams.builder().hashOnRef(invalidHash).build())).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Bad Request (HTTP/400): ").hasMessageContaining("getEntries.params.hashOnRef: Hash must consist of the hex representation of 8-32 bytes")});
    }

    @ParameterizedTest
    @CsvSource(value={",1234567890123456789012345678901234567890123456789012345678901234", "abc',1234567890123456789012345678901234567890123456789012345678901234", ".foo,1234567890123456789012345678901234567890", "abc'def'..'blah,1234567890123456789012345678901234567890", "abc'de..blah,1234567890123456", "abc'de@{blah,1234567890123456"})
    void invalidTags(String invalidTagNameIn, String validHash) {
        String invalidTagName = invalidTagNameIn != null ? invalidTagNameIn : "";
        String validBranchName = "hello";
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        String tag = "{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String branch = "{\"type\": \"BRANCH\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        String different = "{\"type\": \"FOOBAR\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put(null))).isInstanceOf(NessieBadRequestException.class)).hasMessage("Bad Request (HTTP/400): assignTag.tag: must not be null"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)tag))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + invalidTagName + "\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)branch))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'BRANCH' as a subtype of `org.projectnessie.model.Tag`: Class `org.projectnessie.model.Branch` not subtype of `org.projectnessie.model.Tag`\n"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unwrap(() -> this.httpClient.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", validBranchName).queryParam("expectedHash", validHash).put((Object)different))).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Tag`: known type ids = []\n")});
    }

    @Test
    public void testInvalidNamedRefs() {
        ContentsKey key = ContentsKey.of((String[])new String[]{"x"});
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{key});
        String invalidRef = "1234567890123456";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog(invalidRef, CommitLogParams.empty())).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): getCommitLog.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getEntries(invalidRef, EntriesParams.empty())).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): getEntries.refName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getContents(key, invalidRef, null)).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): getContents.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getMultipleContents(invalidRef, null, mgReq)).isInstanceOf(NessieBadRequestException.class)).hasMessageStartingWith("Bad Request (HTTP/400): getMultipleContents.ref: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..");
    }

    @Test
    public void testValidHashesOnValidNamedRefs() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch b = Branch.of((String)"testValidHashesOnValidNamedRefs", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)b);
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        int commits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, commits, currentHash);
        LogResponse entireLog = this.tree.getCommitLog(branch.getName(), CommitLogParams.empty());
        Assertions.assertThat((Object)entireLog).isNotNull();
        Assertions.assertThat((List)entireLog.getOperations()).hasSize(commits);
        EntriesResponse allEntries = this.tree.getEntries(branch.getName(), EntriesParams.empty());
        Assertions.assertThat((Object)allEntries).isNotNull();
        Assertions.assertThat((List)allEntries.getEntries()).hasSize(commits);
        ArrayList keys = new ArrayList();
        IntStream.range(0, commits).forEach(i -> keys.add(ContentsKey.of((String[])new String[]{"table" + i})));
        MultiGetContentsRequest mgReq = MultiGetContentsRequest.of(keys);
        List allContents = this.contents.getMultipleContents(branch.getName(), null, mgReq).getContents();
        for (int i2 = 0; i2 < commits; ++i2) {
            String hash = ((CommitMeta)entireLog.getOperations().get(i2)).getHash();
            LogResponse log = this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().endHash(hash).build());
            Assertions.assertThat((Object)log).isNotNull();
            Assertions.assertThat((List)log.getOperations()).hasSize(commits - i2);
            Assertions.assertThat((List)ImmutableList.copyOf((Collection)entireLog.getOperations()).subList(i2, commits)).containsExactlyElementsOf((Iterable)log.getOperations());
            EntriesResponse entries = this.tree.getEntries(branch.getName(), EntriesParams.builder().hashOnRef(hash).build());
            Assertions.assertThat((Object)entries).isNotNull();
            Assertions.assertThat((List)entries.getEntries()).hasSize(commits - i2);
            int idx = commits - 1 - i2;
            Contents c = this.contents.getContents(ContentsKey.of((String[])new String[]{"table" + idx}), branch.getName(), hash);
            ((ObjectAssert)Assertions.assertThat((Object)c).isNotNull()).isEqualTo((Object)((MultiGetContentsResponse.ContentsWithKey)allContents.get(idx)).getContents());
        }
    }

    @Test
    public void testUnknownHashesOnValidNamedRefs() throws NessieNotFoundException, NessieConflictException {
        Reference main = this.tree.getReferenceByName("main");
        Branch b = Branch.of((String)"testUnknownHashesOnValidNamedRefs", (String)main.getHash());
        Reference branch = this.tree.createReference((Reference)b);
        Assertions.assertThat((Object)branch).isEqualTo((Object)b);
        String invalidHash = "1234567890123456";
        int commits = 10;
        String currentHash = main.getHash();
        this.createCommits(branch, 1, commits, currentHash);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getCommitLog(branch.getName(), CommitLogParams.builder().endHash(invalidHash).build())).isInstanceOf(NessieNotFoundException.class)).hasMessage(String.format("Hash %s on Ref %s could not be found", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tree.getEntries(branch.getName(), EntriesParams.builder().hashOnRef(invalidHash).build())).isInstanceOf(NessieNotFoundException.class)).hasMessage(String.format("Hash %s on Ref %s could not be found", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getMultipleContents(branch.getName(), invalidHash, MultiGetContentsRequest.of((ContentsKey[])new ContentsKey[]{ContentsKey.of((String[])new String[]{"table0"})})).getContents()).isInstanceOf(NessieNotFoundException.class)).hasMessage(String.format("Hash %s on Ref %s could not be found", invalidHash, b.getName()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.contents.getContents(ContentsKey.of((String[])new String[]{"table0"}), branch.getName(), invalidHash)).isInstanceOf(NessieNotFoundException.class)).hasMessage(String.format("Hash %s on Ref %s could not be found", invalidHash, b.getName()));
    }

    void unwrap(Executable exec) throws Throwable {
        try {
            exec.execute();
        }
        catch (Throwable targetException) {
            if (targetException instanceof HttpClientException && (targetException.getCause() instanceof NessieNotFoundException || targetException.getCause() instanceof NessieConflictException)) {
                throw targetException.getCause();
            }
            throw targetException;
        }
    }

    private /* synthetic */ void lambda$invalidHashes$49(String validBranchName, String invalidHash, Operations ops, String opsCountMsg) throws Throwable {
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(validBranchName, invalidHash, ops))).getMessage()).contains(new CharSequence[]{"Bad Request (HTTP/400): "})).contains(new CharSequence[]{"commitMultipleOperations.hash: Hash must consist of the hex representation of 8-32 bytes"})).contains(new CharSequence[]{opsCountMsg});
    }

    private /* synthetic */ void lambda$invalidBranchNames$27(String invalidBranchName, String validHash, Operations ops, String opsCountMsg) throws Throwable {
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((NessieBadRequestException)org.junit.jupiter.api.Assertions.assertThrows(NessieBadRequestException.class, () -> this.tree.commitMultipleOperations(invalidBranchName, validHash, ops))).getMessage()).contains(new CharSequence[]{"Bad Request (HTTP/400): "})).contains(new CharSequence[]{"commitMultipleOperations.branchName: Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .."})).contains(new CharSequence[]{opsCountMsg});
    }

    private static final class ContentAndOperationType {
        final Contents.Type type;
        final Operation operation;

        ContentAndOperationType(Contents.Type type, Operation operation) {
            this.type = type;
            this.operation = operation;
        }

        public String toString() {
            String s = this.operation instanceof Operation.Put ? "Put_" + ((Operation.Put)this.operation).getContents().getClass().getSimpleName() : this.operation.getClass().getSimpleName();
            return s + "_" + this.operation.getKey().toPathString();
        }
    }
}

