/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.Namespace;

class TestContentsKey {
    TestContentsKey() {
    }

    @ParameterizedTest
    @MethodSource(value={"contentsKeyOfAndParseCases"})
    void contentsKeyOfAndParse(ContentsKeyOfParse testCase) {
        Assertions.assertThat((Object)testCase.key).extracting(new Function[]{ContentsKey::getElements, ContentsKey::getName, ContentsKey::getNamespace, ContentsKey::toString, ContentsKey::toPathString}).containsExactly(new Object[]{testCase.elements, testCase.name, testCase.namespace, testCase.string, testCase.pathString});
    }

    static List<ContentsKeyOfParse> contentsKeyOfAndParseCases() {
        return Arrays.asList(new ContentsKeyOfParse(ContentsKey.fromPathString((String)"a.table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.of((String[])new String[]{"a", "table"}), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.of(Arrays.asList("a", "table")), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.of((String[])new String[]{"a"}), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.of(Collections.singletonList("a")), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.parse((String)"a"), (String)"table"), Arrays.asList("a", "table"), "table", Namespace.of((String[])new String[]{"a"}), "a.table", "a.table"), new ContentsKeyOfParse(ContentsKey.fromPathString((String)"a.b.table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of((String[])new String[]{"a", "b", "table"}), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of(Arrays.asList("a", "b", "table")), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.of((String[])new String[]{"a", "b"}), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.of(Arrays.asList("a", "b")), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.parse((String)"a.b"), (String)"table"), Arrays.asList("a", "b", "table"), "table", Namespace.of((String[])new String[]{"a", "b"}), "a.b.table", "a.b.table"), new ContentsKeyOfParse(ContentsKey.of((Namespace)Namespace.EMPTY, (String)"table"), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentsKeyOfParse(ContentsKey.of((String[])new String[]{"table"}), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentsKeyOfParse(ContentsKey.of(Collections.singletonList("table")), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"), new ContentsKeyOfParse(ContentsKey.fromPathString((String)"table"), Collections.singletonList("table"), "table", Namespace.parse((String)""), "table", "table"));
    }

    @Test
    void namespaceNotIncluded() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Namespace namespace = Namespace.parse((String)"a.b.c");
        Assertions.assertThat((String)namespace.name()).isEqualTo("a.b.c");
        Assertions.assertThat((Object[])namespace.getElements()).containsExactly((Object[])new String[]{"a", "b", "c"});
        ContentsKey key = ContentsKey.of((String[])new String[]{"a", "b", "c", "tableName"});
        Assertions.assertThat((Object)key.getNamespace()).isEqualTo((Object)namespace);
        String serializedKey = mapper.writeValueAsString((Object)key);
        ((AbstractStringAssert)Assertions.assertThat((String)serializedKey).contains(new CharSequence[]{"elements"})).doesNotContain(new CharSequence[]{"namespace"});
        ContentsKey deserialized = (ContentsKey)mapper.readValue(serializedKey, ContentsKey.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)key);
        Assertions.assertThat((Object)deserialized.getNamespace()).isEqualTo((Object)namespace);
    }

    @Test
    public void validation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of((String[])new String[]{"a", "b", "\u0000", "c", "d"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key must not contain a zero byte.");
    }

    @Test
    public void construction() {
        CharSequence[] elements = new String[]{"a", "b", "c", "d"};
        ContentsKey key = ContentsKey.of((String[])elements);
        Assertions.assertThat((List)key.getElements()).containsExactlyElementsOf(Arrays.asList(elements));
        Assertions.assertThat((String)key.toPathString()).isEqualTo(String.join((CharSequence)".", elements));
        Assertions.assertThat((Object)ContentsKey.fromPathString((String)"a.b.c.d")).isEqualTo((Object)key);
    }

    @Test
    void singleByte() {
        this.assertRoundTrip("a.b", "c.d");
    }

    @Test
    void strangeCharacters() {
        this.assertRoundTrip("/%", "#&&");
    }

    @Test
    void doubleByte() {
        this.assertRoundTrip("/%\u56fd", "\u56fd.\u56fd");
    }

    @Test
    void blockZeroByteUsage() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ContentsKey.of((String[])new String[]{"\u0000"}));
    }

    @Test
    void npe() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThatThrownBy(() -> ContentsKey.of((String[])null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of(null, null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of((String[])new String[]{"a", null})).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of((List)null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of(Collections.singletonList(null))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of(Arrays.asList("a", null))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> ContentsKey.of(Arrays.asList(null, "a"))).isInstanceOf(NullPointerException.class)});
    }

    @Test
    void empty() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of(null, (String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key must not contain an empty name (last element)."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of((String[])new String[]{"a", ""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key must not contain an empty name (last element)."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of(Collections.singletonList(""))).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key must not contain an empty name (last element)."), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of(Arrays.asList("a", ""))).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key must not contain an empty name (last element).")});
    }

    private void assertRoundTrip(String ... elements) {
        ContentsKey k = ContentsKey.of((String[])elements);
        ContentsKey k2 = ContentsKey.fromPathString((String)k.toPathString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)k, (Object)k2);
    }

    static class ContentsKeyOfParse {
        final ContentsKey key;
        final List<String> elements;
        final String name;
        final Namespace namespace;
        final String string;
        final String pathString;

        ContentsKeyOfParse(ContentsKey key, List<String> elements, String name, Namespace namespace, String string, String pathString) {
            this.key = key;
            this.elements = elements;
            this.name = name;
            this.namespace = namespace;
            this.string = string;
            this.pathString = pathString;
        }

        public String toString() {
            return "key=" + this.key + ", elements=" + this.elements + ", namespace=" + this.namespace + ", string='" + this.string + '\'' + ", pathString='" + this.pathString + '\'';
        }
    }
}

