/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.TableReference;

public class TestTableReference {
    static List<Object[]> fromContentsKeyTestCases() {
        return Arrays.asList({"simple_name", "simple_name", null, null, null}, {"`simple_name@ref`", "simple_name", "ref", null, null}, {"`simple_name@ref#12345678abcdef12345678abcdef`", "simple_name", "ref", "12345678abcdef12345678abcdef", null}, {"`simple_name#12345678abcdef12345678abcdef`", "simple_name", null, "12345678abcdef12345678abcdef", null}, {"`simple_name#2020-12-24`", "simple_name", null, null, "2020-12-24"}, {"`simple_name@ref#2020-12-24`", "simple_name", "ref", null, "2020-12-24"});
    }

    @ParameterizedTest
    @MethodSource(value={"fromContentsKeyTestCases"})
    public void fromContentsKey(String name, String expectedName, String expectedReference, String expectedHash, String expectedTimestamp) {
        TableReference tr = TableReference.parse((String)name);
        Assertions.assertThat((Object)tr).extracting(new Function[]{TableReference::getName, TableReference::hasReference, TableReference::getReference, TableReference::hasHash, TableReference::getHash, TableReference::hasTimestamp, TableReference::getTimestamp, TableReference::toString}).containsExactly(new Object[]{expectedName, expectedReference != null, expectedReference, expectedHash != null, expectedHash, expectedTimestamp != null, expectedTimestamp, name.replaceAll("'", "`")});
    }

    @ParameterizedTest
    @ValueSource(strings={"foo@bar@boo", "foo#baz#baa", "foo@#baa", "foo@#", "foo@bar#", "@bar#baz", "@#baz", "@#baz", "#baz", "#", "@", ""})
    void illegalSyntax(String tableReference) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableReference.parse((String)tableReference)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Illegal table reference syntax, '%s' must match the syntax 'table-identifier ( '@' reference-name )? ( '#' hashOrTimestamp )?', optionally enclosed by backticks or single-quotes.", tableReference));
    }

    @Test
    public void strangeCharacters() {
        String branch = "bar";
        String path = "/%";
        TableReference tr = TableReference.parse((String)path);
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)tr.getReference()).isNull();
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        tr = TableReference.parse((String)(path + "@" + branch));
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)branch).isEqualTo(tr.getReference());
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        path = "&&";
        tr = TableReference.parse((String)path);
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)tr.getReference()).isNull();
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        tr = TableReference.parse((String)(path + "@" + branch));
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)branch).isEqualTo(tr.getReference());
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
    }

    @Test
    public void doubleByte() {
        String branch = "bar";
        String path = "/%\u56fd";
        TableReference tr = TableReference.parse((String)path);
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)tr.getReference()).isNull();
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        tr = TableReference.parse((String)(path + "@" + branch));
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)branch).isEqualTo(tr.getReference());
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        path = "\u56fd.\u56fd";
        tr = TableReference.parse((String)path);
        Assertions.assertThat((String)path).isEqualTo(tr.toString());
        Assertions.assertThat((String)tr.getReference()).isNull();
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        tr = TableReference.parse((String)(path + "@" + branch));
        Assertions.assertThat((String)("`" + path + "@" + branch + "`")).isEqualTo(tr.toString());
        Assertions.assertThat((String)branch).isEqualTo(tr.getReference());
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
    }

    @Test
    public void whitespace() {
        String branch = "bar";
        String path = "foo ";
        TableReference tr = TableReference.parse((String)path);
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)tr.getReference()).isNull();
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
        tr = TableReference.parse((String)(path + "@" + branch));
        Assertions.assertThat((String)path).isEqualTo(tr.getName());
        Assertions.assertThat((String)branch).isEqualTo(tr.getReference());
        Assertions.assertThat((String)tr.getTimestamp()).isNull();
    }
}

